/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.job.BBacnetDiscoverJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.job.BDiscoveryPointTable;
import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDiscoverPointsJob
extends BBacnetDiscoverJob {
    public static final Action discover = BBacnetDiscoverPointsJob.newAction((int)0, (BValue)BDiscoveryPoint.NULL, null);
    public static final Action discoverFacets = BBacnetDiscoverPointsJob.newAction((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Action checkForPriorityArray = BBacnetDiscoverPointsJob.newAction((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Type TYPE;
    private long pointsAdded;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BBacnetDiscoverPointsJob;

    public BDiscoveryPointTable discover(BDiscoveryPoint bDiscoveryPoint) {
        return (BDiscoveryPointTable)this.invoke(discover, (BValue)bDiscoveryPoint, null);
    }

    public BFacets discoverFacets(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return (BFacets)this.invoke(discoverFacets, (BValue)bBacnetObjectIdentifier, null);
    }

    public BBoolean checkForPriorityArray(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return (BBoolean)this.invoke(checkForPriorityArray, (BValue)bBacnetObjectIdentifier, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDiscoveryPointTable doDiscover(BDiscoveryPoint bDiscoveryPoint) {
        BDiscoveryPoint[] bDiscoveryPointArray = new BDiscoveryPoint[]{};
        try {
            switch (bDiscoveryPoint.getPointType()) {
                case 0: {
                    HashMap hashMap = new HashMap();
                    bDiscoveryPointArray = this.discoverProperties(bDiscoveryPoint.getObjectName(), bDiscoveryPoint.getObjectId(), hashMap);
                    BFacets bFacets = BFacets.make(hashMap);
                    int n = 0;
                    while (n < bDiscoveryPointArray.length) {
                        PropertyInfo propertyInfo = this.device().getPropertyInfo(bDiscoveryPointArray[n].getObjectId().getObjectType(), bDiscoveryPointArray[n].getPropertyId());
                        if (propertyInfo != null && !propertyInfo.getFacetControl().equals("no")) {
                            bDiscoveryPointArray[n].setFacets(bFacets);
                        }
                        ++n;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    bDiscoveryPointArray = this.discoverElements(bDiscoveryPoint);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.log().failed(" ERROR: Unable to learn Bacnet properties of " + (Object)((Object)bDiscoveryPoint.getObjectId()) + ": " + exception);
            log.error("Unable to learn Bacnet properties of " + (Object)((Object)bDiscoveryPoint.getObjectId()) + ": " + exception, (Throwable)exception);
        }
        return this.makeDiscoveryPointTable(bDiscoveryPointArray);
    }

    public BFacets doDiscoverFacets(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        HashMap hashMap = BacnetDiscoveryUtil.discoverFacets(bBacnetObjectIdentifier, this.device());
        switch (bBacnetObjectIdentifier.getObjectType()) {
            case 2: 
            case 5: 
            case 19: {
                hashMap.put("priPV", BacnetDiscoveryUtil.checkForPriorityArray(bBacnetObjectIdentifier, this.device()));
                break;
            }
        }
        return BFacets.make((Map)hashMap);
    }

    public BBoolean doCheckForPriorityArray(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return BacnetDiscoveryUtil.checkForPriorityArray(bBacnetObjectIdentifier, this.device());
    }

    void addDiscoveryChild(BBacnetDiscoverJob.IdVals idVals) {
        BBacnetDiscoverJob.PropVal propVal = idVals.primary();
        if (propVal == null) {
            log.trace("No primary value for discovered object " + idVals);
        } else {
            BDiscoveryPoint bDiscoveryPoint = new BDiscoveryPoint(idVals.name, idVals.id, BBacnetPropertyIdentifier.tag(propVal.propId), propVal.val, null, true);
            BBacnetDiscoverJob.PropVal propVal2 = idVals.get(28);
            if (propVal2 != null) {
                bDiscoveryPoint.setDescription(propVal2.toString());
            }
            this.add("dc" + this.pointsAdded++, (BValue)bDiscoveryPoint);
        }
    }

    protected BDiscoveryPointTable makeDiscoveryPointTable(BDiscoveryPoint[] bDiscoveryPointArray) {
        BDiscoveryPointTable bDiscoveryPointTable = new BDiscoveryPointTable();
        if (bDiscoveryPointArray != null) {
            int n = 0;
            while (n < bDiscoveryPointArray.length) {
                bDiscoveryPointTable.add(null, bDiscoveryPointArray[n].newCopy());
                ++n;
            }
        }
        return bDiscoveryPointTable;
    }

    BDiscoveryPoint[] discoverProperties(String string, BBacnetObjectIdentifier bBacnetObjectIdentifier, HashMap hashMap) {
        Object object;
        if (!this.device().isServiceSupported("readPropertyMultiple")) {
            return this.buildPropertyChildren(string, bBacnetObjectIdentifier, this.device().getRequiredProperties(bBacnetObjectIdentifier), hashMap);
        }
        Vector<NReadAccessSpec> vector = new Vector<NReadAccessSpec>();
        vector.add(new NReadAccessSpec(bBacnetObjectIdentifier, 8));
        Vector vector2 = null;
        try {
            vector2 = BBacnetDiscoverPointsJob.client().readPropertyMultiple(this.device().getAddress(), vector);
        }
        catch (BacnetException bacnetException) {
            log.message("BacnetException reading properties for " + (Object)((Object)bBacnetObjectIdentifier) + ": " + (Object)((Object)bacnetException));
            return this.buildPropertyChildren(string, bBacnetObjectIdentifier, this.device().getRequiredProperties(bBacnetObjectIdentifier), hashMap);
        }
        if (vector2 == null) {
            return this.buildPropertyChildren(string, bBacnetObjectIdentifier, this.device().getRequiredProperties(bBacnetObjectIdentifier), hashMap);
        }
        ListIterator listIterator = ((NReadAccessResult)vector2.elementAt(0)).getResults();
        int n = bBacnetObjectIdentifier.getObjectType();
        PropertyInfo propertyInfo = null;
        Vector<BDiscoveryPoint> vector3 = new Vector<BDiscoveryPoint>();
        while (listIterator.hasNext()) {
            BDiscoveryPoint bDiscoveryPoint;
            object = (NReadPropertyResult)listIterator.next();
            if (((NReadPropertyResult)object).getPropertyId() == 8) {
                return this.buildPropertyChildren(string, bBacnetObjectIdentifier, this.device().getRequiredProperties(bBacnetObjectIdentifier), hashMap);
            }
            propertyInfo = this.device().getPropertyInfo(n, ((NReadPropertyResult)object).getPropertyId());
            if (((NReadPropertyResult)object).isError()) {
                bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, BBacnetPropertyIdentifier.tag(((NReadPropertyResult)object).getPropertyId()), (BValue)BString.make((String)(lex.get("pointManager.error") + ':' + ((NReadPropertyResult)object).getPropertyAccessError().toString())), null, false);
                vector3.add(bDiscoveryPoint);
                continue;
            }
            if (propertyInfo != null) {
                bDiscoveryPoint = this.buildPropertyResult(string, bBacnetObjectIdentifier, propertyInfo, ((NReadPropertyResult)object).getPropertyValue(), hashMap);
                if (bDiscoveryPoint == null) continue;
                vector3.add(bDiscoveryPoint);
                continue;
            }
            bDiscoveryPoint = this.buildPropertyResult(string, bBacnetObjectIdentifier, ((NReadPropertyResult)object).getPropertyId(), ((NReadPropertyResult)object).getPropertyValue());
            if (bDiscoveryPoint == null) continue;
            vector3.add(bDiscoveryPoint);
        }
        object = new BDiscoveryPoint[vector3.size()];
        vector3.copyInto((Object[])object);
        return object;
    }

    private final BDiscoveryPoint buildPropertyResult(String string, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) {
        BDiscoveryPoint bDiscoveryPoint = null;
        String string2 = BBacnetPropertyIdentifier.tag(n);
        try {
            BValue[] bValueArray = AsnUtil.fromAsn(byArray);
            if (bValueArray.length == 1) {
                bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, string2, bValueArray[0], null, false);
            } else {
                Type type = bValueArray[0].getType();
                boolean bl = true;
                int n2 = 1;
                while (n2 < bValueArray.length) {
                    if (bValueArray[n2].getType() != type) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    BDiscoveryPoint[] bDiscoveryPointArray = new BDiscoveryPoint[bValueArray.length];
                    int n3 = 1;
                    while (n3 <= bValueArray.length) {
                        BDiscoveryPoint bDiscoveryPoint2;
                        bDiscoveryPointArray[n3 - 1] = bDiscoveryPoint2 = new BDiscoveryPoint(string, bBacnetObjectIdentifier, string2, n3, (BValue)BString.make((String)""), null);
                        ++n3;
                    }
                    bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, string2, bDiscoveryPointArray, null);
                } else {
                    bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, string2, (BValue)BString.make((String)""), null, false);
                }
            }
        }
        catch (Exception exception) {
            log.message("Exception in buildPropertyResult for " + string + " [" + (Object)((Object)bBacnetObjectIdentifier) + "] pId:" + n + " val=" + ByteArrayUtil.toHexString((byte[])byArray) + ':' + exception, (Throwable)exception);
            bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, string2, (BValue)BString.make((String)"???"), null, false);
        }
        return bDiscoveryPoint;
    }

    private final BDiscoveryPoint buildPropertyResult(String string, BBacnetObjectIdentifier bBacnetObjectIdentifier, PropertyInfo propertyInfo, byte[] byArray, HashMap hashMap) {
        try {
            BDiscoveryPoint bDiscoveryPoint = null;
            if (propertyInfo.isArray()) {
                int n = propertyInfo.getSize();
                if (n < 0) {
                    try {
                        byte[] byArray2 = BBacnetDiscoverPointsJob.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, propertyInfo.getId(), 0);
                        int n2 = AsnUtil.fromAsnInteger(byArray2);
                        BDiscoveryPoint[] bDiscoveryPointArray = new BDiscoveryPoint[n2];
                        int n3 = 1;
                        while (n3 <= n2) {
                            BDiscoveryPoint bDiscoveryPoint2;
                            bDiscoveryPointArray[n3 - 1] = bDiscoveryPoint2 = new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), n3, (BValue)BString.make((String)""), null);
                            ++n3;
                        }
                        bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), bDiscoveryPointArray, null);
                    }
                    catch (BacnetException bacnetException) {
                        log.message("Unable to read array size for " + string + " [" + (Object)((Object)bBacnetObjectIdentifier) + "] " + propertyInfo.getName() + ": " + (Object)((Object)bacnetException));
                    }
                } else {
                    BDiscoveryPoint[] bDiscoveryPointArray = new BDiscoveryPoint[n];
                    int n4 = 1;
                    while (n4 <= n) {
                        BDiscoveryPoint bDiscoveryPoint3;
                        bDiscoveryPointArray[n4 - 1] = bDiscoveryPoint3 = new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), n4, (BValue)BString.make((String)""), null);
                        ++n4;
                    }
                    bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), bDiscoveryPointArray, null);
                }
            } else {
                try {
                    BValue bValue = AsnUtil.asnToValue(propertyInfo, byArray);
                    BFacets bFacets = null;
                    if (propertyInfo.isEnum()) {
                        try {
                            BTypeSpec bTypeSpec = BTypeSpec.make((String)propertyInfo.getType());
                            BEnum bEnum = (BEnum)bTypeSpec.getInstance();
                            bFacets = propertyInfo.isExtensible() ? BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)bEnum.getType())) : BFacets.makeEnum((BEnumRange)bEnum.getRange());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    bDiscoveryPoint = new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), bValue, bFacets, false);
                }
                catch (AsnException asnException) {
                    asnException.printStackTrace();
                    log.message("Exception in buildPropertyResult for " + string + " [" + (Object)((Object)bBacnetObjectIdentifier) + "] pInfo:" + propertyInfo + " val=" + ByteArrayUtil.toHexString((byte[])byArray) + " f=" + hashMap + ':' + (Object)((Object)asnException));
                    return new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), (BValue)BString.make((String)"???"), null, false);
                }
            }
            if (propertyInfo.isFacet()) {
                BacnetDiscoveryUtil.addFacet(propertyInfo.getId(), byArray, hashMap, this.device());
            }
            return bDiscoveryPoint;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            log.message("Exception in buildPropertyResult for " + string + " [" + (Object)((Object)bBacnetObjectIdentifier) + "] pInfo:" + propertyInfo + " val=" + ByteArrayUtil.toHexString((byte[])byArray) + " f=" + hashMap + ':' + runtimeException);
            return new BDiscoveryPoint(string, bBacnetObjectIdentifier, propertyInfo.getName(), (BValue)BString.make((String)"???"), null, false);
        }
    }

    private final BDiscoveryPoint[] buildPropertyChildren(String string, BBacnetObjectIdentifier bBacnetObjectIdentifier, int[] nArray, HashMap hashMap) {
        BDiscoveryPoint[] bDiscoveryPointArray = new BDiscoveryPoint[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            try {
                PropertyInfo propertyInfo = this.device().getPropertyInfo(bBacnetObjectIdentifier.getObjectType(), nArray[n]);
                byte[] byArray = BBacnetDiscoverPointsJob.client().readProperty(this.device().getAddress(), bBacnetObjectIdentifier, nArray[n]);
                bDiscoveryPointArray[n] = propertyInfo != null ? this.buildPropertyResult(string, bBacnetObjectIdentifier, propertyInfo, byArray, hashMap) : new BDiscoveryPoint(string, bBacnetObjectIdentifier, BBacnetPropertyIdentifier.tag(nArray[n]), (BValue)BString.make((String)"?n/a?"), null, false);
            }
            catch (BacnetException bacnetException) {
                log.message("BacnetException reading property " + BBacnetPropertyIdentifier.tag(nArray[n]) + ':' + (Object)((Object)bacnetException));
                bDiscoveryPointArray[n] = new BDiscoveryPoint(string, bBacnetObjectIdentifier, BBacnetPropertyIdentifier.tag(nArray[n]), (BValue)BString.make((String)"???"), null, false);
            }
            ++n;
        }
        return bDiscoveryPointArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BDiscoveryPoint[] discoverElements(BDiscoveryPoint var1_1) {
        block16: {
            var2_2 = var1_1.getPoints();
            var3_3 = var1_1.getPropertyId();
            var4_4 = this.device().getPropertyInfo(var1_1.getObjectId().getObjectType(), var3_3);
            if (!this.device().isServiceSupported("readPropertyMultiple")) break block16;
            var5_5 = new Vector<NBacnetPropertyReference>();
            var6_7 = 0;
            while (true) {
                if (var6_7 >= var2_2.length) {
                    var6_8 = null;
                    ** try [egrp 0[TRYBLOCK] [3 : 88->315)] { 
lbl11:
                    // 1 sources

                    break;
                }
                var5_5.add(new NBacnetPropertyReference(var3_3, var2_2[var6_7].getPropertyArrayIndex()));
                ++var6_7;
            }
            {
                var6_8 = BBacnetDiscoverPointsJob.client().readPropertyMultiple(this.device().getAddress(), var1_1.getObjectId(), var5_5);
                var7_12 = var6_8.iterator();
                var8_15 = 0;
                while (true) {
                    if (!var7_12.hasNext()) {
                        return var2_2;
                    }
                    try {
                        try {
                            block17: {
                                var12_18 = (NReadPropertyResult)var7_12.next();
                                if (var4_4 == null) break block17;
                                var13_20 = BTypeSpec.make((String)var4_4.getType());
                                var14_21 = (BValue)var13_20.getInstance();
                                var14_21 = AsnUtil.fromAsn(var12_18.getPropertyValue(), var14_21);
                                var2_2[var8_15].setValue(var14_21);
                                ** GOTO lbl-1000
                            }
                            var13_20 = AsnUtil.asnToValue(var12_18.getPropertyValue());
                            var2_2[var8_15].setValue((BValue)var13_20);
                        }
                        catch (Exception var12_19) {
                            BBacnetDiscoverPointsJob.log.message("Exception reading element " + var8_15 + " in " + (Object)var1_1.getObjectId() + " [" + var1_1.getPropertyIdentifier() + "]: " + var12_19);
                            var2_2[var8_15].setValue((BValue)BString.make((String)"???"));
                        }
                    }
                    catch (Throwable var9_22) {
                        var10_17 = null;
                        ++var8_15;
                        throw var9_22;
                    }
lbl-1000:
                    // 3 sources

                    {
                        var10_17 = null;
                        ++var8_15;
                        continue;
                    }
                    break;
                }
            }
lbl47:
            // 1 sources

            catch (BacnetException var7_13) {
                BBacnetDiscoverPointsJob.log.message("BacnetException reading elements in " + (Object)var1_1.getObjectId() + " [" + var1_1.getPropertyIdentifier() + "]: " + (Object)var7_13);
                return var2_2;
            }
        }
        var5_6 = 0;
        while (true) {
            if (var5_6 >= var2_2.length) {
                return var2_2;
            }
            try {
                var6_9 = BBacnetDiscoverPointsJob.client().readProperty(this.device().getAddress(), var2_2[var5_6].getObjectId(), var3_3, var2_2[var5_6].getPropertyArrayIndex());
                var7_14 = BTypeSpec.make((String)var4_4.getType());
                var8_16 = (BValue)var7_14.getInstance();
                var8_16 = AsnUtil.fromAsn(var6_9, var8_16);
                var2_2[var5_6].setValue(var8_16);
            }
            catch (BacnetException var6_10) {
                BBacnetDiscoverPointsJob.log.message("BacnetException reading element " + var5_6 + " in " + (Object)var1_1.getObjectId() + " [" + var1_1.getPropertyIdentifier() + "]: " + (Object)var6_10);
                var2_2[var5_6].setValue((BValue)BString.make((String)"???"));
            }
            catch (Exception var6_11) {
                BBacnetDiscoverPointsJob.log.message("Exception reading element " + var5_6 + " in " + (Object)var1_1.getObjectId() + " [" + var1_1.getPropertyIdentifier() + "]: " + var6_11);
                var2_2[var5_6].setValue((BValue)BString.make((String)"???"));
            }
            ++var5_6;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pointsAdded = 0L;
    }

    public BBacnetDiscoverPointsJob() {
        this.this();
    }

    public BBacnetDiscoverPointsJob(BBacnetPointDeviceExt bBacnetPointDeviceExt) {
        super((BDeviceExt)bBacnetPointDeviceExt);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BBacnetDiscoverPointsJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BBacnetDiscoverPointsJob = BBacnetDiscoverPointsJob.class("[Lcom.tridium.bacnet.job.BBacnetDiscoverPointsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

