/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.text.MessageFormat;
import java.util.ListIterator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.driver.BDeviceExt;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetDiscoverJob
extends BSimpleJob
implements BacnetConst {
    public static final Type TYPE;
    public static final Log log;
    protected static final int[] DESCRIPTION_ONLY;
    static Lexicon lex;
    BBacnetDeviceObject deviceObject;
    BBacnetDevice device;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BBacnetDiscoverJob;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BBacnetDiscoverJob$IdVals;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
    static /* synthetic */ Class class$com$tridium$bacnet$asn$NReadAccessSpec;

    public Type getType() {
        return TYPE;
    }

    protected boolean doForId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return true;
    }

    void processId(BBacnetObjectIdentifier bBacnetObjectIdentifier, String string) throws Exception {
    }

    int[] getDiscoveryPropIds(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        int n = bBacnetObjectIdentifier.getObjectType();
        switch (n) {
            case 8: {
                return new int[]{112, 28};
            }
            case 29: {
                return new int[]{208, 28};
            }
            case 18: {
                return new int[]{125, 28};
            }
            case 9: {
                return new int[]{36, 28};
            }
            case 10: {
                return new int[]{42, 28};
            }
            case 15: {
                return new int[]{17, 28};
            }
            case 16: {
                return new int[]{92, 28};
            }
            case 20: 
            case 25: 
            case 27: {
                return new int[]{141, 28};
            }
        }
        return new int[]{85, 28};
    }

    void addDiscoveryChild(IdVals idVals) {
    }

    /*
     * Unable to fully structure code
     */
    public void run(Context var1_1) throws Exception {
        var2_2 = 0L;
        try {
            this.log().start(BBacnetDiscoverJob.lex.getText("discover.begin"));
            super.progress(0);
            var2_2 = Clock.ticks();
            if (!this.readObjectList()) {
                this.log().failed(" ERROR: Unable to read the Bacnet object list for " + this.device);
                BBacnetDiscoverJob.log.error("Unable to read the Bacnet object list for " + this.device);
                this.log().failed(BBacnetDiscoverJob.lex.getText("discover.fail"));
                this.failed(null);
                throw new BajaRuntimeException(BBacnetDiscoverJob.lex.getText("discover.fail"));
            }
            this.checkCancel();
            var4_3 = this.deviceObject.getObjectList().getSize();
            if (var4_3 <= 0) {
                var4_3 = 1;
            }
            var5_5 = MessageFormat.format(BBacnetDiscoverJob.lex.getText("discover.finishedList"), new Object[]{new Integer(this.deviceObject.getObjectList().getSize())});
            this.log().message(var5_5);
            this.progress(10);
            this.log().message("Reading Object_Names...");
            var6_6 = this.deviceObject.getObjectList().getProperties();
            v0 = BBacnetDiscoverJob.class$com$tridium$bacnet$job$BBacnetDiscoverJob$IdVals;
            if (v0 == null) {
                v0 = BBacnetDiscoverJob.class$com$tridium$bacnet$job$BBacnetDiscoverJob$IdVals = BBacnetDiscoverJob.class("[Lcom.tridium.bacnet.job.BBacnetDiscoverJob$IdVals;", false);
            }
            var7_7 = new Array(v0);
            if (true) ** GOTO lbl30
            do {
                if (this.doForId((BBacnetObjectIdentifier)(var8_8 = (BBacnetObjectIdentifier)var6_6.get()))) {
                    var7_7.add((Object)new IdVals((BBacnetObjectIdentifier)var8_8, 77));
                }
lbl30:
                // 4 sources

                if ((v1 = BBacnetDiscoverJob.class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier) != null) continue;
                v1 = BBacnetDiscoverJob.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
            } while (var6_6.next(v1));
            if (var7_7.size() == 0) {
                this.log().message("No objects of an appropriate type were found!");
                return;
            }
            this.checkCancel();
            this.readObjectVals(var7_7, 15, 40);
            this.checkCancel();
            this.log().message("Reading Object properties...");
            var8_8 = var7_7.iterator();
            while (var8_8.hasNext()) {
                if (!this.isAlive()) break;
                var9_9 = (IdVals)var8_8.next();
                var9_9.name = var9_9.get(77).toString();
                var9_9.clear();
                var10_11 = this.getDiscoveryPropIds(var9_9.id);
                var11_13 = 0;
                while (var11_13 < var10_11.length) {
                    var9_9.addPV(var10_11[var11_13]);
                    ++var11_13;
                }
            }
            this.checkCancel();
            this.readObjectVals(var7_7, 45, 70);
            this.checkCancel();
            this.log().message("Creating discovery children...");
            var8_8 = var7_7.iterator();
            var9_10 = var7_7.size();
            var10_12 = 0;
            while (var8_8.hasNext()) {
                this.checkCancel();
                var11_15 = (IdVals)var8_8.next();
                this.addDiscoveryChild(var11_15);
                this.progress(++var10_12, var9_10, 70, 100);
            }
            this.log().success(BBacnetDiscoverJob.lex.getText("discover.end"));
            var11_16 = Clock.ticks();
            var13_17 = this.deviceObject.getObjectList().getSize();
            var14_18 = (int)((var11_16 - var2_2) / 1000L);
            var15_19 = BBacnetDiscoverJob.lex.getText("discover.stats");
            if (var13_17 == 1) {
                var15_19 = BBacnetDiscoverJob.lex.getText("discover.stats.1obj");
            }
            var16_20 = MessageFormat.format(var15_19, new Object[]{new Integer(var13_17), new Integer(var14_18)});
            this.log().message(var16_20);
        }
        catch (Exception var4_4) {
            this.log().failed(" ERROR: Unable to learn Bacnet objects in " + this.device + ": " + var4_4);
            BBacnetDiscoverJob.log.error("Unable to learn Bacnet objects in " + this.device + ": " + var4_4, (Throwable)var4_4);
            throw var4_4;
        }
    }

    private final void checkCancel() {
        if (!this.isAlive()) {
            this.log().message("discover.canceled");
            throw new BajaRuntimeException(lex.getText("discover.canceled"));
        }
    }

    public void progress(int n) {
        int n2 = this.getProgress();
        if (n > n2) {
            super.progress(n);
        } else {
            this.heartbeat();
        }
    }

    private final void progress(int n, int n2, int n3, int n4) {
        int n5 = n3 + (int)((float)(++n) / (float)n2 * (float)(n4 - n3));
        this.progress(n5);
    }

    private final boolean readObjectList() {
        try {
            this.deviceObject.readProperty(BBacnetDeviceObject.objectList);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final BValue decodeVal(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) {
        BValue bValue;
        String string = BBacnetPropertyIdentifier.tag(n);
        try {
            bValue = AsnUtil.asnToValue(this.device.getPropertyInfo(bBacnetObjectIdentifier.getObjectType(), n), byArray);
        }
        catch (AsnException asnException) {
            this.log().message("   ERROR: Unable to convert Asn-encoded value (" + ByteArrayUtil.toHexString((byte[])byArray) + ") for object " + (Object)((Object)bBacnetObjectIdentifier) + ", property " + string);
            log.message("Unable to convert Asn-encoded value (" + ByteArrayUtil.toHexString((byte[])byArray) + ") for object " + (Object)((Object)bBacnetObjectIdentifier) + ", property " + string);
            bValue = BString.make((String)("ASN error:" + bBacnetObjectIdentifier.toString() + " [" + string + ']'));
        }
        return bValue;
    }

    private final void readVal(BBacnetObjectIdentifier bBacnetObjectIdentifier, PropVal propVal) {
        String string = BBacnetPropertyIdentifier.tag(propVal.propId);
        try {
            byte[] byArray = BBacnetDiscoverJob.client().readProperty(this.device.getAddress(), bBacnetObjectIdentifier, propVal.propId);
            propVal.len = byArray.length + 4;
            propVal.val = this.decodeVal(bBacnetObjectIdentifier, propVal.propId, byArray);
        }
        catch (BacnetException bacnetException) {
            log.message("BacnetException reading property " + string + " for " + (Object)((Object)bBacnetObjectIdentifier) + " :: " + (Object)((Object)bacnetException));
            propVal.val = BString.make((String)(bacnetException.toString() + ':' + (Object)((Object)bBacnetObjectIdentifier) + " [" + string + ']'));
            propVal.err = true;
        }
    }

    private final void readObjectValsRP(Array array, int n, int n2) {
        int n3 = array.size();
        int n4 = 0;
        this.progress(n);
        ListIterator listIterator = array.iterator();
        while (listIterator.hasNext()) {
            IdVals idVals = (IdVals)listIterator.next();
            IntHashMap.Iterator iterator = idVals.propVals.iterator();
            while (iterator.hasNext()) {
                this.checkCancel();
                this.readVal(idVals.id, (PropVal)iterator.next());
            }
            this.progress(++n4, n3, n, n2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void readObjectVals(Array var1_1, int var2_2, int var3_3) {
        var4_4 = var1_1.size();
        var5_5 = 0;
        this.progress(var2_2);
        BBacnetDiscoverJob.log.trace("readObjectVals: a.size=" + var4_4);
        var6_6 = false;
        var7_7 = var1_1.iterator();
        if (!this.device.isServiceSupported("readPropertyMultiple")) {
            BBacnetDiscoverJob.log.trace("  no RPM; just use RP");
            this.log().message("Device does not support ReadPropertyMultiple; using ReadProperty...");
            this.readObjectValsRP(var1_1, var2_2, var3_3);
            return;
        }
        if (this.device.getSegmentationSupported().isSegmentedTransmit()) {
            BBacnetDiscoverJob.log.trace("segmented transmit ok, try one RPM!");
            v0 = BBacnetDiscoverJob.class$com$tridium$bacnet$asn$NReadAccessSpec;
            if (v0 == null) {
                v0 = BBacnetDiscoverJob.class$com$tridium$bacnet$asn$NReadAccessSpec = BBacnetDiscoverJob.class("[Lcom.tridium.bacnet.asn.NReadAccessSpec;", false);
            }
            var8_8 = new Array(v0);
            while (var7_7.hasNext()) {
                var9_10 = (IdVals)var7_7.next();
                var10_13 /* !! */  = new int[var9_10.propVals.size()];
                var11_15 = var9_10.propVals.iterator();
                var12_17 = 0;
                while (var11_15.hasNext()) {
                    var10_13 /* !! */ [var12_17++] = ((PropVal)var11_15.next()).propId;
                }
                var13_21 = new NReadAccessSpec(var9_10.id, var10_13 /* !! */ );
                var8_8.add(var13_21);
            }
            try {
                this.checkCancel();
                var9_10 = BBacnetDiscoverJob.client().readPropertyMultiple(this.device.getAddress(), var8_8);
                var7_7 = var1_1.iterator();
                while (var7_7.hasNext()) {
                    this.checkCancel();
                    if (!var9_10.hasNext()) {
                        throw new IllegalStateException("results do not match specs!");
                    }
                    var10_13 /* !! */  = (int[])((IdVals)var7_7.next());
                    var11_15 = var10_13 /* !! */ .propVals.iterator();
                    while (var11_15.hasNext()) {
                        var12_19 = (NReadPropertyResult)var9_10.next();
                        var13_21 = (PropVal)var11_15.next();
                        if (!var10_13 /* !! */ .id.equals((Object)var12_19.getObjectId())) {
                            throw new IllegalStateException("objectId mismatch: spec=" + (Object)var10_13 /* !! */ .id + "; rpr=" + (Object)var12_19.getObjectId());
                        }
                        if (var13_21.propId != var12_19.getPropertyId()) {
                            throw new IllegalStateException("propertyId mismatch: spec=" + var13_21.propId + "; rpr=" + var12_19.getPropertyId());
                        }
                        if (var12_19.isError()) {
                            var13_21.val = BString.make((String)(var12_19.getPropertyAccessError() + ':' + (Object)var12_19.getObjectId() + " [" + BBacnetPropertyIdentifier.tag(var13_21.propId) + ']'));
                            var13_21.err = true;
                            continue;
                        }
                        var13_21.val = this.decodeVal(var10_13 /* !! */ .id, var13_21.propId, var12_19.getPropertyValue());
                    }
                    this.progress(++var5_5, var4_4, var2_2, var3_3);
                }
                var6_6 = true;
            }
            catch (Exception var9_11) {
                BBacnetDiscoverJob.log.trace("Error reading object values with single RPM message:" + var9_11.toString());
                this.log().message("Error reading object values with single RPM message:" + var9_11.toString());
            }
        }
        this.checkCancel();
        if (!var6_6) {
            var8_9 = Math.min(BBacnetNetwork.localDevice().getMaxAPDULengthAccepted(), this.device.getMaxAPDULengthAccepted());
            var9_12 = var8_9 / 50;
            var10_14 = 1;
            var11_16 = 0;
            var12_20 = 0;
            var13_22 = 0;
            var14_23 = 0;
            var15_24 = 0;
            var7_7 = var1_1.iterator();
            var5_5 = 0;
            do {
                block34: {
                    block35: {
                        this.checkCancel();
                        var15_24 = var14_23 + var9_12;
                        v1 = BBacnetDiscoverJob.class$com$tridium$bacnet$asn$NReadAccessSpec;
                        if (v1 == null) {
                            v1 = BBacnetDiscoverJob.class("[Lcom.tridium.bacnet.asn.NReadAccessSpec;", false);
                        }
                        var16_25 = new Array(v1);
                        if (var15_24 > var1_1.size()) {
                            var15_24 = var1_1.size();
                        }
                        this.log().message("Reading object values in groups: items " + var14_23 + " to " + (var15_24 - 1));
                        BBacnetDiscoverJob.log.trace("Reading object values in groups: maxApdu=" + var8_9 + "; numVals=" + var9_12 + "; maxLen=" + var10_14 + "; totLen=" + var11_16 + "; totVals=" + var12_20 + "; avgLen=" + var13_22 + "; next=" + var14_23 + "; lastP1=" + var15_24);
                        var17_26 = var14_23;
                        while (var17_26 < var15_24) {
                            var18_27 = (IdVals)var7_7.next();
                            var19_31 = new int[var18_27.propVals.size()];
                            var20_36 = var18_27.propVals.iterator();
                            var21_38 = 0;
                            while (var20_36.hasNext() && var21_38 < var19_31.length) {
                                var19_31[var21_38++] = ((PropVal)var20_36.next()).propId;
                            }
                            var22_41 = new NReadAccessSpec(var18_27.id, var19_31);
                            var16_25.add(var22_41);
                            ++var17_26;
                        }
                        var17_26 = 1;
                        try {
                            var18_27 = BBacnetDiscoverJob.client().readPropertyMultiple(this.device.getAddress(), var16_25);
                            var19_32 = var14_23;
                            while (var19_32 < var15_24) {
                                var20_36 = (IdVals)var1_1.get(var19_32);
                                var21_39 = var20_36.propVals.iterator();
                                while (var21_39.hasNext()) {
                                    var22_41 = (PropVal)var21_39.next();
                                    var23_42 = (NReadPropertyResult)var18_27.next();
                                    if (var22_41.propId != var23_42.getPropertyId()) {
                                        var17_26 = 0;
                                        continue;
                                    }
                                    if (var23_42.isError()) {
                                        this.log().message("Error reading " + (Object)var20_36.id + " [" + var22_41.dbg() + ']');
                                        var22_41.val = BString.make((String)(var23_42.getPropertyAccessError() + ':' + (Object)var23_42.getObjectId() + " [" + BBacnetPropertyIdentifier.tag(var22_41.propId) + ']'));
                                        var22_41.err = true;
                                        var22_41.len = 8;
                                        continue;
                                    }
                                    var22_41.len = var23_42.getPropertyValue().length + 4;
                                    var22_41.val = this.decodeVal(var20_36.id, var22_41.propId, var23_42.getPropertyValue());
                                }
                                this.progress(++var5_5, var4_4, var2_2, var3_3);
                                ++var19_32;
                            }
                            break block34;
                        }
                        catch (BacnetException var18_28) {
                            if (var9_12 <= 4) break block35;
                            this.log().message("BacnetException reading group: " + (Object)var18_28 + "; retrying with smaller group size..");
                            if (BBacnetDiscoverJob.log.isTraceOn()) {
                                BBacnetDiscoverJob.log.trace("BacnetException reading group: " + (Object)var18_28 + "; retrying with smaller group size..");
                            }
                            var19_33 = var14_23;
                            ** while (var19_33 < var15_24)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var7_7.previous();
                            ++var19_33;
                            continue;
                        }
lbl134:
                        // 1 sources

                        var15_24 = var14_23 + (var9_12 /= 2);
                        continue;
                    }
                    this.log().message("BacnetException reading group: " + (Object)var18_28);
                    var17_26 = 0;
                }
                this.checkCancel();
                if (var17_26 == 0) {
                    BBacnetDiscoverJob.log.trace("!groupOk - RP for the items in this group.");
                    this.log().message("Reading items individually for ids " + var14_23 + " through " + var15_24 + "...");
                    var5_5 = var14_23;
                    var18_29 = var14_23;
                    while (var18_29 < var15_24) {
                        this.checkCancel();
                        var19_34 = (IdVals)var1_1.get(var18_29);
                        var20_36 = var19_34.propVals.iterator();
                        while (var20_36.hasNext()) {
                            var21_40 = (PropVal)var20_36.next();
                            if (var21_40.val != null) continue;
                            this.readVal(var19_34.id, var21_40);
                        }
                        this.progress(++var5_5, var4_4, var2_2, var3_3);
                        ++var18_29;
                    }
                }
                var18_30 = var14_23;
                while (var18_30 < var15_24) {
                    var19_35 = (IdVals)var1_1.get(var18_30);
                    ++var12_20;
                    var20_37 = var19_35.getLength();
                    if (var20_37 > var10_14) {
                        var10_14 = var20_37;
                    }
                    var11_16 += var20_37;
                    ++var18_30;
                }
                if (var12_20 > 0) {
                    var13_22 = var11_16 / var12_20;
                }
                if (var12_20 >= var1_1.size()) break;
                var14_23 = var15_24;
                var18_30 = var10_14;
                if (var13_22 != 0 && var10_14 > 3 * var13_22) {
                    var18_30 = var13_22;
                }
                var9_12 = (var8_9 - 3) / var18_30;
                BBacnetDiscoverJob.log.trace("Configure next group read: maxLen=" + var10_14 + "; avgLen=" + var13_22 + "  --> numVals=" + var9_12);
            } while (var15_24 <= var1_1.size());
        }
    }

    static final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    protected final BBacnetDevice device() {
        return this.device;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetDiscoverJob() {
    }

    public BBacnetDiscoverJob(BDeviceExt bDeviceExt) {
        this.device = (BBacnetDevice)bDeviceExt.getParent();
        this.deviceObject = this.device.getConfig().getDeviceObject();
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BBacnetDiscoverJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BBacnetDiscoverJob = BBacnetDiscoverJob.class("[Lcom.tridium.bacnet.job.BBacnetDiscoverJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.client");
        DESCRIPTION_ONLY = new int[]{28};
        lex = Lexicon.make((String)"bacnet");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IdVals {
        public BBacnetObjectIdentifier id;
        String name;
        public IntHashMap propVals;
        int pri;

        public void addPV(int n) {
            if (this.propVals.size() == 0) {
                this.pri = n;
            }
            this.propVals.put(n, (Object)new PropVal(n));
        }

        public void clear() {
            this.propVals.clear();
            this.pri = 85;
        }

        public PropVal get(int n) {
            return (PropVal)this.propVals.get(n);
        }

        public PropVal primary() {
            return (PropVal)this.propVals.get(this.pri);
        }

        public int getLength() {
            IntHashMap.Iterator iterator = this.propVals.iterator();
            int n = 7;
            while (iterator.hasNext()) {
                n += ((PropVal)iterator.next()).len;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.id.toShortString()).append(" {");
            IntHashMap.Iterator iterator = this.propVals.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((PropVal)iterator.next()).dbg());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        private final /* synthetic */ void this() {
            this.pri = 85;
        }

        public IdVals(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
            this(bBacnetObjectIdentifier, new int[0]);
        }

        public IdVals(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
            this(bBacnetObjectIdentifier, new int[]{n});
        }

        public IdVals(BBacnetObjectIdentifier bBacnetObjectIdentifier, int[] nArray) {
            this.this();
            this.id = bBacnetObjectIdentifier;
            this.propVals = new IntHashMap();
            int n = 0;
            while (n < nArray.length) {
                this.propVals.put(nArray[n], (Object)new PropVal(nArray[n]));
                ++n;
            }
            if (nArray.length > 0) {
                this.pri = nArray[0];
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PropVal {
        int propId;
        BValue val;
        int len;
        boolean err;

        public String toString() {
            return this.val != null ? this.val.toString() : "--";
        }

        public String dbg() {
            return "" + this.propId + '=' + (this.val != null ? this.val.toString() + " [" + this.val.getType() + ']' : "--");
        }

        private final /* synthetic */ void this() {
            this.len = 0;
            this.err = false;
        }

        public PropVal(int n) {
            this.this();
            this.propId = n;
        }
    }
}

