/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.history.BBacnetHistoryImport;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLogMultipleRecord;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetTrendLogMultipleImport
extends BBacnetHistoryImport
implements BacnetConst {
    public static final Property localHistoryNames = BBacnetTrendLogMultipleImport.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    public static final Log log;
    public static final Lexicon lex;
    public static final int ASN_NULL = 0;
    public static final int ASN_BOOLEAN = 1;
    public static final int ASN_UNSIGNED = 2;
    public static final int ASN_INTEGER = 3;
    public static final int ASN_REAL = 4;
    public static final int ASN_DOUBLE = 5;
    public static final int ASN_OCTET_STRING = 6;
    public static final int ASN_CHARACTER_STRING = 7;
    public static final int ASN_BIT_STRING = 8;
    public static final int ASN_ENUMERATED = 9;
    public static final int ASN_DATE = 10;
    public static final int ASN_TIME = 11;
    public static final int ASN_OBJECT_IDENTIFIER = 12;
    private AsnInputStream asnIn;
    byte[] prev;
    String[] prevNams;
    boolean oprChange;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetTrendLogMultipleImport;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetLogMultipleRecord;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference;
    static /* synthetic */ Class class$java$lang$String;

    public String getLocalHistoryNames() {
        return this.getString(localHistoryNames);
    }

    public void setLocalHistoryNames(String string) {
        this.setString(localHistoryNames, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExecute() throws ArchiveException {
        block23: {
            block22: {
                if (!this.isRunning()) {
                    return;
                }
                BBacnetDevice bBacnetDevice = this.device();
                if (!bBacnetDevice.isServiceSupported("readRange")) {
                    this.executeFail(lex.getText("serviceNotSupported.readRange"));
                    return;
                }
                BHistoryDatabase bHistoryDatabase = this.getHistoryDb();
                this.verifyLocalNameFormat();
                BIHistory[] bIHistoryArray = this.getOrCreateHistories(bHistoryDatabase);
                long l = -1;
                int n = 6;
                BBacnetDateTime bBacnetDateTime = this.getReferenceTime();
                int n2 = this.getMaxRecordsPerRequest();
                if (n2 == 0) {
                    n2 = 10;
                }
                try {
                    try {
                        l = this.determineNextIndex();
                        if (l < 0L) {
                            Object var10_8 = null;
                            break block22;
                        }
                        ReadRangeAck readRangeAck = null;
                        boolean bl = true;
                        block7: while (bl) {
                            Object object;
                            Class clazz;
                            ReadRangeAck readRangeAck2 = this.client().readRange(bBacnetDevice.getAddress(), this.getObjectId(), 131, -1, n, l, bBacnetDateTime, n2);
                            if (readRangeAck2 == null) {
                                log.message("Error importing history data for " + this + ": null response from device!");
                                break;
                            }
                            if (((Object)readRangeAck2).equals(readRangeAck)) {
                                log.message("Error importing history data for " + this + ": duplicate response (loop?):\nResponse:" + readRangeAck2);
                                break;
                            }
                            readRangeAck = readRangeAck2;
                            byte[] byArray = readRangeAck2.getItemData();
                            if (byArray == null || byArray.length == 0) break;
                            boolean bl2 = false;
                            if (readRangeAck2.isMoreItems() || !readRangeAck2.includesLastItem()) {
                                bl2 = true;
                            }
                            bl = bl2;
                            this.asnIn.setBuffer(byArray);
                            long l2 = readRangeAck2.getFirstSequenceNumber();
                            if (l2 == (long)-1) {
                                l2 = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                            }
                            if ((clazz = class$javax$baja$bacnet$datatypes$BBacnetLogMultipleRecord) == null) {
                                clazz = BBacnetTrendLogMultipleImport.class("[Ljavax.baja.bacnet.datatypes.BBacnetLogMultipleRecord;", false);
                            }
                            Array array = new Array(clazz);
                            while (true) {
                                if (this.asnIn.peekTag() == -1) break;
                                object = new BBacnetLogMultipleRecord(this.asnIn);
                                array.add(object);
                            }
                            object = (BBacnetLogMultipleRecord[])array.trim();
                            BBacnetLogMultipleRecord bBacnetLogMultipleRecord = object[((BBacnetLogMultipleRecord[])object).length - 1];
                            this.getReferenceTime().copyFrom((BComplex)bBacnetLogMultipleRecord.getTimestamp());
                            this.setLastSequenceNumberProcessed(readRangeAck2.getFirstSequenceNumber() + (long)((BBacnetLogMultipleRecord[])object).length - 1L);
                            int n3 = 0;
                            while (true) {
                                if (n3 >= ((BBacnetLogMultipleRecord[])object).length) {
                                    if (!bl) continue block7;
                                    l = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                                    bBacnetDateTime = this.getReferenceTime();
                                    continue block7;
                                }
                                BBacnetLogMultipleRecord bBacnetLogMultipleRecord2 = object[n3];
                                int n4 = 0;
                                while (n4 < bIHistoryArray.length) {
                                    if (bIHistoryArray[n4] != null) {
                                        try {
                                            BHistoryRecord bHistoryRecord = bBacnetLogMultipleRecord2.initializeNiagaraRecord(bIHistoryArray[n4].getConfig().makeRecord(), l2, n4);
                                            bIHistoryArray[n4].append((BIHistoryRecordSet)this.correctTimestamp(bHistoryRecord));
                                        }
                                        catch (Exception exception) {
                                            log.error("Ignore trend record " + l2 + ':' + exception.toString());
                                            break;
                                        }
                                    }
                                    ++n4;
                                }
                                l2 = BacnetTrendLogUtil.incrementSequenceNumber(l2);
                                ++n3;
                            }
                        }
                        this.executeOk();
                        break block23;
                    }
                    catch (Exception exception) {
                        this.executeFail(exception);
                        log.error("Asn Exception reading range (device " + bBacnetDevice.getAddress() + ", id " + (Object)((Object)this.getObjectId()) + ", rangeType " + n + ", referenceIndex " + l + ", referenceTime " + bBacnetDateTime + ", count " + n2 + ')', (Throwable)exception);
                        throw new ArchiveException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    this.setState(BDescriptorState.idle);
                    throw throwable;
                }
            }
            this.setState(BDescriptorState.idle);
            return;
        }
        Object var10_10 = null;
        this.setState(BDescriptorState.idle);
    }

    private final BBacnetObjectPropertyReference[] getDeviceObjectProps() throws ArchiveException {
        try {
            byte[] byArray = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 132);
            boolean bl = false;
            if (this.prev == null || !ByteArrayUtil.equals((byte[])byArray, (byte[])this.prev)) {
                bl = true;
            }
            this.oprChange = bl;
            this.prev = byArray;
            this.asnIn.setBuffer(byArray);
            Class clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference;
            if (clazz == null) {
                clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference = BBacnetTrendLogMultipleImport.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;", false);
            }
            Array array = new Array(clazz);
            while (this.asnIn.available() > 0) {
                BBacnetObjectPropertyReference bBacnetObjectPropertyReference = new BBacnetObjectPropertyReference();
                bBacnetObjectPropertyReference.readAsn(this.asnIn);
                array.add((Object)bBacnetObjectPropertyReference);
            }
            return (BBacnetObjectPropertyReference[])array.trim();
        }
        catch (Throwable throwable) {
            throw new ArchiveException(throwable);
        }
    }

    private final String[] getHistoryNames(BBacnetObjectPropertyReference[] bBacnetObjectPropertyReferenceArray) throws ArchiveException {
        if (!this.oprChange && this.prevNams != null) {
            return this.prevNams;
        }
        try {
            BBacnetDevice bBacnetDevice = this.device();
            Hashtable<BBacnetObjectIdentifier, String> hashtable = new Hashtable<BBacnetObjectIdentifier, String>();
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = BBacnetTrendLogMultipleImport.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            int n = 0;
            while (n < bBacnetObjectPropertyReferenceArray.length) {
                BBacnetObjectIdentifier bBacnetObjectIdentifier = bBacnetObjectPropertyReferenceArray[n].getObjectId();
                String string = (String)hashtable.get((Object)bBacnetObjectIdentifier);
                if (string == null) {
                    try {
                        byte[] byArray = this.client().readProperty(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 77);
                        string = AsnUtil.fromAsnCharacterString(byArray);
                    }
                    catch (Throwable throwable) {
                        string = bBacnetObjectIdentifier.toShortString();
                    }
                    hashtable.put(bBacnetObjectIdentifier, string);
                }
                if (string.length() > 0) {
                    int n2 = bBacnetObjectPropertyReferenceArray[n].getPropertyId();
                    PropertyInfo propertyInfo = bBacnetDevice.getPropertyInfo(bBacnetObjectIdentifier.getId(), n2);
                    string = propertyInfo != null ? this.getLocalHistoryName() + '_' + string + '_' + propertyInfo.getName() : this.getLocalHistoryName() + '_' + string + "_p" + n2;
                }
                array.add((Object)string);
                ++n;
            }
            this.prevNams = (String[])array.trim();
            this.setLocalHistoryNames(this.toDelimitedString(this.prevNams));
            return this.prevNams;
        }
        catch (Throwable throwable) {
            throw new ArchiveException(throwable);
        }
    }

    private final String toDelimitedString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final String[] getStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public String[] getLocalHistoryNamesArray() {
        return BBacnetTrendLogMultipleImport.getStringArray(this.getLocalHistoryNames());
    }

    private final BIHistory[] getOrCreateHistories(BHistoryDatabase bHistoryDatabase) {
        BBacnetObjectPropertyReference[] bBacnetObjectPropertyReferenceArray = this.getDeviceObjectProps();
        String[] stringArray = this.getHistoryNames(bBacnetObjectPropertyReferenceArray);
        BIHistory[] bIHistoryArray = new BIHistory[bBacnetObjectPropertyReferenceArray.length];
        int n = 0;
        while (n < bBacnetObjectPropertyReferenceArray.length) {
            bIHistoryArray[n] = null;
            BHistoryId bHistoryId = BHistoryId.make((String)this.device().getName(), (String)stringArray[n]);
            if (bHistoryId != null) {
                BTypeSpec bTypeSpec;
                bIHistoryArray[n] = bHistoryDatabase.getHistory(bHistoryId);
                if (bIHistoryArray[n] == null && (bTypeSpec = this.getTypeSpec(bBacnetObjectPropertyReferenceArray[n])) != null) {
                    bIHistoryArray[n] = this.createHistory(bHistoryDatabase, bTypeSpec, bHistoryId);
                }
            }
            ++n;
        }
        return bIHistoryArray;
    }

    public BIHistory[] getHistories() {
        BHistorySpace bHistorySpace = (BHistorySpace)BOrd.make((String)"history:").get((BObject)this);
        String[] stringArray = BBacnetTrendLogMultipleImport.getStringArray(this.getLocalHistoryNames());
        if (bHistorySpace == null || stringArray.length == 0) {
            return new BIHistory[0];
        }
        BIHistory[] bIHistoryArray = new BIHistory[stringArray.length];
        int n = 0;
        while (n < bIHistoryArray.length) {
            BHistoryId bHistoryId = BHistoryId.make((String)this.getParent().getParent().getName(), (String)stringArray[n]);
            bIHistoryArray[n] = bHistorySpace.getHistory(bHistoryId);
            ++n;
        }
        return bIHistoryArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.asnIn = new AsnInputStream();
        this.prev = null;
        this.prevNams = null;
        this.oprChange = true;
    }

    public BBacnetTrendLogMultipleImport() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$history$BBacnetTrendLogMultipleImport;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetTrendLogMultipleImport = BBacnetTrendLogMultipleImport.class("[Lcom.tridium.bacnet.history.BBacnetTrendLogMultipleImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.history");
        lex = Lexicon.make((String)"bacnet");
    }
}

