/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import java.util.HashMap;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetTrendLogAlarmSourceExt
extends BPointExtension
implements BIAlarmSource,
BacnetAlarmConst {
    public static final Property notificationThreshold = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BLong.make((long)10L), null);
    public static final Property recordsSinceNotification = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BLong.make((long)0L), null);
    public static final Property lastNotifyRecord = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BLong.make((long)0L), null);
    public static final Property alarmInhibit = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property alarmState = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BAlarmState.normal, null);
    public static final Property alarmEnable = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BAlarmTransitionBits.make((int)4), null);
    public static final Property ackedTransitions = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)BAlarmTransitionBits.ALL, null);
    public static final Property notifyType = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BBacnetNotifyType.alarm, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"bacnet:BacnetNotifyTypeFE")));
    public static final Property toOffnormalTimes = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    public static final Property toFaultTimes = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    public static final Property toNormalTimes = BBacnetTrendLogAlarmSourceExt.newProperty((int)3, (BValue)new BAlarmTimestamps(), null);
    public static final Property toNormalText = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (String)"BUFFER_READY", null);
    public static final Property hyperlinkOrd = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (boolean)false));
    public static final Property alarmClass = BBacnetTrendLogAlarmSourceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Action ackAlarm = BBacnetTrendLogAlarmSourceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    private static final Context millis;
    private static Log log;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt;

    public long getNotificationThreshold() {
        return this.getLong(notificationThreshold);
    }

    public void setNotificationThreshold(long l) {
        this.setLong(notificationThreshold, l, null);
    }

    public long getRecordsSinceNotification() {
        return this.getLong(recordsSinceNotification);
    }

    public void setRecordsSinceNotification(long l) {
        this.setLong(recordsSinceNotification, l, null);
    }

    public long getLastNotifyRecord() {
        return this.getLong(lastNotifyRecord);
    }

    public void setLastNotifyRecord(long l) {
        this.setLong(lastNotifyRecord, l, null);
    }

    public BStatusBoolean getAlarmInhibit() {
        return (BStatusBoolean)this.get(alarmInhibit);
    }

    public void setAlarmInhibit(BStatusBoolean bStatusBoolean) {
        this.set(alarmInhibit, (BValue)bStatusBoolean, null);
    }

    public BAlarmState getAlarmState() {
        return (BAlarmState)this.get(alarmState);
    }

    public void setAlarmState(BAlarmState bAlarmState) {
        this.set(alarmState, (BValue)bAlarmState, null);
    }

    public BAlarmTransitionBits getAlarmEnable() {
        return (BAlarmTransitionBits)this.get(alarmEnable);
    }

    public void setAlarmEnable(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(alarmEnable, (BValue)bAlarmTransitionBits, null);
    }

    public BAlarmTransitionBits getAckedTransitions() {
        return (BAlarmTransitionBits)this.get(ackedTransitions);
    }

    public void setAckedTransitions(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(ackedTransitions, (BValue)bAlarmTransitionBits, null);
    }

    public BBacnetNotifyType getNotifyType() {
        return (BBacnetNotifyType)this.get(notifyType);
    }

    public void setNotifyType(BBacnetNotifyType bBacnetNotifyType) {
        this.set(notifyType, (BValue)bBacnetNotifyType, null);
    }

    public BAlarmTimestamps getToOffnormalTimes() {
        return (BAlarmTimestamps)this.get(toOffnormalTimes);
    }

    public void setToOffnormalTimes(BAlarmTimestamps bAlarmTimestamps) {
        this.set(toOffnormalTimes, (BValue)bAlarmTimestamps, null);
    }

    public BAlarmTimestamps getToFaultTimes() {
        return (BAlarmTimestamps)this.get(toFaultTimes);
    }

    public void setToFaultTimes(BAlarmTimestamps bAlarmTimestamps) {
        this.set(toFaultTimes, (BValue)bAlarmTimestamps, null);
    }

    public BAlarmTimestamps getToNormalTimes() {
        return (BAlarmTimestamps)this.get(toNormalTimes);
    }

    public void setToNormalTimes(BAlarmTimestamps bAlarmTimestamps) {
        this.set(toNormalTimes, (BValue)bAlarmTimestamps, null);
    }

    public String getToNormalText() {
        return this.getString(toNormalText);
    }

    public void setToNormalText(String string) {
        this.setString(toNormalText, string, null);
    }

    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    public void setHyperlinkOrd(BOrd bOrd) {
        this.set(hyperlinkOrd, (BValue)bOrd, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setLastNotifyRecord(this.getTrendLogExt().getTotalRecordCount());
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIBacnetTrendLogExt;
    }

    protected boolean isSiblingLegal(BComponent bComponent) {
        return true;
    }

    protected BIBacnetTrendLogExt getTrendLogExt() {
        return (BIBacnetTrendLogExt)this.getParent();
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        BAlarmTransitionBits bAlarmTransitionBits;
        if (!this.isRunning()) {
            return BBoolean.make((boolean)false);
        }
        bAlarmRecord.setAckTime(BAbsTime.make());
        boolean bl = false;
        bAlarmRecord.setAckState(BAckState.acked);
        bAlarmRecord.setAckRequired(false);
        BSourceState bSourceState = bAlarmRecord.getSourceState();
        Property property = null;
        if (bSourceState == BSourceState.normal) {
            property = toNormalTimes;
        } else if (bSourceState == BSourceState.offnormal) {
            property = toOffnormalTimes;
        } else if (bSourceState == BSourceState.fault) {
            property = toFaultTimes;
        } else {
            throw new IllegalStateException();
        }
        BAlarmTimestamps bAlarmTimestamps = (BAlarmTimestamps)this.get(property);
        BAbsTime bAbsTime = bAlarmTimestamps.getAlarmTime();
        if (bAbsTime.equals((Object)bAlarmRecord.getTimestamp())) {
            bAlarmTimestamps.setAckTime(bAlarmRecord.getAckTime());
            bAlarmTimestamps.setCount(0);
            bAlarmTransitionBits = this.getAckedTransitions();
            if (bSourceState == BSourceState.offnormal) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)bAlarmTransitionBits, (BAlarmTransitionBits)BAlarmTransitionBits.toOffnormal, (boolean)true));
            } else if (bSourceState == BSourceState.fault) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)bAlarmTransitionBits, (BAlarmTransitionBits)BAlarmTransitionBits.toFault, (boolean)true));
            } else if (bSourceState == BSourceState.normal) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)bAlarmTransitionBits, (BAlarmTransitionBits)BAlarmTransitionBits.toNormal, (boolean)true));
            } else if (bSourceState == BSourceState.alert) {
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)bAlarmTransitionBits, (BAlarmTransitionBits)BAlarmTransitionBits.toAlert, (boolean)true));
            }
            bl = true;
        } else {
            log.message("Ack timestamp does not match: stale ack! " + bAbsTime.toString(millis) + " != " + bAlarmRecord.getTimestamp().toString(millis));
            bAlarmRecord.addAlarmFacet("staleAck", (BIDataValue)BBoolean.TRUE);
        }
        try {
            bAlarmTransitionBits = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            bAlarmTransitionBits.routeAlarm(bAlarmRecord);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return BBoolean.make((boolean)bl);
    }

    public void incrementRecordsSinceNotification() {
        this.setRecordsSinceNotification(this.getRecordsSinceNotification() + 1L);
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == notificationThreshold || property == recordsSinceNotification) {
            this.checkBufferReady(this.getTrendLogExt().getTotalRecordCount());
        }
    }

    public void checkBufferReady(long l) {
        boolean bl;
        if (this.getAlarmInhibit().getBoolean()) {
            return;
        }
        if (this.getRecordsSinceNotification() >= this.getNotificationThreshold() && (bl = this.initiateBufferReadyEvent(l, this.getLastNotifyRecord()))) {
            this.setRecordsSinceNotification(0L);
            this.setLastNotifyRecord(l);
        }
    }

    private final boolean initiateBufferReadyEvent(long l, long l2) {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference;
        BBacnetObjectIdentifier bBacnetObjectIdentifier;
        if (!this.getAlarmEnable().includes(BSourceState.normal)) {
            return true;
        }
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        String string = "";
        BOrd bOrd = BOrd.NULL;
        Property property = null;
        string = this.getToNormalText();
        bOrd = this.getHyperlinkOrd();
        property = toNormalTimes;
        try {
            bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(((BComponent)this.getTrendLogExt()).getHandleOrd());
            bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference(bBacnetObjectIdentifier, 131);
            hashMap.put("presentValue", BString.make((String)bBacnetDeviceObjectPropertyReference.encodeToString()));
            hashMap.put("fromState", BString.make((String)this.getAlarmState().getTag()));
            hashMap.put("toState", BString.make((String)BAlarmState.normal.getTag()));
            hashMap.put("msgText", BString.make((String)string));
            hashMap.put("hyperlinkOrd", BString.make((String)bOrd.toString()));
            hashMap.put("notifyType", BString.make((String)this.getNotifyType().getTag()));
            hashMap.put("previousNotification", BString.make((String)String.valueOf(l2)));
            hashMap.put("currentNotification", BString.make((String)String.valueOf(l)));
        }
        catch (Exception exception) {
            log.error("Buffer-Ready toNormal Transition Failed - Could not build alarm record facets.", (Throwable)exception);
            return false;
        }
        try {
            BAlarmTransitionBits bAlarmTransitionBits;
            bBacnetObjectIdentifier = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            bBacnetDeviceObjectPropertyReference = bBacnetObjectIdentifier.lookupAlarmClass(this.getAlarmClass());
            BAlarmRecord bAlarmRecord = new BAlarmRecord((BComponent)this, this.getAlarmClass(), BFacets.make(hashMap));
            bAlarmRecord.setSourceState(BSourceState.normal);
            boolean bl = bBacnetDeviceObjectPropertyReference.getAckRequired().includes(BSourceState.normal);
            bAlarmRecord.setAckRequired(bl);
            if (bl) {
                bAlarmTransitionBits = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)bAlarmTransitionBits, (BAlarmTransitionBits)BAlarmTransitionBits.toNormal, (boolean)false));
            }
            bAlarmTransitionBits = (BAlarmTimestamps)this.get(property);
            BAbsTime bAbsTime = bAlarmRecord.getTimestamp();
            bAlarmTransitionBits.setAlarmTime(bAbsTime);
            bAlarmTransitionBits.setNormalTime(bAbsTime);
            bAlarmRecord.setNormalTime(bAbsTime);
            bAlarmTransitionBits.setAckTime(BAbsTime.DEFAULT);
            bAlarmTransitionBits.setCount(bAlarmTransitionBits.getCount() + 1);
            bBacnetObjectIdentifier.routeAlarm(bAlarmRecord);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Buffer-Ready toNormal Transition Failed - AlarmService not found.");
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt = BBacnetTrendLogAlarmSourceExt.class("[Lcom.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        millis = BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
        log = Log.getLog((String)"bacnet.server");
    }
}

