/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetActivePeriod;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import java.io.IOException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetTrendLogDescriptor;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.history.ext.BNumericIntervalHistoryExt;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetNumericIntervalTrendLogExt
extends BNumericIntervalHistoryExt
implements BIBacnetTrendLogExt {
    public static final Property historyNameFormat = BBacnetNumericIntervalTrendLogExt.newProperty((int)0, (BValue)BFormat.make((String)"%parent.name% Log"), null);
    public static final Property totalRecordCount = BBacnetNumericIntervalTrendLogExt.newProperty((int)1, (BValue)BLong.make((long)0L), null);
    public static final Action startLogging = BBacnetNumericIntervalTrendLogExt.newAction((int)0, null);
    public static final Action stopLogging = BBacnetNumericIntervalTrendLogExt.newAction((int)0, null);
    public static final Type TYPE;
    private static Log log;
    private BBacnetNumericTrendRecord rec;
    private boolean trigger;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetNumericIntervalTrendLogExt;

    public long getTotalRecordCount() {
        return this.getLong(totalRecordCount);
    }

    public void setTotalRecordCount(long l) {
        this.setLong(totalRecordCount, l, null);
    }

    public void startLogging() {
        this.invoke(startLogging, null, null);
    }

    public void stopLogging() {
        this.invoke(stopLogging, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.rec = new BBacnetNumericTrendRecord();
        if (!(this.getActivePeriod() instanceof BBacnetActivePeriod)) {
            this.setActivePeriod(new BBacnetActivePeriod());
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(this.getHandleOrd());
        if (bBacnetObjectIdentifier == null) {
            BBacnetTrendLogDescriptor bBacnetTrendLogDescriptor = new BBacnetTrendLogDescriptor();
            bBacnetTrendLogDescriptor.setObjectId(BBacnetObjectIdentifier.make(20, BBacnetNetwork.localDevice().getNextInstance(bBacnetTrendLogDescriptor.getObjectId().getObjectType())));
            bBacnetTrendLogDescriptor.setObjectName(SlotPath.unescape((String)this.getHistoryNameFormat().format((Object)this)));
            BBacnetNetwork.localDevice().getExportTable().add(bBacnetTrendLogDescriptor.getObjectId().toString(BacnetConst.nameContext), (BValue)bBacnetTrendLogDescriptor);
            bBacnetTrendLogDescriptor.setObjectOrd(this.getHandleOrd(), null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void atSteadyState() {
        if (!this.isRunning()) return;
        try {
            try {
                BAbsTime bAbsTime = BAbsTime.make();
                if (this.getActivePeriod().isActive(bAbsTime) && this.getEnabled()) {
                    this.trigger = true;
                    long l = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                    BTrendEvent bTrendEvent = BTrendEvent.LOG_STATUS_ENABLED;
                    BStatus bStatus = BStatus.DEFAULT;
                    BacnetTrendLogUtil.writeEvent(this, bAbsTime, bStatus, l, bTrendEvent);
                }
            }
            catch (Exception exception) {
                log.error("Error storing log status enabled event", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.trigger = false;
            throw throwable;
        }
        {
            Object var2_8 = null;
            this.trigger = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (!property.equals((Object)enabled)) return;
        if (!this.isParentLegal(this.getParent().asComponent())) {
            log.error("Tried to enable BacnetTrendLogExt inside an illegal parent!?");
            this.setEnabled(false);
            return;
        }
        try {
            block8: {
                try {
                    this.trigger = true;
                    BAbsTime bAbsTime = BAbsTime.make();
                    if (this.getEnabled()) {
                        BacnetTrendLogUtil.writeEvent(this, bAbsTime, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_ENABLED);
                        break block8;
                    }
                    BacnetTrendLogUtil.writeEvent(this, bAbsTime, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
                }
                catch (Exception exception) {
                    log.error("Error storing event", (Throwable)exception);
                }
            }
            Object var4_7 = null;
            this.trigger = false;
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.trigger = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clockChanged(BRelTime bRelTime) throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        try {
            try {
                this.trigger = true;
                long l = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                BAbsTime bAbsTime = BAbsTime.now();
                BTrendEvent bTrendEvent = BTrendEvent.makeTimeChange(bRelTime.getSeconds());
                BStatus bStatus = this.getStatus();
                BacnetTrendLogUtil.writeEvent(this, bAbsTime, bStatus, l, bTrendEvent);
            }
            catch (Exception exception) {
                log.error("Error storing event", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.trigger = false;
            throw throwable;
        }
        {
            Object var3_9 = null;
            this.trigger = false;
            return;
        }
    }

    public void doStartLogging() {
        this.setEnabled(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doStopLogging() {
        try {
            try {
                this.trigger = true;
                BAbsTime bAbsTime = BAbsTime.make();
                BacnetTrendLogUtil.writeEvent(this, bAbsTime, BStatus.DEFAULT, BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
            }
            catch (Exception exception) {
                log.error("Error storing event", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.trigger = false;
            this.setEnabled(false);
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.trigger = false;
        }
        this.setEnabled(false);
    }

    public Type getRecordType() {
        return BBacnetNumericTrendRecord.TYPE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeRecord(BAbsTime bAbsTime, BStatusValue bStatusValue) throws IOException {
        try {
            this.trigger = true;
            BacnetTrendLogUtil.writeRecord(this, bAbsTime, bStatusValue);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.trigger = false;
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.trigger = false;
            return;
        }
    }

    public BBacnetTrendRecord getRecord() {
        return this.rec;
    }

    public ErrorType setLogInterval(long l, Context context) {
        this.set(interval, (BValue)BRelTime.make((long)l), context);
        return null;
    }

    public boolean getTrigger() {
        return this.trigger;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.trigger = false;
    }

    public BBacnetNumericIntervalTrendLogExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$history$BBacnetNumericIntervalTrendLogExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetNumericIntervalTrendLogExt = BBacnetNumericIntervalTrendLogExt.class("[Lcom.tridium.bacnet.history.BBacnetNumericIntervalTrendLogExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.server");
    }
}

