/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.history.BBacnetHistoryImport;
import com.tridium.bacnet.job.BBacnetDiscoverTrendLogsJob;
import com.tridium.driver.util.StringUtil;
import java.util.ArrayList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetHistoryDeviceExt
extends BHistoryDeviceExt
implements BacnetConst {
    public static final Action submitTrendLogDiscoveryJob = BBacnetHistoryDeviceExt.newAction((int)4, null);
    public static final Action getImportTypes = BBacnetHistoryDeviceExt.newAction((int)4, null);
    public static final Type TYPE;
    public static final Log log;
    private BTimeZone timeZone;
    private boolean timeZoneChecked;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetHistoryDeviceExt;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetHistoryImport;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public BOrd submitTrendLogDiscoveryJob() {
        return (BOrd)this.invoke(submitTrendLogDiscoveryJob, null, null);
    }

    public BString getImportTypes() {
        return (BString)this.invoke(getImportTypes, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetDevice;
    }

    public void added(Property property, Context context) {
        BBacnetHistoryImport bBacnetHistoryImport;
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue instanceof BBacnetHistoryImport && (bBacnetHistoryImport = (BBacnetHistoryImport)bValue).getExecutionTime().getTriggerMode() != BManualTriggerMode.DEFAULT) {
            ((BBacnetHistoryImport)bValue).execute();
        }
    }

    public void subscribed() {
        log.trace("Determining time zone for history imports");
        this.getTimeZone();
    }

    public BOrd doSubmitTrendLogDiscoveryJob(Context context) {
        if (this.device().isFatalFault()) {
            return null;
        }
        return new BBacnetDiscoverTrendLogsJob(this).submit(context);
    }

    public BString doGetImportTypes() {
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BBacnetHistoryImport.TYPE.getTypeInfo());
        String[] stringArray = new String[typeInfoArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = typeInfoArray[n].toString();
            ++n;
        }
        String string = StringUtil.toString((String[])stringArray, (String)";");
        return BString.make((String)string);
    }

    public final BBacnetDevice device() {
        return (BBacnetDevice)this.getDevice();
    }

    public Cursor getHistoryIds(BOrd bOrd) {
        throw new UnsupportedOperationException("Unsupported operation BBacnetHistoryDeviceExt.getHistoryIds()");
    }

    public Type getImportDescriptorType() {
        return BBacnetHistoryImport.TYPE;
    }

    public Type getExportDescriptorType() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final BBacnetHistoryImport[] findImportDescriptors(BBacnetObjectIdentifier var1_1) {
        var2_2 = this.getProperties();
        var3_3 = new ArrayList<Object>();
        if (true) ** GOTO lbl8
        do {
            if ((var4_4 = (BBacnetHistoryImport)var2_2.get()).getObjectId().equals((Object)var1_1)) {
                var3_3.add(var4_4);
            }
lbl8:
            // 4 sources

            if ((v0 = BBacnetHistoryDeviceExt.class$com$tridium$bacnet$history$BBacnetHistoryImport) != null) continue;
            v0 = BBacnetHistoryDeviceExt.class("[Lcom.tridium.bacnet.history.BBacnetHistoryImport;", false);
        } while (var2_2.next(v0));
        var4_4 = new BBacnetHistoryImport[var3_3.size()];
        return (BBacnetHistoryImport[])var3_3.toArray((T[])var4_4);
    }

    private static final BTimeZone getTimeZone(int n, boolean bl, BAbsTime bAbsTime) {
        Object object;
        int n2 = (int)((long)(-n) * 60000L);
        if (bl) {
            n2 = (int)((long)n2 - 3600000L);
        }
        BTimeZone[] bTimeZoneArray = TimeZoneDatabase.get().getTimeZones();
        Class clazz = class$javax$baja$timezone$BTimeZone;
        if (clazz == null) {
            clazz = class$javax$baja$timezone$BTimeZone = BBacnetHistoryDeviceExt.class("[Ljavax.baja.timezone.BTimeZone;", false);
        }
        Array array = new Array(clazz);
        int n3 = 0;
        while (n3 < bTimeZoneArray.length) {
            object = bTimeZoneArray[n3];
            if (object.getUtcOffset() == n2) {
                boolean bl2;
                long l = BAbsTime.now().getMillis();
                boolean bl3 = false;
                if (bAbsTime.isAfter(object.getDaylightTimeStart(l)) && bAbsTime.isBefore(object.getDaylightTimeEnd(l))) {
                    bl3 = true;
                }
                if (bl == (bl2 = bl3)) {
                    array.add(object);
                }
            }
            ++n3;
        }
        if (log.isTraceOn()) {
            System.out.println("getTimeZone(): candidate list size:" + array.size());
        }
        if (array.size() == 0) {
            return null;
        }
        if (array.size() == 1) {
            return (BTimeZone)array.get(0);
        }
        if (log.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            object = array.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next()).append(';');
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            log.trace("Time Zones matching the specified UTC Offset and Daylight Savings Status:\n" + stringBuffer.toString());
        }
        return (BTimeZone)array.get(0);
    }

    public BTimeZone getTimeZone() {
        BBacnetDeviceObject bBacnetDeviceObject = this.device().getConfig().getDeviceObject();
        if (!this.timeZoneChecked) {
            try {
                BInteger bInteger = (BInteger)bBacnetDeviceObject.readBacnetProperty((BEnum)BBacnetPropertyIdentifier.utcOffset);
                BBoolean bBoolean = (BBoolean)bBacnetDeviceObject.readBacnetProperty((BEnum)BBacnetPropertyIdentifier.daylightSavingsStatus);
                if (bInteger != null) {
                    BTimeZone bTimeZone;
                    BBacnetDate bBacnetDate = (BBacnetDate)bBacnetDeviceObject.readBacnetProperty((BEnum)BBacnetPropertyIdentifier.localDate);
                    BBacnetTime bBacnetTime = (BBacnetTime)bBacnetDeviceObject.readBacnetProperty((BEnum)BBacnetPropertyIdentifier.localTime);
                    BAbsTime bAbsTime = BBacnetDateTime.makeBAbsTime(bBacnetDate, bBacnetTime);
                    this.timeZone = bTimeZone = BBacnetHistoryDeviceExt.getTimeZone(bInteger.getInt(), bBoolean.getBoolean(), bAbsTime);
                    this.timeZoneChecked = true;
                } else {
                    this.timeZoneChecked = true;
                }
            }
            catch (Exception exception) {
                log.warning("Exception reading time zone info from device:" + exception);
            }
            if (this.timeZone == null) {
                log.warning("TimeZone determined from TimeZoneDatabase and device values is null, resetting to default!");
                this.timeZone = BTimeZone.getLocal();
            }
        }
        return this.timeZone;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetHistoryDeviceExt", 2);
        spyWriter.prop((Object)"timeZone", (Object)this.timeZone);
        spyWriter.prop((Object)"timeZoneChecked", this.timeZoneChecked);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.timeZone = BTimeZone.getLocal();
        this.timeZoneChecked = false;
    }

    public BBacnetHistoryDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$history$BBacnetHistoryDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetHistoryDeviceExt = BBacnetHistoryDeviceExt.class("[Lcom.tridium.bacnet.history.BBacnetHistoryDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.history");
    }
}

