/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.datatypes;

import com.tridium.bacnet.asn.NErrorType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTrendEvent
extends BSimple {
    public static final long NO_EVENT = 0L;
    public static final long LOG_STATUS_EVENT = 0x100000000L;
    public static final long FAILURE_EVENT = 0x200000000L;
    public static final long TIME_CHANGE_EVENT = 0x400000000L;
    public static final long INVALID_EVENT = 0x800000000L;
    private static final long LOG_DISABLED_BIT = 1L;
    private static final long BUFFER_PURGED_BIT = 2L;
    private static final long LOG_INTERRUPTED_BIT = 4L;
    private static final BTrendEvent ZERO;
    public static final BTrendEvent DEFAULT;
    public static final Type TYPE;
    private static final boolean[] LS_ENABLE;
    private static final boolean[] LS_DISABLE;
    private static final boolean[] LS_ENABLE_PURGE;
    private static final boolean[] LS_DISABLE_PURGE;
    private static final boolean[] LS_INTERRUPTED;
    public static final BTrendEvent LOG_STATUS_ENABLED;
    public static final BTrendEvent LOG_STATUS_DISABLED;
    public static final BTrendEvent LOG_STATUS_ENABLED_BUFFER_PURGED;
    public static final BTrendEvent LOG_STATUS_DISABLED_BUFFER_PURGED;
    public static final BTrendEvent LOG_STATUS_INTERRUPTED;
    private long value;
    static /* synthetic */ Class class$com$tridium$bacnet$datatypes$BTrendEvent;

    public static final BTrendEvent make() {
        return BTrendEvent.make(0L);
    }

    public static final BTrendEvent makeLogStatus(BBacnetBitString bBacnetBitString) {
        long l = 0x100000000L;
        if (bBacnetBitString == null) {
            return BTrendEvent.make(l | 0x800000000L);
        }
        boolean[] blArray = bBacnetBitString.getBits();
        if (blArray.length < 2) {
            l |= 0x800000000L;
        }
        int n = 0;
        while (n < blArray.length) {
            if (n >= 32) {
                l |= 0x800000000L;
                break;
            }
            if (blArray[n]) {
                l |= 1L << n;
            }
            ++n;
        }
        return BTrendEvent.make(l);
    }

    public static final BTrendEvent makeFailure(NErrorType nErrorType) {
        long l = 0x200000000L;
        if (nErrorType == null) {
            return BTrendEvent.make(l | 0x800000000L);
        }
        long l2 = (char)-1 & nErrorType.getErrorClass();
        long l3 = (char)-1 & nErrorType.getErrorCode();
        long l4 = 0L;
        l4 |= l2;
        l4 <<= 16;
        return BTrendEvent.make(l |= (l4 |= l3));
    }

    public static final BTrendEvent makeTimeChange(long l) {
        long l2 = 0x400000000L;
        long l3 = 0xFFFFFFFFL & l;
        return BTrendEvent.make(l2 |= l3);
    }

    public static final BTrendEvent make(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new BTrendEvent(l);
    }

    public static final BTrendEvent make(String string) {
        return BTrendEvent.make(BTrendEvent.decode(string));
    }

    public final boolean getBit(long l) {
        boolean bl = false;
        if ((this.value & l) != 0L) {
            bl = true;
        }
        return bl;
    }

    public static final boolean getBit(long l, long l2) {
        boolean bl = false;
        if ((l2 & l) != 0L) {
            bl = true;
        }
        return bl;
    }

    public final long getLong() {
        return this.value;
    }

    public final int getInt() {
        return (int)this.value;
    }

    public final float getFloat() {
        return this.value;
    }

    public final double getDouble() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object object) {
        if (object instanceof BTrendEvent) {
            boolean bl = false;
            if (((BTrendEvent)((Object)object)).value == this.value) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        long l = this.value;
        long l2 = ((BNumber)object).getLong();
        if (l == l2) {
            return 0;
        }
        if (l < l2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BTrendEvent.encode(this.value);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BTrendEvent.make(dataInput.readLong());
    }

    public final String encodeToString() throws IOException {
        return BTrendEvent.encode(this.value);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BTrendEvent.make(BTrendEvent.decode(string));
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid BTrendEvent: " + string);
        }
    }

    public static final long decode(String string) {
        if (string == null) {
            return 0L;
        }
        int n = string.lastIndexOf(58);
        if (n <= 0) {
            return 0L;
        }
        return Long.parseLong(string.substring(n + 1));
    }

    public static final String encode(long l) {
        if (l == 0L) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (BTrendEvent.getBit(0x800000000L, l)) {
            stringBuffer.append(BBacnetLogRecord.INVALID_STRING + ' ');
            n = -1;
        }
        if (BTrendEvent.getBit(0x100000000L, l)) {
            stringBuffer.append(BBacnetLogRecord.LOG_STATUS_STRING + ' ');
            if (n >= 0) {
                n = 1;
            } else {
                stringBuffer.append(BBacnetLogRecord.EVENT_STRING);
            }
        } else if (BTrendEvent.getBit(0x200000000L, l)) {
            stringBuffer.append(BBacnetLogRecord.FAILURE_STRING + ' ');
            if (n >= 0) {
                n = 2;
            } else {
                stringBuffer.append(BBacnetLogRecord.EVENT_STRING);
            }
        } else if (BTrendEvent.getBit(0x400000000L, l)) {
            stringBuffer.append(BBacnetLogRecord.TIME_CHANGE_STRING + ' ');
            if (n >= 0) {
                n = 3;
            } else {
                stringBuffer.append(BBacnetLogRecord.EVENT_STRING);
            }
        } else {
            stringBuffer.append(BBacnetLogRecord.UNKNOWN_STRING + BBacnetLogRecord.EVENT_STRING);
        }
        switch (n) {
            case 1: {
                if (BTrendEvent.getBit(1L, l)) {
                    stringBuffer.append(BBacnetLogRecord.LOG_DISABLED_STRING + ' ');
                } else {
                    stringBuffer.append(BBacnetLogRecord.LOG_ENABLED_STRING + ' ');
                }
                if (BTrendEvent.getBit(2, l)) {
                    stringBuffer.append(BBacnetLogRecord.LOG_BUFFER_PURGED_STRING + ' ');
                }
                if (!BTrendEvent.getBit(4, l)) break;
                stringBuffer.append(BBacnetLogRecord.LOG_INTERRUPTED_STRING);
                break;
            }
            case 2: {
                int n2 = (int)(0xFFFFL & l);
                int n3 = (int)(0xFFFFFFFFFFFF0000L & l) >> 16;
                stringBuffer.append("(" + BBacnetErrorClass.tag(n3) + ", " + BBacnetErrorCode.tag(n2) + ')');
                break;
            }
            case 3: {
                int n4 = (int)((long)-1 & l);
                stringBuffer.append(String.valueOf(n4) + ' ' + BBacnetLogRecord.SECONDS_STRING);
                break;
            }
        }
        stringBuffer.append(":" + String.valueOf(l));
        return stringBuffer.toString();
    }

    public final boolean isLogStatus() {
        boolean bl = false;
        if ((this.value & 0x100000000L) != 0L) {
            bl = true;
        }
        return bl;
    }

    public final boolean isFailure() {
        boolean bl = false;
        if ((this.value & 0x200000000L) != 0L) {
            bl = true;
        }
        return bl;
    }

    public final boolean isTimeChange() {
        boolean bl = false;
        if ((this.value & 0x400000000L) != 0L) {
            bl = true;
        }
        return bl;
    }

    public final BBacnetBitString getLogStatus() {
        boolean[] blArray = new boolean[]{this.getBit(1L), this.getBit(2), this.getBit(4)};
        return BBacnetBitString.make(blArray);
    }

    public final boolean isLogDisabled() {
        boolean bl = false;
        if (this.isLogStatus() && this.getBit(1L)) {
            bl = true;
        }
        return bl;
    }

    public final NErrorType getFailure() {
        int n = (int)(0xFFFFL & this.value);
        int n2 = (int)(0xFFFFFFFFFFFF0000L & this.value) >> 16;
        return new NErrorType(n2, n);
    }

    public final float getTimeChange() {
        return (long)-1 & this.value;
    }

    public static final BBacnetBitString getLogStatus(long l) {
        boolean[] blArray = new boolean[3];
        boolean bl = false;
        if ((l & 1L) != 0L) {
            bl = true;
        }
        blArray[0] = bl;
        boolean bl2 = false;
        if ((l & (long)2) != 0L) {
            bl2 = true;
        }
        blArray[1] = bl2;
        boolean bl3 = false;
        if ((l & (long)4) != 0L) {
            bl3 = true;
        }
        blArray[2] = bl3;
        return BBacnetBitString.make(blArray);
    }

    public static final NErrorType getFailure(long l) {
        int n = (int)(0xFFFFL & l);
        int n2 = (int)(0xFFFFFFFFFFFF0000L & l) >> 16;
        return new NErrorType(n2, n);
    }

    public static final float getTimeChange(long l) {
        return 0xFFFFFFFFL & l;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BTrendEvent(long l) {
        this.value = l;
    }

    static {
        DEFAULT = ZERO = new BTrendEvent(0L);
        Class clazz = class$com$tridium$bacnet$datatypes$BTrendEvent;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$datatypes$BTrendEvent = BTrendEvent.class("[Lcom.tridium.bacnet.datatypes.BTrendEvent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        LS_ENABLE = new boolean[3];
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        LS_DISABLE = blArray;
        boolean[] blArray2 = new boolean[3];
        blArray2[1] = true;
        LS_ENABLE_PURGE = blArray2;
        boolean[] blArray3 = new boolean[3];
        blArray3[0] = true;
        blArray3[1] = true;
        LS_DISABLE_PURGE = blArray3;
        boolean[] blArray4 = new boolean[3];
        blArray4[2] = true;
        LS_INTERRUPTED = blArray4;
        LOG_STATUS_ENABLED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_ENABLE));
        LOG_STATUS_DISABLED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_DISABLE));
        LOG_STATUS_ENABLED_BUFFER_PURGED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_ENABLE_PURGE));
        LOG_STATUS_DISABLED_BUFFER_PURGED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_DISABLE_PURGE));
        LOG_STATUS_INTERRUPTED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_INTERRUPTED));
    }
}

