/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.datatypes;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BEventHandler;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEventSaver
extends BAlarmRecipient {
    public static final Type TYPE;
    private final Log log;
    static /* synthetic */ Class class$com$tridium$bacnet$datatypes$BEventSaver;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetNotificationClassDescriptor;
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        block18: {
            BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
            BBacnetEventSource bBacnetEventSource = null;
            boolean bl = this.log.isTraceOn();
            try {
                BObject bObject;
                BComponent bComponent;
                BOrd bOrd;
                BBacnetObjectIdentifier bBacnetObjectIdentifier;
                if (bl) {
                    this.log.trace("handleAlarm on " + SlotPath.unescape((String)this.getName()) + ':' + bAlarmRecord + "\n alarmData=" + bAlarmRecord.getAlarmData() + "\n uuid=" + bAlarmRecord.getUuid());
                }
                if ((bBacnetObjectIdentifier = bLocalBacnetDevice.lookupBacnetObjectId(bOrd = (bComponent = (bObject = bAlarmRecord.getSource().get(0).get((BObject)this)).asComplex().getParent().asComponent()).getOrdInSession())) == null) {
                    if (bl) {
                        this.log.trace("event not saved: object not exported to BACnet");
                    }
                    return;
                }
                BSourceState bSourceState = bAlarmRecord.getSourceState();
                if (bSourceState == BSourceState.alert) {
                    if (bl) {
                        this.log.trace("event not saved: alert");
                    }
                    return;
                }
                try {
                    bBacnetEventSource = (BBacnetEventSource)bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier);
                }
                catch (ClassCastException classCastException) {
                    if (bl) {
                        this.log.trace("event not saved: object not a BacnetEventSource");
                    }
                    return;
                }
                if (bBacnetEventSource == null) {
                    if (bl) {
                        this.log.trace("event not saved: event object not exported");
                    }
                    return;
                }
                BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = bBacnetEventSource.getNotificationClass();
                if (bBacnetNotificationClassDescriptor == null) {
                    if (bl) {
                        this.log.trace("event not saved: alarm class not exported to BACnet");
                    }
                    return;
                }
                BEventHandler bEventHandler = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler();
                if (bAlarmRecord.getSourceState() != BSourceState.normal || bAlarmRecord.getAckState() != BAckState.acked) {
                    BBacnetEventState bBacnetEventState = BBacnetEventState.make(bAlarmRecord.getSourceState());
                    if (bl) {
                        this.log.trace("Save record to " + bBacnetEventState + " buffer: " + (Object)((Object)bLocalBacnetDevice.getObjectId()) + ' ' + (Object)((Object)bBacnetObjectIdentifier) + " 0");
                    }
                    bEventHandler.addEventSummary(bBacnetObjectIdentifier);
                    bEventHandler.putRecordToEventBuffer(bBacnetEventState.getOrdinal(), bLocalBacnetDevice.getObjectId(), bBacnetObjectIdentifier, 0L, bAlarmRecord);
                } else {
                    bEventHandler.removeEventSummary(bBacnetObjectIdentifier);
                    if (bl) {
                        this.log.trace("Remove record from outstanding events: " + (Object)((Object)bLocalBacnetDevice.getObjectId()) + ' ' + (Object)((Object)bBacnetObjectIdentifier) + " 0");
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!bl) break block18;
                this.log.trace("Exception in BEventSaver.handleAlarm() [" + this.getName() + ']');
            }
        }
    }

    public boolean accept(BAlarmRecord bAlarmRecord) {
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = Log.getLog((String)"bacnet.server");
    }

    public BEventSaver() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$datatypes$BEventSaver;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$datatypes$BEventSaver = BEventSaver.class("[Lcom.tridium.bacnet.datatypes.BEventSaver;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

