/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class UnsignedRange
extends BacnetNotificationParameters {
    public static final int TIME_DELAY_TAG = 0;
    public static final int LOW_LIMIT_TAG = 1;
    public static final int HIGH_LIMIT_TAG = 2;
    long timeDelay;
    long lowLimit;
    long highLimit;

    public int getChoiceType() {
        return 11;
    }

    public long getTimeDelay() {
        return this.timeDelay;
    }

    public void setTimeDelay(long l) {
        this.timeDelay = l;
    }

    public long getLowLimit() {
        return this.lowLimit;
    }

    public void setLowLimit(long l) {
        this.lowLimit = l;
    }

    public long getHighLimit() {
        return this.highLimit;
    }

    public void setHighLimit(long l) {
        this.highLimit = l;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(11);
        asnOutputStream.writeUnsignedInteger(0, this.timeDelay);
        asnOutputStream.writeUnsignedInteger(1, this.lowLimit);
        asnOutputStream.writeUnsignedInteger(2, this.highLimit);
        asnOutputStream.writeClosingTag(11);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(11)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.timeDelay = asnInputStream.readUnsignedInteger(0);
        this.lowLimit = asnInputStream.readUnsignedInteger(1);
        this.highLimit = asnInputStream.readUnsignedInteger(2);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(11)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  unsigned-range\n");
        stringBuffer.append("    " + this.timeDelay);
        stringBuffer.append("    " + this.lowLimit);
        stringBuffer.append("    " + this.highLimit);
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".tmDel." + this.timeDelay);
        stringBuffer.append(".loLim." + this.lowLimit);
        stringBuffer.append(".hiLim." + this.highLimit);
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("timeDelay", BString.make((String)String.valueOf(this.timeDelay)));
        hashMap.put("lowLimit", BString.make((String)String.valueOf(this.lowLimit)));
        hashMap.put("highLimit", BString.make((String)String.valueOf(this.highLimit)));
    }

    public UnsignedRange() {
    }

    public UnsignedRange(long l, long l2, long l3) {
        this.timeDelay = l;
        this.lowLimit = l2;
        this.highLimit = l3;
    }
}

