/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class OutOfRange
extends BacnetNotificationParameters {
    public static final int EXCEEDING_VALUE_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    public static final int DEADBAND_TAG = 2;
    public static final int EXCEEDED_LIMIT_TAG = 3;
    float exceedingValue;
    BBacnetBitString statusFlags;
    float deadband;
    float exceededLimit;

    public int getChoiceType() {
        return 5;
    }

    public float getExceedingValue() {
        return this.exceedingValue;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public float getDeadband() {
        return this.deadband;
    }

    public float getExceededLimit() {
        return this.exceededLimit;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(5);
        asnOutputStream.writeReal(0, this.exceedingValue);
        asnOutputStream.writeBitString(1, this.statusFlags);
        asnOutputStream.writeReal(2, this.deadband);
        asnOutputStream.writeReal(3, this.exceededLimit);
        asnOutputStream.writeClosingTag(5);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(5)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.exceedingValue = asnInputStream.readReal(0);
        this.statusFlags = asnInputStream.readBitString(1);
        this.deadband = asnInputStream.readReal(2);
        this.exceededLimit = asnInputStream.readReal(3);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(5)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  out-of-range\n");
        stringBuffer.append("    " + this.exceedingValue);
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        stringBuffer.append("    " + this.deadband);
        stringBuffer.append("    " + this.exceededLimit);
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".excVal." + this.exceedingValue);
        stringBuffer.append(".sF." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        stringBuffer.append(".dband." + this.deadband);
        stringBuffer.append(".excLim." + this.exceededLimit);
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("exceedingValue", BString.make((String)String.valueOf(this.exceedingValue)));
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
        hashMap.put("deadband", BString.make((String)String.valueOf(this.deadband)));
        hashMap.put("exceededLimit", BString.make((String)String.valueOf(this.exceededLimit)));
    }

    public OutOfRange() {
    }

    public OutOfRange(float f, BBacnetBitString bBacnetBitString, float f2, float f3) {
        this.exceedingValue = f;
        this.statusFlags = bBacnetBitString;
        this.deadband = f2;
        this.exceededLimit = f3;
    }
}

