/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.util.ByteArrayUtil;

public class CommandFailure
extends BacnetNotificationParameters {
    public static final int COMMAND_VALUE_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    public static final int FEEDBACK_VALUE_TAG = 2;
    byte[] commandValue;
    BBacnetBitString statusFlags;
    byte[] feedbackValue;

    public int getChoiceType() {
        return 3;
    }

    public byte[] getCommandValue() {
        return this.commandValue;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public byte[] getFeedbackValue() {
        return this.feedbackValue;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(3);
        asnOutputStream.writeEncodedValue(0, this.commandValue);
        asnOutputStream.writeBitString(1, this.statusFlags);
        asnOutputStream.writeEncodedValue(2, this.feedbackValue);
        asnOutputStream.writeClosingTag(3);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(3)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.commandValue = asnInputStream.readEncodedValue(0);
        this.statusFlags = asnInputStream.readBitString(1);
        this.feedbackValue = asnInputStream.readEncodedValue(2);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(3)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  command-failure\n");
        stringBuffer.append("    " + ByteArrayUtil.toHexString((byte[])this.commandValue));
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        stringBuffer.append("    " + ByteArrayUtil.toHexString((byte[])this.feedbackValue));
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".cmdVal." + ByteArrayUtil.toHexString((byte[])this.commandValue));
        stringBuffer.append(".sF." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        stringBuffer.append(".fbVal." + ByteArrayUtil.toHexString((byte[])this.feedbackValue));
        return stringBuffer.toString().replace(' ', '.');
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("commandValue", BString.make((String)ByteArrayUtil.toHexString((byte[])this.commandValue)));
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
        hashMap.put("feedbackValue", BString.make((String)ByteArrayUtil.toHexString((byte[])this.feedbackValue)));
    }

    public CommandFailure() {
    }

    public CommandFailure(byte[] byArray, BBacnetBitString bBacnetBitString, byte[] byArray2) {
        this.commandValue = byArray;
        this.statusFlags = bBacnetBitString;
        this.feedbackValue = byArray2;
    }
}

