/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyOperation;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChangeOfLifeSafety
extends BacnetNotificationParameters {
    public static final int NEW_STATE_TAG = 0;
    public static final int NEW_MODE_TAG = 1;
    public static final int STATUS_FLAGS_TAG = 2;
    public static final int OPERATION_EXPECTED_TAG = 3;
    BBacnetLifeSafetyState newState;
    BBacnetLifeSafetyMode newMode;
    BBacnetBitString statusFlags;
    BBacnetLifeSafetyOperation operationExpected;

    public int getChoiceType() {
        return 8;
    }

    public BBacnetLifeSafetyState getNewState() {
        return this.newState;
    }

    public BBacnetLifeSafetyMode getNewMode() {
        return this.newMode;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public BBacnetLifeSafetyOperation getOperationExpected() {
        return this.operationExpected;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(8);
        asnOutputStream.writeEnumerated(0, this.newState.getOrdinal());
        asnOutputStream.writeEnumerated(1, this.newMode.getOrdinal());
        asnOutputStream.writeBitString(2, this.statusFlags);
        asnOutputStream.writeEnumerated(3, this.operationExpected.getOrdinal());
        asnOutputStream.writeClosingTag(8);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.skipOpeningTag(8);
        this.newState = BBacnetLifeSafetyState.make(asnInputStream.readEnumerated(0));
        this.newMode = BBacnetLifeSafetyMode.make(asnInputStream.readEnumerated(1));
        this.statusFlags = asnInputStream.readBitString(2);
        this.operationExpected = BBacnetLifeSafetyOperation.make(asnInputStream.readEnumerated(3));
        asnInputStream.skipClosingTag(8);
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  change-of-life-safety\n");
        stringBuffer.append("    " + this.newState);
        stringBuffer.append("    " + this.newMode);
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        stringBuffer.append("    " + this.operationExpected);
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".newState." + this.newState);
        stringBuffer.append(".newMode." + this.newMode);
        stringBuffer.append(".status." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        stringBuffer.append(".operationExpected." + this.operationExpected);
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("newState", BString.make((String)this.newState.getTag()));
        hashMap.put("newMode", BString.make((String)this.newMode.getTag()));
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
        hashMap.put("operationExpected", BString.make((String)this.operationExpected.getTag()));
    }

    private final /* synthetic */ void this() {
        this.statusFlags = BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags"));
    }

    public ChangeOfLifeSafety() {
        this.this();
    }

    public ChangeOfLifeSafety(BBacnetLifeSafetyState bBacnetLifeSafetyState, BBacnetLifeSafetyMode bBacnetLifeSafetyMode, BBacnetBitString bBacnetBitString, BBacnetLifeSafetyOperation bBacnetLifeSafetyOperation) {
        this.this();
        this.newState = bBacnetLifeSafetyState;
        this.newMode = bBacnetLifeSafetyMode;
        this.statusFlags = bBacnetBitString;
        this.operationExpected = bBacnetLifeSafetyOperation;
    }
}

