/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class BufferReady
extends BacnetNotificationParameters {
    public static final int BUFFER_PROPERTY_TAG = 0;
    public static final int PREVIOUS_NOTIFICATION_TAG = 1;
    public static final int CURRENT_NOTIFICATION_TAG = 2;
    BBacnetDeviceObjectPropertyReference bufferProperty;
    long previousNotification;
    long currentNotification;

    public int getChoiceType() {
        return 10;
    }

    public BBacnetDeviceObjectPropertyReference getBufferProperty() {
        return this.bufferProperty;
    }

    public long getPreviousNotification() {
        return this.previousNotification;
    }

    public long getCurrentNotification() {
        return this.currentNotification;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(10);
        asnOutputStream.writeOpeningTag(0);
        this.bufferProperty.writeAsn(asnOutputStream);
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeUnsignedInteger(1, this.previousNotification);
        asnOutputStream.writeUnsignedInteger(2, this.currentNotification);
        asnOutputStream.writeClosingTag(10);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(10)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.bufferProperty = new BBacnetDeviceObjectPropertyReference();
        this.bufferProperty.readAsn(asnInputStream);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.previousNotification = asnInputStream.readUnsignedInteger(1);
        this.currentNotification = asnInputStream.readUnsignedInteger(2);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(10)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  buffer-ready\n");
        stringBuffer.append("    " + this.bufferProperty);
        stringBuffer.append("    " + this.previousNotification);
        stringBuffer.append("    " + this.currentNotification);
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".bufProp." + this.bufferProperty);
        stringBuffer.append(".prevN." + this.previousNotification);
        stringBuffer.append(".currN." + this.currentNotification);
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        try {
            hashMap.put("bufferProperty", BString.make((String)this.bufferProperty.encodeToString()));
            hashMap.put("previousNotification", BString.make((String)String.valueOf(this.previousNotification)));
            hashMap.put("currentNotification", BString.make((String)String.valueOf(this.currentNotification)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BufferReady() {
    }

    public BufferReady(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference, long l, long l2) {
        this.bufferProperty = bBacnetDeviceObjectPropertyReference;
        this.previousNotification = l;
        this.currentNotification = l2;
    }
}

