/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;

public class NWriteAccessSpec
implements AsnConst {
    public static final int OBJECT_ID_TAG = 0;
    public static final int LIST_OF_PROPERTY_VALUES_TAG = 1;
    private BBacnetObjectIdentifier objectId;
    private Vector listOfPropertyValues;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public int getSize() {
        return this.listOfPropertyValues.size();
    }

    public void addPropertyValue(NBacnetPropertyValue nBacnetPropertyValue) {
        this.listOfPropertyValues.addElement(nBacnetPropertyValue);
    }

    public void addPropertyValue(int n, byte[] byArray) {
        this.listOfPropertyValues.addElement(new NBacnetPropertyValue(n, byArray));
    }

    public void addPropertyValue(int n, int n2, byte[] byArray) {
        this.listOfPropertyValues.addElement(new NBacnetPropertyValue(n, n2, byArray));
    }

    public void addPropertyValue(int n, int n2, byte[] byArray, int n3) {
        this.listOfPropertyValues.addElement(new NBacnetPropertyValue(n, n2, byArray, n3));
    }

    public void removePropertyValue(NBacnetPropertyValue nBacnetPropertyValue) {
        this.listOfPropertyValues.removeElement(nBacnetPropertyValue);
    }

    public void removePropertyValue(int n, int n2) {
        int n3 = 0;
        while (n3 < this.listOfPropertyValues.size()) {
            if (((NBacnetPropertyValue)this.listOfPropertyValues.elementAt(n3)).getPropertyId() == n && ((NBacnetPropertyValue)this.listOfPropertyValues.elementAt(n3)).getPropertyArrayIndex() == n2) {
                this.listOfPropertyValues.removeElementAt(n3);
            }
            ++n3;
        }
    }

    public ListIterator getPropertyValues() {
        return this.listOfPropertyValues.listIterator();
    }

    public PropertyValue[] getListOfPropertyValues() {
        Object[] objectArray = new PropertyValue[this.listOfPropertyValues.size()];
        this.listOfPropertyValues.copyInto(objectArray);
        return objectArray;
    }

    public boolean isEmpty() {
        return this.listOfPropertyValues.isEmpty();
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.objectId);
        asnOutput.writeOpeningTag(1);
        Iterator iterator = this.listOfPropertyValues.iterator();
        while (iterator.hasNext()) {
            NBacnetPropertyValue nBacnetPropertyValue = (NBacnetPropertyValue)iterator.next();
            nBacnetPropertyValue.writeAsn(asnOutput);
        }
        asnOutput.writeClosingTag(1);
    }

    public void readAsn(AsnInput asnInput) throws AsnException, RejectException {
        this.objectId = asnInput.readObjectIdentifier(0);
        asnInput.peekTag();
        if (!asnInput.isOpeningTag(1)) {
            throw new RejectException(4);
        }
        asnInput.skipTag();
        do {
            NBacnetPropertyValue nBacnetPropertyValue = new NBacnetPropertyValue();
            nBacnetPropertyValue.readAsn(asnInput);
            this.listOfPropertyValues.addElement(nBacnetPropertyValue);
            if (asnInput.peekTag() != -1) continue;
            throw new AsnException("No closing tag");
        } while (!asnInput.isClosingTag(1));
        asnInput.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NWriteAccessSpec: ");
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        Iterator iterator = this.listOfPropertyValues.iterator();
        while (iterator.hasNext()) {
            NBacnetPropertyValue nBacnetPropertyValue = (NBacnetPropertyValue)iterator.next();
            stringBuffer.append(nBacnetPropertyValue.toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public NWriteAccessSpec() {
        this.listOfPropertyValues = new Vector();
    }

    public NWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyValues = new Vector();
    }

    public NWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) {
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyValues = new Vector();
        this.addPropertyValue(n, byArray);
    }

    public NWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) {
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyValues = new Vector();
        this.addPropertyValue(n, n2, byArray);
    }

    public NWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray, int n3) {
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyValues = new Vector();
        this.addPropertyValue(n, n2, byArray, n3);
    }

    public NWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, Vector vector) {
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyValues = vector;
    }
}

