/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadAccessResult;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NReadPropertyResult
implements AsnConst,
PropertyValue {
    public static final int PROPERTY_ID_TAG = 2;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 3;
    public static final int PROPERTY_VALUE_TAG = 4;
    public static final int PROPERTY_ACCESS_ERROR_TAG = 5;
    private int propertyId;
    private int propertyArrayIndex;
    private byte[] propertyValue;
    private ErrorType propertyAccessError;
    private NReadAccessResult rar;

    public int getPropertyId() {
        return this.propertyId;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public byte[] getPropertyValue() {
        return this.propertyValue;
    }

    public int getPriority() {
        throw new IllegalStateException();
    }

    public ErrorType getPropertyAccessError() {
        return this.propertyAccessError;
    }

    public boolean isError() {
        boolean bl = false;
        if (this.propertyAccessError != null) {
            bl = true;
        }
        return bl;
    }

    public int getErrorClass() {
        return this.propertyAccessError.getErrorClass();
    }

    public int getErrorCode() {
        return this.propertyAccessError.getErrorCode();
    }

    public BBacnetObjectIdentifier getObjectId() {
        return this.rar != null ? this.rar.getObjectId() : null;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeEnumerated(2, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutput.writeUnsignedInteger(3, this.propertyArrayIndex);
        }
        if (this.propertyAccessError == null) {
            asnOutput.writeEncodedValue(4, this.propertyValue);
        } else {
            asnOutput.writeOpeningTag(5);
            asnOutput.writeEnumerated(this.getErrorClass());
            asnOutput.writeEnumerated(this.getErrorCode());
            asnOutput.writeClosingTag(5);
        }
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.propertyId = asnInput.readEnumerated(2);
        int n = asnInput.peekTag();
        if (asnInput.isValueTag(3)) {
            this.propertyArrayIndex = asnInput.readUnsignedInt(3);
            n = asnInput.peekTag();
        } else {
            this.propertyArrayIndex = -1;
        }
        if (asnInput.isOpeningTag(4)) {
            this.propertyValue = asnInput.readEncodedValue(4);
        } else if (asnInput.isOpeningTag(5)) {
            asnInput.skipTag();
            this.propertyAccessError = new NErrorType();
            this.propertyAccessError.readEncoded(asnInput);
            asnInput.skipTag();
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    public String toString() {
        return this.string(false);
    }

    public String debug() {
        return this.string(true);
    }

    private final String string(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("\n");
        }
        stringBuffer.append("  ").append(BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append('[').append(this.propertyArrayIndex).append(']');
        }
        if (this.isError()) {
            stringBuffer.append(" err=").append(this.propertyAccessError.toString());
        } else {
            stringBuffer.append(" val=");
            if (this.propertyValue == null) {
                stringBuffer.append("null");
            } else if (this.propertyValue.length == 0) {
                stringBuffer.append("-");
            } else {
                stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.propertyValue));
            }
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.propertyArrayIndex = -1;
    }

    public NReadPropertyResult(NReadAccessResult nReadAccessResult) {
        this.this();
        this.rar = nReadAccessResult;
    }

    public NReadPropertyResult(int n, byte[] byArray) {
        this(n, -1, byArray, null);
    }

    public NReadPropertyResult(int n, int n2, byte[] byArray) {
        this(n, n2, byArray, null);
    }

    public NReadPropertyResult(int n, ErrorType errorType) {
        this(n, -1, null, errorType);
    }

    public NReadPropertyResult(int n, int n2, ErrorType errorType) {
        this(n, n2, null, errorType);
    }

    public NReadPropertyResult(int n, int n2, byte[] byArray, ErrorType errorType) {
        this.this();
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.propertyValue = byArray;
        this.propertyAccessError = errorType;
    }
}

