/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.RejectException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NReadAccessSpec
implements AsnConst {
    public static final int OBJECT_ID_TAG = 0;
    public static final int LIST_OF_PROPERTY_REFERENCES_TAG = 1;
    public static final int BASE_DATA_SIZE = 7;
    private BBacnetObjectIdentifier objectId;
    private Vector listOfPropertyReferences;
    private int encodedSize;
    private int expectedDataSize;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public int getSize() {
        return this.listOfPropertyReferences.size();
    }

    public void addPropertyReference(NBacnetPropertyReference nBacnetPropertyReference) {
        this.listOfPropertyReferences.addElement(nBacnetPropertyReference);
        this.encodedSize += 2;
        this.expectedDataSize += 10;
    }

    public void addPropertyReference(int n) {
        this.addPropertyReference(n, -1, 10);
    }

    public void addPropertyReference(int n, int n2) {
        this.addPropertyReference(n, n2, 10);
    }

    public void addPropertyReference(int n, int n2, int n3) {
        this.listOfPropertyReferences.addElement(new NBacnetPropertyReference(n, n2));
        this.encodedSize += 2;
        this.expectedDataSize += n3;
    }

    public void removePropertyReference(NBacnetPropertyReference nBacnetPropertyReference) {
        this.listOfPropertyReferences.removeElement(nBacnetPropertyReference);
        this.encodedSize -= 2;
        this.expectedDataSize -= 10;
    }

    public void removePropertyReference(int n, int n2) {
        int n3 = 0;
        while (n3 < this.listOfPropertyReferences.size()) {
            if (((NBacnetPropertyReference)this.listOfPropertyReferences.elementAt(n3)).getPropertyId() == n && ((NBacnetPropertyReference)this.listOfPropertyReferences.elementAt(n3)).getPropertyArrayIndex() == n2) {
                this.listOfPropertyReferences.removeElementAt(n3);
            }
            ++n3;
        }
        this.encodedSize -= 2;
        this.expectedDataSize -= 10;
    }

    public ListIterator getPropertyReferences() {
        return this.listOfPropertyReferences.listIterator();
    }

    public PropertyReference[] getListOfPropertyReferences() {
        Object[] objectArray = new PropertyReference[this.listOfPropertyReferences.size()];
        this.listOfPropertyReferences.copyInto(objectArray);
        return objectArray;
    }

    public boolean isEmpty() {
        return this.listOfPropertyReferences.isEmpty();
    }

    public int getEncodedSize() {
        return this.encodedSize;
    }

    public int getExpectedDataSize() {
        return this.expectedDataSize;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.objectId);
        asnOutput.writeOpeningTag(1);
        Iterator iterator = this.listOfPropertyReferences.iterator();
        while (iterator.hasNext()) {
            NBacnetPropertyReference nBacnetPropertyReference = (NBacnetPropertyReference)iterator.next();
            nBacnetPropertyReference.writeAsn(asnOutput);
        }
        asnOutput.writeClosingTag(1);
    }

    public void readAsn(AsnInput asnInput) throws AsnException, RejectException {
        this.objectId = asnInput.readObjectIdentifier(0);
        int n = asnInput.peekTag();
        if (!asnInput.isOpeningTag(1)) {
            throw new RejectException(4);
        }
        asnInput.skipTag();
        n = asnInput.peekTag();
        while (!asnInput.isClosingTag(1)) {
            if (n == -1) {
                throw new RejectException(4);
            }
            NBacnetPropertyReference nBacnetPropertyReference = new NBacnetPropertyReference();
            nBacnetPropertyReference.readAsn(asnInput);
            this.listOfPropertyReferences.addElement(nBacnetPropertyReference);
            n = asnInput.peekTag();
        }
        asnInput.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  " + (Object)((Object)this.objectId));
        Iterator iterator = this.listOfPropertyReferences.iterator();
        while (iterator.hasNext()) {
            NBacnetPropertyReference nBacnetPropertyReference = (NBacnetPropertyReference)iterator.next();
            stringBuffer.append(nBacnetPropertyReference.toString());
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.encodedSize = 7;
        this.expectedDataSize = 7;
    }

    public NReadAccessSpec() {
        this.this();
        this.listOfPropertyReferences = new Vector();
    }

    public NReadAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyReferences = new Vector();
    }

    public NReadAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyReferences = new Vector();
        this.addPropertyReference(n);
    }

    public NReadAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyReferences = new Vector();
        this.addPropertyReference(n, n2);
    }

    public NReadAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, Vector vector) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyReferences = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.addPropertyReference((NBacnetPropertyReference)vector.elementAt(n));
            ++n;
        }
    }

    public NReadAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int[] nArray) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.listOfPropertyReferences = new Vector();
        int n = 0;
        while (n < nArray.length) {
            this.addPropertyReference(nArray[n]);
            ++n;
        }
    }
}

