/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;

public class NEventSummary
implements AsnConst {
    public static final int OBJECT_ID_TAG = 0;
    public static final int EVENT_STATE_TAG = 1;
    public static final int ACKNOWLEDGED_TRANSITIONS_TAG = 2;
    public static final int EVENT_TIME_STAMPS_TAG = 3;
    public static final int NOTIFY_TYPE_TAG = 4;
    public static final int EVENT_ENABLE_TAG = 5;
    public static final int EVENT_PRIORITIES_TAG = 6;
    private BBacnetObjectIdentifier objectId;
    private BEnum eventState;
    private BBacnetBitString acknowledgedTransitions;
    private BBacnetTimeStamp[] eventTimeStamps;
    private BBacnetNotifyType notifyType;
    private BBacnetBitString eventEnable;
    private int[] eventPriorities;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public BEnum getEventState() {
        return this.eventState;
    }

    public BBacnetBitString getAcknowledgedTransitions() {
        return this.acknowledgedTransitions;
    }

    public BBacnetTimeStamp[] getEventTimeStamps() {
        return this.eventTimeStamps;
    }

    public BBacnetNotifyType getNotifyType() {
        return this.notifyType;
    }

    public BBacnetBitString getEventEnable() {
        return this.eventEnable;
    }

    public int[] getEventPriorities() {
        return this.eventPriorities;
    }

    public int getEncodedSize() {
        int n = 23;
        int n2 = 0;
        if (this.getEventState().getOrdinal() > 255) {
            n2 = 1;
        }
        n += n2 + 2;
        int n3 = 0;
        while (n3 < 3) {
            switch (this.eventTimeStamps[n3].getChoice()) {
                case 0: {
                    n += 5;
                    break;
                }
                case 1: {
                    n += 1 + this.getEncodedIntegerSize(this.eventTimeStamps[n3].getSequenceNumber().getUnsigned());
                    break;
                }
                case 2: {
                    n += 12;
                    break;
                }
            }
            ++n3;
        }
        return n;
    }

    private final int getEncodedIntegerSize(long l) {
        if (l <= 255L) {
            return 1;
        }
        if (l <= 65535L) {
            return 2;
        }
        if (l <= 0xFFFFFFL) {
            return 3;
        }
        return 4;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.objectId);
        asnOutput.writeEnumerated(1, this.eventState.getOrdinal());
        asnOutput.writeBitString(2, this.acknowledgedTransitions);
        asnOutput.writeOpeningTag(3);
        int n = 0;
        while (n < 3) {
            this.eventTimeStamps[n].writeAsn(asnOutput);
            ++n;
        }
        asnOutput.writeClosingTag(3);
        asnOutput.writeEnumerated(4, this.notifyType.getOrdinal());
        asnOutput.writeBitString(5, this.eventEnable);
        asnOutput.writeOpeningTag(6);
        n = 0;
        while (n < 3) {
            asnOutput.writeUnsignedInteger(this.eventPriorities[n]);
            ++n;
        }
        asnOutput.writeClosingTag(6);
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.readAsn(null, asnInput);
    }

    public void readAsn(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInput asnInput) throws AsnException {
        BBacnetDevice bBacnetDevice;
        this.objectId = asnInput.readObjectIdentifier(0);
        BExtensibleEnumList bExtensibleEnumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (bBacnetObjectIdentifier != null && (bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier)) != null) {
            bExtensibleEnumList = bBacnetDevice.getEnumerationList();
        }
        int n = asnInput.readEnumerated(1);
        this.eventState = bExtensibleEnumList.getEventState().getRange().get(n);
        this.acknowledgedTransitions = asnInput.readBitString(2);
        int n2 = asnInput.peekTag();
        if (!asnInput.isOpeningTag(3)) {
            throw new AsnException("Invalid tag: " + n2);
        }
        asnInput.skipTag();
        this.eventTimeStamps = new BBacnetTimeStamp[3];
        int n3 = 0;
        while (n3 < 3) {
            this.eventTimeStamps[n3] = new BBacnetTimeStamp();
            this.eventTimeStamps[n3].readAsn(asnInput);
            ++n3;
        }
        asnInput.skipTag();
        this.notifyType = BBacnetNotifyType.make(asnInput.readEnumerated(4));
        this.eventEnable = asnInput.readBitString(5);
        n2 = asnInput.peekTag();
        if (!asnInput.isOpeningTag(6)) {
            throw new AsnException("Invalid tag: " + n2);
        }
        asnInput.skipTag();
        this.eventPriorities = new int[3];
        n3 = 0;
        while (n3 < 3) {
            this.eventPriorities[n3] = asnInput.readUnsignedInt();
            ++n3;
        }
        asnInput.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NEventSummary: ");
        stringBuffer.append("\n  objectId:" + (Object)((Object)this.objectId));
        stringBuffer.append("\n  eventState:" + this.eventState);
        stringBuffer.append("\n  ackedTransitions:" + (Object)((Object)this.acknowledgedTransitions));
        stringBuffer.append("\n  eventTimeStamps:");
        int n = 0;
        while (n < 3) {
            stringBuffer.append("\n    " + this.eventTimeStamps[n]);
            ++n;
        }
        stringBuffer.append("\n  notifyType:" + (Object)((Object)this.notifyType));
        stringBuffer.append("\n  eventEnable:" + (Object)((Object)this.eventEnable));
        stringBuffer.append("\n  eventPriorities:");
        n = 0;
        while (n < 3) {
            stringBuffer.append("  " + this.eventPriorities[n]);
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public BString toJob() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.objectId.toString()).append('|').append(this.eventState.toString()).append('|').append(this.acknowledgedTransitions.toString(BacnetBitStringUtil.BacnetEventTransitionBits)).append('|').append(this.eventTimeStamps[0]).append('|').append(this.eventTimeStamps[1]).append('|').append(this.eventTimeStamps[2]).append('|').append(this.notifyType.toString()).append('|').append(this.eventEnable.toString()).append('|').append(this.eventPriorities[0]).append('|').append(this.eventPriorities[1]).append('|').append(this.eventPriorities[2]);
        return BString.make((String)stringBuffer.toString());
    }

    public static String fromJob(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 11) {
            return "Cannot parse:" + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Object ID:").append(stringTokenizer.nextToken()).append("; Event State:").append(stringTokenizer.nextToken()).append("; Acked Transitions:").append(stringTokenizer.nextToken()).append("\n  ");
        stringBuffer.append("Event Time Stamps:").append(stringTokenizer.nextToken()).append("; ").append(stringTokenizer.nextToken()).append("; ").append(stringTokenizer.nextToken()).append("\n  ");
        stringBuffer.append("Notify Type:").append(stringTokenizer.nextToken()).append("; Event Enable:").append(stringTokenizer.nextToken()).append("\n  ");
        stringBuffer.append("Event Priorities:").append(stringTokenizer.nextToken()).append("; ").append(stringTokenizer.nextToken()).append("; ").append(stringTokenizer.nextToken()).append("\n");
        return stringBuffer.toString();
    }

    public NEventSummary() {
    }

    public NEventSummary(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, BBacnetBitString bBacnetBitString, BBacnetTimeStamp[] bBacnetTimeStampArray, BBacnetNotifyType bBacnetNotifyType, BBacnetBitString bBacnetBitString2, int[] nArray) {
        this.objectId = bBacnetObjectIdentifier;
        this.eventState = bEnum;
        this.acknowledgedTransitions = bBacnetBitString;
        this.eventTimeStamps = bBacnetTimeStampArray;
        this.notifyType = bBacnetNotifyType;
        this.eventEnable = bBacnetBitString2;
        this.eventPriorities = nArray;
    }
}

