/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NEnrollmentSummary
implements AsnConst {
    private BBacnetObjectIdentifier objectId;
    private BEnum eventType;
    private BEnum eventState;
    private int priority;
    private long notificationClass;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public BEnum getEventType() {
        return this.eventState;
    }

    public BEnum getEventState() {
        return this.eventState;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getNotificationClass() {
        return this.notificationClass;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(this.objectId);
        asnOutput.writeEnumerated(this.eventType.getOrdinal());
        asnOutput.writeEnumerated(this.eventState.getOrdinal());
        asnOutput.writeUnsignedInteger(this.priority);
        if (this.notificationClass >= 0L) {
            asnOutput.writeUnsignedInteger(this.notificationClass);
        }
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.readAsn(null, asnInput);
    }

    public void readAsn(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInput asnInput) throws AsnException {
        BBacnetDevice bBacnetDevice;
        this.objectId = asnInput.readObjectIdentifier();
        BExtensibleEnumList bExtensibleEnumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (bBacnetObjectIdentifier != null && (bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier)) != null) {
            bExtensibleEnumList = bBacnetDevice.getEnumerationList();
        }
        int n = asnInput.readEnumerated();
        this.eventType = bExtensibleEnumList.getEventType().getRange().get(n);
        int n2 = asnInput.readEnumerated();
        this.eventState = bExtensibleEnumList.getEventState().getRange().get(n2);
        this.priority = asnInput.readUnsignedInt();
        int n3 = asnInput.peekTag();
        if (n3 != -1 && asnInput.isValueTag(2)) {
            this.notificationClass = asnInput.readUnsignedInteger();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NEnrollmentSummary: ");
        stringBuffer.append("\n  objectId:" + (Object)((Object)this.objectId));
        stringBuffer.append("\n  eventType:" + this.eventType);
        stringBuffer.append("\n  eventState:" + this.eventState);
        stringBuffer.append("\n  priority:" + this.priority);
        stringBuffer.append("\n  notificationClass:" + this.notificationClass);
        return stringBuffer.toString();
    }

    public BString toJob() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.objectId.toString()).append('|').append(this.eventType.toString()).append('|').append(this.eventState.toString()).append('|').append(this.priority).append('|').append(this.notificationClass).append('|');
        return BString.make((String)stringBuffer.toString());
    }

    public static String fromJob(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 5) {
            return "Cannot parse:" + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Object ID:").append(stringTokenizer.nextToken()).append("; Event Type:").append(stringTokenizer.nextToken()).append("; Event State:").append(stringTokenizer.nextToken()).append("; Priority:").append(stringTokenizer.nextToken()).append("; Notification Class:").append(stringTokenizer.nextToken()).append("\n");
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.priority = -1;
        this.notificationClass = -1;
    }

    public NEnrollmentSummary() {
        this.this();
    }

    public NEnrollmentSummary(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, BEnum bEnum2, int n, long l) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.eventType = bEnum;
        this.eventState = bEnum2;
        this.priority = n;
        this.notificationClass = l;
    }
}

