/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;
import javax.baja.sys.Context;

public class NBacnetPropertyStates {
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int BINARY_VALUE_TAG = 1;
    public static final int EVENT_TYPE_TAG = 2;
    public static final int POLARITY_TAG = 3;
    public static final int PROGRAM_CHANGE_TAG = 4;
    public static final int PROGRAM_STATE_TAG = 5;
    public static final int REASON_FOR_HALT_TAG = 6;
    public static final int RELIABILITY_TAG = 7;
    public static final int STATE_TAG = 8;
    public static final int SYSTEM_STATUS_TAG = 9;
    public static final int UNITS_TAG = 10;
    public static final int UNSIGNED_VALUE_TAG = 11;
    public static final int LIFE_SAFETY_MODE_TAG = 12;
    public static final int LIFE_SAFETY_STATE_TAG = 13;
    int choiceType;
    private boolean booleanValue;
    private long unsignedValue;
    private BEnum enumValue;

    public int getChoiceType() {
        return this.choiceType;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public BBacnetBinaryPv getBinaryValue() {
        return (BBacnetBinaryPv)this.enumValue;
    }

    public BEnum getEventType() {
        return this.enumValue;
    }

    public BBacnetPolarity getPolarity() {
        return (BBacnetPolarity)this.enumValue;
    }

    public BEnum getProgramRequest() {
        return this.enumValue;
    }

    public BEnum getProgramState() {
        return this.enumValue;
    }

    public BEnum getProgramError() {
        return this.enumValue;
    }

    public BEnum getReliability() {
        return this.enumValue;
    }

    public BEnum getEventState() {
        return this.enumValue;
    }

    public BEnum getSystemStatus() {
        return this.enumValue;
    }

    public BEnum getUnits() {
        return this.enumValue;
    }

    public long getUnsignedValue() {
        return this.unsignedValue;
    }

    public BEnum getLifeSafetyMode() {
        return this.enumValue;
    }

    public BEnum getLifeSafetyState() {
        return this.enumValue;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        switch (this.choiceType) {
            case 0: {
                asnOutputStream.writeBoolean(0, this.booleanValue);
                break;
            }
            case 1: {
                asnOutputStream.writeEnumerated(1, this.enumValue.getOrdinal());
                break;
            }
            case 2: {
                asnOutputStream.writeEnumerated(2, this.enumValue.getOrdinal());
                break;
            }
            case 3: {
                asnOutputStream.writeEnumerated(3, this.enumValue.getOrdinal());
                break;
            }
            case 4: {
                asnOutputStream.writeEnumerated(4, this.enumValue.getOrdinal());
                break;
            }
            case 5: {
                asnOutputStream.writeEnumerated(5, this.enumValue.getOrdinal());
                break;
            }
            case 6: {
                asnOutputStream.writeEnumerated(6, this.enumValue.getOrdinal());
                break;
            }
            case 7: {
                asnOutputStream.writeEnumerated(7, this.enumValue.getOrdinal());
                break;
            }
            case 8: {
                asnOutputStream.writeEnumerated(8, this.enumValue.getOrdinal());
                break;
            }
            case 9: {
                asnOutputStream.writeEnumerated(9, this.enumValue.getOrdinal());
                break;
            }
            case 10: {
                asnOutputStream.writeEnumerated(10, this.enumValue.getOrdinal());
                break;
            }
            case 11: {
                asnOutputStream.writeUnsignedInteger(11, this.unsignedValue);
                break;
            }
            case 12: {
                asnOutputStream.writeEnumerated(12, this.enumValue.getOrdinal());
                break;
            }
            case 13: {
                asnOutputStream.writeEnumerated(13, this.enumValue.getOrdinal());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        this.choiceType = asnInputStream.peekTag();
        BBacnetDevice bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier);
        BExtensibleEnumList bExtensibleEnumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (bBacnetDevice != null) {
            bExtensibleEnumList = bBacnetDevice.getEnumerationList();
        }
        switch (this.choiceType) {
            case 0: {
                this.booleanValue = asnInputStream.readBoolean(0);
                break;
            }
            case 1: {
                this.enumValue = BBacnetBinaryPv.make(asnInputStream.readEnumerated(1));
                break;
            }
            case 2: {
                int n = asnInputStream.readEnumerated(2);
                this.enumValue = bExtensibleEnumList.getEventType().getRange().get(n);
                break;
            }
            case 3: {
                this.enumValue = BBacnetPolarity.make(asnInputStream.readEnumerated(3));
                break;
            }
            case 4: {
                this.enumValue = BBacnetProgramRequest.make(asnInputStream.readEnumerated(4));
                break;
            }
            case 5: {
                this.enumValue = BBacnetProgramState.make(asnInputStream.readEnumerated(5));
                break;
            }
            case 6: {
                int n = asnInputStream.readEnumerated(6);
                this.enumValue = bExtensibleEnumList.getProgramError().getRange().get(n);
                break;
            }
            case 7: {
                int n = asnInputStream.readEnumerated(7);
                this.enumValue = bExtensibleEnumList.getReliability().getRange().get(n);
                break;
            }
            case 8: {
                int n = asnInputStream.readEnumerated(8);
                this.enumValue = bExtensibleEnumList.getEventState().getRange().get(n);
                break;
            }
            case 9: {
                int n = asnInputStream.readEnumerated(9);
                this.enumValue = bExtensibleEnumList.getDeviceStatus().getRange().get(n);
                break;
            }
            case 10: {
                int n = asnInputStream.readEnumerated(10);
                this.enumValue = bExtensibleEnumList.getEngineeringUnits().getRange().get(n);
                break;
            }
            case 11: {
                this.unsignedValue = asnInputStream.readUnsignedInteger(11);
                break;
            }
            case 12: {
                int n = asnInputStream.readEnumerated(12);
                this.enumValue = bExtensibleEnumList.getLifeSafetyMode().getRange().get(n);
                break;
            }
            case 13: {
                int n = asnInputStream.readEnumerated(13);
                this.enumValue = bExtensibleEnumList.getLifeSafetyState().getRange().get(n);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NBacnetPropertyStates: \n");
        switch (this.choiceType) {
            case 0: {
                stringBuffer.append("  booleanValue: " + this.booleanValue);
                break;
            }
            case 1: {
                stringBuffer.append("  binaryValue: " + this.enumValue);
                break;
            }
            case 2: {
                stringBuffer.append("  eventType: " + this.enumValue);
                break;
            }
            case 3: {
                stringBuffer.append("  polarity: " + this.enumValue);
                break;
            }
            case 4: {
                stringBuffer.append("  programChange: " + this.enumValue);
                break;
            }
            case 5: {
                stringBuffer.append("  programState: " + this.enumValue);
                break;
            }
            case 6: {
                stringBuffer.append("  programError: " + this.enumValue);
                break;
            }
            case 7: {
                stringBuffer.append("  reliability: " + this.enumValue);
                break;
            }
            case 8: {
                stringBuffer.append("  state: " + this.enumValue);
                break;
            }
            case 9: {
                stringBuffer.append("  systemStatus: " + this.enumValue);
                break;
            }
            case 10: {
                stringBuffer.append("  units: " + this.enumValue);
                break;
            }
            case 11: {
                stringBuffer.append("  unsignedValue: " + this.unsignedValue);
                break;
            }
            case 12: {
                stringBuffer.append("  lifeSafetyMode: " + this.enumValue);
                break;
            }
            case 13: {
                stringBuffer.append("  lifeSafetyState: " + this.enumValue);
                break;
            }
        }
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.choiceType) {
            case 0: {
                stringBuffer.append("booleanValue-" + this.booleanValue);
                break;
            }
            case 1: {
                stringBuffer.append("binaryValue-" + this.enumValue);
                break;
            }
            case 2: {
                stringBuffer.append("eventType-" + this.enumValue);
                break;
            }
            case 3: {
                stringBuffer.append("polarity-" + this.enumValue);
                break;
            }
            case 4: {
                stringBuffer.append("programChange-" + this.enumValue);
                break;
            }
            case 5: {
                stringBuffer.append("programState-" + this.enumValue);
                break;
            }
            case 6: {
                stringBuffer.append("programError-" + this.enumValue);
                break;
            }
            case 7: {
                stringBuffer.append("reliability-" + this.enumValue);
                break;
            }
            case 8: {
                stringBuffer.append("state-" + this.enumValue);
                break;
            }
            case 9: {
                stringBuffer.append("systemStatus-" + this.enumValue);
                break;
            }
            case 10: {
                stringBuffer.append("units-" + this.enumValue);
                break;
            }
            case 11: {
                stringBuffer.append("unsignedValue-" + this.unsignedValue);
                break;
            }
            case 12: {
                stringBuffer.append("lifeSafetyMode-" + this.enumValue);
                break;
            }
            case 13: {
                stringBuffer.append("lifeSafetyState-" + this.enumValue);
                break;
            }
        }
        return stringBuffer.toString();
    }

    public NBacnetPropertyStates() {
    }

    public NBacnetPropertyStates(boolean bl) {
        this.choiceType = 0;
        this.booleanValue = bl;
    }

    public NBacnetPropertyStates(BBacnetBinaryPv bBacnetBinaryPv) {
        this(1, (BEnum)bBacnetBinaryPv);
    }

    public NBacnetPropertyStates(BBacnetEventType bBacnetEventType) {
        this(2, (BEnum)bBacnetEventType);
    }

    public NBacnetPropertyStates(BBacnetPolarity bBacnetPolarity) {
        this(3, (BEnum)bBacnetPolarity);
    }

    public NBacnetPropertyStates(BBacnetProgramRequest bBacnetProgramRequest) {
        this(4, (BEnum)bBacnetProgramRequest);
    }

    public NBacnetPropertyStates(BBacnetProgramState bBacnetProgramState) {
        this(5, (BEnum)bBacnetProgramState);
    }

    public NBacnetPropertyStates(BBacnetProgramError bBacnetProgramError) {
        this(6, (BEnum)bBacnetProgramError);
    }

    public NBacnetPropertyStates(BBacnetReliability bBacnetReliability) {
        this(7, (BEnum)bBacnetReliability);
    }

    public NBacnetPropertyStates(BBacnetEventState bBacnetEventState) {
        this(8, (BEnum)bBacnetEventState);
    }

    public NBacnetPropertyStates(BBacnetDeviceStatus bBacnetDeviceStatus) {
        this(9, (BEnum)bBacnetDeviceStatus);
    }

    public NBacnetPropertyStates(BBacnetEngineeringUnits bBacnetEngineeringUnits) {
        this(10, (BEnum)bBacnetEngineeringUnits);
    }

    public NBacnetPropertyStates(long l) {
        this.choiceType = 11;
        this.unsignedValue = l;
    }

    public NBacnetPropertyStates(BBacnetLifeSafetyMode bBacnetLifeSafetyMode) {
        this(12, (BEnum)bBacnetLifeSafetyMode);
    }

    public NBacnetPropertyStates(BBacnetLifeSafetyState bBacnetLifeSafetyState) {
        this(13, (BEnum)bBacnetLifeSafetyState);
    }

    private NBacnetPropertyStates(int n, BEnum bEnum) {
        this.choiceType = n;
        this.enumValue = bEnum;
    }
}

