/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyReference;

public class NBacnetPropertyReference
implements PropertyReference,
BacnetConst {
    public static final int PROPERTY_ID_TAG = 0;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 1;
    private int propertyId;
    private int propertyArrayIndex;

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeEnumerated(0, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutput.writeUnsignedInteger(1, this.propertyArrayIndex);
        }
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.propertyId = asnInput.readEnumerated(0);
        asnInput.peekTag();
        this.propertyArrayIndex = asnInput.isValueTag(1) ? asnInput.readUnsignedInt(1) : -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof NBacnetPropertyReference) {
            boolean bl = false;
            if (this.propertyId == ((NBacnetPropertyReference)object).propertyId && this.propertyArrayIndex == ((NBacnetPropertyReference)object).propertyArrayIndex) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public NBacnetPropertyReference() {
        this(-1, -1);
    }

    public NBacnetPropertyReference(int n) {
        this(n, -1);
    }

    public NBacnetPropertyReference(int n, int n2) {
        this.propertyId = n;
        this.propertyArrayIndex = n2;
    }
}

