/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;

public class CovNotificationParameters
implements AsnConst {
    public static final int SUBSCRIBER_PROCESS_ID_TAG = 0;
    public static final int INITIATING_DEVICE_ID_TAG = 1;
    public static final int MONITORED_OBJECT_ID_TAG = 2;
    public static final int TIME_REMAINING_TAG = 3;
    public static final int LIST_OF_VALUES_TAG = 4;
    private long subscriberProcessId;
    private BBacnetObjectIdentifier initiatingDeviceId;
    private BBacnetObjectIdentifier monitoredObjectId;
    private long timeRemaining;
    private PropertyValue[] listOfValues;

    public long getSubscriberProcessId() {
        return this.subscriberProcessId;
    }

    public BBacnetObjectIdentifier getInitiatingDeviceId() {
        return this.initiatingDeviceId;
    }

    public BBacnetObjectIdentifier getMonitoredObjectId() {
        return this.monitoredObjectId;
    }

    public long getTimeRemaining() {
        return this.timeRemaining;
    }

    public PropertyValue[] getListOfValues() {
        return this.listOfValues;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeUnsignedInteger(0, this.subscriberProcessId);
        asnOutputStream.writeObjectIdentifier(1, this.initiatingDeviceId);
        asnOutputStream.writeObjectIdentifier(2, this.monitoredObjectId);
        asnOutputStream.writeUnsignedInteger(3, this.timeRemaining);
        asnOutputStream.writeOpeningTag(4);
        int n = 0;
        while (n < this.listOfValues.length) {
            this.listOfValues[n].writeAsn(asnOutputStream);
            ++n;
        }
        asnOutputStream.writeClosingTag(4);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.subscriberProcessId = asnInputStream.readUnsignedInteger(0);
        this.initiatingDeviceId = asnInputStream.readObjectIdentifier(1);
        this.monitoredObjectId = asnInputStream.readObjectIdentifier(2);
        this.timeRemaining = asnInputStream.readUnsignedInteger(3);
        asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(4)) {
            throw new RejectException(5);
        }
        asnInputStream.skipTag();
        Vector<NBacnetPropertyValue> vector = new Vector<NBacnetPropertyValue>();
        asnInputStream.peekTag();
        while (!asnInputStream.isClosingTag(4)) {
            NBacnetPropertyValue nBacnetPropertyValue = new NBacnetPropertyValue();
            nBacnetPropertyValue.readAsn(asnInputStream);
            vector.add(nBacnetPropertyValue);
            if (asnInputStream.peekTag() != -1) continue;
            throw new AsnException("No closing tag");
        }
        asnInputStream.skipTag();
        this.listOfValues = new PropertyValue[vector.size()];
        vector.copyInto(this.listOfValues);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("\n  subscriberProcessId: " + this.subscriberProcessId);
        stringBuffer.append("\n  initiatingDeviceId:  " + (Object)((Object)this.initiatingDeviceId));
        stringBuffer.append("\n  monitoredObjectId:   " + (Object)((Object)this.monitoredObjectId));
        stringBuffer.append("\n  timeRemaining:       " + this.timeRemaining);
        stringBuffer.append("\n  listOfValues:        " + this.listOfValues.length + " elements");
        int n = 0;
        while (n < this.listOfValues.length) {
            stringBuffer.append("\n    listOfValues[" + n + "]: " + this.listOfValues[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public CovNotificationParameters() {
        this.listOfValues = new PropertyValue[0];
    }

    public CovNotificationParameters(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, long l2, PropertyValue[] propertyValueArray) {
        this.subscriberProcessId = l;
        this.initiatingDeviceId = bBacnetObjectIdentifier;
        this.monitoredObjectId = bBacnetObjectIdentifier2;
        this.timeRemaining = l2;
        this.listOfValues = propertyValueArray;
    }
}

