/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import java.util.HashMap;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AsnUtil
implements AsnConst {
    private static final int MAX_ASN_COUNT = 10;
    private static AsnOutputStream[] asnPool = new AsnOutputStream[10];
    private static int asnCnt = 0;
    static Lexicon lex = Lexicon.make((String)"bacnet");
    private static IntHashMap asnNamesByType = new IntHashMap();
    private static HashMap asnTypesByName;
    private static IntHashMap sizesBySpec;
    static /* synthetic */ Class class$javax$baja$sys$BValue;

    public static String getAsnTypeName(int n) {
        String string = (String)asnNamesByType.get(n);
        if (string == null) {
            return "???";
        }
        return string;
    }

    public static String getAsnTypeName(BInteger bInteger) {
        if (bInteger == null) {
            return "";
        }
        return AsnUtil.getAsnTypeName(bInteger.getInt());
    }

    public static int getAsnType(String string) {
        Integer n = (Integer)asnTypesByName.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetNull fromAsnNull(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetNull bBacnetNull = asnInputStream.readNull();
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetNull;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnNull() {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeNull();
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnNull(BBacnetNull bBacnetNull) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeNull();
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static boolean fromAsnBoolean(byte[] byArray) throws AsnException {
        int n;
        block6: {
            AsnInputStream asnInputStream;
            block5: {
                asnInputStream = AsnInputStream.make(byArray);
                try {
                    n = asnInputStream.peekTag();
                    if (n != 1) break block5;
                    boolean bl = asnInputStream.readBoolean();
                    Object var3_5 = null;
                    asnInputStream.release();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    asnInputStream.release();
                    throw throwable;
                }
            }
            if (n != 9) break block6;
            boolean bl = false;
            if (asnInputStream.readEnumerated() != 0) {
                bl = true;
            }
            boolean bl2 = bl;
            Object var3_6 = null;
            asnInputStream.release();
            return bl2;
        }
        throw new AsnException("Invalid tag: " + n);
    }

    public static byte[] toAsnBoolean(boolean bl) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeBoolean(bl);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnBoolean(BBoolean bBoolean) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeBoolean(bBoolean.getBoolean());
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fromAsnUnsignedInteger(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            long l = asnInputStream.readUnsignedInteger();
            Object var3_3 = null;
            asnInputStream.release();
            return l;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnUnsigned(long l) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeUnsignedInteger(l);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fromAsnUnsignedInt(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            long l = asnInputStream.readUnsignedInteger();
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Unsigned int is too big:" + l);
            }
            int n = (int)l;
            Object var3_4 = null;
            asnInputStream.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnUnsigned(BBacnetUnsigned bBacnetUnsigned) {
        return AsnUtil.toAsnUnsigned(bBacnetUnsigned.getUnsigned());
    }

    public static byte[] toAsnUnsigned(BEnum bEnum) {
        return AsnUtil.toAsnUnsigned(bEnum.getOrdinal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetUnsigned fromAsnUnsigned(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetUnsigned bBacnetUnsigned = BBacnetUnsigned.make(asnInputStream.readUnsignedInteger());
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetUnsigned;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fromAsnSignedInteger(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            int n = asnInputStream.readSignedInteger();
            Object var3_3 = null;
            asnInputStream.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnInteger(int n) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeSignedInteger(n);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnInteger(BInteger bInteger) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeSignedInteger(bInteger.getInt());
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fromAsnInteger(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            int n = asnInputStream.readInteger();
            Object var3_3 = null;
            asnInputStream.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float fromAsnReal(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            float f = asnInputStream.readReal();
            Object var3_3 = null;
            asnInputStream.release();
            return f;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnReal(double d) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeReal(d);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnReal(BFloat bFloat) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeReal(bFloat.getFloat());
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double fromAsnDouble(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            double d = asnInputStream.readDouble();
            Object var3_3 = null;
            asnInputStream.release();
            return d;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnDouble(double d) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeDouble(d);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnDouble(BDouble bDouble) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeDouble(bDouble.getDouble());
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetOctetString fromAsnOctetString(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetOctetString bBacnetOctetString = BBacnetOctetString.make(asnInputStream.readOctetString());
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetOctetString;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnOctetString(byte[] byArray) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeOctetString(byArray);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnOctetString(BBacnetOctetString bBacnetOctetString) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeOctetString(bBacnetOctetString);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromAsnCharacterString(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            String string = asnInputStream.readCharacterString();
            Object var3_3 = null;
            asnInputStream.release();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnCharacterString(String string) {
        return AsnUtil.toAsnCharacterString(string, BBacnetNetwork.localDevice().getCharacterSet());
    }

    public static byte[] toAsnCharacterString(String string, BCharacterSetEncoding bCharacterSetEncoding) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeCharacterString(string, bCharacterSetEncoding);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnCharacterString(BString bString) {
        return AsnUtil.toAsnCharacterString(bString.getString(), BBacnetNetwork.localDevice().getCharacterSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BCharacterSetEncoding getCharacterSetEncoding(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BCharacterSetEncoding bCharacterSetEncoding = asnInputStream.peekEncoding();
            Object var3_3 = null;
            asnInputStream.release();
            return bCharacterSetEncoding;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetBitString fromAsnBitString(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetBitString bBacnetBitString = asnInputStream.readBitString();
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetBitString;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnBitString(boolean[] blArray) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeBitString(blArray);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnBitString(BBacnetBitString bBacnetBitString) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeBitString(bBacnetBitString.getBits());
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fromAsnEnumerated(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            int n = asnInputStream.readEnumerated();
            Object var3_3 = null;
            asnInputStream.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnEnumerated(int n) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeEnumerated(n);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toAsnEnumerated(boolean bl) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeEnumerated(bl ? 1 : 0);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BEnum fromAsnEnumerated(BEnum bEnum, byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BEnum bEnum2 = bEnum.getRange().get(asnInputStream.readEnumerated());
            Object var4_4 = null;
            asnInputStream.release();
            return bEnum2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnEnumerated(BEnum bEnum) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeEnumerated(bEnum.getOrdinal());
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetDate fromAsnDate(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetDate bBacnetDate = asnInputStream.readDate();
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetDate;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnDate(BBacnetDate bBacnetDate) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeDate(bBacnetDate);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetTime fromAsnTime(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetTime bBacnetTime = asnInputStream.readTime();
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetTime;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnTime(BBacnetTime bBacnetTime) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeTime(bBacnetTime);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBacnetObjectIdentifier fromAsnObjectId(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BBacnetObjectIdentifier bBacnetObjectIdentifier = asnInputStream.readObjectIdentifier();
            Object var3_3 = null;
            asnInputStream.release();
            return bBacnetObjectIdentifier;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static byte[] toAsnObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeObjectIdentifier(bBacnetObjectIdentifier);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static BValue fromAsn(int n, byte[] byArray) throws AsnException {
        return AsnUtil.fromAsn(n, byArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue fromAsn(byte[] byArray, BValue bValue) throws AsnException {
        if (bValue != null) {
            Type type = bValue.getType();
            if (type == BBacnetNull.TYPE) {
                return AsnUtil.fromAsnNull(byArray);
            }
            if (type == BBoolean.TYPE) {
                return BBoolean.make((boolean)AsnUtil.fromAsnBoolean(byArray));
            }
            if (type == BBacnetUnsigned.TYPE) {
                return AsnUtil.fromAsnUnsigned(byArray);
            }
            if (type == BInteger.TYPE) {
                return BInteger.make((int)AsnUtil.fromAsnInteger(byArray));
            }
            if (type == BFloat.TYPE) {
                return BFloat.make((float)AsnUtil.fromAsnReal(byArray));
            }
            if (type == BDouble.TYPE) {
                return BDouble.make((double)AsnUtil.fromAsnDouble(byArray));
            }
            if (type == BBacnetOctetString.TYPE) {
                return AsnUtil.fromAsnOctetString(byArray);
            }
            if (type == BString.TYPE) {
                return BString.make((String)AsnUtil.fromAsnCharacterString(byArray));
            }
            if (type == BBacnetBitString.TYPE) {
                return AsnUtil.fromAsnBitString(byArray);
            }
            if (type.is(BEnum.TYPE)) {
                return ((BEnum)bValue).getRange().get(AsnUtil.fromAsnEnumerated(byArray));
            }
            if (type == BBacnetDate.TYPE) {
                return AsnUtil.fromAsnDate(byArray);
            }
            if (type == BBacnetTime.TYPE) {
                return AsnUtil.fromAsnTime(byArray);
            }
            if (type == BBacnetObjectIdentifier.TYPE) {
                return AsnUtil.fromAsnObjectId(byArray);
            }
            if (type.is(BIBacnetDataType.TYPE)) {
                AsnInputStream asnInputStream = AsnInputStream.make(byArray);
                try {
                    ((BIBacnetDataType)bValue).readAsn(asnInputStream);
                    BValue bValue2 = bValue;
                    Object var5_5 = null;
                    asnInputStream.release();
                    return bValue2;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    asnInputStream.release();
                    throw throwable;
                }
            }
        }
        return AsnUtil.asnToValue(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue fromAsn(int n, byte[] byArray, BValue bValue) throws AsnException {
        switch (n) {
            case 0: {
                return BBacnetNull.DEFAULT;
            }
            case 1: {
                return BBoolean.make((boolean)AsnUtil.fromAsnBoolean(byArray));
            }
            case 2: {
                if (bValue == null || bValue.getType() != BDynamicEnum.TYPE) {
                    return AsnUtil.fromAsnUnsigned(byArray);
                }
                return ((BDynamicEnum)bValue).getRange().get(AsnUtil.fromAsnUnsignedInt(byArray));
            }
            case 3: {
                return BInteger.make((int)AsnUtil.fromAsnInteger(byArray));
            }
            case 4: {
                return BFloat.make((float)AsnUtil.fromAsnReal(byArray));
            }
            case 5: {
                return BDouble.make((double)AsnUtil.fromAsnDouble(byArray));
            }
            case 6: {
                return AsnUtil.fromAsnOctetString(byArray);
            }
            case 7: {
                return BString.make((String)AsnUtil.fromAsnCharacterString(byArray));
            }
            case 8: {
                return AsnUtil.fromAsnBitString(byArray);
            }
            case 9: {
                if (bValue == null) {
                    return BInteger.make((int)AsnUtil.fromAsnEnumerated(byArray));
                }
                return ((BEnum)bValue).getRange().get(AsnUtil.fromAsnEnumerated(byArray));
            }
            case 10: {
                return AsnUtil.fromAsnDate(byArray);
            }
            case 11: {
                return AsnUtil.fromAsnTime(byArray);
            }
            case 12: {
                return AsnUtil.fromAsnObjectId(byArray);
            }
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                AsnInputStream asnInputStream = AsnInputStream.make(byArray);
                try {
                    ((BIBacnetDataType)bValue).readAsn(asnInputStream);
                    BValue bValue2 = bValue;
                    Object var5_5 = null;
                    asnInputStream.release();
                    return bValue2;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    asnInputStream.release();
                    throw throwable;
                }
            }
            case -6: {
                return AsnUtil.asnToValue(byArray);
            }
        }
        throw new AsnException("Invalid tag: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue[] fromAsn(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BValue[] bValueArray = AsnUtil.fromAsn(asnInputStream, -1);
            Object var3_3 = null;
            asnInputStream.release();
            return bValueArray;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    public static BValue asnToValue(PropertyInfo propertyInfo, byte[] byArray) throws AsnException {
        return AsnUtil.asnToValue(propertyInfo, byArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final BValue asnToValue(PropertyInfo propertyInfo, byte[] byArray, BValue bValue) throws AsnException {
        try {
            BTypeSpec bTypeSpec = null;
            Type type = null;
            if (propertyInfo == null) {
                return AsnUtil.asnToValue(byArray);
            }
            switch (propertyInfo.getAsnType()) {
                case 0: {
                    return BBacnetNull.DEFAULT;
                }
                case 1: {
                    return BBoolean.make((boolean)AsnUtil.fromAsnBoolean(byArray));
                }
                case 2: {
                    return AsnUtil.fromAsnUnsigned(byArray);
                }
                case 3: {
                    return BInteger.make((int)AsnUtil.fromAsnInteger(byArray));
                }
                case 4: {
                    return BFloat.make((float)AsnUtil.fromAsnReal(byArray));
                }
                case 5: {
                    return BDouble.make((double)AsnUtil.fromAsnDouble(byArray));
                }
                case 6: {
                    return AsnUtil.fromAsnOctetString(byArray);
                }
                case 7: {
                    return BString.make((String)AsnUtil.fromAsnCharacterString(byArray));
                }
                case 8: {
                    return AsnUtil.fromAsnBitString(byArray);
                }
                case 9: {
                    bTypeSpec = BTypeSpec.make((String)propertyInfo.getType());
                    BEnum bEnum = (BEnum)bTypeSpec.getInstance();
                    if (propertyInfo.isExtensible()) {
                        return BDynamicEnum.make((int)AsnUtil.fromAsnEnumerated(byArray), (BEnumRange)BEnumRange.make((Type)bEnum.getType()));
                    }
                    return bEnum.getRange().get(AsnUtil.fromAsnEnumerated(byArray));
                }
                case 10: {
                    return AsnUtil.fromAsnDate(byArray);
                }
                case 11: {
                    return AsnUtil.fromAsnTime(byArray);
                }
                case 12: {
                    return AsnUtil.fromAsnObjectId(byArray);
                }
                case -5: 
                case -1: {
                    bTypeSpec = BTypeSpec.make((String)propertyInfo.getType());
                    BValue bValue2 = (BValue)bTypeSpec.getInstance();
                    AsnInputStream asnInputStream = AsnInputStream.make(byArray);
                    try {
                        ((BIBacnetDataType)bValue2).readAsn(asnInputStream);
                        BValue bValue3 = bValue2;
                        Object var9_14 = null;
                        asnInputStream.release();
                        return bValue3;
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        asnInputStream.release();
                        throw throwable;
                    }
                }
                case -2: {
                    bTypeSpec = BTypeSpec.make((String)propertyInfo.getType());
                    type = bTypeSpec.getResolvedType();
                    BBacnetArray bBacnetArray = null;
                    bBacnetArray = propertyInfo.getSize() >= 0 ? new BBacnetArray(type, propertyInfo.getSize()) : new BBacnetArray(type);
                    AsnInputStream asnInputStream = AsnInputStream.make(byArray);
                    try {
                        bBacnetArray.readAsn(asnInputStream);
                        BBacnetArray bBacnetArray2 = bBacnetArray;
                        Object var9_16 = null;
                        asnInputStream.release();
                        return bBacnetArray2;
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        asnInputStream.release();
                        throw throwable;
                    }
                }
                case -3: {
                    bTypeSpec = BTypeSpec.make((String)propertyInfo.getType());
                    type = bTypeSpec.getResolvedType();
                    BBacnetListOf bBacnetListOf = new BBacnetListOf(type);
                    AsnInputStream asnInputStream = AsnInputStream.make(byArray);
                    try {
                        bBacnetListOf.readAsn(asnInputStream);
                        BBacnetListOf bBacnetListOf2 = bBacnetListOf;
                        Object var9_18 = null;
                        asnInputStream.release();
                        return bBacnetListOf2;
                    }
                    catch (Throwable throwable) {
                        Object var9_19 = null;
                        asnInputStream.release();
                        throw throwable;
                    }
                }
                case -4: {
                    return BBacnetAny.make(byArray);
                }
                case -6: {
                    return AsnUtil.asnToValue(byArray);
                }
            }
            throw new AsnException("Invalid tag: " + propertyInfo.getAsnType());
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet.asn").trace("Unable to decode Asn value:" + ByteArrayUtil.toHexString((byte[])byArray), (Throwable)exception);
            throw new AsnException("Asn conversion failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue asnToValue(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BValue bValue = AsnUtil.asnToValue(asnInputStream, -1);
            Object var3_3 = null;
            asnInputStream.release();
            return bValue;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            asnInputStream.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BValue asnToValue(AsnInput asnInput, int n) throws AsnException {
        AsnInput asnInput2 = asnInput;
        synchronized (asnInput2) {
            BValue[] bValueArray = AsnUtil.fromAsn(asnInput, n);
            if (bValueArray.length == 1) {
                return bValueArray[0];
            }
            BComponent bComponent = new BComponent();
            int n2 = 0;
            while (n2 < bValueArray.length) {
                bComponent.add(null, bValueArray[n2]);
                ++n2;
            }
            return bComponent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BValue[] fromAsn(AsnInput asnInput, int n) throws AsnException {
        Class clazz = class$javax$baja$sys$BValue;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BValue = AsnUtil.class("[Ljavax.baja.sys.BValue;", false);
        }
        Array array = new Array(clazz);
        AsnInput asnInput2 = asnInput;
        synchronized (asnInput2) {
            int n2 = asnInput.peekTag();
            BSimple bSimple = null;
            while (n2 != -1 && !asnInput.isClosingTag(n)) {
                bSimple = null;
                if (asnInput.isApplicationTag(n2)) {
                    switch (n2) {
                        case 0: {
                            bSimple = asnInput.readNull();
                            break;
                        }
                        case 1: {
                            bSimple = BBoolean.make((boolean)asnInput.readBoolean());
                            break;
                        }
                        case 2: {
                            bSimple = asnInput.readUnsigned();
                            break;
                        }
                        case 3: {
                            bSimple = asnInput.readSigned();
                            break;
                        }
                        case 4: {
                            bSimple = asnInput.readFloat();
                            break;
                        }
                        case 5: {
                            bSimple = BDouble.make((double)asnInput.readDouble());
                            break;
                        }
                        case 6: {
                            bSimple = asnInput.readBacnetOctetString();
                            break;
                        }
                        case 7: {
                            bSimple = BString.make((String)asnInput.readCharacterString());
                            break;
                        }
                        case 8: {
                            bSimple = asnInput.readBitString();
                            break;
                        }
                        case 9: {
                            bSimple = BDynamicEnum.make((int)asnInput.readEnumerated());
                            break;
                        }
                        case 10: {
                            bSimple = asnInput.readDate();
                            break;
                        }
                        case 11: {
                            bSimple = asnInput.readTime();
                            break;
                        }
                        case 12: {
                            bSimple = asnInput.readObjectIdentifier();
                            break;
                        }
                    }
                    n2 = asnInput.peekTag();
                } else if (asnInput.isOpeningTag(n2)) {
                    asnInput.skipTag();
                    bSimple = AsnUtil.asnToValue(asnInput, n2);
                    n2 = asnInput.peekTag();
                } else if (asnInput.isValueTag(n2)) {
                    byte[] byArray = asnInput.readContextTaggedData();
                    bSimple = BString.make((String)("context-tagged data [" + n2 + "]:" + ByteArrayUtil.toHexString((byte[])byArray)));
                    n2 = asnInput.peekTag();
                } else if (asnInput.isClosingTag(n2)) {
                    asnInput.skipTag();
                    n2 = asnInput.peekTag();
                }
                if (bSimple == null) continue;
                if (array.size() == 0 && n2 == -1) {
                    return new BValue[]{bSimple};
                }
                array.add((Object)bSimple);
            }
            return (BValue[])array.trim();
        }
    }

    public static byte[] toAsn(BValue bValue) {
        Type type = bValue.getType();
        if (type == BBacnetNull.TYPE) {
            return AsnUtil.toAsnNull();
        }
        if (type == BBoolean.TYPE) {
            return AsnUtil.toAsnBoolean((BBoolean)bValue);
        }
        if (type == BBacnetUnsigned.TYPE) {
            return AsnUtil.toAsnUnsigned((BBacnetUnsigned)bValue);
        }
        if (type == BInteger.TYPE) {
            return AsnUtil.toAsnInteger((BInteger)bValue);
        }
        if (type == BFloat.TYPE) {
            return AsnUtil.toAsnReal((BFloat)bValue);
        }
        if (type == BDouble.TYPE) {
            return AsnUtil.toAsnDouble((BDouble)bValue);
        }
        if (type == BBacnetOctetString.TYPE) {
            return AsnUtil.toAsnOctetString((BBacnetOctetString)bValue);
        }
        if (type == BString.TYPE) {
            return AsnUtil.toAsnCharacterString((BString)bValue);
        }
        if (type == BBacnetBitString.TYPE) {
            return AsnUtil.toAsnBitString((BBacnetBitString)bValue);
        }
        if (bValue instanceof BEnum) {
            return AsnUtil.toAsnEnumerated((BEnum)bValue);
        }
        if (type == BBacnetDate.TYPE) {
            return AsnUtil.toAsnDate((BBacnetDate)bValue);
        }
        if (type == BBacnetTime.TYPE) {
            return AsnUtil.toAsnTime((BBacnetTime)bValue);
        }
        if (type == BBacnetObjectIdentifier.TYPE) {
            return AsnUtil.toAsnObjectId((BBacnetObjectIdentifier)bValue);
        }
        if (type.is(BIBacnetDataType.TYPE)) {
            AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
            asnOutputStream.reset();
            ((BIBacnetDataType)bValue).writeAsn(asnOutputStream);
            return AsnUtil.releaseAsn(asnOutputStream);
        }
        return AsnUtil.toAsnCharacterString(bValue.toString());
    }

    public static byte[] toAsn(int n, BValue bValue) {
        switch (n) {
            case 0: {
                return AsnUtil.toAsnNull((BBacnetNull)bValue);
            }
            case 1: {
                return AsnUtil.toAsnBoolean((BBoolean)bValue);
            }
            case 2: {
                return AsnUtil.toAsnUnsigned((BBacnetUnsigned)bValue);
            }
            case 3: {
                return AsnUtil.toAsnInteger(((BNumber)bValue).getInt());
            }
            case 4: {
                return AsnUtil.toAsnReal(((BNumber)bValue).getFloat());
            }
            case 5: {
                return AsnUtil.toAsnDouble(((BNumber)bValue).getDouble());
            }
            case 6: {
                return AsnUtil.toAsnOctetString((BBacnetOctetString)bValue);
            }
            case 7: {
                return AsnUtil.toAsnCharacterString((BString)bValue);
            }
            case 8: {
                return AsnUtil.toAsnBitString((BBacnetBitString)bValue);
            }
            case 9: {
                return AsnUtil.toAsnEnumerated((BEnum)bValue);
            }
            case 10: {
                return AsnUtil.toAsnDate((BBacnetDate)bValue);
            }
            case 11: {
                return AsnUtil.toAsnTime((BBacnetTime)bValue);
            }
            case 12: {
                return AsnUtil.toAsnObjectId((BBacnetObjectIdentifier)bValue);
            }
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
                asnOutputStream.reset();
                ((BIBacnetDataType)bValue).writeAsn(asnOutputStream);
                return AsnUtil.releaseAsn(asnOutputStream);
            }
        }
        throw new IllegalArgumentException("Invalid tag: " + n);
    }

    public static int getAsnType(Type type) {
        if (type == BBacnetNull.TYPE) {
            return 0;
        }
        if (type == BBoolean.TYPE) {
            return 1;
        }
        if (type == BBacnetUnsigned.TYPE) {
            return 2;
        }
        if (type == BInteger.TYPE) {
            return 3;
        }
        if (type == BFloat.TYPE) {
            return 4;
        }
        if (type == BDouble.TYPE) {
            return 5;
        }
        if (type == BBacnetOctetString.TYPE) {
            return 6;
        }
        if (type == BString.TYPE) {
            return 7;
        }
        if (type == BBacnetBitString.TYPE) {
            return 8;
        }
        if (type.is(BEnum.TYPE)) {
            return 9;
        }
        if (type == BBacnetDate.TYPE) {
            return 10;
        }
        if (type == BBacnetTime.TYPE) {
            return 11;
        }
        if (type == BBacnetObjectIdentifier.TYPE) {
            return 12;
        }
        return -6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAsnType(byte[] byArray) throws AsnException {
        AsnInputStream asnInputStream;
        block3: {
            asnInputStream = AsnInputStream.make(byArray);
            try {
                asnInputStream.setBuffer(byArray);
                int n = asnInputStream.skipTag();
                if (asnInputStream.peekApplicationTag() != -1) break block3;
                int n2 = n;
                Object var3_5 = null;
                asnInputStream.release();
                return n2;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                asnInputStream.release();
                throw throwable;
            }
        }
        int n = -1;
        Object var3_6 = null;
        asnInputStream.release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BStatus asnStatusFlagsToBStatus(byte[] byArray) {
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            BStatus bStatus = asnInputStream.readStatusFlags();
            Object var3_4 = null;
            asnInputStream.release();
            return bStatus;
        }
        catch (AsnException asnException) {
            try {
                BStatus bStatus = null;
                Object var3_5 = null;
                asnInputStream.release();
                return bStatus;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                asnInputStream.release();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BStatus addPriority(BStatus bStatus, byte[] byArray) {
        BStatus bStatus2 = bStatus;
        if (byArray == null) return bStatus2;
        bStatus2 = BStatus.make((BStatus)bStatus2, (String)"bac", (BIDataValue)BString.make((String)"def"));
        AsnInputStream asnInputStream = AsnInputStream.make(byArray);
        try {
            try {
                int n = 0;
                int n2 = 0;
                n2 = 1;
                while (n2 <= 16) {
                    block6: {
                        n = asnInputStream.skipTag();
                        if (n == 0) break block6;
                        bStatus2 = BStatus.make((BStatus)bStatus2, (String)"bac", (BIDataValue)BInteger.make((int)n2));
                        break;
                    }
                    ++n2;
                }
            }
            catch (AsnException asnException) {
                BStatus bStatus3 = bStatus;
                Object var5_8 = null;
                asnInputStream.release();
                return bStatus3;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            asnInputStream.release();
            throw throwable;
        }
        {
            Object var5_10 = null;
            asnInputStream.release();
            return bStatus2;
        }
    }

    public static byte[] statusToAsnStatusFlags(BStatus bStatus) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeStatusFlags(bStatus);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static byte[] toBacnetDateTime(BAbsTime bAbsTime) {
        AsnOutputStream asnOutputStream = AsnUtil.getAsnOut();
        asnOutputStream.reset();
        asnOutputStream.writeDate(bAbsTime);
        asnOutputStream.writeTime(bAbsTime);
        return AsnUtil.releaseAsn(asnOutputStream);
    }

    public static int getSize(BTypeSpec bTypeSpec) {
        BInteger bInteger = (BInteger)sizesBySpec.get(bTypeSpec.hashCode());
        if (bInteger == null) {
            return 10;
        }
        return bInteger.getInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final AsnOutputStream getAsnOut() {
        AsnOutputStream[] asnOutputStreamArray = asnPool;
        synchronized (asnPool) {
            if (asnCnt > 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return asnPool[--asnCnt];
            }
            return new AsnOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final byte[] releaseAsn(AsnOutputStream asnOutputStream) {
        byte[] byArray = asnOutputStream.toByteArray();
        AsnOutputStream[] asnOutputStreamArray = asnPool;
        synchronized (asnPool) {
            if (asnCnt < asnPool.length) {
                AsnUtil.asnPool[AsnUtil.asnCnt++] = asnOutputStream;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return byArray;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        asnNamesByType.put(0, (Object)lex.getText("asn.null"));
        asnNamesByType.put(1, (Object)lex.getText("asn.boolean"));
        asnNamesByType.put(2, (Object)lex.getText("asn.unsigned"));
        asnNamesByType.put(3, (Object)lex.getText("asn.integer"));
        asnNamesByType.put(4, (Object)lex.getText("asn.real"));
        asnNamesByType.put(5, (Object)lex.getText("asn.double"));
        asnNamesByType.put(6, (Object)lex.getText("asn.octetString"));
        asnNamesByType.put(7, (Object)lex.getText("asn.characterString"));
        asnNamesByType.put(8, (Object)lex.getText("asn.bitString"));
        asnNamesByType.put(9, (Object)lex.getText("asn.enumerated"));
        asnNamesByType.put(10, (Object)lex.getText("asn.date"));
        asnNamesByType.put(11, (Object)lex.getText("asn.time"));
        asnNamesByType.put(12, (Object)lex.getText("asn.objectId"));
        asnNamesByType.put(13, (Object)lex.getText("asn.reserved13"));
        asnNamesByType.put(14, (Object)lex.getText("asn.reserved14"));
        asnNamesByType.put(15, (Object)lex.getText("asn.reserved15"));
        asnNamesByType.put(-1, (Object)lex.getText("asn.constructed"));
        asnNamesByType.put(-2, (Object)lex.getText("asn.array"));
        asnNamesByType.put(-3, (Object)lex.getText("asn.list"));
        asnNamesByType.put(-4, (Object)lex.getText("asn.any"));
        asnNamesByType.put(-5, (Object)lex.getText("asn.choice"));
        asnNamesByType.put(-6, (Object)lex.getText("asn.unknown"));
        asnTypesByName = new HashMap();
        asnTypesByName.put(lex.getText("asn.null"), new Integer(0));
        asnTypesByName.put(lex.getText("asn.boolean"), new Integer(1));
        asnTypesByName.put(lex.getText("asn.unsigned"), new Integer(2));
        asnTypesByName.put(lex.getText("asn.integer"), new Integer(3));
        asnTypesByName.put(lex.getText("asn.real"), new Integer(4));
        asnTypesByName.put(lex.getText("asn.double"), new Integer(5));
        asnTypesByName.put(lex.getText("asn.octetString"), new Integer(6));
        asnTypesByName.put(lex.getText("asn.characterString"), new Integer(7));
        asnTypesByName.put(lex.getText("asn.bitString"), new Integer(8));
        asnTypesByName.put(lex.getText("asn.enumerated"), new Integer(9));
        asnTypesByName.put(lex.getText("asn.date"), new Integer(10));
        asnTypesByName.put(lex.getText("asn.time"), new Integer(11));
        asnTypesByName.put(lex.getText("asn.objectId"), new Integer(12));
        asnTypesByName.put(lex.getText("asn.reserved13"), new Integer(13));
        asnTypesByName.put(lex.getText("asn.reserved14"), new Integer(14));
        asnTypesByName.put(lex.getText("asn.reserved15"), new Integer(15));
        asnTypesByName.put(lex.getText("asn.constructed"), new Integer(-1));
        asnTypesByName.put(lex.getText("asn.array"), new Integer(-2));
        asnTypesByName.put(lex.getText("asn.list"), new Integer(-3));
        asnTypesByName.put(lex.getText("asn.any"), new Integer(-4));
        asnTypesByName.put(lex.getText("asn.choice"), new Integer(-5));
        asnTypesByName.put(lex.getText("asn.unknown"), new Integer(-6));
        sizesBySpec = new IntHashMap();
        sizesBySpec.put(BBacnetNull.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)1));
        sizesBySpec.put(BBoolean.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)1));
        sizesBySpec.put(BBacnetUnsigned.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BInteger.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BFloat.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BDouble.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)9));
        sizesBySpec.put(BBacnetOctetString.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)27));
        sizesBySpec.put(BString.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)28));
        sizesBySpec.put(BBacnetBitString.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)8));
        sizesBySpec.put(BEnum.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)3));
        sizesBySpec.put(BBacnetDate.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BBacnetTime.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BBacnetObjectIdentifier.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)5));
        sizesBySpec.put(BBacnetDateTime.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)10));
        sizesBySpec.put(BBacnetTimeStamp.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)12));
        sizesBySpec.put(BBacnetTimeValue.TYPE.getTypeSpec().hashCode(), (Object)BInteger.make((int)10));
    }
}

