/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AsnInputStream
extends ByteArrayInputStream
implements AsnInput,
AsnConst {
    private static final int BACNET_STATUS_FLAGS_ALARM_BIT = 128;
    private static final int BACNET_STATUS_FLAGS_FAULT_BIT = 64;
    private static final int BACNET_STATUS_FLAGS_OVERRIDDEN_BIT = 32;
    private static final int BACNET_STATUS_FLAGS_OUT_OF_SERVICE_BIT = 16;
    private static final int STREAM_POOL_SIZE = 20;
    private static final byte[] NULL_BUFFER = new byte[0];
    private static int cnt = 0;
    private static AsnInputStream[] pool = new AsnInputStream[20];
    private static Object poolLock = new Object();
    private int currentTag;
    private int currentTagNumber;
    private int dataLength;
    private int currentTagIndex;
    private int nextTag;
    private boolean freeBuf;

    public void setBuffer(byte[] byArray) {
        this.setBuffer(byArray, 0);
    }

    public void setBuffer(byte[] byArray, int n) {
        this.buf = byArray == null ? NULL_BUFFER : byArray;
        this.pos = this.mark = n;
        this.count = this.buf.length;
        this.nextTag = 0;
    }

    public int getPos() {
        return this.pos;
    }

    public int peekTag() throws AsnException {
        if (this.available() == 0) {
            this.currentTag = -1;
            this.currentTagNumber = -1;
            this.dataLength = -1;
            this.currentTagIndex = -1;
            this.nextTag = -1;
            return -1;
        }
        int n = this.pos;
        int n2 = this.readTag();
        this.pos = n;
        return n2;
    }

    public boolean isApplicationTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 8) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isContextTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 8) == 8) {
            bl = true;
        }
        return bl;
    }

    public boolean isOpeningTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 8) == 8 && (this.currentTag & 7) == 6) {
            bl = true;
        }
        return bl;
    }

    public void skipOpeningTag(int n) throws AsnException {
        int n2 = this.peekTag();
        if (!this.isOpeningTag(n)) {
            throw new AsnException("Invalid tag: " + n2);
        }
        this.skipTag();
    }

    public boolean isClosingTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 8) == 8 && (this.currentTag & 7) == 7) {
            bl = true;
        }
        return bl;
    }

    public void skipClosingTag(int n) throws AsnException {
        int n2 = this.peekTag();
        if (!this.isClosingTag(n)) {
            throw new AsnException("Invalid tag: " + n2);
        }
        this.skipTag();
    }

    public boolean isValueTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 7) != 6 && (this.currentTag & 7) != 7) {
            bl = true;
        }
        return bl;
    }

    public int peekApplicationTag() throws AsnException {
        int n = this.peekTag();
        if (this.isApplicationTag(n)) {
            return n;
        }
        return -1;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int skipTag() throws AsnException {
        if (this.available() == 0) {
            this.currentTag = -1;
            this.currentTagNumber = -1;
            this.dataLength = -1;
            this.currentTagIndex = -1;
            this.nextTag = -1;
            return -1;
        }
        int n = this.readTag();
        if (this.pos != this.nextTag) {
            this.pos = this.nextTag;
        }
        return n;
    }

    public BBacnetNull readNull() throws AsnException {
        this.readTag();
        this.validateApplicationTag(0);
        return BBacnetNull.DEFAULT;
    }

    public BBacnetNull readNull(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return BBacnetNull.DEFAULT;
    }

    public boolean readBoolean() throws AsnException {
        this.readTag();
        this.validateApplicationTag(1);
        return this.dataLength != 0;
    }

    public boolean readBoolean(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        int n2 = this.read();
        if (n2 == 0) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        throw new AsnException("Invalid boolean value");
    }

    public long readUnsignedInteger() throws AsnException {
        this.readTag();
        this.validateApplicationTag(2);
        return this.decodeUnsignedInteger();
    }

    public long readUnsignedInteger(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeUnsignedInteger();
    }

    private final long decodeUnsignedInteger() throws AsnException {
        long l = 0L;
        if (this.dataLength > 4) {
            throw new AsnException("Integer overflow");
        }
        int n = 0;
        while (n < this.dataLength) {
            l <<= 8;
            l |= (long)this.read();
            ++n;
        }
        if (l < 0L) {
            throw new AsnException("Integer overflow");
        }
        return l;
    }

    public int readUnsignedInt() throws AsnException {
        this.readTag();
        this.validateApplicationTag(2);
        return (int)this.decodeUnsignedInteger();
    }

    public int readUnsignedInt(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return (int)this.decodeUnsignedInteger();
    }

    public BBacnetUnsigned readUnsigned() throws AsnException {
        this.readTag();
        this.validateApplicationTag(2);
        return BBacnetUnsigned.make(this.decodeUnsignedInteger());
    }

    public BBacnetUnsigned readUnsigned(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return BBacnetUnsigned.make(this.decodeUnsignedInteger());
    }

    public int readSignedInteger() throws AsnException {
        this.readTag();
        this.validateApplicationTag(3);
        return this.decodeSignedInteger();
    }

    public int readSignedInteger(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeSignedInteger();
    }

    private final int decodeSignedInteger() throws AsnException {
        if (this.dataLength > 4) {
            throw new AsnException("Integer overflow");
        }
        int n = this.read();
        if (this.dataLength < 4 && (n & 0x80) != 0) {
            n |= 0xFFFFFF00;
        }
        int n2 = this.dataLength - 1;
        while (n2 > 0) {
            n <<= 8;
            n |= this.read();
            --n2;
        }
        return n;
    }

    public BInteger readSigned() throws AsnException {
        this.readTag();
        this.validateApplicationTag(3);
        return BInteger.make((int)this.decodeSignedInteger());
    }

    public BInteger readSigned(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return BInteger.make((int)this.decodeSignedInteger());
    }

    public int readInteger() throws AsnException {
        this.readTag();
        boolean bl = true;
        try {
            this.validateApplicationTag(2);
        }
        catch (AsnException asnException) {
            this.validateApplicationTag(3);
            bl = false;
        }
        return bl ? (int)this.decodeUnsignedInteger() : this.decodeSignedInteger();
    }

    public float readReal() throws AsnException {
        this.readTag();
        this.validateApplicationTag(4);
        return this.decodeReal();
    }

    public float readReal(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeReal();
    }

    private final float decodeReal() throws AsnException {
        if (this.dataLength != 4) {
            throw new AsnException("Invalid real value");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.dataLength) {
            n <<= 8;
            n |= this.read();
            ++n2;
        }
        return Float.intBitsToFloat(n);
    }

    public BFloat readFloat() throws AsnException {
        this.readTag();
        this.validateApplicationTag(4);
        return BFloat.make((float)this.decodeReal());
    }

    public BFloat readFloat(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return BFloat.make((float)this.decodeReal());
    }

    public double readDouble() throws AsnException {
        this.readTag();
        this.validateApplicationTag(5);
        return this.decodeDouble();
    }

    public double readDouble(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeDouble();
    }

    private final double decodeDouble() throws AsnException {
        long l = 0L;
        if (this.dataLength != 8) {
            throw new AsnException("Invalid double value");
        }
        int n = 0;
        while (n < this.dataLength) {
            l <<= 8;
            l |= (long)this.read();
            ++n;
        }
        return Double.longBitsToDouble(l);
    }

    public byte[] readOctetString() throws AsnException {
        this.readTag();
        this.validateApplicationTag(6);
        return this.decodeOctetString();
    }

    public byte[] readOctetString(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeOctetString();
    }

    public BBacnetOctetString readBacnetOctetString() throws AsnException {
        this.readTag();
        this.validateApplicationTag(6);
        return BBacnetOctetString.make(this.decodeOctetString());
    }

    public BBacnetOctetString readBacnetOctetString(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return BBacnetOctetString.make(this.decodeOctetString());
    }

    private final byte[] decodeOctetString() {
        byte[] byArray = new byte[this.dataLength];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)this.read();
            ++n;
        }
        return byArray;
    }

    public BCharacterSetEncoding peekEncoding() throws AsnException {
        int n = this.pos;
        this.readTag();
        this.validateApplicationTag(7);
        int n2 = this.read();
        this.pos = n;
        return BCharacterSetEncoding.make(n2);
    }

    public BCharacterSetEncoding peekEncoding(int n) throws AsnException {
        int n2 = this.pos;
        this.readTag();
        this.validateContextTag(n);
        int n3 = this.read();
        this.pos = n2;
        return BCharacterSetEncoding.make(n3);
    }

    public String readCharacterString() throws AsnException {
        this.readTag();
        this.validateApplicationTag(7);
        return this.decodeCharacterString();
    }

    public String readCharacterString(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeCharacterString();
    }

    private final String decodeCharacterString() throws AsnException {
        BCharacterSetEncoding bCharacterSetEncoding = BCharacterSetEncoding.make(this.read());
        String string = null;
        int n = this.dataLength - 1;
        if (bCharacterSetEncoding == BCharacterSetEncoding.ibmMicrosoftDBCS) {
            int n2 = this.read() << 8;
            string = "cp" + (n2 |= this.read());
            n -= 2;
        } else {
            string = bCharacterSetEncoding.getEncodingName();
        }
        if (string == null) {
            throw new AsnException("Unsupported char set " + bCharacterSetEncoding.getTag());
        }
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[this.dataLength - 1];
        this.read(byArray);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AsnException("Unsupported char set " + bCharacterSetEncoding.getTag());
        }
    }

    public BBacnetBitString readBitString() throws AsnException {
        this.readTag();
        this.validateApplicationTag(8);
        return this.decodeBitString();
    }

    public BBacnetBitString readBitString(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeBitString();
    }

    private final BBacnetBitString decodeBitString() {
        int n = this.read();
        int n2 = (this.dataLength - 1) * 8 - n;
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.dataLength - 1) {
            int n5 = this.read();
            int n6 = 128;
            int n7 = 0;
            while (n7 < 8) {
                if (n3 < blArray.length) {
                    boolean bl = false;
                    if ((n5 & n6) != 0) {
                        bl = true;
                    }
                    blArray[n3] = bl;
                }
                n6 >>= 1;
                ++n3;
                ++n7;
            }
            ++n4;
        }
        return BBacnetBitString.make(blArray);
    }

    public BStatus readStatusFlags() throws AsnException {
        this.readTag();
        this.validateApplicationTag(8);
        return this.decodeStatusFlags();
    }

    public BStatus readStatusFlags(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeStatusFlags();
    }

    private final BStatus decodeStatusFlags() throws AsnException {
        boolean bl;
        if (this.read() != 4) {
            throw new AsnException("Invalid bit string length");
        }
        int n = this.read();
        int n2 = 0;
        if ((n & 0x80) != 0) {
            n2 |= 8;
        }
        if ((n & 0x40) != 0) {
            n2 |= 2;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x20;
        }
        boolean bl2 = false;
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if (!(bl = bl2)) {
            return BStatus.make((int)n2);
        }
        return BStatus.make((int)n2, (BFacets)BFacets.make((String)"outOfService", (boolean)true));
    }

    public int readEnumerated() throws AsnException {
        this.readTag();
        this.validateApplicationTag(9);
        return (int)this.decodeUnsignedInteger();
    }

    public int readEnumerated(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return (int)this.decodeUnsignedInteger();
    }

    public BBacnetDate readDate() throws AsnException {
        this.readTag();
        this.validateApplicationTag(10);
        return this.decodeDate();
    }

    public BBacnetDate readDate(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeDate();
    }

    private final BBacnetDate decodeDate() {
        return BBacnetDate.make(this.read(), this.read(), this.read(), this.read());
    }

    public BBacnetTime readTime() throws AsnException {
        this.readTag();
        this.validateApplicationTag(11);
        return this.decodeTime();
    }

    public BBacnetTime readTime(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeTime();
    }

    public BBacnetTime decodeTime() {
        return BBacnetTime.make(this.read(), this.read(), this.read(), this.read());
    }

    public BBacnetObjectIdentifier readObjectIdentifier() throws AsnException {
        this.readTag();
        this.validateApplicationTag(12);
        return this.decodeObjectIdentifier();
    }

    public BBacnetObjectIdentifier readObjectIdentifier(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeObjectIdentifier();
    }

    private final BBacnetObjectIdentifier decodeObjectIdentifier() throws AsnException {
        int n = (int)this.decodeUnsignedInteger();
        return BBacnetObjectIdentifier.makeId(n);
    }

    public BSimple readAsn() throws AsnException {
        this.readTag();
        this.validateApplicationTag(this.currentTagNumber);
        switch (this.currentTagNumber) {
            case 0: {
                return this.readNull();
            }
            case 1: {
                return BBoolean.make((boolean)this.readBoolean());
            }
            case 2: {
                return this.readUnsigned();
            }
            case 3: {
                return this.readSigned();
            }
            case 4: {
                return this.readFloat();
            }
            case 5: {
                return BDouble.make((double)this.readDouble());
            }
            case 6: {
                return this.readBacnetOctetString();
            }
            case 7: {
                return BString.make((String)this.readCharacterString());
            }
            case 8: {
                return this.readBitString();
            }
            case 9: {
                return BInteger.make((int)this.readEnumerated());
            }
            case 10: {
                return this.readDate();
            }
            case 11: {
                return this.readTime();
            }
            case 12: {
                return this.readObjectIdentifier();
            }
        }
        throw new AsnException("Invalid tag: " + this.currentTagNumber);
    }

    public byte[] readContextTaggedData() throws AsnException {
        byte[] byArray = new byte[this.dataLength];
        this.readTag();
        this.read(byArray);
        return byArray;
    }

    public byte[] readEncodedValue(int n) throws AsnException {
        this.readTag();
        if (this.currentTagNumber != n) {
            throw new AsnException("Invalid tag: " + this.currentTagNumber);
        }
        if ((this.currentTag & 7) != 6) {
            throw new AsnException("Expected opening tag");
        }
        byte[] byArray = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.pos;
        int n4 = 1;
        while (this.skipTag() != -1) {
            if (this.isOpeningTag(n)) {
                ++n4;
            }
            if (!this.isClosingTag(n) || --n4 != 0) continue;
            bl = true;
            n2 = this.currentTagIndex - n3;
            break;
        }
        if (!bl) {
            throw new AsnException("No closing tag");
        }
        if (n2 != 0) {
            int n5 = this.pos;
            this.pos = n3;
            byArray = new byte[n2];
            this.read(byArray);
            this.pos = n5;
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    private final void validateContextTag(int n) throws AsnException {
        if ((this.currentTag & 8) != 8) {
            throw new AsnException("Invalid tag class actual=" + this.currentTag + " expected=" + n);
        }
        if (!this.isValueTag(n)) {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    private final void validateApplicationTag(int n) throws AsnException {
        if ((this.currentTag & 8) != 0) {
            throw new AsnException("Invalid tag class actual=" + this.currentTag + " expected=" + n);
        }
        if (!this.isValueTag(n)) {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    private final int readTag() throws AsnException {
        this.currentTagIndex = this.pos;
        this.currentTag = this.read();
        this.currentTagNumber = this.readTagNumber(this.currentTag);
        if ((this.currentTag & 0xF) == 14 || (this.currentTag & 0xF) == 15) {
            this.parseConstructedData(this.currentTag);
        } else {
            this.parsePrimitiveData(this.currentTag);
        }
        return this.currentTagNumber;
    }

    private final int readTagNumber(int n) throws AsnException {
        int n2 = 0;
        if ((n & 0xF0) == 240) {
            n2 = this.read();
            if (n2 == 255) {
                throw new AsnException("Invalid tag number");
            }
        } else {
            n2 = (n & 0xF0) >> 4;
        }
        return n2;
    }

    private final void parsePrimitiveData(int n) throws AsnException {
        if ((n & 8) == 0 && this.currentTagNumber == 1) {
            this.dataLength = n & 7;
            this.nextTag = this.pos;
            return;
        }
        if ((n & 7) != 5) {
            this.dataLength = n & 7;
        } else {
            int n2 = this.read();
            if (n2 <= 253) {
                this.dataLength = n2;
            } else if (n2 == 254) {
                int n3 = this.read();
                this.dataLength = n3 << 8;
                n3 = this.read();
                this.dataLength |= n3;
            } else if (n2 == 255) {
                this.dataLength = 0;
                int n4 = 0;
                while (n4 < 4) {
                    this.dataLength <<= 8;
                    this.dataLength |= this.read();
                    ++n4;
                }
            } else {
                throw new AsnException("Invalid length tag");
            }
        }
        if (this.available() < this.dataLength) {
            throw new AsnException("Invalid length tag");
        }
        this.nextTag = this.pos + this.dataLength;
    }

    private final void parseConstructedData(int n) {
        this.nextTag = this.pos;
        this.dataLength = 0;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public void debug(String string) {
        System.out.println(string);
    }

    public void dump(PrintStream printStream) {
        printStream.println("currentTag " + this.currentTag);
        printStream.println("currentTagNumber " + this.currentTagNumber);
        printStream.println("dataLength " + this.dataLength);
        printStream.println("currentTagIndex " + this.currentTagIndex);
        printStream.println("nextTag " + this.nextTag);
        printStream.println("pos " + this.pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setPoolSize(int n) {
        Object object = poolLock;
        synchronized (object) {
            AsnInputStream[] asnInputStreamArray = new AsnInputStream[n];
            System.arraycopy(pool, 0, asnInputStreamArray, 0, Math.min(pool.length, asnInputStreamArray.length));
            pool = asnInputStreamArray;
            return;
        }
    }

    public static AsnInputStream make(byte[] byArray) {
        if (byArray == null) {
            return AsnInputStream.make(NULL_BUFFER, 0, 0);
        }
        return AsnInputStream.make(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AsnInputStream make(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            byArray = NULL_BUFFER;
        }
        Object object = poolLock;
        synchronized (object) {
            AsnInputStream asnInputStream;
            block5: {
                block4: {
                    if (cnt <= 0 || cnt > pool.length) break block4;
                    asnInputStream = pool[--cnt];
                    asnInputStream.pos = n;
                    asnInputStream.mark = n;
                    asnInputStream.buf = byArray;
                    asnInputStream.count = n2;
                    break block5;
                }
                asnInputStream = new AsnInputStream(byArray, n, n2);
            }
            asnInputStream.freeBuf = false;
            return asnInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        Object object = poolLock;
        synchronized (object) {
            if (this.freeBuf) {
                return;
            }
            if (cnt < pool.length) {
                AsnInputStream.pool[AsnInputStream.cnt++] = this;
            }
            this.freeBuf = true;
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.freeBuf = false;
    }

    public AsnInputStream() {
        super(new byte[0]);
        this.this();
    }

    public AsnInputStream(byte[] byArray) {
        super(byArray);
        this.this();
        this.nextTag = 0;
    }

    public AsnInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.this();
        this.nextTag = 0;
    }
}

