/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet;

import com.tridium.bacnet.BacnetQuery;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.schedule.BScheduleReference;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetOrdScheme
extends BOrdScheme {
    public static final BBacnetOrdScheme INSTANCE = new BBacnetOrdScheme();
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$bacnet$BBacnetOrdScheme;

    public OrdQuery parse(String string) {
        return new BacnetQuery(string);
    }

    private final BBacnetNetwork findNetwork(BObject bObject) {
        try {
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            if (bBacnetNetwork != null) {
                return bBacnetNetwork;
            }
            BOrd bOrd = BOrd.make((String)"service:bacnet:BacnetNetwork");
            return (BBacnetNetwork)bOrd.get(bObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public OrdTarget resolve(OrdTarget ordTarget, OrdQuery ordQuery) throws SyntaxException, UnresolvedException {
        try {
            BacnetQuery bacnetQuery = (BacnetQuery)ordQuery;
            BObject bObject = ordTarget.get();
            BBacnetNetwork bBacnetNetwork = this.findNetwork(bObject);
            String string = bacnetQuery.getDevice();
            String string2 = bacnetQuery.getObject();
            String string3 = bacnetQuery.getProperty();
            String string4 = bacnetQuery.getIndex();
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.DEFAULT;
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = BBacnetObjectIdentifier.DEFAULT;
            int n = -1;
            int n2 = -1;
            bBacnetObjectIdentifier = (BBacnetObjectIdentifier)bBacnetObjectIdentifier.decodeFromString(string);
            if (!bacnetQuery.hasObject()) {
                BLocalBacnetDevice bLocalBacnetDevice = (BLocalBacnetDevice)bBacnetNetwork.getLocalDevice().loadSlots();
                if (bBacnetObjectIdentifier.equals((Object)bLocalBacnetDevice.getObjectId())) {
                    return new OrdTarget(ordTarget, (BObject)bLocalBacnetDevice);
                }
                BOrd bOrd = bBacnetNetwork.lookupDeviceOrdById(bBacnetObjectIdentifier);
                BBacnetDevice bBacnetDevice = (BBacnetDevice)bOrd.get((BObject)bBacnetNetwork);
                return new OrdTarget(ordTarget, (BObject)bBacnetDevice);
            }
            bBacnetObjectIdentifier2 = (BBacnetObjectIdentifier)bBacnetObjectIdentifier2.decodeFromString(string2);
            if (bacnetQuery.hasProperty()) {
                n = Integer.parseInt(string3);
            }
            if (bacnetQuery.hasIndex()) {
                n2 = Integer.parseInt(string4);
            }
            if (bObject instanceof BIBacnetObjectContainer) {
                BIBacnetObjectContainer bIBacnetObjectContainer = (BIBacnetObjectContainer)bObject;
                BObject bObject2 = bIBacnetObjectContainer.lookupBacnetObject(bBacnetObjectIdentifier2, n, n2, bacnetQuery.getDomain());
                return new OrdTarget(ordTarget, bObject2);
            }
            if (bBacnetNetwork != null) {
                if (bBacnetObjectIdentifier.equals((Object)bBacnetNetwork.getLocalDevice().getObjectId())) {
                    BObject bObject3 = bBacnetNetwork.getLocalDevice().lookupBacnetObject(bBacnetObjectIdentifier2, n, n2, bacnetQuery.getDomain());
                    if (bObject instanceof BScheduleReference) {
                        return new OrdTarget(ordTarget, ((BIBacnetExportObject)bObject3).getObject());
                    }
                    return new OrdTarget(ordTarget, bObject3);
                }
                BOrd bOrd = bBacnetNetwork.lookupDeviceOrdById(bBacnetObjectIdentifier);
                BBacnetDevice bBacnetDevice = (BBacnetDevice)bOrd.get((BObject)bBacnetNetwork);
                if (bBacnetDevice != null) {
                    BObject bObject4 = bBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier2, n, n2, bacnetQuery.getDomain());
                    return new OrdTarget(ordTarget, bObject4);
                }
                throw new UnresolvedException(bObject + " [" + bObject.getType() + "] is not a valid base for resolving a Bacnet ord query!");
            }
        }
        catch (Exception exception) {
            throw new UnresolvedException("Unable to resolve Bacnet ord query:" + ordQuery + " against base:" + ordTarget, (Throwable)exception);
        }
        throw new UnresolvedException("Unable to resolve Bacnet ord query:" + ordQuery + " against base:" + ordTarget);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetOrdScheme() {
        super("bac");
    }

    static {
        Class clazz = class$com$tridium$bacnet$BBacnetOrdScheme;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$BBacnetOrdScheme = BBacnetOrdScheme.class("[Lcom.tridium.bacnet.BBacnetOrdScheme;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

