/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.security;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.pki.ClientPrivateKeyInfo;
import com.tridium.platform.pki.PemCertInfo;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEAPMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiWPA2Settings;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

public class BWifiWPA2Editor
extends BWbView {
    public static final Action editorModified = BWifiWPA2Editor.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setEnabledStates = BWifiWPA2Editor.newAction((int)0, null);
    public static final Action handleEAPPasswordChanged = BWifiWPA2Editor.newAction((int)4, null);
    public static final Action handleEAPIdentityChanged = BWifiWPA2Editor.newAction((int)4, null);
    public static final Action handleEAPAnonymousIdentityChanged = BWifiWPA2Editor.newAction((int)4, null);
    public static final Action handlePrivateKeyPasswordChanged = BWifiWPA2Editor.newAction((int)4, null);
    public static final Action handlePrivateKeyPassword2Changed = BWifiWPA2Editor.newAction((int)4, null);
    public static final Action handleEAPMethodChanged = BWifiWPA2Editor.newAction((int)4, null);
    public static final Action handlePhase2Changed = BWifiWPA2Editor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platwifi$ui$security$BWifiWPA2Editor == null ? (class$com$tridium$platwifi$ui$security$BWifiWPA2Editor = BWifiWPA2Editor.class$("com.tridium.platwifi.ui.security.BWifiWPA2Editor")) : class$com$tridium$platwifi$ui$security$BWifiWPA2Editor));
    private BGridPane mainPane = null;
    private BBorderPane tunnelParametersPane = null;
    private BEdgePane wpa2EdgePane = null;
    private BBooleanFE wpa2SupportedFE = null;
    private BCheckBox wpa2EnabledCheckBox = null;
    private BLimitedFrozenEnumFE wpa2EncryptionFE = null;
    private BLimitedFrozenEnumFE authenticationFE = null;
    private BLimitedFrozenEnumFE wpa2EAPTypeFE = null;
    private boolean eapPasswordDirty = false;
    private boolean eapIdentityDirty = false;
    private boolean eapAnonymousIdentityDirty = false;
    private boolean privateKeyPasswordDirty = false;
    private boolean privateKeyPassword2Dirty = false;
    private boolean eapIdentityMustBeSet = false;
    private boolean eapPasswordMustBeSet = false;
    private BFileSpace fileSpace = null;
    private BTextField wpa2EAPIdentityFE = null;
    private BTextField wpa2EAPAnonymousIdentityFE = null;
    private BPasswordFE wpa2EAPPasswordFE = null;
    private FilePath srcClientCertsDirPath = null;
    private FilePath srcClientKeysDirPath = null;
    private FilePath srcCaCertsDirPath = null;
    private FilePath destClientCertsDirPath = null;
    private FilePath destClientKeysDirPath = null;
    private FilePath destCaCertsDirPath = null;
    private BTextField wpa2CACertFE = null;
    private BTextField wpa2CACertDirFE = null;
    private BTextField wpa2ClientCertFE = null;
    private BTextField wpa2PrivateKeyFileFE = null;
    private BPasswordFE wpa2PrivateKeyPasswordFE = null;
    private BListDropDown clientKeyDropDown = null;
    private BListDropDown caCertDropDown = null;
    private BListDropDown wpa2TunnelPhase1FE = null;
    private BListDropDown wpa2TunnelPhase2FE = null;
    private final TunnelModel peapPhase1Model = new TunnelModel(new String[]{"", "peaplabel=0", "peaplabel=1", "peapver=0", "peapver=1", "peapver=0 peaplabel=0", "peapver=1 peaplabel=0", "peapver=0 peaplabel=1", "peapver=1 peaplabel=1"});
    private final TunnelModel peapPhase2Model = new TunnelModel(new String[]{"", "auth=MSCHAPV2", "auth=TLS", "auth=MD5", "auth=GTC"});
    private final TunnelModel ttlsPhase1Model = new TunnelModel(new String[]{""});
    private final TunnelModel ttlsPhase2Model = new TunnelModel(new String[]{"", "autheap=MSCHAPV2", "autheap=TLS", "autheap=MD5", "autheap=GTC", "auth=MSCHAPV2", "auth=MSCHAP", "auth=CHAP", "auth=PAP"});
    private final TunnelModel fastPhase1Model = new TunnelModel(new String[]{"", "fast_provisioning=1", "fast_provisioning=3"});
    private final TunnelModel fastPhase2Model = new TunnelModel(new String[]{""});
    private BTextField wpa2CACert2FE = null;
    private BTextField wpa2CACertDir2FE = null;
    private BTextField wpa2ClientCert2FE = null;
    private BTextField wpa2PrivateKeyFile2FE = null;
    private BPasswordFE wpa2PrivateKeyPassword2FE = null;
    private BListDropDown clientKey2DropDown = null;
    private BListDropDown caCert2DropDown = null;
    static /* synthetic */ Class class$com$tridium$platwifi$ui$security$BWifiWPA2Editor;
    static /* synthetic */ Class class$com$tridium$platform$pki$PemCertInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$pki$ClientPrivateKeyInfo;

    public void editorModified(BWidgetEvent bWidgetEvent) {
        this.invoke(editorModified, (BValue)bWidgetEvent, null);
    }

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public void handleEAPPasswordChanged() {
        this.invoke(handleEAPPasswordChanged, null, null);
    }

    public void handleEAPIdentityChanged() {
        this.invoke(handleEAPIdentityChanged, null, null);
    }

    public void handleEAPAnonymousIdentityChanged() {
        this.invoke(handleEAPAnonymousIdentityChanged, null, null);
    }

    public void handlePrivateKeyPasswordChanged() {
        this.invoke(handlePrivateKeyPasswordChanged, null, null);
    }

    public void handlePrivateKeyPassword2Changed() {
        this.invoke(handlePrivateKeyPassword2Changed, null, null);
    }

    public void handleEAPMethodChanged() {
        this.invoke(handleEAPMethodChanged, null, null);
    }

    public void handlePhase2Changed() {
        this.invoke(handlePhase2Changed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiWPA2Editor(BDaemonSession bDaemonSession) {
        this();
        this.init((BFileSpace)bDaemonSession.getFileSpace(), ClientPrivateKeyInfo.CLIENT_KEYS_PATH, ClientPrivateKeyInfo.CLIENT_CERTS_PATH, PemCertInfo.CA_CERTS_PATH, bDaemonSession.getFileSpace().getAltPath(new FilePath("!")));
    }

    public BWifiWPA2Editor(BWifiPlatformService bWifiPlatformService) {
        this();
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)bWifiPlatformService);
        bSystemPlatformService.lease();
        String string = bSystemPlatformService.getBajaHome().replace('\\', '/');
        FilePath filePath = string.charAt(0) == '/' ? new FilePath(string) : new FilePath('/' + string);
        this.init((BFileSpace)BOrd.make((String)"file:").get((BObject)bWifiPlatformService), ClientPrivateKeyInfo.CLIENT_KEYS_PATH, ClientPrivateKeyInfo.CLIENT_CERTS_PATH, PemCertInfo.CA_CERTS_PATH, filePath);
    }

    public BWifiWPA2Editor(BFileSpace bFileSpace, FilePath filePath, FilePath filePath2, FilePath filePath3, FilePath filePath4) {
        this();
        this.init(bFileSpace, filePath, filePath2, filePath3, filePath4);
    }

    protected void init(BFileSpace bFileSpace, FilePath filePath, FilePath filePath2, FilePath filePath3, FilePath filePath4) {
        this.fileSpace = bFileSpace;
        this.srcClientCertsDirPath = filePath2;
        this.srcClientKeysDirPath = filePath;
        this.srcCaCertsDirPath = filePath3;
        this.destClientKeysDirPath = BWifiWPA2Editor.makeLocalAbsolutePath(filePath4, ClientPrivateKeyInfo.CLIENT_KEYS_PATH);
        this.destClientCertsDirPath = BWifiWPA2Editor.makeLocalAbsolutePath(filePath4, ClientPrivateKeyInfo.CLIENT_CERTS_PATH);
        this.destCaCertsDirPath = BWifiWPA2Editor.makeLocalAbsolutePath(filePath4, PemCertInfo.CA_CERTS_PATH);
    }

    public BWifiWPA2Editor() {
    }

    public final void doLoadValue(BObject bObject, Context context) {
        boolean bl;
        BFacets bFacets;
        int n;
        if (context == null) {
            context = new BasicContext((Context)BFacets.make((String)"configureMode", (int)0));
        }
        if ((n = (bFacets = context.getFacets()).geti("configureMode", 0)) > 2 || n < 0) {
            n = 0;
        }
        boolean bl2 = bFacets.getb("showUse", true);
        boolean bl3 = bFacets.getb("useSetAndReadonly", false);
        boolean bl4 = bFacets.getb("showCACert", true);
        boolean bl5 = bFacets.getb("showCACertDir", true);
        BBoolean bBoolean = (BBoolean)context.getFacets().getFacet("showSupported");
        BBoolean bBoolean2 = (BBoolean)context.getFacets().getFacet("supportedReadonly");
        boolean bl6 = bBoolean != null ? bBoolean.getBoolean() : (bl = n == 1);
        boolean bl7 = bBoolean2 != null ? bBoolean2.getBoolean() : n != 1;
        this.eapIdentityMustBeSet = n != 0;
        this.eapPasswordMustBeSet = n != 0;
        this.mainPane = new BGridPane(2);
        this.mainPane.setColumnAlign(BHalign.fill);
        this.mainPane.setValign(BValign.top);
        this.mainPane.setHalign(BHalign.left);
        this.mainPane.setColumnGap(10.0);
        this.mainPane.setRowGap(6.0);
        this.mainPane.setColorRows(true);
        this.wpa2SupportedFE = new BBooleanFE();
        this.wpa2EnabledCheckBox = new BCheckBox(this.getLexicon().getText("WifiNetworkManager.WPA2CheckBox.value"));
        if (bl) {
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPA2Supported.label"), (BWidget)this.left((BWidget)this.wpa2SupportedFE));
            this.linkTo(null, (BComponent)this.wpa2SupportedFE, (Slot)BBooleanFE.pluginModified, (Slot)setEnabledStates);
            this.linkTo(null, (BComponent)this.wpa2SupportedFE, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        }
        if (bl2) {
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPA2CheckBox.label"), (BWidget)this.wpa2EnabledCheckBox);
            this.linkTo(null, (BComponent)this.wpa2EnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            this.linkTo(null, (BComponent)this.wpa2EnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        }
        this.authenticationFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.Authentication.label"), (BWidget)this.left((BWidget)this.authenticationFE));
        this.linkTo(null, (BComponent)this.authenticationFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.wpa2EncryptionFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEncryption.label"), (BWidget)this.left((BWidget)this.wpa2EncryptionFE));
        this.linkTo(null, (BComponent)this.wpa2EncryptionFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.wpa2EAPTypeFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAP.label"), (BWidget)this.left((BWidget)this.wpa2EAPTypeFE));
        this.linkTo(null, (BComponent)this.wpa2EAPTypeFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)handleEAPMethodChanged);
        this.wpa2EAPIdentityFE = new BTextField("", 32);
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAPIdentity.label"), (BWidget)this.wpa2EAPIdentityFE);
        this.linkTo(null, (BComponent)this.wpa2EAPIdentityFE, (Slot)BTextField.textModified, (Slot)handleEAPIdentityChanged);
        this.linkTo(null, (BComponent)this.wpa2EAPIdentityFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.wpa2EAPAnonymousIdentityFE = new BTextField("", 32);
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAPAnonymousIdentity.label"), (BWidget)this.wpa2EAPAnonymousIdentityFE);
        this.linkTo(null, (BComponent)this.wpa2EAPAnonymousIdentityFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpa2EAPAnonymousIdentityFE, (Slot)BTextField.textModified, (Slot)handleEAPAnonymousIdentityChanged);
        this.wpa2EAPPasswordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAEAPPassword.label"), (BWidget)this.wpa2EAPPasswordFE);
        this.linkTo(null, (BComponent)this.wpa2EAPPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)handleEAPPasswordChanged);
        this.linkTo(null, (BComponent)this.wpa2EAPPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        PemCertInfo[] pemCertInfoArray = null;
        ClientPrivateKeyInfo[] clientPrivateKeyInfoArray = null;
        if (this.fileSpace != null && this.srcCaCertsDirPath != null) {
            try {
                pemCertInfoArray = PemCertInfo.list((BFileSpace)this.fileSpace, (FilePath)this.srcCaCertsDirPath);
            }
            catch (Exception exception) {
                pemCertInfoArray = null;
            }
        }
        if (this.fileSpace != null && this.srcClientCertsDirPath != null && this.srcClientKeysDirPath != null) {
            try {
                clientPrivateKeyInfoArray = ClientPrivateKeyInfo.list((BFileSpace)this.fileSpace, (FilePath)this.srcClientKeysDirPath, (FilePath)this.srcClientCertsDirPath);
            }
            catch (Exception exception) {
                clientPrivateKeyInfoArray = null;
            }
        }
        if (pemCertInfoArray != null) {
            this.caCertDropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACACertDropDown.label"), (BWidget)this.caCertDropDown);
            this.caCertDropDown.getList().setModel((ListModel)new CACertModel(pemCertInfoArray));
            this.linkTo(null, (BComponent)this.caCertDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.caCertDropDown == null) {
            if (bl4) {
                this.wpa2CACertFE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcert.label"), (BWidget)this.wpa2CACertFE);
                this.linkTo(null, (BComponent)this.wpa2CACertFE, (Slot)BTextField.textModified, (Slot)setModified);
            }
            if (bl5) {
                this.wpa2CACertDirFE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcertDir.label"), (BWidget)this.wpa2CACertDirFE);
                this.linkTo(null, (BComponent)this.wpa2CACertDirFE, (Slot)BTextField.textModified, (Slot)setModified);
            }
        }
        if (clientPrivateKeyInfoArray != null) {
            this.clientKeyDropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientKeyDropDown.label"), (BWidget)this.clientKeyDropDown);
            this.clientKeyDropDown.getList().setModel((ListModel)new ClientKeyModel(clientPrivateKeyInfoArray));
            this.linkTo(null, (BComponent)this.clientKeyDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.clientKeyDropDown == null) {
            this.wpa2ClientCertFE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientCert.label"), (BWidget)this.wpa2ClientCertFE);
            this.linkTo(null, (BComponent)this.wpa2ClientCertFE, (Slot)BTextField.textModified, (Slot)setModified);
            this.wpa2PrivateKeyFileFE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyFile.label"), (BWidget)this.wpa2PrivateKeyFileFE);
            this.linkTo(null, (BComponent)this.wpa2PrivateKeyFileFE, (Slot)BTextField.textModified, (Slot)setModified);
        }
        this.wpa2PrivateKeyPasswordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)this.mainPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyPassword.label"), (BWidget)this.wpa2PrivateKeyPasswordFE);
        this.linkTo(null, (BComponent)this.wpa2PrivateKeyPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)handlePrivateKeyPasswordChanged);
        this.linkTo(null, (BComponent)this.wpa2PrivateKeyPasswordFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.wpa2SupportedFE.setEnabled(false);
        this.wpa2SupportedFE.setReadonly(true);
        this.wpa2EnabledCheckBox.setEnabled(false);
        this.wpa2EncryptionFE.setEnabled(false);
        this.wpa2EncryptionFE.setReadonly(true);
        this.authenticationFE.setEnabled(false);
        this.authenticationFE.setReadonly(true);
        this.wpa2EAPTypeFE.setEnabled(false);
        this.wpa2EAPTypeFE.setReadonly(true);
        this.wpa2EAPIdentityFE.setEnabled(false);
        this.wpa2EAPIdentityFE.setEditable(false);
        this.wpa2EAPAnonymousIdentityFE.setEnabled(false);
        this.wpa2EAPAnonymousIdentityFE.setEditable(false);
        this.wpa2EAPPasswordFE.setEnabled(false);
        this.wpa2EAPPasswordFE.setReadonly(true);
        if (this.wpa2CACertFE != null) {
            this.wpa2CACertFE.setEnabled(false);
            this.wpa2CACertFE.setEditable(false);
        }
        if (this.wpa2CACertDirFE != null) {
            this.wpa2CACertDirFE.setEnabled(false);
            this.wpa2CACertDirFE.setEditable(false);
        }
        if (this.wpa2ClientCertFE != null) {
            this.wpa2ClientCertFE.setEnabled(false);
            this.wpa2ClientCertFE.setEditable(false);
        }
        if (this.wpa2PrivateKeyFileFE != null) {
            this.wpa2PrivateKeyFileFE.setEnabled(false);
            this.wpa2PrivateKeyFileFE.setEditable(false);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(false);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(false);
        }
        this.wpa2PrivateKeyPasswordFE.setEnabled(false);
        this.wpa2PrivateKeyPasswordFE.setReadonly(true);
        BWifiWPA2Settings bWifiWPA2Settings = (BWifiWPA2Settings)bObject;
        this.wpa2SupportedFE.setEnabled(!bl7);
        this.wpa2SupportedFE.setReadonly(bl7);
        this.wpa2SupportedFE.loadValue((BObject)BBoolean.make((boolean)bWifiWPA2Settings.getSupported()), context);
        if (bl3) {
            this.wpa2EnabledCheckBox.setSelected(true);
            this.wpa2EnabledCheckBox.setEnabled(false);
        } else {
            this.wpa2EnabledCheckBox.setSelected(bWifiWPA2Settings.getUse());
        }
        this.authenticationFE.loadValue((BObject)bWifiWPA2Settings.getAuthentication(), (Context)new BasicContext(context, BWifiWPA2Settings.authentication.getFacets()));
        this.wpa2EncryptionFE.loadValue((BObject)bWifiWPA2Settings.getEncryption(), (Context)new BasicContext(context, BWifiWPA2Settings.encryption.getFacets()));
        this.wpa2EAPTypeFE.loadValue((BObject)bWifiWPA2Settings.getEap(), (Context)new BasicContext(context, BWifiWPA2Settings.eap.getFacets()));
        this.wpa2EAPIdentityFE.setText(bWifiWPA2Settings.getEapIdentity());
        this.wpa2EAPAnonymousIdentityFE.setText(bWifiWPA2Settings.getEapAnonymousIdentity());
        this.wpa2EAPPasswordFE.loadValue((BObject)bWifiWPA2Settings.getEapPassword(), context);
        if (this.wpa2CACertFE != null) {
            this.wpa2CACertFE.setText(bWifiWPA2Settings.getCertAuthCertificate());
        }
        if (this.wpa2CACertDirFE != null) {
            this.wpa2CACertDirFE.setText(bWifiWPA2Settings.getCertAuthDirectoryPath());
        }
        if (this.wpa2ClientCertFE != null) {
            this.wpa2ClientCertFE.setText(bWifiWPA2Settings.getClientCertificate());
        }
        if (this.wpa2PrivateKeyFileFE != null) {
            this.wpa2PrivateKeyFileFE.setText(bWifiWPA2Settings.getPrivateKeyFile());
        }
        if (this.clientKeyDropDown != null) {
            ((ClientKeyModel)this.clientKeyDropDown.getList().getModel()).select(bWifiWPA2Settings.getPrivateKeyFile());
        }
        if (this.caCertDropDown != null) {
            ((CACertModel)this.caCertDropDown.getList().getModel()).select(bWifiWPA2Settings.getCertAuthCertificate());
        }
        this.wpa2PrivateKeyPasswordFE.loadValue((BObject)bWifiWPA2Settings.getPrivateKeyPassword(), context);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        bGridPane.setColorRows(true);
        this.wpa2TunnelPhase1FE = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPATunnel.phase1.label"), (BWidget)this.left((BWidget)this.wpa2TunnelPhase1FE));
        this.wpa2TunnelPhase1FE.getList().getSelection().deselectAll();
        this.wpa2TunnelPhase1FE.getList().removeAllItems();
        this.linkTo(null, (BComponent)this.wpa2TunnelPhase1FE, (Slot)BListDropDown.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpa2TunnelPhase1FE, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.wpa2TunnelPhase2FE = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPATunnel.phase2.label"), (BWidget)this.left((BWidget)this.wpa2TunnelPhase2FE));
        this.wpa2TunnelPhase2FE.getList().getSelection().deselectAll();
        this.wpa2TunnelPhase2FE.getList().removeAllItems();
        this.linkTo(null, (BComponent)this.wpa2TunnelPhase2FE, (Slot)BListDropDown.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpa2TunnelPhase2FE, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpa2TunnelPhase2FE, (Slot)BListDropDown.listActionPerformed, (Slot)handlePhase2Changed);
        if (pemCertInfoArray != null) {
            this.caCert2DropDown = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACACertDropDown2.label"), (BWidget)this.caCert2DropDown);
            this.caCert2DropDown.getList().setModel((ListModel)new CACertModel(pemCertInfoArray));
            this.linkTo(null, (BComponent)this.caCert2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        }
        if (this.caCert2DropDown == null) {
            if (bl4) {
                this.wpa2CACert2FE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcert2.label"), (BWidget)this.wpa2CACert2FE);
                this.linkTo(null, (BComponent)this.wpa2CACert2FE, (Slot)BTextField.textModified, (Slot)setModified);
            }
            if (bl5) {
                this.wpa2CACertDir2FE = new BTextField("", 32);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPACAcertDir2.label"), (BWidget)this.wpa2CACertDir2FE);
                this.linkTo(null, (BComponent)this.wpa2CACertDir2FE, (Slot)BTextField.textModified, (Slot)setModified);
            }
        }
        if (clientPrivateKeyInfoArray != null) {
            try {
                this.clientKey2DropDown = new BListDropDown();
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientKeyDropDown2.label"), (BWidget)this.clientKey2DropDown);
                this.clientKey2DropDown.getList().setModel((ListModel)new ClientKeyModel(clientPrivateKeyInfoArray));
                this.linkTo(null, (BComponent)this.clientKey2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.clientKey2DropDown == null) {
            this.wpa2ClientCert2FE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAClientCert2.label"), (BWidget)this.wpa2ClientCert2FE);
            this.linkTo(null, (BComponent)this.wpa2ClientCert2FE, (Slot)BTextField.textModified, (Slot)setModified);
            this.wpa2PrivateKeyFile2FE = new BTextField("", 32);
            LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyFile2.label"), (BWidget)this.wpa2PrivateKeyFile2FE);
            this.linkTo(null, (BComponent)this.wpa2PrivateKeyFile2FE, (Slot)BTextField.textModified, (Slot)setModified);
        }
        this.wpa2PrivateKeyPassword2FE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.WPAPrivateKeyPassword2.label"), (BWidget)this.wpa2PrivateKeyPassword2FE);
        this.linkTo(null, (BComponent)this.wpa2PrivateKeyPassword2FE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpa2PrivateKeyPassword2FE, (Slot)BPasswordFE.pluginModified, (Slot)handlePrivateKeyPassword2Changed);
        this.wpa2TunnelPhase1FE.setEnabled(false);
        this.wpa2TunnelPhase2FE.setEnabled(false);
        if (this.wpa2CACert2FE != null) {
            this.wpa2CACert2FE.setEnabled(false);
            this.wpa2CACert2FE.setEditable(false);
        }
        if (this.wpa2CACertDir2FE != null) {
            this.wpa2CACertDir2FE.setEnabled(false);
            this.wpa2CACertDir2FE.setEditable(false);
        }
        if (this.wpa2ClientCert2FE != null) {
            this.wpa2ClientCert2FE.setEnabled(false);
            this.wpa2ClientCert2FE.setEditable(false);
        }
        if (this.wpa2PrivateKeyFile2FE != null) {
            this.wpa2PrivateKeyFile2FE.setEnabled(false);
            this.wpa2PrivateKeyFile2FE.setEditable(false);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(false);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(false);
        }
        this.wpa2PrivateKeyPassword2FE.setEnabled(false);
        this.wpa2PrivateKeyPassword2FE.setReadonly(true);
        if (this.wpa2CACert2FE != null) {
            this.wpa2CACert2FE.setText(bWifiWPA2Settings.getCertAuthCertificate2());
        }
        if (this.wpa2CACertDir2FE != null) {
            this.wpa2CACertDir2FE.setText(bWifiWPA2Settings.getCertAuthDirectoryPath2());
        }
        if (this.wpa2ClientCert2FE != null) {
            this.wpa2ClientCert2FE.setText(bWifiWPA2Settings.getClientCertificate2());
        }
        if (this.wpa2PrivateKeyFile2FE != null) {
            this.wpa2PrivateKeyFile2FE.setText(bWifiWPA2Settings.getPrivateKeyFile2());
        }
        if (this.clientKey2DropDown != null) {
            ((ClientKeyModel)this.clientKey2DropDown.getList().getModel()).select(bWifiWPA2Settings.getPrivateKeyFile2());
        }
        if (this.caCert2DropDown != null) {
            ((CACertModel)this.caCert2DropDown.getList().getModel()).select(bWifiWPA2Settings.getCertAuthCertificate2());
        }
        this.wpa2PrivateKeyPassword2FE.loadValue((BObject)bWifiWPA2Settings.getPrivateKeyPassword2(), context);
        this.eapPasswordDirty = false;
        this.eapIdentityDirty = false;
        this.eapAnonymousIdentityDirty = false;
        this.privateKeyPasswordDirty = false;
        this.privateKeyPassword2Dirty = false;
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
        bBorderPane.setBorder(BBorder.inset);
        bBorderPane.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiNetworkManager.WPATunnel.border.label"), (boolean)true));
        this.tunnelParametersPane = new BBorderPane((BWidget)bBorderPane, 10.0, 0.0, 0.0, 0.0);
        this.wpa2EdgePane = new BEdgePane(null, (BWidget)this.tunnelParametersPane, null, null, (BWidget)this.mainPane);
        this.setContent((BWidget)this.wpa2EdgePane);
        this.doSetReadonly(this.isReadonly());
        this.doSetEnabledStates();
        this.wpa2TunnelPhase1FE.setSelectedItem((Object)bWifiWPA2Settings.getTunnelPhase1());
        this.wpa2TunnelPhase2FE.setSelectedItem((Object)bWifiWPA2Settings.getTunnelPhase2());
        this.doHandlePhase2Changed();
    }

    public final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BWifiWPA2Settings bWifiWPA2Settings = (BWifiWPA2Settings)bObject;
        bWifiWPA2Settings.setSupported(((BBoolean)this.wpa2SupportedFE.saveValue(context)).getBoolean());
        if (!bWifiWPA2Settings.getSupported()) {
            return bWifiWPA2Settings;
        }
        bWifiWPA2Settings.setUse(this.wpa2EnabledCheckBox.isSelected());
        bWifiWPA2Settings.setAuthentication((BWifiAuthenticationMethod)this.authenticationFE.saveValue(context));
        bWifiWPA2Settings.setEap((BWifiEAPMethod)this.wpa2EAPTypeFE.saveValue(context));
        bWifiWPA2Settings.setEncryption((BWifiEncryptionMethod)this.wpa2EncryptionFE.saveValue(context));
        String string = null;
        if (this.eapIdentityDirty) {
            string = this.wpa2EAPIdentityFE.getText().trim();
            if (string == null || string.length() == 0) {
                this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidIdentity");
            }
            bWifiWPA2Settings.setEapIdentity(string);
        } else if (bWifiWPA2Settings.getUse() && this.eapIdentityMustBeSet) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.eapIdentityMustBeSet");
        }
        if (this.eapAnonymousIdentityDirty) {
            string = this.wpa2EAPAnonymousIdentityFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setEapAnonymousIdentity("");
            } else {
                bWifiWPA2Settings.setEapAnonymousIdentity(string);
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.wpa2CACertFE != null) {
            string = this.wpa2CACertFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setCertAuthCertificate("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl = true;
                        bWifiWPA2Settings.setCertAuthCertificate(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                }
            }
        }
        if (this.wpa2CACertDirFE != null) {
            string = this.wpa2CACertDirFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setCertAuthDirectoryPath("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl2 = true;
                        bWifiWPA2Settings.setCertAuthDirectoryPath(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                }
            }
        }
        if (this.caCertDropDown != null) {
            bWifiWPA2Settings.setCertAuthCertificate(((CACertModel)this.caCertDropDown.getList().getModel()).getSelectedCertPath(this.destCaCertsDirPath));
            bl = true;
        }
        if (bl && bl2) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertConfigurationBoth");
        }
        if (this.wpa2ClientCertFE != null) {
            string = this.wpa2ClientCertFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setClientCertificate("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPA2Settings.setClientCertificate(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                }
            }
        }
        if (this.wpa2PrivateKeyFileFE != null) {
            string = this.wpa2PrivateKeyFileFE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setPrivateKeyFile("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPA2Settings.setPrivateKeyFile(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                }
            }
        }
        if (this.clientKeyDropDown != null) {
            bWifiWPA2Settings.setPrivateKeyFile(((ClientKeyModel)this.clientKeyDropDown.getList().getModel()).getSelectedKeyPath(this.destClientKeysDirPath));
            bWifiWPA2Settings.setClientCertificate(((ClientKeyModel)this.clientKeyDropDown.getList().getModel()).getSelectedCertPath(this.destClientCertsDirPath));
        }
        if (this.eapPasswordDirty) {
            bWifiWPA2Settings.setEapPassword((BPassword)this.wpa2EAPPasswordFE.saveValue(context));
        } else if (!bWifiWPA2Settings.getUse() || !this.eapPasswordMustBeSet || bWifiWPA2Settings.getEap().getOrdinal() != 1) {
            // empty if block
        }
        if (this.privateKeyPasswordDirty) {
            bWifiWPA2Settings.setPrivateKeyPassword((BPassword)this.wpa2PrivateKeyPasswordFE.saveValue(context));
        }
        if (bWifiWPA2Settings.getEap() == BWifiEAPMethod.peap || bWifiWPA2Settings.getEap() == BWifiEAPMethod.ttls || bWifiWPA2Settings.getEap() == BWifiEAPMethod.fast) {
            String string2 = (String)this.wpa2TunnelPhase1FE.getSelectedItem();
            bWifiWPA2Settings.setTunnelPhase1(string2 != null ? string2 : "");
            string2 = (String)this.wpa2TunnelPhase2FE.getSelectedItem();
            bWifiWPA2Settings.setTunnelPhase2(string2 != null ? string2 : "");
        } else {
            bWifiWPA2Settings.setTunnelPhase1("");
            bWifiWPA2Settings.setTunnelPhase2("");
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.wpa2CACert2FE != null) {
            string = this.wpa2CACert2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setCertAuthCertificate2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl3 = true;
                        bWifiWPA2Settings.setCertAuthCertificate2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertFilePath");
                }
            }
        }
        if (this.wpa2CACertDir2FE != null) {
            string = this.wpa2CACertDir2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setCertAuthDirectoryPath2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bl4 = true;
                        bWifiWPA2Settings.setCertAuthDirectoryPath2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertDirectoryFilePath");
                }
            }
        }
        if (this.caCert2DropDown != null) {
            bWifiWPA2Settings.setCertAuthCertificate2(((CACertModel)this.caCert2DropDown.getList().getModel()).getSelectedCertPath(this.destCaCertsDirPath));
            bl3 = true;
        }
        if (bl3 && bl4) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidCACertConfigurationBoth");
        }
        if (this.wpa2ClientCert2FE != null) {
            string = this.wpa2ClientCert2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setClientCertificate2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPA2Settings.setClientCertificate2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidClientCertificate");
                }
            }
        }
        if (this.wpa2PrivateKeyFile2FE != null) {
            string = this.wpa2PrivateKeyFile2FE.getText().trim();
            if (string == null || string.length() == 0) {
                bWifiWPA2Settings.setPrivateKeyFile2("");
            } else {
                try {
                    if (new FilePath(string).isAbsolute()) {
                        bWifiWPA2Settings.setPrivateKeyFile2(string);
                    } else {
                        this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                    }
                }
                catch (SyntaxException syntaxException) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidKeyFile");
                }
            }
        }
        if (this.clientKey2DropDown != null) {
            bWifiWPA2Settings.setPrivateKeyFile2(((ClientKeyModel)this.clientKey2DropDown.getList().getModel()).getSelectedKeyPath(this.destClientKeysDirPath));
            bWifiWPA2Settings.setClientCertificate2(((ClientKeyModel)this.clientKey2DropDown.getList().getModel()).getSelectedCertPath(this.destClientCertsDirPath));
        }
        if (this.privateKeyPassword2Dirty) {
            bWifiWPA2Settings.setPrivateKeyPassword2((BPassword)this.wpa2PrivateKeyPassword2FE.saveValue(context));
        }
        this.eapPasswordDirty = false;
        this.eapIdentityDirty = false;
        this.eapAnonymousIdentityDirty = false;
        this.privateKeyPasswordDirty = false;
        this.privateKeyPassword2Dirty = false;
        return bWifiWPA2Settings;
    }

    public void doHandleEAPPasswordChanged() {
        this.eapPasswordDirty = true;
        this.setModified();
    }

    public boolean isPasswordDirty() {
        return this.eapPasswordDirty;
    }

    public void doHandleEAPIdentityChanged() {
        this.eapIdentityDirty = true;
        this.setModified();
    }

    public boolean isEapIdentityDirty() {
        return this.eapIdentityDirty;
    }

    public void doHandleEAPAnonymousIdentityChanged() {
        this.eapAnonymousIdentityDirty = true;
        this.setModified();
    }

    public boolean isEAPAnonymousIdentityDirty() {
        return this.eapAnonymousIdentityDirty;
    }

    public void doHandlePrivateKeyPasswordChanged() {
        this.privateKeyPasswordDirty = true;
        this.setModified();
    }

    public boolean isPrivateKeyPasswordDirty() {
        return this.privateKeyPasswordDirty;
    }

    public void doHandlePrivateKeyPassword2Changed() {
        this.privateKeyPassword2Dirty = true;
        this.setModified();
    }

    public boolean isPrivateKeyPassword2Dirty() {
        return this.privateKeyPassword2Dirty;
    }

    private void saveError(String string) throws CannotSaveException {
        throw new CannotSaveException(this.getLexicon().getText(string));
    }

    private BWidget left(BWidget bWidget) {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.add(null, (BValue)bWidget);
        return bGridPane;
    }

    public final void doSetEnabledStates() {
        boolean bl = this.isReadonly();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = ((BBoolean)this.wpa2SupportedFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        this.wpa2EnabledCheckBox.setEnabled(!bl && bl2);
        if (this.wpa2EnabledCheckBox.isSelected() && !bl2) {
            this.wpa2EnabledCheckBox.setSelected(false);
        }
        bl3 = this.wpa2EnabledCheckBox.getSelected();
        boolean bl4 = !bl && bl2 && bl3;
        boolean bl5 = !bl4;
        this.authenticationFE.setEnabled(bl4);
        this.authenticationFE.setReadonly(bl5);
        this.wpa2EAPIdentityFE.setEnabled(bl4);
        this.wpa2EAPIdentityFE.setEditable(bl4);
        this.wpa2EAPAnonymousIdentityFE.setEnabled(bl4);
        this.wpa2EAPAnonymousIdentityFE.setEditable(bl4);
        this.wpa2EAPPasswordFE.setEnabled(bl4);
        this.wpa2EAPPasswordFE.setReadonly(bl5);
        this.wpa2EncryptionFE.setEnabled(bl4);
        this.wpa2EncryptionFE.setReadonly(bl5);
        this.wpa2EAPTypeFE.setEnabled(bl4);
        this.wpa2EAPTypeFE.setReadonly(bl5);
        if (this.wpa2CACertFE != null) {
            this.wpa2CACertFE.setEnabled(bl4);
            this.wpa2CACertFE.setEditable(bl4);
        }
        if (this.wpa2CACertDirFE != null) {
            this.wpa2CACertDirFE.setEnabled(bl4);
            this.wpa2CACertDirFE.setEditable(bl4);
        }
        if (this.wpa2ClientCertFE != null) {
            this.wpa2ClientCertFE.setEnabled(bl4);
            this.wpa2ClientCertFE.setEditable(bl4);
        }
        if (this.wpa2PrivateKeyFileFE != null) {
            this.wpa2PrivateKeyFileFE.setEnabled(bl4);
            this.wpa2PrivateKeyFileFE.setEditable(bl4);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(bl4);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(bl4);
        }
        this.wpa2PrivateKeyPasswordFE.setEnabled(bl4);
        this.wpa2PrivateKeyPasswordFE.setReadonly(bl5);
        this.wpa2TunnelPhase1FE.setEnabled(bl4);
        this.wpa2TunnelPhase2FE.setEnabled(bl4);
        if (this.wpa2CACert2FE != null) {
            this.wpa2CACert2FE.setEnabled(bl4);
            this.wpa2CACert2FE.setEditable(bl4);
        }
        if (this.wpa2CACertDir2FE != null) {
            this.wpa2CACertDir2FE.setEnabled(bl4);
            this.wpa2CACertDir2FE.setEditable(bl4);
        }
        if (this.wpa2ClientCert2FE != null) {
            this.wpa2ClientCert2FE.setEnabled(bl4);
            this.wpa2ClientCert2FE.setEditable(bl4);
        }
        if (this.wpa2PrivateKeyFile2FE != null) {
            this.wpa2PrivateKeyFile2FE.setEnabled(bl4);
            this.wpa2PrivateKeyFile2FE.setEditable(bl4);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(bl4);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(bl4);
        }
        this.wpa2PrivateKeyPassword2FE.setEnabled(bl4);
        this.wpa2PrivateKeyPassword2FE.setReadonly(bl5);
        this.doHandleEAPMethodChanged();
        this.doHandlePhase2Changed();
    }

    public void doHandleEAPMethodChanged() {
        boolean bl = this.isReadonly();
        boolean bl2 = false;
        boolean bl3 = this.wpa2EnabledCheckBox.isSelected();
        try {
            bl2 = ((BBoolean)this.wpa2SupportedFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        boolean bl4 = !bl && bl2 && bl3;
        boolean bl5 = !bl4;
        this.wpa2EdgePane.setBottom((BWidget)new BNullWidget());
        try {
            BWifiEAPMethod bWifiEAPMethod = (BWifiEAPMethod)this.wpa2EAPTypeFE.saveValue();
            if (bWifiEAPMethod == BWifiEAPMethod.peap || bWifiEAPMethod == BWifiEAPMethod.ttls || bWifiEAPMethod == BWifiEAPMethod.fast) {
                this.wpa2EAPPasswordFE.setEnabled(bl4);
                this.wpa2EAPPasswordFE.setReadonly(bl5);
                if (bWifiEAPMethod == BWifiEAPMethod.ttls || bWifiEAPMethod == BWifiEAPMethod.peap) {
                    this.wpa2EAPAnonymousIdentityFE.setEnabled(bl4);
                    this.wpa2EAPAnonymousIdentityFE.setEditable(bl4);
                } else {
                    this.wpa2EAPAnonymousIdentityFE.setEnabled(false);
                    this.wpa2EAPAnonymousIdentityFE.setEditable(false);
                }
                if (this.wpa2ClientCertFE != null) {
                    this.wpa2ClientCertFE.setEnabled(false);
                    this.wpa2ClientCertFE.setEditable(false);
                }
                if (this.wpa2PrivateKeyFileFE != null) {
                    this.wpa2PrivateKeyFileFE.setEnabled(false);
                    this.wpa2PrivateKeyFileFE.setEditable(false);
                }
                if (this.clientKeyDropDown != null) {
                    this.clientKeyDropDown.setEnabled(false);
                }
                this.wpa2PrivateKeyPasswordFE.setEnabled(false);
                this.wpa2PrivateKeyPasswordFE.setReadonly(true);
                if (this.wpa2CACertFE != null) {
                    this.wpa2CACertFE.setEnabled(bl4);
                    this.wpa2CACertFE.setEditable(bl4);
                }
                if (this.wpa2CACertDirFE != null) {
                    this.wpa2CACertDirFE.setEnabled(bl4);
                    this.wpa2CACertDirFE.setEditable(bl4);
                }
                if (this.caCertDropDown != null) {
                    this.caCertDropDown.setEnabled(bl4);
                }
                TunnelModel tunnelModel = null;
                TunnelModel tunnelModel2 = null;
                if (bWifiEAPMethod == BWifiEAPMethod.peap) {
                    if (this.wpa2TunnelPhase1FE.getList().getModel() != this.peapPhase1Model || this.wpa2TunnelPhase2FE.getList().getModel() != this.peapPhase2Model) {
                        tunnelModel = this.peapPhase1Model;
                        tunnelModel2 = this.peapPhase2Model;
                    }
                } else if (bWifiEAPMethod == BWifiEAPMethod.ttls) {
                    if (this.wpa2TunnelPhase1FE.getList().getModel() != this.ttlsPhase1Model || this.wpa2TunnelPhase2FE.getList().getModel() != this.ttlsPhase2Model) {
                        tunnelModel = this.ttlsPhase1Model;
                        tunnelModel2 = this.ttlsPhase2Model;
                    }
                } else if (bWifiEAPMethod == BWifiEAPMethod.fast && (this.wpa2TunnelPhase1FE.getList().getModel() != this.fastPhase1Model || this.wpa2TunnelPhase2FE.getList().getModel() != this.fastPhase2Model)) {
                    tunnelModel = this.fastPhase1Model;
                    tunnelModel2 = this.fastPhase2Model;
                }
                if (tunnelModel != null && tunnelModel2 != null) {
                    this.wpa2TunnelPhase1FE.getList().getSelection().deselectAll();
                    this.wpa2TunnelPhase2FE.getList().getSelection().deselectAll();
                    this.wpa2TunnelPhase1FE.getList().setModel((ListModel)tunnelModel);
                    this.wpa2TunnelPhase2FE.getList().setModel((ListModel)tunnelModel2);
                    if (tunnelModel == this.ttlsPhase1Model) {
                        this.wpa2TunnelPhase1FE.setEnabled(false);
                    } else {
                        this.wpa2TunnelPhase1FE.setEnabled(bl4);
                    }
                    this.doHandlePhase2Changed();
                    this.wpa2TunnelPhase1FE.getList().getSelection().select(0);
                    this.wpa2TunnelPhase2FE.getList().getSelection().select(0);
                    this.setModified();
                }
                this.wpa2EdgePane.setBottom((BWidget)this.tunnelParametersPane);
            } else {
                if (bWifiEAPMethod == BWifiEAPMethod.leap) {
                    this.wpa2EAPPasswordFE.setEnabled(bl4);
                    this.wpa2EAPPasswordFE.setReadonly(bl5);
                    this.wpa2EAPAnonymousIdentityFE.setEnabled(false);
                    this.wpa2EAPAnonymousIdentityFE.setEditable(false);
                    if (this.wpa2ClientCertFE != null) {
                        this.wpa2ClientCertFE.setEnabled(false);
                        this.wpa2ClientCertFE.setEditable(false);
                    }
                    if (this.wpa2PrivateKeyFileFE != null) {
                        this.wpa2PrivateKeyFileFE.setEnabled(false);
                        this.wpa2PrivateKeyFileFE.setEditable(false);
                    }
                    if (this.clientKeyDropDown != null) {
                        this.clientKeyDropDown.setEnabled(false);
                    }
                    this.wpa2PrivateKeyPasswordFE.setEnabled(false);
                    this.wpa2PrivateKeyPasswordFE.setReadonly(true);
                    if (this.wpa2CACertFE != null) {
                        this.wpa2CACertFE.setEnabled(false);
                        this.wpa2CACertFE.setEditable(false);
                    }
                    if (this.wpa2CACertDirFE != null) {
                        this.wpa2CACertDirFE.setEnabled(false);
                        this.wpa2CACertDirFE.setEditable(false);
                    }
                    if (this.caCertDropDown != null) {
                        this.caCertDropDown.setEnabled(false);
                    }
                } else if (bWifiEAPMethod == BWifiEAPMethod.tls) {
                    this.wpa2EAPPasswordFE.setEnabled(false);
                    this.wpa2EAPPasswordFE.setReadonly(true);
                    this.wpa2EAPAnonymousIdentityFE.setEnabled(false);
                    this.wpa2EAPAnonymousIdentityFE.setEditable(false);
                    if (this.wpa2ClientCertFE != null) {
                        this.wpa2ClientCertFE.setEnabled(bl4);
                        this.wpa2ClientCertFE.setEditable(bl4);
                    }
                    if (this.wpa2PrivateKeyFileFE != null) {
                        this.wpa2PrivateKeyFileFE.setEnabled(bl4);
                        this.wpa2PrivateKeyFileFE.setEditable(bl4);
                    }
                    if (this.clientKeyDropDown != null) {
                        this.clientKeyDropDown.setEnabled(bl4);
                    }
                    this.wpa2PrivateKeyPasswordFE.setEnabled(bl4);
                    this.wpa2PrivateKeyPasswordFE.setReadonly(bl5);
                    if (this.wpa2CACertFE != null) {
                        this.wpa2CACertFE.setEnabled(bl4);
                        this.wpa2CACertFE.setEditable(bl4);
                    }
                    if (this.wpa2CACertDirFE != null) {
                        this.wpa2CACertDirFE.setEnabled(bl4);
                        this.wpa2CACertDirFE.setEditable(bl4);
                    }
                    if (this.caCertDropDown != null) {
                        this.caCertDropDown.setEnabled(bl4);
                    }
                }
                this.tunnelParametersPane.computePreferredSize();
                this.wpa2EdgePane.setBottom((BWidget)new BEdgePane(null, (BWidget)new BBox(this.tunnelParametersPane.getPreferredWidth(), 0.0), (BWidget)new BBox(0.0, this.tunnelParametersPane.getPreferredHeight()), null, null));
                this.setModified();
            }
        }
        catch (Exception exception) {
            System.err.println("Error while handling EAPMethodChanged");
            exception.printStackTrace();
        }
    }

    public void doHandlePhase2Changed() {
        boolean bl = this.isReadonly();
        boolean bl2 = false;
        boolean bl3 = this.wpa2EnabledCheckBox.isSelected();
        try {
            bl2 = ((BBoolean)this.wpa2SupportedFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        boolean bl4 = !bl && bl2 && bl3;
        boolean bl5 = !bl4;
        String string = (String)this.wpa2TunnelPhase2FE.getList().getSelectedItem();
        if (string != null && (string.equals("auth=TLS") || string.equals("autheap=TLS"))) {
            if (this.wpa2ClientCert2FE != null) {
                this.wpa2ClientCert2FE.setEnabled(bl4);
                this.wpa2ClientCert2FE.setEditable(bl4);
            }
            if (this.wpa2PrivateKeyFile2FE != null) {
                this.wpa2PrivateKeyFile2FE.setEnabled(bl4);
                this.wpa2PrivateKeyFile2FE.setEditable(bl4);
            }
            if (this.clientKey2DropDown != null) {
                this.clientKey2DropDown.setEnabled(bl4);
            }
            this.wpa2PrivateKeyPassword2FE.setEnabled(bl4);
            this.wpa2PrivateKeyPassword2FE.setReadonly(bl5);
            if (this.wpa2CACert2FE != null) {
                this.wpa2CACert2FE.setEnabled(bl4);
                this.wpa2CACert2FE.setEditable(bl4);
            }
            if (this.wpa2CACertDir2FE != null) {
                this.wpa2CACertDir2FE.setEnabled(bl4);
                this.wpa2CACertDir2FE.setEditable(bl4);
            }
            if (this.caCert2DropDown != null) {
                this.caCert2DropDown.setEnabled(bl4);
            }
        } else {
            if (this.wpa2ClientCert2FE != null) {
                this.wpa2ClientCert2FE.setEnabled(false);
                this.wpa2ClientCert2FE.setEditable(false);
            }
            if (this.wpa2PrivateKeyFile2FE != null) {
                this.wpa2PrivateKeyFile2FE.setEnabled(false);
                this.wpa2PrivateKeyFile2FE.setEditable(false);
            }
            if (this.clientKey2DropDown != null) {
                this.clientKey2DropDown.setEnabled(false);
            }
            this.wpa2PrivateKeyPassword2FE.setEnabled(false);
            this.wpa2PrivateKeyPassword2FE.setReadonly(true);
            if (this.wpa2CACert2FE != null) {
                this.wpa2CACert2FE.setEnabled(false);
                this.wpa2CACert2FE.setEditable(false);
            }
            if (this.wpa2CACertDir2FE != null) {
                this.wpa2CACertDir2FE.setEnabled(false);
                this.wpa2CACertDir2FE.setEditable(false);
            }
            if (this.caCert2DropDown != null) {
                this.caCert2DropDown.setEnabled(false);
            }
        }
        this.setModified();
    }

    public void doEditorModified(BWidgetEvent bWidgetEvent) {
    }

    public void doSetReadonly(boolean bl) {
        if (this.wpa2SupportedFE != null) {
            this.wpa2SupportedFE.setEnabled(!bl);
            this.wpa2SupportedFE.setReadonly(bl);
        }
        if (this.wpa2EnabledCheckBox != null) {
            this.wpa2EnabledCheckBox.setEnabled(!bl);
        }
        if (this.wpa2EncryptionFE != null) {
            this.wpa2EncryptionFE.setEnabled(!bl);
            this.wpa2EncryptionFE.setReadonly(bl);
        }
        if (this.authenticationFE != null) {
            this.authenticationFE.setEnabled(!bl);
            this.authenticationFE.setReadonly(bl);
        }
        if (this.wpa2EAPTypeFE != null) {
            this.wpa2EAPTypeFE.setEnabled(!bl);
            this.wpa2EAPTypeFE.setReadonly(bl);
        }
        if (this.wpa2EAPIdentityFE != null) {
            this.wpa2EAPIdentityFE.setEditable(!bl);
            this.wpa2EAPIdentityFE.setEnabled(!bl);
        }
        if (this.wpa2EAPAnonymousIdentityFE != null) {
            this.wpa2EAPAnonymousIdentityFE.setEditable(!bl);
            this.wpa2EAPAnonymousIdentityFE.setEnabled(!bl);
        }
        if (this.wpa2EAPPasswordFE != null) {
            this.wpa2EAPPasswordFE.setEnabled(!bl);
            this.wpa2EAPPasswordFE.setReadonly(bl);
        }
        if (this.wpa2ClientCertFE != null) {
            this.wpa2ClientCertFE.setEnabled(!bl);
            this.wpa2ClientCertFE.setEditable(!bl);
        }
        if (this.wpa2PrivateKeyFileFE != null) {
            this.wpa2PrivateKeyFileFE.setEnabled(!bl);
            this.wpa2PrivateKeyFileFE.setEditable(!bl);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(!bl);
        }
        if (this.wpa2PrivateKeyPasswordFE != null) {
            this.wpa2PrivateKeyPasswordFE.setEnabled(!bl);
            this.wpa2PrivateKeyPasswordFE.setReadonly(bl);
        }
        if (this.wpa2CACertFE != null) {
            this.wpa2CACertFE.setEnabled(!bl);
            this.wpa2CACertFE.setEditable(!bl);
        }
        if (this.wpa2CACertDirFE != null) {
            this.wpa2CACertDirFE.setEnabled(!bl);
            this.wpa2CACertDirFE.setEditable(!bl);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(!bl);
        }
        if (this.wpa2TunnelPhase1FE != null) {
            this.wpa2TunnelPhase1FE.setEnabled(!bl);
        }
        if (this.wpa2TunnelPhase2FE != null) {
            this.wpa2TunnelPhase2FE.setEnabled(!bl);
        }
        if (this.wpa2ClientCert2FE != null) {
            this.wpa2ClientCert2FE.setEnabled(!bl);
            this.wpa2ClientCert2FE.setEditable(!bl);
        }
        if (this.wpa2PrivateKeyFile2FE != null) {
            this.wpa2PrivateKeyFile2FE.setEnabled(!bl);
            this.wpa2PrivateKeyFile2FE.setEditable(!bl);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(!bl);
        }
        if (this.wpa2PrivateKeyPassword2FE != null) {
            this.wpa2PrivateKeyPassword2FE.setEnabled(!bl);
            this.wpa2PrivateKeyPassword2FE.setReadonly(bl);
        }
        if (this.wpa2CACert2FE != null) {
            this.wpa2CACert2FE.setEnabled(!bl);
            this.wpa2CACert2FE.setEditable(!bl);
        }
        if (this.wpa2CACertDir2FE != null) {
            this.wpa2CACertDir2FE.setEnabled(!bl);
            this.wpa2CACertDir2FE.setEditable(!bl);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(!bl);
        }
    }

    public static FilePath makeLocalAbsolutePath(FilePath filePath, FilePath filePath2) {
        if (filePath2.isLocalAbsolute()) {
            return filePath2;
        }
        if (filePath2.isSysHomeAbsolute()) {
            FilePath filePath3 = filePath;
            for (int i = 0; i < filePath2.depth(); ++i) {
                filePath3 = filePath3.merge(filePath2.nameAt(i));
            }
            return filePath3;
        }
        throw new IllegalArgumentException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClientKeyModel
    extends ListModel {
        private Array items = new Array(class$com$tridium$platform$pki$ClientPrivateKeyInfo == null ? (class$com$tridium$platform$pki$ClientPrivateKeyInfo = BWifiWPA2Editor.class$("com.tridium.platform.pki.ClientPrivateKeyInfo")) : class$com$tridium$platform$pki$ClientPrivateKeyInfo);

        public ClientKeyModel(ClientPrivateKeyInfo[] clientPrivateKeyInfoArray) {
            this.items.add((Object)ClientPrivateKeyInfo.BLANK_KEY_CERTIFICATE);
            for (int i = 0; i < clientPrivateKeyInfoArray.length; ++i) {
                if (clientPrivateKeyInfoArray[i].keyFile == null) continue;
                this.items.add((Object)clientPrivateKeyInfoArray[i]);
            }
        }

        public void select(String string) {
            if (string == null || string.length() == 0) {
                this.getSelection().select(0);
                return;
            }
            String string2 = new FilePath(string).getName();
            for (int i = 1; i < this.getItemCount(); ++i) {
                if (!string2.equals(this.keyInfo((int)i).keyFile.getFileName())) continue;
                this.getSelection().select(i);
                return;
            }
            this.getSelection().deselectAll();
        }

        public String getSelectedKeyPath(FilePath filePath) {
            int n = this.getSelection().getLead();
            if (n < 1) {
                return "";
            }
            return filePath.merge(this.keyInfo((int)n).keyFile.getFileName()).getBody();
        }

        public String getSelectedCertPath(FilePath filePath) {
            int n = this.getSelection().getLead();
            if (n < 1) {
                return "";
            }
            return filePath.merge(this.keyInfo((int)n).certFile.getFileName()).getBody();
        }

        public ClientPrivateKeyInfo keyInfo(int n) {
            return (ClientPrivateKeyInfo)this.items.get(n);
        }

        public Object getItem(int n) {
            if (n == 0) {
                return "NONE";
            }
            return this.keyInfo((int)n).keyFile.getFileName();
        }

        public int getItemCount() {
            return this.items.size();
        }
    }

    private static class TunnelModel
    extends ListModel {
        private Array items = new Array(class$java$lang$String == null ? (class$java$lang$String = BWifiWPA2Editor.class$("java.lang.String")) : class$java$lang$String);

        public TunnelModel(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.items.add((Object)stringArray[i]);
            }
        }

        public String tunnelInfo(int n) {
            return (String)this.items.get(n);
        }

        public Object getItem(int n) {
            return this.tunnelInfo(n);
        }

        public int getItemCount() {
            return this.items.size();
        }
    }

    private static class CACertModel
    extends ListModel {
        private Array items = new Array(class$com$tridium$platform$pki$PemCertInfo == null ? (class$com$tridium$platform$pki$PemCertInfo = BWifiWPA2Editor.class$("com.tridium.platform.pki.PemCertInfo")) : class$com$tridium$platform$pki$PemCertInfo);

        public CACertModel(PemCertInfo[] pemCertInfoArray) {
            this.items.add((Object)PemCertInfo.BLANK_CERTIFICATE);
            for (int i = 0; i < pemCertInfoArray.length; ++i) {
                if (pemCertInfoArray[i].file == null) continue;
                this.items.add((Object)pemCertInfoArray[i]);
            }
        }

        public void select(String string) {
            if (string == null || string.length() == 0) {
                this.getSelection().select(0);
                return;
            }
            String string2 = new FilePath(string).getName();
            for (int i = 1; i < this.getItemCount(); ++i) {
                if (!this.caCertInfo((int)i).file.getFileName().equals(string2)) continue;
                this.getSelection().select(i);
                return;
            }
            this.getSelection().deselectAll();
        }

        public String getSelectedCertPath(FilePath filePath) {
            int n = this.getSelection().getLead();
            if (n < 1) {
                return "";
            }
            return filePath.merge(this.caCertInfo((int)n).file.getFileName()).getBody();
        }

        public PemCertInfo caCertInfo(int n) {
            return (PemCertInfo)this.items.get(n);
        }

        public Object getItem(int n) {
            if (n == 0) {
                return "NONE";
            }
            return this.caCertInfo((int)n).file.getFileName();
        }

        public int getItemCount() {
            return this.items.size();
        }
    }
}

