/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.platwifi.BWifiCommandArgs;
import com.tridium.platwifi.BWifiHostSettings;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiWEPSettings;
import com.tridium.platwifi.security.BWifiWPA2PSKSettings;
import com.tridium.platwifi.security.BWifiWPA2Settings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.security.BWifiWPASettings;
import com.tridium.platwifi.status.BWifiDaemonStateEnum;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import com.tridium.platwifi.ui.BWifiNetworkEditorDialog;
import com.tridium.platwifi.ui.BWifiPlatformServicePlugin;
import com.tridium.platwifi.ui.daemon.BWifiConfiguration;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import java.util.Comparator;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BWifiNetworksManager
extends BWbComponentView {
    public static final Action handleDiscoveredTableModified = BWifiNetworksManager.newAction((int)0, null);
    public static final Action handleDiscoveredSelectionModified = BWifiNetworksManager.newAction((int)0, null);
    public static final Action handleDiscoveredFocusModified = BWifiNetworksManager.newAction((int)0, (BValue)new BFocusEvent(), null);
    public static final Action handleDatabaseTableModified = BWifiNetworksManager.newAction((int)0, null);
    public static final Action handleDatabaseSelectionModified = BWifiNetworksManager.newAction((int)0, null);
    public static final Action handleDatabaseFocusModified = BWifiNetworksManager.newAction((int)0, (BValue)new BFocusEvent(), null);
    public static final Action setEnabledStates = BWifiNetworksManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platwifi$ui$BWifiNetworksManager == null ? (class$com$tridium$platwifi$ui$BWifiNetworksManager = BWifiNetworksManager.class$("com.tridium.platwifi.ui.BWifiNetworksManager")) : class$com$tridium$platwifi$ui$BWifiNetworksManager));
    private volatile Object operationMonitor = new Object();
    private boolean operationTakingPlace = false;
    protected BGridPane ledgerPane = null;
    protected BBooleanFE wifiEnabledFE = null;
    protected BLabel daemonStateLabel = null;
    protected BLabel currentAdapterLabel = null;
    protected BWifiNetwork currentNetwork = null;
    protected BTitlePane titledDatabaseTable = null;
    protected BTitlePane titledDiscoveryTable = null;
    protected BTable discoveredNetworkTable = null;
    protected BTable databaseNetworkTable = null;
    protected WifiNetworkTableModel discoveredNetworkTableModel = null;
    protected WifiNetworkTableModel databaseNetworkTableModel = null;
    protected BButtonPane discoverButtons = null;
    protected DiscoverCommand discoverNetworksCommand = null;
    protected AddCommand addNetworkCommand = null;
    protected BButtonPane databaseButtons = null;
    protected ConnectCommand connectNetworkCommand = null;
    protected RoamCommand roamNetworkCommand = null;
    protected NewCommand newNetworkCommand = null;
    protected EditCommand editNetworkCommand = null;
    protected DisconnectCommand disconnectNetworkCommand = null;
    protected RemoveCommand removeNetworkCommand = null;
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 800;
    public static final BImage NORMAL_NETWORK_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png")}));
    public static final BImage UNAVAILABLE_NETWORK_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloudDisconnected.png")}));
    static /* synthetic */ Class class$com$tridium$platwifi$ui$BWifiNetworksManager;
    static /* synthetic */ Class class$com$tridium$platwifi$BWifiNetwork;
    static /* synthetic */ Class class$com$tridium$platwifi$ui$BWifiNetworksManager$WifiNetworkTableRow;
    static /* synthetic */ Class class$javax$baja$sys$BInteger;
    static /* synthetic */ Class class$com$tridium$platwifi$security$BWifiSecurityPolicy;

    public void handleDiscoveredTableModified() {
        this.invoke(handleDiscoveredTableModified, null, null);
    }

    public void handleDiscoveredSelectionModified() {
        this.invoke(handleDiscoveredSelectionModified, null, null);
    }

    public void handleDiscoveredFocusModified(BFocusEvent bFocusEvent) {
        this.invoke(handleDiscoveredFocusModified, (BValue)bFocusEvent, null);
    }

    public void handleDatabaseTableModified() {
        this.invoke(handleDatabaseTableModified, null, null);
    }

    public void handleDatabaseSelectionModified() {
        this.invoke(handleDatabaseSelectionModified, null, null);
    }

    public void handleDatabaseFocusModified(BFocusEvent bFocusEvent) {
        this.invoke(handleDatabaseFocusModified, (BValue)bFocusEvent, null);
    }

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void doLoadValue(BObject bObject, Context context) {
        this.autoRegisterForComponentEvents = false;
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        this.ledgerPane = new BGridPane(2);
        this.ledgerPane.setRowAlign(BValign.top);
        this.ledgerPane.setHalign(BHalign.left);
        this.ledgerPane.setColumnAlign(BHalign.left);
        this.ledgerPane.setRowGap(5.0);
        this.ledgerPane.setStretchColumn(1);
        this.ledgerPane.add(null, (BValue)new BLabel(this.getLexicon().getText("WifiNetworkManager.settings.enabled.label")));
        this.wifiEnabledFE = new BBooleanFE();
        this.ledgerPane.add(null, (BValue)this.wifiEnabledFE);
        this.linkTo(null, (BComponent)this.wifiEnabledFE, (Slot)BBooleanFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wifiEnabledFE, (Slot)BBooleanFE.pluginModified, (Slot)setEnabledStates);
        this.ledgerPane.add(null, (BValue)new BLabel(this.getLexicon().getText("WifiNetworkManager.settings.daemonState.label")));
        this.daemonStateLabel = new BLabel(BWifiDaemonStateEnum.unknown.getTag());
        this.ledgerPane.add(null, (BValue)this.daemonStateLabel);
        this.ledgerPane.add(null, (BValue)new BLabel(this.getLexicon().getText("WifiNetworkManager.settings.currentAdapter.label")));
        this.currentAdapterLabel = new BLabel("");
        this.ledgerPane.add(null, (BValue)this.currentAdapterLabel);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.ledgerPane);
        bBorderPane.setBorder(BBorder.solid);
        bBorderPane.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiNetworkManager.settings.label"), (boolean)true));
        bBorderPane.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setOrientation(BOrientation.vertical);
        this.discoveredNetworkTableModel = new WifiNetworkTableModel(false, false);
        this.discoveredNetworkTable = new BTable((TableModel)this.discoveredNetworkTableModel);
        this.discoveredNetworkTable.setCellRenderer((TableCellRenderer)new WifiNetworkCellRenderer());
        this.discoveredNetworkTable.setController((TableController)new DiscoveryTableController());
        this.discoveredNetworkTable.setHeaderVisible(true);
        this.discoveredNetworkTable.setMultipleSelection(false);
        this.databaseNetworkTableModel = new WifiNetworkTableModel(true, true);
        this.databaseNetworkTable = new BTable((TableModel)this.databaseNetworkTableModel);
        this.databaseNetworkTable.setCellRenderer((TableCellRenderer)new WifiNetworkCellRenderer());
        this.databaseNetworkTable.setController((TableController)new DatabaseTableController());
        this.databaseNetworkTable.setHeaderVisible(true);
        this.databaseNetworkTable.setMultipleSelection(false);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.selectionModified, (Slot)handleDiscoveredSelectionModified);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.tableModified, (Slot)handleDiscoveredTableModified);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.focusEvent, (Slot)handleDiscoveredFocusModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.selectionModified, (Slot)handleDatabaseSelectionModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.tableModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.tableModified, (Slot)handleDatabaseTableModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.focusEvent, (Slot)handleDatabaseFocusModified);
        this.discoverButtons = new BButtonPane();
        this.discoverButtons.setColumnCount(2);
        this.discoverButtons.setUniformColumnWidth(false);
        this.discoverButtons.setBandBrush(bBrush);
        this.databaseButtons = new BButtonPane();
        this.databaseButtons.setColumnCount(6);
        this.databaseButtons.setUniformColumnWidth(false);
        this.databaseButtons.setBandBrush(bBrush);
        this.titledDiscoveryTable = BTitlePane.makePane((String)this.getLexicon().getText("WifiNetworkManager.header.discovered"), (BTable)this.discoveredNetworkTable);
        this.titledDatabaseTable = BTitlePane.makePane((String)this.getLexicon().getText("WifiNetworkManager.header.database"), (BTable)this.databaseNetworkTable);
        this.discoverNetworksCommand = new DiscoverCommand();
        this.discoverButtons.add("discover", (BValue)new BButton((Command)this.discoverNetworksCommand, true, true));
        this.addNetworkCommand = new AddCommand();
        this.discoverButtons.add("add", (BValue)new BButton((Command)this.addNetworkCommand, true, true));
        this.roamNetworkCommand = new RoamCommand();
        this.databaseButtons.add("roam", (BValue)new BButton((Command)this.roamNetworkCommand, true, true));
        this.connectNetworkCommand = new ConnectCommand();
        this.databaseButtons.add("connect", (BValue)new BButton((Command)this.connectNetworkCommand, true, true));
        this.disconnectNetworkCommand = new DisconnectCommand();
        this.databaseButtons.add("disconnect", (BValue)new BButton((Command)this.disconnectNetworkCommand, true, true));
        this.editNetworkCommand = new EditCommand();
        this.databaseButtons.add("edit", (BValue)new BButton((Command)this.editNetworkCommand, true, true));
        this.newNetworkCommand = new NewCommand();
        this.databaseButtons.add("add", (BValue)new BButton((Command)this.newNetworkCommand, true, true));
        this.removeNetworkCommand = new RemoveCommand();
        this.databaseButtons.add("remove", (BValue)new BButton((Command)this.removeNetworkCommand, true, true));
        if (this.discoverNetworksCommand != null) {
            this.discoverNetworksCommand.setEnabled(true);
        }
        if (this.newNetworkCommand != null) {
            this.newNetworkCommand.setEnabled(true);
        }
        if (this.roamNetworkCommand != null) {
            this.roamNetworkCommand.setEnabled(true);
        }
        if (this.addNetworkCommand != null) {
            this.addNetworkCommand.setEnabled(false);
        }
        if (this.connectNetworkCommand != null) {
            this.connectNetworkCommand.setEnabled(false);
        }
        if (this.disconnectNetworkCommand != null) {
            this.disconnectNetworkCommand.setEnabled(false);
        }
        if (this.editNetworkCommand != null) {
            this.editNetworkCommand.setEnabled(false);
        }
        if (this.removeNetworkCommand != null) {
            this.removeNetworkCommand.setEnabled(false);
        }
        BBorderPane bBorderPane2 = new BBorderPane((BWidget)this.discoverButtons);
        BBorderPane bBorderPane3 = new BBorderPane((BWidget)this.databaseButtons);
        bBorderPane2.setPadding(BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        bBorderPane3.setPadding(BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        if (this.titledDiscoveryTable != null) {
            this.titledDiscoveryTable.setBottom((BWidget)bBorderPane2);
        }
        if (this.titledDatabaseTable != null) {
            this.titledDatabaseTable.setBottom((BWidget)bBorderPane3);
        }
        bSplitPane.setWidget1((BWidget)this.titledDiscoveryTable);
        bSplitPane.setWidget2((BWidget)this.titledDatabaseTable);
        if (this.wifiEnabledFE != null) {
            this.wifiEnabledFE.setReadonly(true);
            this.wifiEnabledFE.setEnabled(false);
        }
        if (this.titledDatabaseTable != null) {
            this.titledDatabaseTable.setEnabled(true);
        }
        if (this.titledDiscoveryTable != null) {
            this.titledDiscoveryTable.setEnabled(true);
        }
        if (this.discoveredNetworkTable != null) {
            this.discoveredNetworkTable.setEnabled(true);
        }
        if (this.databaseNetworkTable != null) {
            this.databaseNetworkTable.setEnabled(true);
        }
        if (this.discoverButtons != null) {
            this.discoverButtons.setEnabled(true);
        }
        if (this.databaseButtons != null) {
            this.databaseButtons.setEnabled(true);
        }
        if (this.addNetworkCommand != null) {
            this.addNetworkCommand.setEnabled(true);
        }
        if (this.connectNetworkCommand != null) {
            this.connectNetworkCommand.setEnabled(true);
        }
        if (this.editNetworkCommand != null) {
            this.editNetworkCommand.setEnabled(true);
        }
        if (this.disconnectNetworkCommand != null) {
            this.disconnectNetworkCommand.setEnabled(true);
        }
        if (this.removeNetworkCommand != null) {
            this.removeNetworkCommand.setEnabled(true);
        }
        if (this.discoverNetworksCommand != null) {
            this.discoverNetworksCommand.setEnabled(true);
        }
        if (this.roamNetworkCommand != null) {
            this.roamNetworkCommand.setEnabled(true);
        }
        if (this.newNetworkCommand != null) {
            this.newNetworkCommand.setEnabled(true);
        }
        BBorderPane bBorderPane4 = new BBorderPane((BWidget)bSplitPane, 10.0, 10.0, 5.0, 10.0);
        bBorderPane4.setBorder(BBorder.solid);
        bBorderPane4.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiNetworkManager.networks.label"), (boolean)true));
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)bBorderPane, null, null, null, (BWidget)bBorderPane4)));
        BWifiHostSettings bWifiHostSettings = (BWifiHostSettings)bObject;
        this.refreshSettings(bWifiHostSettings, context);
    }

    public final void refreshSettings(BWifiHostSettings bWifiHostSettings, Context context) {
        Object object;
        int n;
        if (bWifiHostSettings == null) {
            return;
        }
        if (this.wifiEnabledFE == null) {
            return;
        }
        if (this.daemonStateLabel == null) {
            return;
        }
        if (this.currentAdapterLabel == null) {
            return;
        }
        if (this.isOperationTakingPlace()) {
            return;
        }
        this.lockModifiedState();
        boolean bl = this.isModified();
        boolean bl2 = false;
        Context context2 = context == null ? new BasicContext() : context;
        this.wifiEnabledFE.loadValue((BObject)BBoolean.make((boolean)bWifiHostSettings.getIsWifiEnabled()), context2);
        String string = bWifiHostSettings.getCurrentNetworkSsid();
        BWifiNetworkVector bWifiNetworkVector = bWifiHostSettings.getNetworkDatabase();
        if (context2.getFacet("update") == null) {
            this.databaseNetworkTableModel.clear();
            bl2 = false;
        } else {
            bl2 = true;
        }
        if (bWifiNetworkVector != null) {
            if (bl2) {
                for (n = 0; n < this.databaseNetworkTableModel.getRowCount(); ++n) {
                    object = (BWifiNetwork)bWifiNetworkVector.get(SlotPath.escape((String)this.databaseNetworkTableModel.getNetworkAt(n).getSsid()));
                    if (object == null) {
                        this.databaseNetworkTableModel.removeNetwork(n);
                        continue;
                    }
                    if (string.equals(object.getSsid())) {
                        this.currentNetwork = object;
                    }
                    this.databaseNetworkTableModel.setStatusAt(n, object.getNetworkState());
                    this.databaseNetworkTableModel.setStrengthAt(n, object.getSignalStrength());
                }
            } else {
                SlotCursor slotCursor = bWifiNetworkVector.loadSlots().getProperties();
                while (slotCursor.next(class$com$tridium$platwifi$BWifiNetwork == null ? BWifiNetworksManager.class$("com.tridium.platwifi.BWifiNetwork") : class$com$tridium$platwifi$BWifiNetwork)) {
                    object = (BWifiNetwork)slotCursor.get();
                    if (string.equals(object.getSsid())) {
                        this.currentNetwork = object;
                    }
                    this.databaseNetworkTableModel.addCurrentNetwork(object, BWifiNetworksManager.NORMAL_NETWORK_ICON);
                }
            }
        }
        this.daemonStateLabel.setText(bWifiHostSettings.getDaemonState().getDisplayTag(context2));
        this.currentAdapterLabel.setText(bWifiHostSettings.getAdapterName());
        if (bWifiHostSettings.getDaemonState() == BWifiDaemonStateEnum.completed) {
            if (this.currentNetwork != null) {
                this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connected);
            }
        } else if (bWifiHostSettings.getDaemonState() == BWifiDaemonStateEnum.associating || bWifiHostSettings.getDaemonState() == BWifiDaemonStateEnum.associated || bWifiHostSettings.getDaemonState() == BWifiDaemonStateEnum.fourwayhandshake || bWifiHostSettings.getDaemonState() == BWifiDaemonStateEnum.grouphandshake || bWifiHostSettings.getDaemonState() == BWifiDaemonStateEnum.scanning) {
            if (this.currentNetwork != null) {
                this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
            }
        } else if (this.currentNetwork != null) {
            if (this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
            }
            this.currentNetwork = null;
        }
        if (this.databaseNetworkTableModel != null) {
            if (bl2) {
                n = this.databaseNetworkTableModel.getSelection().getRow();
                if (n != -1) {
                    object = null;
                    try {
                        object = this.databaseNetworkTableModel.getSSIDAt(this.databaseNetworkTableModel.getSelection().getAnchor());
                        this.databaseNetworkTableModel.updateValues(true);
                        for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                            if (!this.databaseNetworkTableModel.getSSIDAt(i).equalsIgnoreCase((String)object)) continue;
                            this.databaseNetworkTableModel.getSelection().select(i);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                } else {
                    this.databaseNetworkTableModel.updateValues(true);
                }
            } else {
                this.databaseNetworkTableModel.updateValues(true);
            }
        }
        this.unlockModifiedState();
        if (!bl) {
            this.clearModified();
        }
        this.doSetEnabledStates();
    }

    protected final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        if (!this.isModified()) {
            return bObject;
        }
        if (bObject == null) {
            return bObject;
        }
        BWifiHostSettings bWifiHostSettings = (BWifiHostSettings)bObject;
        bWifiHostSettings.setIsWifiEnabled(((BBoolean)this.wifiEnabledFE.saveValue(context)).getBoolean());
        Array array = new Array(class$com$tridium$platwifi$BWifiNetwork == null ? (class$com$tridium$platwifi$BWifiNetwork = BWifiNetworksManager.class$("com.tridium.platwifi.BWifiNetwork")) : class$com$tridium$platwifi$BWifiNetwork);
        for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
            array.add((Object)this.databaseNetworkTableModel.getNetworkAt(i));
        }
        bWifiHostSettings.getNetworkDatabase().sync((BWifiNetwork[])array.trim());
        return bObject;
    }

    public void doSetReadonly(boolean bl) {
        if (this.wifiEnabledFE != null) {
            this.wifiEnabledFE.setReadonly(true);
            this.wifiEnabledFE.setEnabled(false);
        }
        this.doSetEnabledStates();
    }

    public final void doSetEnabledStates() {
        try {
            boolean bl;
            boolean bl2 = ((BBoolean)this.wifiEnabledFE.saveValue()).getBoolean();
            boolean bl3 = this.isReadonly();
            boolean bl4 = bl = bl2 && !bl3;
            if (this.titledDatabaseTable != null) {
                this.titledDatabaseTable.setEnabled(bl);
            }
            if (this.titledDiscoveryTable != null) {
                this.titledDiscoveryTable.setEnabled(bl);
            }
            if (this.discoveredNetworkTable != null) {
                this.discoveredNetworkTable.setEnabled(bl);
            }
            if (this.databaseNetworkTable != null) {
                this.databaseNetworkTable.setEnabled(bl);
            }
            if (!this.isOperationTakingPlace()) {
                if (this.discoverButtons != null) {
                    this.discoverButtons.setEnabled(bl);
                }
                if (this.databaseButtons != null) {
                    this.databaseButtons.setEnabled(bl);
                }
                if (this.discoverNetworksCommand != null) {
                    this.discoverNetworksCommand.setEnabled(bl);
                }
                if (this.roamNetworkCommand != null) {
                    this.roamNetworkCommand.setEnabled(bl);
                }
                if (this.newNetworkCommand != null) {
                    this.newNetworkCommand.setEnabled(bl);
                }
            }
            if (!bl) {
                if (this.addNetworkCommand != null) {
                    this.addNetworkCommand.setEnabled(bl);
                }
                if (this.connectNetworkCommand != null) {
                    this.connectNetworkCommand.setEnabled(bl);
                }
                if (this.editNetworkCommand != null) {
                    this.editNetworkCommand.setEnabled(bl);
                }
                if (this.disconnectNetworkCommand != null) {
                    this.disconnectNetworkCommand.setEnabled(bl);
                }
                if (this.removeNetworkCommand != null) {
                    this.removeNetworkCommand.setEnabled(bl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void handleComponentEvent(BComponentEvent bComponentEvent) {
        this.lockModifiedState();
        boolean bl = this.isModified();
        if (bComponentEvent.getSourceComponent() instanceof BWifiHostSettings) {
            BWifiHostSettings bWifiHostSettings = (BWifiHostSettings)bComponentEvent.getSourceComponent();
            Property property = bComponentEvent.getSlot().asProperty();
            BValue bValue = bWifiHostSettings.get(property);
            if (property == BWifiHostSettings.isWifiEnabled) {
                if (this.wifiEnabledFE != null) {
                    this.wifiEnabledFE.loadValue((BObject)((BBoolean)bValue));
                }
                this.doSetEnabledStates();
            } else if (property == BWifiHostSettings.adapterName) {
                if (this.currentAdapterLabel != null) {
                    this.currentAdapterLabel.setText(bValue.toString());
                }
            } else if (property == BWifiHostSettings.daemonState) {
                BWifiDaemonStateEnum bWifiDaemonStateEnum = (BWifiDaemonStateEnum)bValue;
                if (this.daemonStateLabel != null) {
                    this.daemonStateLabel.setText(bWifiDaemonStateEnum.getDisplayTag(null));
                }
                if (this.currentNetwork == null) {
                    if (this.databaseNetworkTableModel != null) {
                        int n;
                        for (n = 0; n < this.databaseNetworkTableModel.getRowCount(); ++n) {
                            if (this.databaseNetworkTableModel.getStatusAt(n) == BWifiNetworkStateEnum.disabled) continue;
                            this.databaseNetworkTableModel.setStatusAt(n, BWifiNetworkStateEnum.disconnected);
                        }
                        n = this.databaseNetworkTableModel.getSelection().getRow();
                        if (n != -1) {
                            String string = null;
                            try {
                                string = this.databaseNetworkTableModel.getSSIDAt(this.databaseNetworkTableModel.getSelection().getAnchor());
                                this.databaseNetworkTableModel.updateValues(true);
                                for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                                    if (!this.databaseNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(string)) continue;
                                    this.databaseNetworkTableModel.getSelection().select(i);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        } else {
                            this.databaseNetworkTableModel.updateValues(true);
                        }
                    }
                    return;
                }
                if (bWifiDaemonStateEnum == BWifiDaemonStateEnum.completed) {
                    if (this.currentNetwork != null) {
                        this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connected);
                    }
                } else if (bWifiDaemonStateEnum == BWifiDaemonStateEnum.associated || bWifiDaemonStateEnum == BWifiDaemonStateEnum.fourwayhandshake || bWifiDaemonStateEnum == BWifiDaemonStateEnum.grouphandshake || bWifiDaemonStateEnum == BWifiDaemonStateEnum.associating || bWifiDaemonStateEnum == BWifiDaemonStateEnum.scanning) {
                    if (this.currentNetwork != null) {
                        this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                    }
                } else if (this.currentNetwork != null) {
                    if (this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                        this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                    }
                    this.currentNetwork = null;
                }
            } else if (property == BWifiHostSettings.currentNetworkSsid) {
                String string = bValue.toString();
                if (string.equalsIgnoreCase("")) {
                    if (this.currentNetwork != null) {
                        if (this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                            this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                        }
                        this.currentNetwork = null;
                    } else if (this.databaseNetworkTableModel != null) {
                        int n;
                        for (n = 0; n < this.databaseNetworkTableModel.getRowCount(); ++n) {
                            if (this.databaseNetworkTableModel.getStatusAt(n) == BWifiNetworkStateEnum.disabled) continue;
                            this.databaseNetworkTableModel.setStatusAt(n, BWifiNetworkStateEnum.disconnected);
                        }
                        n = this.databaseNetworkTableModel.getSelection().getRow();
                        if (n != -1) {
                            String string2 = null;
                            try {
                                string2 = this.databaseNetworkTableModel.getSSIDAt(this.databaseNetworkTableModel.getSelection().getAnchor());
                                this.databaseNetworkTableModel.updateValues(true);
                                for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                                    if (!this.databaseNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(string2)) continue;
                                    this.databaseNetworkTableModel.getSelection().select(i);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        } else {
                            this.databaseNetworkTableModel.updateValues(true);
                        }
                    }
                } else {
                    if (this.currentNetwork != null) {
                        if (this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                            this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                        }
                        this.currentNetwork = null;
                    }
                    if (this.databaseNetworkTableModel != null) {
                        for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                            if (!this.databaseNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(string)) continue;
                            this.currentNetwork = this.databaseNetworkTableModel.getNetworkAt(i);
                            break;
                        }
                    }
                    if (this.currentNetwork == null) {
                        return;
                    }
                    String string3 = this.daemonStateLabel.getText();
                    if (string3.equalsIgnoreCase("Completed")) {
                        if (this.currentNetwork != null) {
                            this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connected);
                        }
                    } else if (string3.equalsIgnoreCase("Associating") || string3.equalsIgnoreCase("Associated") || string3.equalsIgnoreCase("4-Way Handshake") || string3.equalsIgnoreCase("Group Handshake") || string3.equalsIgnoreCase("Scanning")) {
                        if (this.currentNetwork != null) {
                            this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                        }
                    } else if (this.currentNetwork != null) {
                        if (this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                            this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                        }
                        this.currentNetwork = null;
                    }
                }
            }
        } else if (!(bComponentEvent.getSourceComponent() instanceof BWifiNetworkVector)) {
            if (bComponentEvent.getSourceComponent() instanceof BWifiNetwork) {
                BWifiNetwork bWifiNetwork = (BWifiNetwork)bComponentEvent.getSourceComponent();
                Property property = bComponentEvent.getSlot().asProperty();
                BValue bValue = bWifiNetwork.get(property);
                int n = -1;
                if (this.databaseNetworkTableModel != null) {
                    int n2;
                    for (n2 = 0; n2 < this.databaseNetworkTableModel.getRowCount(); ++n2) {
                        if (!this.databaseNetworkTableModel.getSSIDAt(n2).equalsIgnoreCase(bWifiNetwork.getSsid())) continue;
                        n = n2;
                        break;
                    }
                    if (n != -1) {
                        if (property == BWifiNetwork.networkState) {
                            this.databaseNetworkTableModel.setStatusAt(n, (BWifiNetworkStateEnum)bValue);
                        } else if (property == BWifiNetwork.signalStrength) {
                            this.databaseNetworkTableModel.setStrengthAt(n, ((BInteger)bValue).getInt());
                        } else if (property == BWifiNetwork.priority) {
                            this.databaseNetworkTableModel.setPriorityAt(n, ((BInteger)bValue).getInt());
                        }
                        n2 = this.databaseNetworkTableModel.getSelection().getRow();
                        if (n2 != -1) {
                            String string = null;
                            try {
                                string = this.databaseNetworkTableModel.getSSIDAt(this.databaseNetworkTableModel.getSelection().getAnchor());
                                this.databaseNetworkTableModel.updateValues(true);
                                for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                                    if (!this.databaseNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(string)) continue;
                                    this.databaseNetworkTableModel.getSelection().select(i);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        } else {
                            this.databaseNetworkTableModel.updateValues(true);
                        }
                    }
                }
            } else {
                super.handleComponentEvent(bComponentEvent);
            }
        }
        this.unlockModifiedState();
        if (!bl) {
            this.clearModified();
        }
    }

    public void doHandleDatabaseSelectionModified() {
        int[] nArray = this.databaseNetworkTable.getSelection().getRows();
        if (nArray.length == 0) {
            this.connectNetworkCommand.setEnabled(false);
            this.disconnectNetworkCommand.setEnabled(false);
            this.editNetworkCommand.setEnabled(false);
            this.removeNetworkCommand.setEnabled(false);
            return;
        }
        if (nArray.length > 1) {
            this.connectNetworkCommand.setEnabled(false);
            this.disconnectNetworkCommand.setEnabled(false);
            this.editNetworkCommand.setEnabled(false);
            this.removeNetworkCommand.setEnabled(false);
        } else {
            boolean bl = this.isReadonly();
            if (!this.isOperationTakingPlace()) {
                BWifiNetwork bWifiNetwork = this.databaseNetworkTableModel.getNetworkAt(this.databaseNetworkTableModel.getSelection().getAnchor());
                if (bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.disconnected || bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.disconnecting || bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.disabled) {
                    this.disconnectNetworkCommand.setEnabled(false);
                    this.connectNetworkCommand.setEnabled(!bl);
                }
                if (bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.connected || bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.connecting) {
                    this.connectNetworkCommand.setEnabled(false);
                    this.disconnectNetworkCommand.setEnabled(!bl);
                }
                this.editNetworkCommand.setEnabled(!bl);
                this.removeNetworkCommand.setEnabled(!bl);
            }
        }
    }

    public void doHandleDatabaseTableModified() {
    }

    public void doHandleDatabaseFocusModified(BFocusEvent bFocusEvent) {
    }

    public void doHandleDiscoveredSelectionModified() {
        int[] nArray = this.discoveredNetworkTable.getSelection().getRows();
        if (nArray.length == 0) {
            this.addNetworkCommand.setEnabled(false);
            return;
        }
        if (nArray.length > 1) {
            this.addNetworkCommand.setEnabled(false);
        } else {
            BImage bImage = this.discoveredNetworkTableModel.getNetworkIconImageAt(this.discoveredNetworkTableModel.getSelection().getAnchor());
            boolean bl = this.isReadonly();
            if (!this.isOperationTakingPlace()) {
                this.addNetworkCommand.setEnabled(!bl && bImage.equals((Object)NORMAL_NETWORK_ICON));
            }
        }
    }

    public void doHandleDiscoveredTableModified() {
    }

    public void doHandleDiscoveredFocusModified(BFocusEvent bFocusEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOperationTakingPlace() {
        boolean bl = false;
        Object object = this.operationMonitor;
        synchronized (object) {
            bl = this.operationTakingPlace;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOperationTakingPlace(boolean bl) {
        Object object = this.operationMonitor;
        synchronized (object) {
            this.operationTakingPlace = bl;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class WifiNetworkCellRenderer
    extends TableCellRenderer {
        public WifiNetworkTableModel getWifiNetworkTableModel() {
            return (WifiNetworkTableModel)this.getTable().getModel();
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            return super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return super.getSelectionForeground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String string = this.getCellText(cell);
            BImage bImage = this.getWifiNetworkTableModel().getCellIcon(cell.row, cell.column);
            double d = 5.0;
            double d2 = 0.0;
            if (string != null && string.length() > 0) {
                d = Theme.table().getCellFont().width(string) + 12.0;
            }
            if (bImage != null) {
                d2 = bImage.getWidth() + 4.0;
            }
            return d2 + d;
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            String string;
            WifiNetworkTableModel wifiNetworkTableModel = this.getWifiNetworkTableModel();
            this.paintCellBackground(graphics, cell);
            double d = 2.0;
            double d2 = (cell.height - 16.0) / 2.0;
            BImage bImage = wifiNetworkTableModel.getCellIcon(cell.row, cell.column);
            if (bImage != null) {
                graphics.drawImage(bImage, d, d2);
                d += 20.0;
            }
            if ((string = this.getCellText(cell)) != null && string.length() > 0) {
                BFont bFont = Theme.table().getCellFont();
                switch (wifiNetworkTableModel.getColumnAlignment(cell.column).getOrdinal()) {
                    case 2: {
                        d = cell.width - 2.0 - bFont.width(string);
                        break;
                    }
                    case 1: {
                        d = (cell.width - bFont.width(string)) / 2.0;
                    }
                }
                graphics.setFont(bFont);
                graphics.drawString(string, d, bFont.getAscent() + 2.0);
            }
        }
    }

    public class WifiNetworkTableRow {
        private BWifiNetwork currentNetwork;
        private BImage rowNetworkIcon;

        public void setCurrentWifiNetwork(BWifiNetwork bWifiNetwork) {
            this.currentNetwork = bWifiNetwork;
        }

        public BWifiNetwork getCurrentWifiNetwork() {
            return this.currentNetwork;
        }

        public String getSSID() {
            return this.currentNetwork.getSsid();
        }

        public String getBSSID() {
            return this.currentNetwork.getBssid();
        }

        public BWifiNetworkMode getMode() {
            return this.currentNetwork.getMode();
        }

        public BInteger getChannel() {
            return BInteger.make((int)this.currentNetwork.getChannel());
        }

        public BVector getSecuritySupported() {
            return this.currentNetwork.getSecuritySupported();
        }

        public String getComment() {
            return "              ";
        }

        public BWifiNetworkStateEnum getNetworkState() {
            return this.currentNetwork.getNetworkState();
        }

        public BInteger getSignalStrengthPercentage() {
            return BInteger.make((int)this.currentNetwork.getSignalStrength());
        }

        public BInteger getPriority() {
            return BInteger.make((int)this.currentNetwork.getPriority());
        }

        public void setStatus(BWifiNetworkStateEnum bWifiNetworkStateEnum) {
            this.currentNetwork.setNetworkState(bWifiNetworkStateEnum);
        }

        public void setStrength(int n) {
            this.currentNetwork.setSignalStrength(n);
        }

        public void setPriority(int n) {
            this.currentNetwork.setPriority(n);
        }

        public BImage getSingalStrengthImage() {
            int n = this.getSignalStrengthPercentage().getInt();
            if (n >= 80) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/fiveBars.png")}));
            }
            if (n >= 60) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/fourBars.png")}));
            }
            if (n >= 40) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/threeBars.png")}));
            }
            if (n >= 20) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/twoBars.png")}));
            }
            if (n > 0) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/oneBar.png")}));
            }
            return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/zeroBars.png")}));
        }

        public void setNetworkIcon(BImage bImage) {
            this.rowNetworkIcon = bImage;
        }

        public BImage getNetworkIcon() {
            return this.rowNetworkIcon;
        }

        public int compareSecurity(WifiNetworkTableRow wifiNetworkTableRow) {
            BVector bVector = this.getSecuritySupported();
            BVector bVector2 = wifiNetworkTableRow.getSecuritySupported();
            int n = 0;
            int n2 = 0;
            SlotCursor slotCursor = bVector.loadSlots().getProperties();
            while (slotCursor.next(class$com$tridium$platwifi$security$BWifiSecurityPolicy == null ? BWifiNetworksManager.class$("com.tridium.platwifi.security.BWifiSecurityPolicy") : class$com$tridium$platwifi$security$BWifiSecurityPolicy)) {
                if (((BWifiSecurityPolicy)slotCursor.get()).getOrdinal() <= n) continue;
                n = ((BWifiSecurityPolicy)slotCursor.get()).getOrdinal();
            }
            slotCursor = bVector2.loadSlots().getProperties();
            while (slotCursor.next(class$com$tridium$platwifi$security$BWifiSecurityPolicy == null ? BWifiNetworksManager.class$("com.tridium.platwifi.security.BWifiSecurityPolicy") : class$com$tridium$platwifi$security$BWifiSecurityPolicy)) {
                if (((BWifiSecurityPolicy)slotCursor.get()).getOrdinal() <= n2) continue;
                n2 = ((BWifiSecurityPolicy)slotCursor.get()).getOrdinal();
            }
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }
    }

    private class DatabaseTableController
    extends TableController {
        private DatabaseTableController() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.isPopupTrigger()) {
                super.cellPressed(bMouseEvent, n, n2);
                return;
            }
            if (n2 != 0 || bMouseEvent.getX() > 14.0) {
                if (bMouseEvent.getClickCount() > 1) {
                    if (!BWifiNetworksManager.this.isOperationTakingPlace()) {
                        BWifiNetworksManager.this.editNetworkCommand.invoke();
                    }
                } else {
                    super.cellPressed(bMouseEvent, n, n2);
                }
                return;
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            if (!BWifiNetworksManager.this.isOperationTakingPlace()) {
                BMenu bMenu = new BMenu();
                bMenu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.editNetworkCommand), null);
                bMenu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.removeNetworkCommand), null);
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.connectNetworkCommand), null);
                bMenu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.disconnectNetworkCommand), null);
                bMenu.open((BWidget)BWifiNetworksManager.this.databaseNetworkTable, bMouseEvent.getX(), bMouseEvent.getY());
            }
        }
    }

    private class DiscoveryTableController
    extends TableController {
        private DiscoveryTableController() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (bMouseEvent.isPopupTrigger()) {
                super.cellPressed(bMouseEvent, n, n2);
                return;
            }
            if (n2 != 0 || bMouseEvent.getX() > 14.0) {
                if (bMouseEvent.getClickCount() > 1) {
                    BWifiNetworksManager.this.addNetworkCommand.invoke();
                } else {
                    super.cellPressed(bMouseEvent, n, n2);
                }
                return;
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.addNetworkCommand), null);
            bMenu.open((BWidget)BWifiNetworksManager.this.discoveredNetworkTable, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    public class WifiNetworkTableModel
    extends TableModel {
        private static final int SSID_COL = 0;
        private static final int BSSID_COL = 1;
        private static final int MODE_COL = 2;
        private static final int PRIORITY_COL = 3;
        private static final int CHANNEL_COL = 4;
        private static final int SECURTIY_POLICY_COL = 5;
        private static final int STATUS_COL = 6;
        private static final int SIGNAL_STRENGTH_PER_COL = 7;
        private int sortColumn = 7;
        private boolean sortAscending = true;
        private boolean needsSort = true;
        protected Array viewableColumns;
        protected Array rows = new Array(class$com$tridium$platwifi$ui$BWifiNetworksManager$WifiNetworkTableRow == null ? (class$com$tridium$platwifi$ui$BWifiNetworksManager$WifiNetworkTableRow = BWifiNetworksManager.class$("com.tridium.platwifi.ui.BWifiNetworksManager$WifiNetworkTableRow")) : class$com$tridium$platwifi$ui$BWifiNetworksManager$WifiNetworkTableRow);

        public WifiNetworkTableModel(boolean bl, boolean bl2) {
            this.viewableColumns = new Array(class$javax$baja$sys$BInteger == null ? (class$javax$baja$sys$BInteger = BWifiNetworksManager.class$("javax.baja.sys.BInteger")) : class$javax$baja$sys$BInteger);
            this.viewableColumns.add((Object)BInteger.make((int)0));
            this.viewableColumns.add((Object)BInteger.make((int)1));
            this.viewableColumns.add((Object)BInteger.make((int)2));
            if (bl2) {
                this.viewableColumns.add((Object)BInteger.make((int)3));
            }
            this.viewableColumns.add((Object)BInteger.make((int)4));
            this.viewableColumns.add((Object)BInteger.make((int)5));
            if (bl) {
                this.viewableColumns.add((Object)BInteger.make((int)6));
            }
            this.viewableColumns.add((Object)BInteger.make((int)7));
        }

        public int getColumnCount() {
            return this.viewableColumns.size();
        }

        public String getColumnName(int n) {
            int n2 = ((BInteger)this.viewableColumns.get(n)).getInt();
            switch (n2) {
                case 0: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.SSID.label");
                }
                case 1: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.BSSID.label");
                }
                case 2: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.mode.label");
                }
                case 3: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.priority.label");
                }
                case 4: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.channel.label");
                }
                case 5: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.security.label");
                }
                case 6: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.status.label");
                }
                case 7: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.signalPercent.label");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int n, int n2) {
            int n3 = ((BInteger)this.viewableColumns.get(n2)).getInt();
            switch (n3) {
                case 0: {
                    return this.getRow(n).getSSID();
                }
                case 1: {
                    return this.getRow(n).getBSSID();
                }
                case 2: {
                    return this.getRow(n).getMode().getDisplayTag(null);
                }
                case 3: {
                    return this.getRow(n).getPriority();
                }
                case 4: {
                    return this.getRow(n).getChannel();
                }
                case 5: {
                    BVector bVector = this.getRow(n).getSecuritySupported();
                    StringBuffer stringBuffer = new StringBuffer();
                    SlotCursor slotCursor = bVector.loadSlots().getProperties();
                    while (slotCursor.next(class$com$tridium$platwifi$security$BWifiSecurityPolicy == null ? BWifiNetworksManager.class$("com.tridium.platwifi.security.BWifiSecurityPolicy") : class$com$tridium$platwifi$security$BWifiSecurityPolicy)) {
                        stringBuffer.append(((BWifiSecurityPolicy)slotCursor.get()).getDisplayTag(null) + " ");
                    }
                    return stringBuffer.toString();
                }
                case 6: {
                    return this.getRow(n).getNetworkState();
                }
                case 7: {
                    return this.getRow(n).getSignalStrengthPercentage();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void clear() {
            this.rows.clear();
            this.updateValues(false);
        }

        private void addCurrentNetwork(BWifiNetwork bWifiNetwork, BImage bImage) {
            if (bWifiNetwork == null || bWifiNetwork.isNull()) {
                return;
            }
            WifiNetworkTableRow wifiNetworkTableRow = this.makeRow();
            wifiNetworkTableRow.setCurrentWifiNetwork(bWifiNetwork);
            wifiNetworkTableRow.setNetworkIcon(bImage);
            this.rows.add((Object)wifiNetworkTableRow);
        }

        private void removeNetwork(int n) {
            if (n == -1 || n >= this.getRowCount()) {
                return;
            }
            this.rows.remove(n);
        }

        protected WifiNetworkTableRow makeRow() {
            return new WifiNetworkTableRow();
        }

        protected WifiNetworkTableRow getRow(int n) {
            return (WifiNetworkTableRow)this.rows.get(n);
        }

        public BWifiNetwork getNetworkAt(int n) {
            return this.getRow(n).getCurrentWifiNetwork();
        }

        public String getSSIDAt(int n) {
            return this.getRow(n).getSSID();
        }

        public String getBSSIDAt(int n) {
            return this.getRow(n).getBSSID();
        }

        public BWifiNetworkMode getModeAt(int n) {
            return this.getRow(n).getMode();
        }

        public BInteger getChannelAt(int n) {
            return this.getRow(n).getChannel();
        }

        public BVector getSecuritySupported(int n) {
            return this.getRow(n).getSecuritySupported();
        }

        public String getCommentAt(int n) {
            return this.getRow(n).getComment();
        }

        public BWifiNetworkStateEnum getStatusAt(int n) {
            return this.getRow(n).getNetworkState();
        }

        public BInteger getSignalStrengthPercentageAt(int n) {
            return this.getRow(n).getSignalStrengthPercentage();
        }

        public BImage getSingalStrengthImageAt(int n) {
            return this.getRow(n).getSingalStrengthImage();
        }

        public BImage getNetworkIconImageAt(int n) {
            return this.getRow(n).getNetworkIcon();
        }

        public void setNetworkIconImageAt(int n, BImage bImage) {
            this.getRow(n).setNetworkIcon(bImage);
        }

        public void setStatusAt(int n, BWifiNetworkStateEnum bWifiNetworkStateEnum) {
            this.getRow(n).setStatus(bWifiNetworkStateEnum);
        }

        public void setStrengthAt(int n, int n2) {
            this.getRow(n).setStrength(n2);
        }

        public void setPriorityAt(int n, int n2) {
            this.getRow(n).setPriority(n2);
        }

        public BImage getCellIcon(int n, int n2) {
            int n3 = ((BInteger)this.viewableColumns.get(n2)).getInt();
            WifiNetworkTableRow wifiNetworkTableRow = this.getRow(n);
            if (n3 == 0) {
                return wifiNetworkTableRow.getNetworkIcon();
            }
            if (n3 == 7) {
                return wifiNetworkTableRow.getSingalStrengthImage();
            }
            return null;
        }

        public void updateTable(boolean bl) {
            this.needsSort = true;
            super.updateTable(bl);
        }

        protected void updateValues(boolean bl) {
            this.needsSort = false;
            if (bl) {
                this.rows = this.rows.sort((Comparator)new WifiNetworkTableRowComparator());
            }
            this.getTable().getSelection().deselectAll();
            this.updateTable(true);
        }

        public void sortByColumn(int n, boolean bl) {
            int n2 = ((BInteger)this.viewableColumns.get(n)).getInt();
            if (!this.needsSort && n2 == this.sortColumn && bl == this.sortAscending) {
                return;
            }
            this.sortColumn = n2;
            this.sortAscending = bl;
            this.updateValues(true);
        }

        private class WifiNetworkTableRowComparator
        implements Comparator {
            private Comparator[] comparators;

            public WifiNetworkTableRowComparator() {
                int n;
                int n2;
                int[] nArray = new int[8];
                nArray[0] = WifiNetworkTableModel.this.sortColumn;
                if (WifiNetworkTableModel.this.sortColumn != 7) {
                    nArray[1] = 7;
                    n2 = 2;
                    for (n = 0; n < nArray.length; ++n) {
                        if (n == WifiNetworkTableModel.this.sortColumn || n == 7) continue;
                        nArray[n2++] = n;
                    }
                } else {
                    n2 = 1;
                    for (n = 0; n < nArray.length; ++n) {
                        if (n == WifiNetworkTableModel.this.sortColumn) continue;
                        nArray[n2++] = n;
                    }
                }
                this.comparators = new Comparator[8];
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2] = new WifiNetworkColumnComparator(nArray[n2], WifiNetworkTableModel.this.sortAscending);
                }
            }

            public int compare(Object object, Object object2) {
                int n = 0;
                for (int i = 0; i < this.comparators.length && n == 0; ++i) {
                    n = this.comparators[i].compare(object, object2);
                }
                return n;
            }
        }

        private class WifiNetworkColumnComparator
        implements Comparator {
            private int comparatorSortColumn;
            private boolean comparatorAscending;

            public WifiNetworkColumnComparator(int n, boolean bl) {
                this.comparatorSortColumn = n;
                this.comparatorAscending = bl;
            }

            public int compare(Object object, Object object2) {
                WifiNetworkTableRow wifiNetworkTableRow = (WifiNetworkTableRow)object;
                WifiNetworkTableRow wifiNetworkTableRow2 = (WifiNetworkTableRow)object2;
                int n = this.comparatorAscending ? 1 : -1;
                switch (this.comparatorSortColumn) {
                    case 0: {
                        return n * TextUtil.toLowerCase((String)wifiNetworkTableRow.getSSID()).compareTo(TextUtil.toLowerCase((String)wifiNetworkTableRow2.getSSID()));
                    }
                    case 1: {
                        return n * TextUtil.toLowerCase((String)wifiNetworkTableRow.getBSSID()).compareTo(TextUtil.toLowerCase((String)wifiNetworkTableRow2.getBSSID()));
                    }
                    case 2: {
                        if (wifiNetworkTableRow.getMode().getOrdinal() < wifiNetworkTableRow2.getMode().getOrdinal()) {
                            return n * -1;
                        }
                        if (wifiNetworkTableRow.getMode().getOrdinal() > wifiNetworkTableRow2.getMode().getOrdinal()) {
                            return n;
                        }
                        return 0;
                    }
                    case 3: {
                        if (wifiNetworkTableRow.getPriority() == null) {
                            if (wifiNetworkTableRow2.getPriority() == null) {
                                return 0;
                            }
                            return n;
                        }
                        if (wifiNetworkTableRow2.getPriority() == null) {
                            return n * -1;
                        }
                        return n * wifiNetworkTableRow.getPriority().compareTo((Object)wifiNetworkTableRow2.getPriority());
                    }
                    case 4: {
                        if (wifiNetworkTableRow.getChannel() == null) {
                            if (wifiNetworkTableRow2.getChannel() == null) {
                                return 0;
                            }
                            return n;
                        }
                        if (wifiNetworkTableRow2.getChannel() == null) {
                            return n * -1;
                        }
                        return n * wifiNetworkTableRow.getChannel().compareTo((Object)wifiNetworkTableRow2.getChannel());
                    }
                    case 5: {
                        return n * wifiNetworkTableRow.compareSecurity(wifiNetworkTableRow2);
                    }
                    case 6: {
                        return 0;
                    }
                    case 7: {
                        n = -n;
                        if (wifiNetworkTableRow.getSignalStrengthPercentage() == null) {
                            if (wifiNetworkTableRow2.getSignalStrengthPercentage() == null) {
                                return 0;
                            }
                            return n;
                        }
                        if (wifiNetworkTableRow2.getSignalStrengthPercentage() == null) {
                            return n * -1;
                        }
                        return n * wifiNetworkTableRow.getSignalStrengthPercentage().compareTo((Object)wifiNetworkTableRow2.getSignalStrengthPercentage());
                    }
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private class NewCommand
    extends AsyncCommand {
        public NewCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.new.label", "New"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/new.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.new.description", "Create a new 802.11 wireless network connection"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                BWifiNetwork bWifiNetwork = null;
                try {
                    bWifiNetwork = this.promptNew();
                    if (bWifiNetwork == null) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                boolean bl = false;
                BDaemonSession bDaemonSession = null;
                BWifiHostSettings bWifiHostSettings = null;
                BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                    if (bWifiNetworksManager instanceof BWifiConfiguration) {
                        bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                        bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                        bl = false;
                        break;
                    }
                    if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                    bl = true;
                    break;
                }
                if (bWifiNetworksManager == null) {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                if (bl) {
                    BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                    if (bWifiPlatformService != null && !bWifiPlatformService.addNetwork(new BWifiCommandArgs(bWifiPlatformService.getSettings().getAdapterName(), bWifiNetwork)).getBoolean()) {
                        throw new BajaRuntimeException("Failed to add new WiFi Network (" + bWifiNetwork.getSsid() + ")");
                    }
                } else if (bWifiHostSettings != null) {
                    if (!WifiUtil.addRemoveFromSession(bWifiHostSettings.getAdapterName(), bWifiNetwork, bDaemonSession, true)) {
                        throw new BajaRuntimeException("Failed to add new WiFi Network (" + bWifiNetwork.getSsid() + ")");
                    }
                    bWifiHostSettings.getNetworkDatabase().add(SlotPath.escape((String)bWifiNetwork.getSsid()), (BValue)bWifiNetwork, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
                }
                BWifiNetworksManager.this.databaseNetworkTableModel.addCurrentNetwork(bWifiNetwork, NORMAL_NETWORK_ICON);
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(bWifiNetwork.getSsid())) continue;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, UNAVAILABLE_NETWORK_ICON);
                    break;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }

        public BWifiNetwork promptNew() throws Exception {
            String string = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.new.title", "New Wireless Network");
            BWifiNetwork bWifiNetwork = new BWifiNetwork();
            bWifiNetwork.setSsid("Enter SSID Here");
            bWifiNetwork.setBssid("00:00:00:00:00:00");
            bWifiNetwork.setChannel(6);
            bWifiNetwork.setPriority(0);
            bWifiNetwork.setSsidBroadcasted(false);
            bWifiNetwork.setMode(BWifiNetworkMode.managed);
            BVector bVector = bWifiNetwork.getSecuritySupported();
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wep.toString()), (BValue)BWifiSecurityPolicy.wep, 1);
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.toString()), (BValue)BWifiSecurityPolicy.wpa_psk, 1);
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.toString()), (BValue)BWifiSecurityPolicy.wpa2_psk, 1);
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa.toString()), (BValue)BWifiSecurityPolicy.wpa, 1);
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.toString()), (BValue)BWifiSecurityPolicy.wpa2, 1);
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.none.toString()), (BValue)BWifiSecurityPolicy.none, 1);
            BVector bVector2 = bWifiNetwork.getSecurityConfigurations();
            bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wep.toString()), (BValue)new BWifiWEPSettings(), 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWEPEditor")));
            bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.toString()), (BValue)new BWifiWPAPSKSettings(), 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAPSKEditor")));
            bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.toString()), (BValue)new BWifiWPA2PSKSettings(), 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2PSKEditor")));
            bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa.toString()), (BValue)new BWifiWPASettings(), 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAEditor")));
            bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.toString()), (BValue)new BWifiWPA2Settings(), 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2Editor")));
            BWifiNetworkEditorDialog bWifiNetworkEditorDialog = new BWifiNetworkEditorDialog(this.getOwner(), string, 1, bWifiNetwork);
            bWifiNetworkEditorDialog.setSize(500.0, 800.0);
            bWifiNetworkEditorDialog.setBoundsCenteredOnOwner();
            bWifiNetworkEditorDialog.open();
            if (bWifiNetworkEditorDialog.getResult() == 1) {
                try {
                    return bWifiNetworkEditorDialog.getNetwork();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)this.getOwner(), (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText(exception.getMessage()));
                    return null;
                }
            }
            return null;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.edit.label", "Edit"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/edit.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.edit.description", "Edit the selected 802.11 wireless network"));
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                return null;
            }
            BWifiNetwork bWifiNetwork = null;
            try {
                bWifiNetwork = this.promptEdit();
                if (bWifiNetwork == null) {
                    return null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            BWifiNetworksManager.this.databaseNetworkTableModel.removeNetwork(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            BWifiNetworksManager.this.databaseNetworkTableModel.addCurrentNetwork(bWifiNetwork, NORMAL_NETWORK_ICON);
            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
            return null;
        }

        public BWifiNetwork promptEdit() throws Exception {
            BWifiNetwork bWifiNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            String string = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.edit.title", "Edit Wireless Network");
            BWifiNetworkEditorDialog bWifiNetworkEditorDialog = new BWifiNetworkEditorDialog(this.getOwner(), string, 0, bWifiNetwork);
            bWifiNetworkEditorDialog.setSize(500.0, 800.0);
            bWifiNetworkEditorDialog.setBoundsCenteredOnOwner();
            bWifiNetworkEditorDialog.open();
            if (bWifiNetworkEditorDialog.getResult() == 1) {
                try {
                    BWifiNetwork bWifiNetwork2 = bWifiNetworkEditorDialog.getNetwork();
                    if (bWifiNetwork2 != null) {
                        bWifiNetwork2.setSignalStrength(bWifiNetwork.getSignalStrength());
                    }
                    if (bWifiNetwork2 != null) {
                        bWifiNetwork2.setNetworkState(bWifiNetwork.getNetworkState());
                    }
                    return bWifiNetwork2;
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)this.getOwner(), (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText(exception.getMessage()));
                    return bWifiNetwork;
                }
            }
            return null;
        }
    }

    private class RemoveCommand
    extends AsyncCommand {
        public RemoveCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.remove.label", "Remove"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/remove.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.remove.description", "Remove a known 802.11 wireless network from the database"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block23: {
                BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
                try {
                    BWifiNetworksManager.this.setOperationTakingPlace(true);
                    BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                    this.setEnabled(false);
                    if (bWbShell != null) {
                        bWbShell.enterBusy();
                    }
                    if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                        return;
                    }
                    if (BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getRowCount() > 1) {
                        return;
                    }
                    BWifiNetwork bWifiNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                    String string = BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.remove.confirmSingle", new Object[]{bWifiNetwork.getSsid()});
                    int n = BDialog.confirm((BWidget)this.getOwner(), (Object)string);
                    if (n == 4) {
                        boolean bl = false;
                        BDaemonSession bDaemonSession = null;
                        BWifiHostSettings bWifiHostSettings = null;
                        BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                        while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                            if (bWifiNetworksManager instanceof BWifiConfiguration) {
                                bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                                bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                                bl = false;
                                break;
                            }
                            if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                            bl = true;
                            break;
                        }
                        if (bWifiNetworksManager == null) {
                            throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                        }
                        if (bl) {
                            BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                            if (bWifiPlatformService != null && !bWifiPlatformService.removeNetwork(new BWifiCommandArgs(bWifiPlatformService.getSettings().getAdapterName(), (BWifiNetwork)bWifiNetwork.newCopy(true))).getBoolean()) {
                                throw new BajaRuntimeException("Failed to remove selected WiFi Network (" + bWifiNetwork.getSsid() + ")");
                            }
                        } else if (bWifiHostSettings != null) {
                            if (!WifiUtil.addRemoveFromSession(bWifiHostSettings.getAdapterName(), (BWifiNetwork)bWifiNetwork.newCopy(true), bDaemonSession, false)) {
                                throw new BajaRuntimeException("Failed to remove selected WiFi Network (" + bWifiNetwork.getSsid() + ")");
                            }
                            bWifiHostSettings.getNetworkDatabase().remove(SlotPath.escape((String)bWifiNetwork.getSsid()));
                            if (bWifiHostSettings.getCurrentNetworkSsid() != null && bWifiHostSettings.getCurrentNetworkSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                                bWifiHostSettings.setCurrentNetworkSsid("");
                            }
                        }
                        BWifiNetworksManager.this.databaseNetworkTableModel.removeNetwork(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                        BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                        if (BWifiNetworksManager.this.currentNetwork != null && bWifiNetwork.getSsid().equals(BWifiNetworksManager.this.currentNetwork.getSsid())) {
                            BWifiNetworksManager.this.currentNetwork = null;
                        }
                        for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                            if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(bWifiNetwork.getSsid())) continue;
                            BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, NORMAL_NETWORK_ICON);
                            break block23;
                        }
                        break block23;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CommandUtil.error((Command)this, (Throwable)throwable);
                }
                finally {
                    this.setEnabled(false);
                    BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                    BWifiNetworksManager.this.setOperationTakingPlace(false);
                    if (bWbShell != null) {
                        bWbShell.exitBusy();
                    }
                }
            }
        }
    }

    private class DisconnectCommand
    extends AsyncCommand {
        public DisconnectCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.disconnect.label", "Disconnect"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/connection.png"), BOrd.make((String)"module://icons/x16/badges/remove.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.disconnect.description", "Disconnect from the selected 802.11 wireless network"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                    return;
                }
                boolean bl = false;
                BDaemonSession bDaemonSession = null;
                BWifiHostSettings bWifiHostSettings = null;
                BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                    if (bWifiNetworksManager instanceof BWifiConfiguration) {
                        bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                        bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                        bl = false;
                        break;
                    }
                    if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                    bl = true;
                    break;
                }
                if (bWifiNetworksManager == null) {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                BWifiNetwork bWifiNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                if (bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.disconnected || bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.disabled) {
                    return;
                }
                bWifiNetwork.setNetworkState(BWifiNetworkStateEnum.disconnecting);
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                    BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnecting);
                }
                if (bl) {
                    BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                    if (bWifiPlatformService != null) {
                        if (!bWifiPlatformService.disconnectFromNetwork(new BWifiCommandArgs(bWifiPlatformService.getSettings().getAdapterName(), (BWifiNetwork)bWifiNetwork.newCopy(true))).getBoolean()) {
                        } else {
                            if (BWifiNetworksManager.this.currentNetwork != null && BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                                if (BWifiNetworksManager.this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                                    BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                                }
                                BWifiNetworksManager.this.currentNetwork = null;
                                BWifiNetworksManager.this.daemonStateLabel.setText(BWifiDaemonStateEnum.disconnected.getDisplayTag(null));
                            }
                            if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                                BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnected);
                            }
                            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                            BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                        }
                    }
                } else if (bWifiHostSettings != null) {
                    if (!WifiUtil.disconnectFromSession(bWifiHostSettings.getAdapterName(), bWifiNetwork.getSsid(), bDaemonSession)) {
                    } else {
                        BWifiNetwork bWifiNetwork2 = (BWifiNetwork)bWifiHostSettings.getNetworkDatabase().get(SlotPath.escape((String)bWifiNetwork.getSsid()));
                        if (bWifiNetwork2 != null && bWifiNetwork2.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                            bWifiNetwork2.setNetworkState(BWifiNetworkStateEnum.disconnected);
                        }
                        if (bWifiNetwork2 != null && bWifiHostSettings.getCurrentNetworkSsid() != null && bWifiHostSettings.getCurrentNetworkSsid().equalsIgnoreCase(bWifiNetwork2.getSsid())) {
                            bWifiHostSettings.setCurrentNetworkSsid("");
                        }
                        if (BWifiNetworksManager.this.currentNetwork != null && BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                            if (BWifiNetworksManager.this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                                BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                            }
                            BWifiNetworksManager.this.currentNetwork = null;
                            BWifiNetworksManager.this.daemonStateLabel.setText(BWifiDaemonStateEnum.disconnected.getDisplayTag(null));
                            bWifiHostSettings.setDaemonState(BWifiDaemonStateEnum.disconnected);
                        }
                        if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                            BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnected);
                        }
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                        BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }
    }

    private class ConnectCommand
    extends AsyncCommand {
        public ConnectCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.connect.label", "Connect"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/connection.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.connect.description", "Connect to the selected 802.11 wireless network"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                    return;
                }
                boolean bl = false;
                BDaemonSession bDaemonSession = null;
                BWifiHostSettings bWifiHostSettings = null;
                BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                    if (bWifiNetworksManager instanceof BWifiConfiguration) {
                        bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                        bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                        bl = false;
                        break;
                    }
                    if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                    bl = true;
                    break;
                }
                if (bWifiNetworksManager == null) {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                BWifiNetwork bWifiNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                if (bWifiNetwork.getNetworkState() == BWifiNetworkStateEnum.connected) {
                    return;
                }
                if (bl) {
                    BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                    if (bWifiPlatformService != null) {
                        if (!bWifiPlatformService.connectToNetwork(new BWifiCommandArgs(bWifiPlatformService.getSettings().getAdapterName(), (BWifiNetwork)bWifiNetwork.newCopy(true))).getBoolean()) {
                        } else {
                            if (BWifiNetworksManager.this.currentNetwork != null && !BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                                BWifiNetworksManager.this.currentNetwork = null;
                            }
                            if (BWifiNetworksManager.this.currentNetwork == null) {
                                BWifiNetworksManager.this.currentNetwork = bWifiNetwork;
                            }
                            BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                            BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                        }
                    }
                } else if (bWifiHostSettings != null) {
                    if (!WifiUtil.connectFromSession(bWifiHostSettings.getAdapterName(), bWifiNetwork.getSsid(), bDaemonSession)) {
                    } else {
                        BWifiNetwork bWifiNetwork2;
                        if (bWifiHostSettings.getCurrentNetworkSsid() != null && !bWifiHostSettings.getCurrentNetworkSsid().equalsIgnoreCase(bWifiNetwork.getSsid())) {
                            bWifiNetwork2 = (BWifiNetwork)bWifiHostSettings.getNetworkDatabase().get(SlotPath.escape((String)bWifiHostSettings.getCurrentNetworkSsid()));
                            if (bWifiNetwork2 != null && bWifiNetwork2.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                                bWifiNetwork2.setNetworkState(BWifiNetworkStateEnum.disconnected);
                            }
                            bWifiHostSettings.setCurrentNetworkSsid("");
                        }
                        if (bWifiHostSettings.getCurrentNetworkSsid().length() == 0) {
                            bWifiHostSettings.setCurrentNetworkSsid(bWifiNetwork.getSsid());
                        }
                        bWifiNetwork2 = (BWifiNetwork)bWifiHostSettings.getNetworkDatabase().get(SlotPath.escape((String)bWifiNetwork.getSsid()));
                        if (BWifiNetworksManager.this.currentNetwork != null && !BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(bWifiNetwork2.getSsid())) {
                            BWifiNetworksManager.this.currentNetwork = null;
                        }
                        if (BWifiNetworksManager.this.currentNetwork == null) {
                            BWifiNetworksManager.this.currentNetwork = bWifiNetwork2;
                        }
                        BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                        BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }
    }

    private class AddCommand
    extends AsyncCommand {
        public AddCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDiscoveryTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.add.label", "Add"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/import.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.add.description", "Add the selected 802.11 wireless network to the database"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(false);
                this.setEnabled(false);
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                if (BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount() == 0) {
                    return;
                }
                BWifiNetwork bWifiNetwork = null;
                try {
                    bWifiNetwork = this.promptAdd();
                    if (bWifiNetwork == null) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                boolean bl = false;
                BDaemonSession bDaemonSession = null;
                BWifiHostSettings bWifiHostSettings = null;
                BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                    if (bWifiNetworksManager instanceof BWifiConfiguration) {
                        bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                        bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                        bl = false;
                        break;
                    }
                    if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                    bl = true;
                    break;
                }
                if (bWifiNetworksManager == null) {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                if (bl) {
                    BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                    if (bWifiPlatformService != null) {
                        if (!bWifiPlatformService.addNetwork(new BWifiCommandArgs(bWifiPlatformService.getSettings().getAdapterName(), bWifiNetwork)).getBoolean()) {
                        } else {
                            BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(BWifiNetworksManager.this.discoveredNetworkTableModel.getSelection().getAnchor(), UNAVAILABLE_NETWORK_ICON);
                            BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(false);
                            BWifiNetworksManager.this.databaseNetworkTableModel.addCurrentNetwork(bWifiNetwork, NORMAL_NETWORK_ICON);
                            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                            BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                            bWifiPlatformService.savePlatformServiceProperties();
                        }
                    }
                } else if (bWifiHostSettings != null) {
                    if (!WifiUtil.addRemoveFromSession(bWifiHostSettings.getAdapterName(), bWifiNetwork, bDaemonSession, true)) {
                    } else {
                        bWifiHostSettings.getNetworkDatabase().add(SlotPath.escape((String)bWifiNetwork.getSsid()), (BValue)bWifiNetwork, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")));
                        BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(BWifiNetworksManager.this.discoveredNetworkTableModel.getSelection().getAnchor(), UNAVAILABLE_NETWORK_ICON);
                        BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(false);
                        BWifiNetworksManager.this.databaseNetworkTableModel.addCurrentNetwork(bWifiNetwork, NORMAL_NETWORK_ICON);
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                        BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                        WifiUtil.saveToSession(bWifiHostSettings, bDaemonSession);
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }

        public BWifiNetwork promptAdd() throws Exception {
            BWifiNetwork bWifiNetwork = (BWifiNetwork)BWifiNetworksManager.this.discoveredNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.discoveredNetworkTableModel.getSelection().getAnchor()).newCopy(true);
            String string = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.add.title", "Add Wireless Network");
            int n = bWifiNetwork.getSignalStrength();
            BWifiNetworkEditorDialog bWifiNetworkEditorDialog = new BWifiNetworkEditorDialog(this.getOwner(), string, 2, bWifiNetwork);
            bWifiNetworkEditorDialog.setPreferredSize(500.0, 800.0);
            bWifiNetworkEditorDialog.setBoundsCenteredOnOwner();
            bWifiNetworkEditorDialog.open();
            if (bWifiNetworkEditorDialog.getResult() == 1) {
                try {
                    BWifiNetwork bWifiNetwork2 = bWifiNetworkEditorDialog.getNetwork();
                    if (bWifiNetwork2 != null) {
                        bWifiNetwork2.setSignalStrength(n);
                    }
                    return bWifiNetwork2;
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)this.getOwner(), (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText(exception.getMessage()));
                    return null;
                }
            }
            return null;
        }
    }

    private class DiscoverCommand
    extends AsyncCommand {
        public DiscoverCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDiscoveryTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.discover.label", "Discover"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/find.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.discover.description", "Discover 802.11 wireless networks"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            int n;
            String string;
            String string2 = BWifiNetworksManager.this.daemonStateLabel.getText();
            if (string2.equalsIgnoreCase("Completed") || string2.equalsIgnoreCase("Associating") || string2.equalsIgnoreCase("Associated") || string2.equalsIgnoreCase("4-Way Handshake") || string2.equalsIgnoreCase("Group Handshake")) {
                string = null;
                string = BWifiNetworksManager.this.currentNetwork != null ? BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.discover.confirmDiscoverKnown", new Object[]{BWifiNetworksManager.this.currentNetwork.getSsid()}) : BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.discover.confirmDiscoverUnknown");
                n = BDialog.confirm((BWidget)this.getOwner(), (Object)string);
                if (n != 4) {
                    return;
                }
            }
            string = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                int n2;
                Object object;
                Object object2;
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(false);
                this.setEnabled(false);
                BWifiNetworksManager.this.lockModifiedState();
                if (string != null) {
                    string.enterBusy();
                }
                n = 0;
                BDaemonSession bDaemonSession = null;
                BWifiHostSettings bWifiHostSettings = null;
                BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                    if (bWifiNetworksManager instanceof BWifiConfiguration) {
                        bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                        bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                        n = 0;
                        break;
                    }
                    if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                    n = 1;
                    break;
                }
                if (bWifiNetworksManager == null) {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                BWifiNetworkVector bWifiNetworkVector = null;
                BWifiNetworksManager.this.daemonStateLabel.setText("Scanning");
                if (BWifiNetworksManager.this.currentNetwork != null) {
                    int n3;
                    object2 = BWifiNetworksManager.this.currentNetwork.getSsid();
                    for (n3 = 0; n3 < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++n3) {
                        if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(n3).equalsIgnoreCase((String)object2)) continue;
                        BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(n3, BWifiNetworkStateEnum.disconnected);
                        break;
                    }
                    if ((n3 = BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getRow()) != -1) {
                        object = null;
                        try {
                            object = BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                            for (n2 = 0; n2 < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++n2) {
                                if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(n2).equalsIgnoreCase((String)object)) continue;
                                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().select(n2);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    } else {
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                    }
                }
                object2 = null;
                if (n != 0) {
                    BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                    if (bWifiPlatformService != null) {
                        BWifiNetworksManager.this.discoveredNetworkTableModel.clear();
                        object2 = new DiscoverThread(bWifiPlatformService.getSettings().getAdapterName(), bWifiPlatformService);
                    }
                } else if (bWifiHostSettings != null) {
                    BWifiNetworksManager.this.discoveredNetworkTableModel.clear();
                    bWifiHostSettings.setDaemonState(BWifiDaemonStateEnum.scanning);
                    object2 = new DiscoverThread(bWifiHostSettings.getAdapterName(), bDaemonSession);
                }
                if (object2 != null) {
                    CancelableDaemonSessionTask cancelableDaemonSessionTask = new CancelableDaemonSessionTask(BWifiNetworksManager.this.getLexicon(), "WifiNetworkManager.discoverTask.title", "WifiNetworkManager.discoverTask.message", 0);
                    object = new DaemonSessionTaskHandler(this.getOwner());
                    ((Thread)object2).start();
                    object.taskStarted((DaemonSessionTask)cancelableDaemonSessionTask);
                    n2 = 0;
                    while (((Thread)object2).isAlive() && ++n2 < 30 && !cancelableDaemonSessionTask.isCanceled()) {
                        Thread.sleep(1000L);
                    }
                    if (n2 == 30 || cancelableDaemonSessionTask.isCanceled()) {
                        object.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
                        if (n2 == 30) {
                            Log.getLog((String)"wifi").error("WiFi Discovery Task did not complete normally, terminating task");
                        } else if (cancelableDaemonSessionTask.isCanceled()) {
                            Log.getLog((String)"wifi").message("WiFi Discovery Task cancelled, terminating thread");
                        }
                        ((Thread)object2).interrupt();
                        ((Thread)object2).join(2000L);
                    } else {
                        object.taskFinished((DaemonSessionTask)cancelableDaemonSessionTask);
                        bWifiNetworkVector = ((DiscoverThread)object2).getResults();
                    }
                }
                if (bWifiNetworkVector != null) {
                    BWifiNetwork bWifiNetwork = null;
                    object = null;
                    n2 = 0;
                    SlotCursor slotCursor = bWifiNetworkVector.loadSlots().getProperties();
                    while (slotCursor.next(class$com$tridium$platwifi$BWifiNetwork == null ? BWifiNetworksManager.class$("com.tridium.platwifi.BWifiNetwork") : class$com$tridium$platwifi$BWifiNetwork)) {
                        object = (BWifiNetwork)slotCursor.get();
                        n2 = 0;
                        for (int i = 0; i < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++i) {
                            if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(i).equals(((BWifiNetwork)((Object)object)).getSsid())) continue;
                            n2 = 1;
                            bWifiNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(i);
                            bWifiNetwork.setSignalStrength(((BWifiNetwork)((Object)object)).getSignalStrength());
                            break;
                        }
                        BImage bImage = n2 != 0 ? UNAVAILABLE_NETWORK_ICON : NORMAL_NETWORK_ICON;
                        BWifiNetwork bWifiNetwork2 = (BWifiNetwork)slotCursor.get();
                        bWifiNetwork2.setSsidBroadcasted(true);
                        BWifiNetworksManager.this.discoveredNetworkTableModel.addCurrentNetwork(bWifiNetwork2, bImage);
                    }
                    BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(true);
                    bWifiNetworkVector.removeAll();
                    bWifiNetworkVector = null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                BWifiNetworksManager.this.unlockModifiedState();
                this.setEnabled(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (string != null) {
                    string.exitBusy();
                }
            }
        }

        private class DiscoverThread
        extends Thread {
            private BWifiNetworkVector result = null;
            private BDaemonSession sessionToPoll = null;
            private BWifiPlatformService serviceToPoll = null;
            private boolean daemonMode = false;
            private String adapter = null;

            DiscoverThread(String string, BDaemonSession bDaemonSession) {
                this.adapter = string;
                this.sessionToPoll = bDaemonSession;
                this.daemonMode = true;
            }

            DiscoverThread(String string, BWifiPlatformService bWifiPlatformService) {
                this.adapter = string;
                this.serviceToPoll = bWifiPlatformService;
                this.daemonMode = false;
            }

            BWifiNetworkVector getResults() {
                return this.result;
            }

            public void run() {
                if (this.daemonMode) {
                    try {
                        this.result = WifiUtil.discoverFromSession(this.adapter, this.sessionToPoll);
                    }
                    catch (Exception exception) {
                        this.result = null;
                    }
                } else {
                    try {
                        this.result = this.serviceToPoll.discoverNetworks(BString.make((String)this.serviceToPoll.getSettings().getAdapterName()));
                    }
                    catch (Exception exception) {
                        this.result = null;
                    }
                }
            }
        }
    }

    private class RoamCommand
    extends AsyncCommand {
        public RoamCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.roam.label", "Roam"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/planet.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.roam.description", "Enter Wireless Network Roaming Mode"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                boolean bl = false;
                BDaemonSession bDaemonSession = null;
                BWifiHostSettings bWifiHostSettings = null;
                BWifiNetworksManager bWifiNetworksManager = BWifiNetworksManager.this;
                while ((bWifiNetworksManager = bWifiNetworksManager.getParent()) != null) {
                    if (bWifiNetworksManager instanceof BWifiConfiguration) {
                        bDaemonSession = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getDaemonSession();
                        bWifiHostSettings = ((BWifiConfiguration)((Object)bWifiNetworksManager)).getWifiHostSettings();
                        bl = false;
                        break;
                    }
                    if (!(bWifiNetworksManager instanceof BWifiPlatformServicePlugin)) continue;
                    bl = true;
                    break;
                }
                if (bWifiNetworksManager == null) {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                if (bl) {
                    BWifiPlatformService bWifiPlatformService = (BWifiPlatformService)BOrd.make((String)"service:platWifi:WifiPlatformService").get(BWifiNetworksManager.this.getCurrentValue());
                    if (bWifiPlatformService != null && bWifiPlatformService.roamNetworks(new BWifiCommandArgs(bWifiPlatformService.getSettings().getAdapterName(), null)).getBoolean()) {
                        // empty if block
                    }
                } else if (bWifiHostSettings != null && !WifiUtil.roamFromSession(bWifiHostSettings.getAdapterName(), bDaemonSession)) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }
    }
}

