/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWEPSettings;
import com.tridium.platwifi.security.BWifiWPA2PSKSettings;
import com.tridium.platwifi.security.BWifiWPA2Settings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.security.BWifiWPASettings;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWifiNetwork
extends BComponent {
    public static final Property bssid = BWifiNetwork.newProperty((int)1, (String)"00:00:00:00:00:00", null);
    public static final Property ssid = BWifiNetwork.newProperty((int)1, (String)"New_Wireless_Network", null);
    public static final Property ssidBroadcasted = BWifiNetwork.newProperty((int)1, (boolean)true, null);
    public static final Property priority = BWifiNetwork.newProperty((int)1, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)10), BInteger.make((int)3)}));
    public static final Property mode;
    public static final Property channel;
    public static final Property securitySupported;
    public static final Property securityConfigurations;
    public static final Property networkState;
    public static final Property signalStrength;
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platwifi$BWifiNetwork;

    public String getBssid() {
        return this.getString(bssid);
    }

    public void setBssid(String string) {
        this.setString(bssid, string, null);
    }

    public String getSsid() {
        return this.getString(ssid);
    }

    public void setSsid(String string) {
        this.setString(ssid, string, null);
    }

    public boolean getSsidBroadcasted() {
        return this.getBoolean(ssidBroadcasted);
    }

    public void setSsidBroadcasted(boolean bl) {
        this.setBoolean(ssidBroadcasted, bl, null);
    }

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int n) {
        this.setInt(priority, n, null);
    }

    public BWifiNetworkMode getMode() {
        return (BWifiNetworkMode)this.get(mode);
    }

    public void setMode(BWifiNetworkMode bWifiNetworkMode) {
        this.set(mode, (BValue)bWifiNetworkMode, null);
    }

    public int getChannel() {
        return this.getInt(channel);
    }

    public void setChannel(int n) {
        this.setInt(channel, n, null);
    }

    public BVector getSecuritySupported() {
        return (BVector)this.get(securitySupported);
    }

    public void setSecuritySupported(BVector bVector) {
        this.set(securitySupported, (BValue)bVector, null);
    }

    public BVector getSecurityConfigurations() {
        return (BVector)this.get(securityConfigurations);
    }

    public void setSecurityConfigurations(BVector bVector) {
        this.set(securityConfigurations, (BValue)bVector, null);
    }

    public BWifiNetworkStateEnum getNetworkState() {
        return (BWifiNetworkStateEnum)this.get(networkState);
    }

    public void setNetworkState(BWifiNetworkStateEnum bWifiNetworkStateEnum) {
        this.set(networkState, (BValue)bWifiNetworkStateEnum, null);
    }

    public int getSignalStrength() {
        return this.getInt(signalStrength);
    }

    public void setSignalStrength(int n) {
        this.setInt(signalStrength, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BWifiNetwork makeNetwork(String string) {
        return new BWifiNetwork(string);
    }

    public void updateNetworkFromString(String string) {
        CharSequence charSequence;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.setBssid(stringTokenizer.nextToken());
        switch (Integer.valueOf(stringTokenizer.nextToken())) {
            case 2412: {
                this.setChannel(1);
                break;
            }
            case 2417: {
                this.setChannel(2);
                break;
            }
            case 2422: {
                this.setChannel(3);
                break;
            }
            case 2427: {
                this.setChannel(4);
                break;
            }
            case 2432: {
                this.setChannel(5);
                break;
            }
            case 2437: {
                this.setChannel(6);
                break;
            }
            case 2442: {
                this.setChannel(7);
                break;
            }
            case 2447: {
                this.setChannel(8);
                break;
            }
            case 2452: {
                this.setChannel(9);
                break;
            }
            case 2457: {
                this.setChannel(10);
                break;
            }
            case 2462: {
                this.setChannel(11);
                break;
            }
            default: {
                this.setChannel(6);
            }
        }
        double d = Double.valueOf(stringTokenizer.nextToken());
        d -= 160.0;
        if (d > 50.0) {
            d = 50.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        double d2 = d / 50.0;
        this.setSignalStrength((int)(100.0 * d2));
        this.setMode(BWifiNetworkMode.managed);
        BVector bVector = new BVector();
        BVector bVector2 = new BVector();
        String string2 = null;
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2 != null && string2.indexOf(91) != -1 && string2.indexOf(93) != -1) {
            charSequence = string2;
            String string3 = null;
            int n = 0;
            int n2 = 0;
            String string4 = null;
            BWifiSecuritySettings bWifiSecuritySettings = null;
            while (((String)charSequence).length() != 0) {
                n = ((String)charSequence).indexOf(91);
                n2 = ((String)charSequence).indexOf(93);
                string3 = ((String)charSequence).substring(n + 1, n2);
                CharSequence charSequence2 = charSequence = n2 + 1 != ((String)charSequence).length() ? ((String)charSequence).substring(n2 + 1) : "";
                if (string3.startsWith("IBSS")) {
                    this.setMode(BWifiNetworkMode.ad_hoc);
                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.none.toString()), (BValue)BWifiSecurityPolicy.none, 1);
                    continue;
                }
                if (string3.startsWith("WPA2-PSK")) {
                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.toString()), (BValue)BWifiSecurityPolicy.wpa2_psk, 1);
                    bWifiSecuritySettings = new BWifiWPA2PSKSettings();
                    bWifiSecuritySettings.setSupported(true);
                    string4 = string3.substring(8);
                    if (!string4.equals("")) {
                        if (string4.indexOf("TKIP+CCMP") != -1) {
                            ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkipPLUSccmp);
                        } else if (string4.indexOf("TKIP") != -1) {
                            ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkip);
                        } else if (string4.indexOf("CCMP") != -1 || string4.indexOf("AES") != -1) {
                            ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.ccmp);
                        } else {
                            ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                        }
                        if (string4.indexOf("preauth") != -1) {
                            ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setPreauthenticationSupported(true);
                        } else {
                            ((BWifiWPA2PSKSettings)bWifiSecuritySettings).setPreauthenticationSupported(false);
                        }
                    }
                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2_psk.toString()), (BValue)bWifiSecuritySettings, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2PSKEditor")));
                    continue;
                }
                if (string3.startsWith("WPA-PSK")) {
                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.toString()), (BValue)BWifiSecurityPolicy.wpa_psk, 1);
                    string4 = string3.substring(7);
                    bWifiSecuritySettings = new BWifiWPAPSKSettings();
                    ((BWifiWPAPSKSettings)bWifiSecuritySettings).setSupported(true);
                    if (!string4.equals("")) {
                        if (string4.indexOf("TKIP+CCMP") != -1) {
                            ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkipPLUSccmp);
                        } else if (string4.indexOf("TKIP") != -1) {
                            ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkip);
                        } else if (string4.indexOf("CCMP") != -1 || string4.indexOf("AES") != -1) {
                            ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.ccmp);
                        } else {
                            ((BWifiWPAPSKSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                        }
                    }
                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa_psk.toString()), (BValue)bWifiSecuritySettings, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAPSKEditor")));
                    continue;
                }
                if (string3.startsWith("WPA2")) {
                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.toString()), (BValue)BWifiSecurityPolicy.wpa2, 1);
                    bWifiSecuritySettings = new BWifiWPA2Settings();
                    ((BWifiWPA2Settings)bWifiSecuritySettings).setSupported(true);
                    string4 = string3.substring(4);
                    if (!string4.equals("")) {
                        if (string4.indexOf("TKIP+CCMP") != -1) {
                            ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkipPLUSccmp);
                        } else if (string4.indexOf("TKIP") != -1) {
                            ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkip);
                        } else if (string4.indexOf("CCMP") != -1 || string4.indexOf("AES") != -1) {
                            ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.ccmp);
                        } else if (string4.indexOf("?") != -1) {
                            ((BWifiWPA2Settings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                        }
                        if (string4.indexOf("preauth") != -1) {
                            ((BWifiWPA2Settings)bWifiSecuritySettings).setPreauthenticationSupported(true);
                        } else {
                            ((BWifiWPA2Settings)bWifiSecuritySettings).setPreauthenticationSupported(false);
                        }
                    }
                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa2.toString()), (BValue)bWifiSecuritySettings, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPA2Editor")));
                    continue;
                }
                if (string3.startsWith("WPA")) {
                    bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa.toString()), (BValue)BWifiSecurityPolicy.wpa, 1);
                    bWifiSecuritySettings = new BWifiWPASettings();
                    ((BWifiWPASettings)bWifiSecuritySettings).setSupported(true);
                    string4 = string3.substring(3);
                    if (!string4.equals("")) {
                        if (string4.indexOf("TKIP+CCMP") != -1) {
                            ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkipPLUSccmp);
                        } else if (string4.indexOf("TKIP") != -1) {
                            ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.tkip);
                        } else if (string4.indexOf("CCMP") != -1 || string4.indexOf("AES") != -1) {
                            ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.ccmp);
                        } else if (string4.indexOf("?") != -1) {
                            ((BWifiWPASettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.unknown);
                        }
                    }
                    bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wpa.toString()), (BValue)bWifiSecuritySettings, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWPAEditor")));
                    continue;
                }
                if (!string3.startsWith("WEP")) continue;
                bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.wep.toString()), (BValue)BWifiSecurityPolicy.wep, 1);
                bWifiSecuritySettings = new BWifiWEPSettings();
                ((BWifiWEPSettings)bWifiSecuritySettings).setSupported(true);
                ((BWifiWEPSettings)bWifiSecuritySettings).setAuthentication(BWifiAuthenticationMethod.open);
                ((BWifiWEPSettings)bWifiSecuritySettings).setEncryption(BWifiEncryptionMethod.wep40);
                string4 = string3.substring(3);
                string4.equals("");
                bVector2.add(SlotPath.escape((String)BWifiSecurityPolicy.wep.toString()), (BValue)bWifiSecuritySettings, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiWEPEditor")));
            }
            string2 = stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : null;
        } else {
            bVector.add(SlotPath.escape((String)BWifiSecurityPolicy.none.toString()), (BValue)BWifiSecurityPolicy.none);
        }
        this.setSecuritySupported(bVector);
        this.setSecurityConfigurations(bVector2);
        if (string2 == null) {
            this.setSsid("SSID N/A");
            this.setNetworkState(BWifiNetworkStateEnum.disabled);
        } else {
            charSequence = new StringBuffer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                ((StringBuffer)charSequence).append(" " + stringTokenizer.nextToken());
            }
            this.setSsid(((StringBuffer)charSequence).toString());
            this.setNetworkState(BWifiNetworkStateEnum.disconnected);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BWifiNetwork() {
    }

    private BWifiNetwork(String string) {
        this.updateNetworkFromString(string);
    }

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        mode = BWifiNetwork.newProperty((int)1, (BValue)BWifiNetworkMode.managed, (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make(null, (int[])nArray, (String[])new String[]{BWifiNetworkMode.managed.getDisplayTag(null), SlotPath.escape((String)BWifiNetworkMode.ad_hoc.getDisplayTag(null))})));
        channel = BWifiNetwork.newProperty((int)3, (int)6, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)11), BInteger.make((int)3)}));
        securitySupported = BWifiNetwork.newProperty((int)1, (BValue)new BVector(), null);
        securityConfigurations = BWifiNetwork.newProperty((int)1, (BValue)new BVector(), null);
        networkState = BWifiNetwork.newProperty((int)3, (BValue)BWifiNetworkStateEnum.unknown, null);
        signalStrength = BWifiNetwork.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)100), BInteger.make((int)3), BUnit.getUnit((String)"percent")}));
        Class clazz = class$com$tridium$platwifi$BWifiNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$platwifi$BWifiNetwork = BWifiNetwork.class("[Lcom.tridium.platwifi.BWifiNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

