/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platNrio;

import com.tridium.platNrio.BNrioPlatformService;
import com.tridium.platform.BOperatingSystemEnum;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioPlatformServiceQnx
extends BNrioPlatformService {
    public static final Action openTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    public static final Action configTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    public static final Action discoverTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    public static final Action setLogicalAddressTest = BNrioPlatformServiceQnx.newAction((int)0, (BValue)BInteger.make((int)1), null);
    public static final Action pingTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    public static final Action enablePollingTest = BNrioPlatformServiceQnx.newAction((int)0, (BValue)BInteger.make((int)1), null);
    public static final Action disablePollingTest = BNrioPlatformServiceQnx.newAction((int)0, (BValue)BInteger.make((int)1), null);
    public static final Action waitForStatusChangeTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    public static final Type TYPE;
    private static boolean nativesLoaded;
    private Process actrld;
    int testHandle;
    byte[] moduleUID;
    byte type;
    static /* synthetic */ Class class$com$tridium$platNrio$BNrioPlatformServiceQnx;

    public void openTest() {
        this.invoke(openTest, null, null);
    }

    public void configTest() {
        this.invoke(configTest, null, null);
    }

    public void discoverTest() {
        this.invoke(discoverTest, null, null);
    }

    public void setLogicalAddressTest(BInteger bInteger) {
        this.invoke(setLogicalAddressTest, (BValue)bInteger, null);
    }

    public void pingTest() {
        this.invoke(pingTest, null, null);
    }

    public void enablePollingTest(BInteger bInteger) {
        this.invoke(enablePollingTest, (BValue)bInteger, null);
    }

    public void disablePollingTest(BInteger bInteger) {
        this.invoke(disablePollingTest, (BValue)bInteger, null);
    }

    public void waitForStatusChangeTest() {
        this.invoke(waitForStatusChangeTest, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx);
    }

    protected synchronized boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        try {
            System.loadLibrary("platnrio");
            nativesLoaded = true;
        }
        catch (Throwable throwable) {
            log.error("Unable load platNrio native", throwable);
        }
        return nativesLoaded;
    }

    public void serviceStarted() throws Exception {
        int n = 2;
        File file = new File("/dev/actrl1");
        if (file.exists()) {
            log.message("access/nrio daemon already running");
        } else {
            this.actrld = Runtime.getRuntime().exec("/proc/boot/actrld -n " + n);
        }
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        if (this.actrld != null) {
            this.actrld.destroy();
            this.actrld = null;
        }
        super.serviceStopped();
    }

    public int open(int n) {
        log.trace("open()");
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load nrio natives");
        }
        int n2 = this.open0(n);
        log.trace("opened, fd = " + n2);
        return n2;
    }

    public void close(int n) {
        log.trace("close()");
        this.close0(n);
    }

    public void setPortParams(int n, String string, int n2) {
        log.trace("setPortParams " + string + " baudrate " + n2);
        this.setPortParams0(n, string, n2);
    }

    public Vector discover(int n) {
        log.trace("discover entry");
        Vector vector = new Vector(16);
        this.discover0(n, vector);
        log.trace("discover returned " + vector.size());
        return vector;
    }

    public void enablePolling(int n, int n2) {
        log.trace("enable polling " + n2);
        this.enablePolling0(n, n2);
    }

    public void disablePolling(int n, int n2) {
        log.trace("disable polling " + n2);
        this.disablePolling0(n, n2);
    }

    public void waitForStatusChange(int n, byte[] byArray) {
        log.trace("waitForStatusChange entry");
        if (byArray.length < 128) {
            throw new IllegalArgumentException("Reply buffer too small");
        }
        this.waitForStatusChange0(n, byArray);
        log.trace("waitForStatusChange exit");
    }

    public void sendRequest(int n, byte[] byArray, byte[] byArray2) {
        log.trace("sendRequest entry");
        if (byArray2.length < 128) {
            throw new IllegalArgumentException("Reply buffer too small");
        }
        this.sendRequest0(n, byArray, byArray2);
        log.trace("sendRequest0 exit");
    }

    native int open0(int var1);

    native void close0(int var1);

    native void setPortParams0(int var1, String var2, int var3);

    native void discover0(int var1, Vector var2);

    native void enablePolling0(int var1, int var2);

    native void disablePolling0(int var1, int var2);

    native void waitForStatusChange0(int var1, byte[] var2);

    native void sendRequest0(int var1, byte[] var2, byte[] var3);

    public void doOpenTest() {
        this.testHandle = this.open(1);
    }

    public void doConfigTest() {
        this.setPortParams(this.testHandle, "/dev/ser2", 115200);
    }

    public void doDiscoverTest() {
        Vector vector = this.discover(this.testHandle);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            System.out.println("Discover response: ");
            ByteArrayUtil.hexDump((byte[])byArray, (int)0, (int)byArray.length);
            System.arraycopy(byArray, 4, this.moduleUID, 0, 6);
            this.type = byArray[10];
        }
    }

    public void doSetLogicalAddressTest(BInteger bInteger) {
        byte[] byArray = new byte[11];
        byte[] byArray2 = new byte[128];
        byArray[0] = -68;
        byArray[1] = 9;
        byArray[2] = 2;
        byArray[3] = 0;
        System.arraycopy(this.moduleUID, 0, byArray, 4, 6);
        byArray[10] = (byte)bInteger.getInt();
        System.out.println("Set Logical Address request: ");
        ByteArrayUtil.hexDump((byte[])byArray, (int)0, (int)byArray.length);
        this.sendRequest(this.testHandle, byArray, byArray2);
        System.out.println("Set Logical Address reply: ");
        ByteArrayUtil.hexDump((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    public void doPingTest() {
        byte[] byArray = new byte[11];
        byte[] byArray2 = new byte[128];
        byArray[0] = -68;
        byArray[1] = 9;
        byArray[2] = 3;
        byArray[3] = 0;
        System.arraycopy(this.moduleUID, 0, byArray, 4, 6);
        byArray[10] = this.type;
        System.out.println("Ping request: ");
        ByteArrayUtil.hexDump((byte[])byArray, (int)0, (int)byArray.length);
        this.sendRequest(this.testHandle, byArray, byArray2);
        System.out.println("Ping reply: ");
        ByteArrayUtil.hexDump((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    public void doEnablePollingTest(BInteger bInteger) {
        this.enablePolling(this.testHandle, bInteger.getInt());
    }

    public void doDisablePollingTest(BInteger bInteger) {
        this.disablePolling(this.testHandle, bInteger.getInt());
    }

    public void doWaitForStatusChangeTest() {
        byte[] byArray = new byte[128];
        this.waitForStatusChange(this.testHandle, byArray);
        System.out.println("Wait for status change reply: ");
        ByteArrayUtil.hexDump((byte[])byArray, (int)0, (int)byArray.length);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.testHandle = -1;
        this.moduleUID = new byte[6];
    }

    public BNrioPlatformServiceQnx() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platNrio$BNrioPlatformServiceQnx;
        if (clazz == null) {
            clazz = class$com$tridium$platNrio$BNrioPlatformServiceQnx = BNrioPlatformServiceQnx.class("[Lcom.tridium.platNrio.BNrioPlatformServiceQnx;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        nativesLoaded = false;
    }
}

