/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPermissions;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.AuthenticateUtil;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTunnelService
extends BComponent
implements BIService,
BIStatus,
TunnelConst {
    public static final Property enabled = BTunnelService.newProperty((int)0, (boolean)true, null);
    public static final Property serverPort = BTunnelService.newProperty((int)0, (int)9973, null);
    public static final Property status = BTunnelService.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property connections = BTunnelService.newProperty((int)67, (int)0, null);
    public static final Action pingConnections = BTunnelService.newAction((int)20, null);
    public static final Type TYPE;
    static final BIcon icon;
    public static Log log;
    private boolean alive;
    private Object mutex;
    private Clock.Ticket pingTicket;
    private Socket socket;
    private Server server;
    private Hashtable sessions;
    private boolean threadAvailable;
    private Hashtable tunnels;
    private Worker workQueue;
    static /* synthetic */ Class class$com$tridium$tunnel$BTunnelService;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public int getServerPort() {
        return this.getInt(serverPort);
    }

    public void setServerPort(int n) {
        this.setInt(serverPort, n, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public int getConnections() {
        return this.getInt(connections);
    }

    public void setConnections(int n) {
        this.setInt(connections, n, null);
    }

    public void pingConnections() {
        this.invoke(pingConnections, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && (property == enabled || property == serverPort)) {
            this.stopServer();
            this.startServer();
        }
        super.changed(property, context);
    }

    public void doPingConnections() {
        Runnable runnable = new Runnable(){

            public final void run() {
                BTunnelService.this.implPingConnections();
            }
        };
        this.postAsync(runnable);
    }

    public void implPingConnections() {
        BTunnelConnection[] bTunnelConnectionArray = this.connections();
        int n = bTunnelConnectionArray.length;
        while (--n >= 0) {
            long l = System.currentTimeMillis();
            BTunnelConnection bTunnelConnection = bTunnelConnectionArray[n];
            if (!bTunnelConnection.isConnected()) continue;
            if (bTunnelConnection.getLastRead().getMillis() + 60000L < l) {
                log.message("Disconnecting idle connection " + SlotPath.unescape((String)bTunnelConnection.toPathString()));
                bTunnelConnection.disconnect();
                continue;
            }
            if (bTunnelConnection.getLastWrite().getMillis() + 15000L >= l) continue;
            try {
                bTunnelConnection.sendPing();
            }
            catch (Exception exception) {
                if (!bTunnelConnection.isConnected()) continue;
                log.error("While pinging " + SlotPath.unescape((String)bTunnelConnection.toPathString()));
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public void started() throws Exception {
        super.started();
        this.workQueue.start("Tunnel.Async");
        this.startServer();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopServer();
        this.workQueue.stop();
    }

    public final IFuture postAsync(Runnable runnable) {
        if (!this.workQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.workQueue.getTodo()).enqueue((Object)runnable);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BTunnelConnection[] connections() {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            int n = this.sessions.size();
            BTunnelConnection[] bTunnelConnectionArray = new BTunnelConnection[n];
            Enumeration enumeration = this.sessions.elements();
            int n2 = 0;
            while (n2 < n) {
                bTunnelConnectionArray[n2] = (BTunnelConnection)enumeration.nextElement();
                ++n2;
            }
            return bTunnelConnectionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(Socket socket) {
        BTunnel bTunnel = null;
        BTunnelConnection bTunnelConnection = null;
        try {
            BAbsTime bAbsTime = Clock.time();
            String string = socket.getInetAddress().getHostName();
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            byte[] byArray = new byte[4];
            dataInputStream.readFully(byArray);
            if (byArray[0] != TunnelConst.MAGIC[0] || byArray[1] != TunnelConst.MAGIC[1] || byArray[2] != TunnelConst.MAGIC[2] || byArray[3] != TunnelConst.MAGIC[3]) {
                log.error("Invalid magic from " + string);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            int n = dataInputStream.read();
            if (n != 13) {
                log.error("Invalid hello from " + string + ": " + n);
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(43);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            int n2 = dataInputStream.read();
            if (n2 != 1) {
                log.error("Unsupported protocol version from " + string + ": " + n2);
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(41);
                dataOutputStream.write(1);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            String string2 = this.readString(dataInputStream);
            log.trace(string + " user: " + string2);
            String string3 = this.readString(dataInputStream);
            String string4 = this.readString(dataInputStream);
            log.trace(string + " requesting tunnel: " + string4);
            BUser bUser = null;
            try {
                bUser = this.getUser(string2, string3);
            }
            catch (Exception exception) {
                log.error("Authentication failure for user " + string2 + " from caller " + string, (Throwable)exception);
            }
            if (bUser == null) {
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(29);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            bTunnel = (BTunnel)((Object)this.tunnels.get(string4));
            if (bTunnel == null) {
                log.error(string + " requested unknown tunnel >" + string4 + '<');
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(31);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            BPermissions bPermissions = bTunnel.getPermissions((Context)bUser);
            if (!bPermissions.hasAdminWrite()) {
                log.error(string2 + " does not have admin write permission for tunnel " + string4);
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(29);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            if (!bTunnel.supportsConcurrentConnections() && bTunnel.getConnections() > 0) {
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(37);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            dataOutputStream.write(TunnelConst.MAGIC);
            dataOutputStream.write(17);
            dataOutputStream.flush();
            if (!this.alive) {
                dataOutputStream.write(TunnelConst.MAGIC);
                dataOutputStream.write(23);
                dataInputStream.close();
                dataOutputStream.close();
                socket.close();
                return;
            }
            bTunnelConnection = new BTunnelConnection(bUser, dataInputStream, dataOutputStream, socket, bTunnel, this);
            bTunnelConnection.setEstablished(bAbsTime);
            bTunnelConnection.setProtocolVersion(n2);
            bTunnelConnection.setUserName(string2);
            bTunnelConnection.setRemoteHost(string);
            bTunnelConnection.setLastRead(Clock.time());
            bTunnelConnection.setLastWrite(Clock.time());
            Hashtable hashtable = this.sessions;
            synchronized (hashtable) {
                this.addConnection(bTunnelConnection);
                // MONITOREXIT @DISABLED, blocks:[0, 2, 5] lbl99 : MonitorExitStatement: MONITOREXIT : var16_19
                bTunnel.addConnection(bTunnelConnection);
            }
        }
        catch (Exception exception) {
            log.trace("Processing hello");
            try {
                socket.close();
                return;
            }
            catch (Exception exception2) {}
            return;
        }
        try {
            bTunnel.service(bTunnelConnection);
            return;
        }
        catch (Exception exception) {
            log.error(bTunnel.getIdentifier(), (Throwable)exception);
        }
    }

    protected void register(BTunnel bTunnel) {
        String string = bTunnel.getIdentifier();
        if (this.tunnels.get(string) != null) {
            throw new IllegalArgumentException(string + " already in use.");
        }
        this.tunnels.put(string, bTunnel);
    }

    protected void startPing() {
        if (this.pingTicket != null) {
            return;
        }
        this.pingTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)15000L), (Action)pingConnections, null);
    }

    protected void startServer() {
        if (this.alive) {
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
        } else {
            this.setStatus(BStatus.ok);
            this.alive = true;
            this.server = new Server();
            this.server.start();
        }
    }

    protected void stopPing() {
        if (this.pingTicket == null) {
            return;
        }
        this.pingTicket.cancel();
        this.pingTicket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopServer() {
        this.alive = false;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            if (this.server != null) {
                this.server.close();
            }
            this.server = null;
            return;
        }
    }

    protected void unregister(BTunnel bTunnel) {
        this.tunnels.remove(bTunnel.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addConnection(BTunnelConnection bTunnelConnection) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.put(bTunnelConnection.getEstablished(), bTunnelConnection);
            this.setConnections(this.sessions.size());
            if (this.sessions.size() == 1) {
                this.startPing();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeConnection(BTunnelConnection bTunnelConnection) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            this.sessions.remove(bTunnelConnection.getEstablished());
            this.setConnections(this.sessions.size());
            if (this.sessions.size() == 0) {
                this.stopPing();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Socket dequeue() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.threadAvailable) {
                return null;
            }
            this.threadAvailable = true;
            while (this.alive && this.socket == null) {
                try {
                    this.mutex.wait();
                }
                catch (Exception exception) {}
            }
            Socket socket = this.socket;
            this.socket = null;
            this.threadAvailable = false;
            this.mutex.notifyAll();
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void enqueue(Socket socket) {
        Object object = this.mutex;
        synchronized (object) {
            block7: {
                while (true) {
                    if (!this.alive || this.socket == null) {
                        this.socket = socket;
                        if (!this.threadAvailable) break;
                        this.mutex.notifyAll();
                        break block7;
                    }
                    try {
                        this.mutex.wait();
                    }
                    catch (Exception exception) {}
                }
                new ServiceThread().start();
            }
            return;
        }
    }

    private final BUser getUser(String string, String string2) throws Exception {
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)bUserService, null);
    }

    private final String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "UTF-8");
        return string;
    }

    static /* synthetic */ Server access$3(BTunnelService bTunnelService) {
        return bTunnelService.server;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.alive = false;
        this.mutex = new Object();
        this.sessions = new Hashtable();
        this.threadAvailable = false;
        this.tunnels = new Hashtable();
        this.workQueue = new Worker((Worker.ITodo)new Queue(100));
    }

    public BTunnelService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$tunnel$BTunnelService;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BTunnelService = BTunnelService.class("[Lcom.tridium.tunnel.BTunnelService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"cloud.png");
        log = Log.getLog((String)"tunnel");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Server
    extends Thread {
        ServerSocket srvr;

        public void close() {
            if (this.srvr != null) {
                try {
                    this.srvr.close();
                }
                catch (Exception exception) {}
                this.srvr = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (BTunnelService.this.alive) {
                try {
                    if (this.srvr == null) {
                        int n = BTunnelService.this.getServerPort();
                        this.srvr = new ServerSocket(n);
                        log.trace("Tunnel server started on port " + n);
                    }
                    BTunnelService.this.setStatus(BStatus.ok);
                }
                catch (Exception exception) {
                    BTunnelService.this.setStatus(BStatus.fault);
                    log.error("Cannot create server socket", (Throwable)exception);
                    BTunnelService.this.alive = false;
                    Object object = BTunnelService.this.mutex;
                    synchronized (object) {
                        BTunnelService.this.mutex.notifyAll();
                    }
                    BTunnelService.this.server = null;
                    return;
                }
                try {
                    Socket socket = this.srvr.accept();
                    try {
                        socket.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {}
                    log.trace("Request received: " + socket.getInetAddress().getHostAddress());
                    BTunnelService.this.enqueue(socket);
                }
                catch (Exception exception) {
                    if (!BTunnelService.this.alive) continue;
                    log.error("Server socket accept", (Throwable)exception);
                }
            }
            log.trace("Tunnel server stopped.");
        }

        public Server() {
            super("Tunnel Server");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ServiceThread
    extends Thread {
        public void run() {
            Socket socket;
            while ((socket = BTunnelService.this.dequeue()) != null) {
                BTunnelService.this.process(socket);
            }
            return;
        }

        public ServiceThread() {
            super("Tunnel Service Thread");
        }
    }
}

