/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelService;
import com.tridium.tunnel.TunnelConst;
import com.tridium.tunnel.TunnelInputStream;
import com.tridium.tunnel.TunnelOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.baja.io.ByteBuffer;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTunnelConnection
extends BComponent
implements Context,
TunnelConst {
    public static final Property established = BTunnelConnection.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property userName = BTunnelConnection.newProperty((int)3, (String)"", null);
    public static final Property remoteHost = BTunnelConnection.newProperty((int)3, (String)"", null);
    public static final Property protocolVersion = BTunnelConnection.newProperty((int)3, (int)1, null);
    public static final Property lastRead = BTunnelConnection.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastWrite = BTunnelConnection.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Action disconnect = BTunnelConnection.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private boolean connected;
    private DataInputStream in;
    private DataOutputStream out;
    private ByteBuffer readBuffer;
    private BTunnelService service;
    private Socket socket;
    private String string;
    private BTunnel tunnel;
    private BUser user;
    private Object writeMutex;
    static /* synthetic */ Class class$com$tridium$tunnel$BTunnelConnection;

    public BAbsTime getEstablished() {
        return (BAbsTime)this.get(established);
    }

    public void setEstablished(BAbsTime bAbsTime) {
        this.set(established, (BValue)bAbsTime, null);
    }

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String string) {
        this.setString(userName, string, null);
    }

    public String getRemoteHost() {
        return this.getString(remoteHost);
    }

    public void setRemoteHost(String string) {
        this.setString(remoteHost, string, null);
    }

    public int getProtocolVersion() {
        return this.getInt(protocolVersion);
    }

    public void setProtocolVersion(int n) {
        this.setInt(protocolVersion, n, null);
    }

    public BAbsTime getLastRead() {
        return (BAbsTime)this.get(lastRead);
    }

    public void setLastRead(BAbsTime bAbsTime) {
        this.set(lastRead, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastWrite() {
        return (BAbsTime)this.get(lastWrite);
    }

    public void setLastWrite(BAbsTime bAbsTime) {
        this.set(lastWrite, (BValue)bAbsTime, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int bytesAvailable() throws IOException {
        if (!this.connected) {
            return -1;
        }
        return this.readBuffer.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDisconnect() {
        if (!this.connected) {
            return;
        }
        Object object = this.writeMutex;
        synchronized (object) {
            try {
                this.out.write(TunnelConst.MAGIC);
                this.out.write(23);
                this.out.flush();
            }
            catch (Exception exception) {}
            this.hardDisconnect();
            return;
        }
    }

    public Context getBase() {
        return null;
    }

    public BObject getFacet(String string) {
        return null;
    }

    public BFacets getFacets() {
        return BFacets.DEFAULT;
    }

    public BIcon getIcon() {
        return icon;
    }

    public String getLanguage() {
        return this.getUser().getLanguage();
    }

    public InputStream getInputStream() {
        return new TunnelInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new TunnelOutputStream(this);
    }

    public BTunnelService getService() {
        return this.service;
    }

    public BTunnel getTunnel() {
        return this.tunnel;
    }

    public BUser getUser() {
        return this.user;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BTunnel;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        if (var2_2 < 0 || var2_2 > var1_1.length || var3_3 < 0 || var2_2 + var3_3 > var1_1.length || var2_2 + var3_3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (var3_3 != 0) ** GOTO lbl8
        return 0;
lbl-1000:
        // 1 sources

        {
            this.readMsg();
lbl8:
            // 2 sources

            ** while (this.connected && this.readBuffer.available() == 0)
        }
lbl9:
        // 1 sources

        if (this.readBuffer.available() > 0) {
            var4_4 = this.readBuffer.read(var1_1, var2_2, var3_3);
            if (this.readBuffer.available() == 0) {
                this.readBuffer.reset();
            }
            return var4_4;
        }
        return -1;
    }

    public String toString(Context context) {
        if (this.string == null) {
            this.string = this.getEstablished().toString();
        }
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected.");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.writeMutex;
        synchronized (object) {
            this.out.write(TunnelConst.MAGIC);
            this.out.write(11);
            this.out.writeInt(n2);
            this.out.write(byArray, n, n2);
            this.out.flush();
            this.setLastWrite(Clock.time());
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.hardDisconnect();
        super.finalize();
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void hardDisconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.service.removeConnection(this);
        try {
            this.in.close();
        }
        catch (Exception exception) {}
        try {
            this.out.close();
        }
        catch (Exception exception) {}
        try {
            this.socket.close();
        }
        catch (Exception exception) {}
        this.tunnel.removeConnection(this);
        this.tunnel.sessionClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendPing() {
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(TunnelConst.MAGIC);
                this.out.write(19);
                this.setLastWrite(Clock.time());
                this.out.flush();
                return;
            }
        }
        catch (IOException iOException) {
            BTunnelService.log.error(this.toString() + " sending ping.", (Throwable)iOException);
            this.disconnect();
        }
    }

    private final void readMsg() {
        block8: {
            try {
                if (this.in.read() != TunnelConst.MAGIC[0] || this.in.read() != TunnelConst.MAGIC[1] || this.in.read() != TunnelConst.MAGIC[2] || this.in.read() != TunnelConst.MAGIC[3]) {
                    BTunnelService.log.error(this.toString() + " invalid magic.");
                    this.disconnect();
                    return;
                }
                int n = this.in.read();
                this.setLastRead(Clock.time());
                switch (n) {
                    case 11: {
                        BTunnelService.log.trace(this.toString() + " recv data.");
                        int n2 = this.in.readInt();
                        this.readBuffer.readFrom((InputStream)this.in, n2);
                        break;
                    }
                    case 19: {
                        BTunnelService.log.trace(this.toString() + " recv ping.");
                        break;
                    }
                    case 23: {
                        BTunnelService.log.trace(this.toString() + " recv disconnect.");
                        this.disconnect();
                        break;
                    }
                    default: {
                        BTunnelService.log.error(this.toString() + " unexpected message: " + n);
                        this.disconnect();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.connected) break block8;
                BTunnelService.log.error(this.toString(), (Throwable)exception);
                this.disconnect();
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.connected = true;
        this.readBuffer = new ByteBuffer();
        this.writeMutex = new Object();
    }

    public BTunnelConnection() {
        this.this();
    }

    BTunnelConnection(BUser bUser, DataInputStream dataInputStream, DataOutputStream dataOutputStream, Socket socket, BTunnel bTunnel, BTunnelService bTunnelService) {
        this.this();
        this.user = bUser;
        this.in = dataInputStream;
        this.out = dataOutputStream;
        this.socket = socket;
        this.tunnel = bTunnel;
        this.service = bTunnelService;
    }

    static {
        Class clazz = class$com$tridium$tunnel$BTunnelConnection;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BTunnelConnection = BTunnelConnection.class("[Lcom.tridium.tunnel.BTunnelConnection;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
    }
}

