/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.BTunnelService;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BTunnel
extends BComponent
implements BIStatus {
    public static final Property enabled = BTunnel.newProperty((int)0, (boolean)true, null);
    public static final Property connections = BTunnel.newProperty((int)67, (int)0, null);
    public static final Property status = BTunnel.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Action disconnectAll = BTunnel.newAction((int)16, null);
    public static final Type TYPE;
    private boolean engaged;
    static /* synthetic */ Class class$com$tridium$tunnel$BTunnel;
    static /* synthetic */ Class class$com$tridium$tunnel$BTunnelConnection;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public int getConnections() {
        return this.getInt(connections);
    }

    public void setConnections(int n) {
        this.setInt(connections, n, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public void disconnectAll() {
        this.invoke(disconnectAll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && property == enabled) {
            this.update();
        }
        super.changed(property, context);
    }

    public void doDisconnectAll() {
        Class clazz = class$com$tridium$tunnel$BTunnelConnection;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BTunnelConnection = BTunnel.class("[Lcom.tridium.tunnel.BTunnelConnection;", false);
        }
        BTunnelConnection[] bTunnelConnectionArray = (BTunnelConnection[])this.getChildren(clazz);
        int n = bTunnelConnectionArray.length;
        while (--n >= 0) {
            bTunnelConnectionArray[n].disconnect();
        }
    }

    public BTunnelConnection[] getTunnelConnectionsArray() {
        Class clazz = class$com$tridium$tunnel$BTunnelConnection;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BTunnelConnection = BTunnel.class("[Lcom.tridium.tunnel.BTunnelConnection;", false);
        }
        BTunnelConnection[] bTunnelConnectionArray = (BTunnelConnection[])this.getChildren(clazz);
        return bTunnelConnectionArray;
    }

    public BIcon getIcon() {
        return BTunnelService.icon;
    }

    public abstract String getIdentifier();

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent instanceof BTunnelConnection;
    }

    public abstract void service(BTunnelConnection var1) throws IOException;

    public abstract void sessionClosed(BTunnelConnection var1);

    public void started() throws Exception {
        super.started();
        this.update();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.unregister();
    }

    public abstract boolean supportsConcurrentConnections();

    protected void update() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.unregister();
            this.disconnectAll();
        } else {
            this.setStatus(BStatus.ok);
            this.register();
        }
    }

    protected void register() {
        if (this.engaged) {
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        try {
            BTunnelService bTunnelService = (BTunnelService)Sys.getService((Type)BTunnelService.TYPE);
            bTunnelService.register(this);
            this.engaged = true;
        }
        catch (Exception exception) {
            this.setStatus(BStatus.fault);
            Log.getLog((String)SlotPath.unescape((String)this.toPathString())).error(this.toPathString(), (Throwable)exception);
        }
    }

    protected void unregister() {
        if (!this.engaged) {
            return;
        }
        try {
            BTunnelService bTunnelService = (BTunnelService)Sys.getService((Type)BTunnelService.TYPE);
            bTunnelService.unregister(this);
            this.engaged = false;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addConnection(BTunnelConnection bTunnelConnection) {
        BTunnel bTunnel = this;
        synchronized (bTunnel) {
            this.setConnections(this.getConnections() + 1);
        }
        this.add(SlotPath.escape((String)(bTunnelConnection.getRemoteHost() + "#1")) + '?', (BValue)bTunnelConnection, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeConnection(BTunnelConnection bTunnelConnection) {
        BTunnel bTunnel = this;
        synchronized (bTunnel) {
            this.setConnections(this.getConnections() - 1);
        }
        this.remove((BComplex)bTunnelConnection);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.engaged = false;
    }

    public BTunnel() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$tunnel$BTunnel;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BTunnel = BTunnel.class("[Lcom.tridium.tunnel.BTunnel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

