/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.TunnelConst;
import com.tridium.tunnel.TunnelUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTestClient
extends BComponent
implements TunnelConst {
    public static final Property tunnelName = BTestClient.newProperty((int)0, (String)"test", null);
    public static final Property tunnelServer = BTestClient.newProperty((int)0, (String)"127.0.0.1", null);
    public static final Property tunnelUserName = BTestClient.newProperty((int)0, (String)"admin", null);
    public static final Property tunnelPassword = BTestClient.newProperty((int)0, (String)"", null);
    public static final Property lastRead = BTestClient.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastWrite = BTestClient.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property txData = BTestClient.newProperty((int)0, (String)"do do do de da da da", null);
    public static final Property rxData = BTestClient.newProperty((int)0, (String)"", null);
    public static final Action connect = BTestClient.newAction((int)16, null);
    public static final Action sendData = BTestClient.newAction((int)16, null);
    public static final Action disconnect = BTestClient.newAction((int)16, null);
    public static final Action pingConnections = BTestClient.newAction((int)20, null);
    public static final Type TYPE;
    private Object writeMutex;
    private Clock.Ticket pingTicket;
    DataInputStream in;
    DataOutputStream out;
    static /* synthetic */ Class class$com$tridium$tunnel$BTestClient;

    public String getTunnelName() {
        return this.getString(tunnelName);
    }

    public void setTunnelName(String string) {
        this.setString(tunnelName, string, null);
    }

    public String getTunnelServer() {
        return this.getString(tunnelServer);
    }

    public void setTunnelServer(String string) {
        this.setString(tunnelServer, string, null);
    }

    public String getTunnelUserName() {
        return this.getString(tunnelUserName);
    }

    public void setTunnelUserName(String string) {
        this.setString(tunnelUserName, string, null);
    }

    public String getTunnelPassword() {
        return this.getString(tunnelPassword);
    }

    public void setTunnelPassword(String string) {
        this.setString(tunnelPassword, string, null);
    }

    public BAbsTime getLastRead() {
        return (BAbsTime)this.get(lastRead);
    }

    public void setLastRead(BAbsTime bAbsTime) {
        this.set(lastRead, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastWrite() {
        return (BAbsTime)this.get(lastWrite);
    }

    public void setLastWrite(BAbsTime bAbsTime) {
        this.set(lastWrite, (BValue)bAbsTime, null);
    }

    public String getTxData() {
        return this.getString(txData);
    }

    public void setTxData(String string) {
        this.setString(txData, string, null);
    }

    public String getRxData() {
        return this.getString(rxData);
    }

    public void setRxData(String string) {
        this.setString(rxData, string, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void sendData() {
        this.invoke(sendData, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void pingConnections() {
        this.invoke(pingConnections, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property == txData && this.out != null) {
            this.doSendData();
        }
    }

    public void doConnect() {
        System.out.println("doConnect()");
        try {
            boolean bl = false;
            Socket socket = new Socket(InetAddress.getByName(this.getTunnelServer()), 9973);
            this.in = new DataInputStream(socket.getInputStream());
            this.out = new DataOutputStream(socket.getOutputStream());
            this.out.write(TunnelConst.MAGIC);
            this.out.write(13);
            this.out.write(1);
            String string = this.getTunnelUserName();
            byte[] byArray = string.getBytes("UTF-8");
            this.out.writeInt(byArray.length);
            this.out.write(byArray);
            string = this.getTunnelPassword();
            byArray = string.getBytes("UTF-8");
            this.out.writeInt(byArray.length);
            this.out.write(byArray);
            string = this.getTunnelName();
            System.out.println("requesting tunnel: " + string);
            byArray = string.getBytes("UTF-8");
            this.out.writeInt(byArray.length);
            this.out.write(byArray);
            int n = 0;
            while (n != 23 && n != 37 && !bl) {
                n = 0;
                n = TunnelUtils.readMessage(this.in, "client");
                this.setLastRead(Clock.time());
                System.out.println("doConnect() 9");
                switch (n) {
                    case 11: {
                        System.out.println("MSG_DATA");
                        int n2 = this.in.readInt();
                        System.out.println("rec length=" + n2);
                        byte[] byArray2 = new byte[n2];
                        this.in.readFully(byArray2);
                        this.setRxData(new String(byArray2));
                        System.out.println("***************");
                        System.out.println(new String(byArray2));
                        break;
                    }
                    case 13: {
                        System.out.println("MSG_HELLO");
                        break;
                    }
                    case 17: {
                        System.out.println("MSG_READY");
                        this.startPing();
                        break;
                    }
                    case 19: {
                        System.out.println("MSG_PING");
                        break;
                    }
                    case 23: {
                        System.out.println("MSG_DISCONNECT");
                        this.stopPing();
                        break;
                    }
                    case 29: {
                        System.out.println("MSG_AUTH_FAIL");
                        break;
                    }
                    case 31: {
                        System.out.println("MSG_UNKNOWN_TUNNEL");
                        break;
                    }
                    case 37: {
                        System.out.println("MSG_TUNNEL_BUSY");
                        break;
                    }
                    case 41: {
                        System.out.println("MSG_UNSUPPORTED_PROTOCOL_VERSION");
                        break;
                    }
                    case 43: {
                        System.out.println("MSG_EXPECTING_HELLO");
                        break;
                    }
                    default: {
                        System.out.println("received message type illegal: " + n);
                        byte[] byArray3 = new byte[1024];
                        try {
                            if (this.in.available() > 0) {
                                this.in.readFully(byArray3);
                                System.out.println("junkBytes:" + ByteArrayUtil.toHexString((byte[])byArray3));
                            }
                        }
                        catch (SocketException socketException) {
                            System.out.println("no msgType match 1: " + socketException);
                            bl = true;
                            break;
                        }
                        catch (Exception exception) {
                            System.out.println("n0 msgTypeMatch 2:" + exception);
                            exception.printStackTrace();
                        }
                        bl = true;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    System.out.println("thread sleep exception:" + exception);
                    break;
                }
            }
            System.out.println("closing socket");
            socket.close();
            this.stopPing();
        }
        catch (Exception exception) {
            System.out.println("doConnect exception:" + exception);
            exception.printStackTrace();
            this.stopPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSendData() {
        System.out.println("doSendData()");
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(TunnelConst.MAGIC);
                this.out.write(11);
                String string = this.getTxData();
                if (!string.startsWith("&")) {
                    string = string + '\n';
                }
                byte[] byArray = string.getBytes();
                this.out.writeInt(byArray.length);
                this.out.write(byArray, 0, byArray.length);
                System.out.println("   length=" + byArray.length);
                System.out.println("   data  =" + byArray);
                this.setLastWrite(Clock.time());
                this.out.flush();
                return;
            }
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDisconnect() {
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(TunnelConst.MAGIC);
                this.out.write(23);
                this.out.flush();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        this.stopPing();
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == connect) {
            new Thread(){

                public final void run() {
                    BTestClient.this.doConnect();
                }
            }.start();
            return null;
        }
        return super.post(action, bValue, context);
    }

    protected void startPing() {
        System.out.println("startPing()");
        if (this.pingTicket != null) {
            return;
        }
        this.pingTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)15000L), (Action)pingConnections, null);
    }

    protected void stopPing() {
        System.out.println("stopPing()");
        if (this.pingTicket == null) {
            return;
        }
        this.pingTicket.cancel();
        this.pingTicket = null;
    }

    public void doPingConnections() {
        System.out.println("doPingConnections()");
        long l = System.currentTimeMillis();
        if (this.getLastRead().getMillis() + 60000L < l) {
            System.out.println("Disconnecting idle connection ");
            this.disconnect();
        } else if (this.getLastWrite().getMillis() + 15000L < l) {
            this.sendPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendPing() {
        System.out.println("sendPing()");
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(TunnelConst.MAGIC);
                this.out.write(19);
                this.setLastWrite(Clock.time());
                this.out.flush();
                return;
            }
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.writeMutex = new Object();
    }

    public BTestClient() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$tunnel$BTestClient;
        if (clazz == null) {
            clazz = class$com$tridium$tunnel$BTestClient = BTestClient.class("[Lcom.tridium.tunnel.BTestClient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

