/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import javax.baja.history.ext.BActivePeriod;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTimeRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBasicActivePeriod
extends BActivePeriod {
    public static final Property daysOfWeek = BBasicActivePeriod.newProperty((int)0, (BValue)BDaysOfWeekBits.ALL, null);
    public static final Property timeRange = BBasicActivePeriod.newProperty((int)0, (BValue)new BTimeRange(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$history$ext$BBasicActivePeriod;

    public final BDaysOfWeekBits getDaysOfWeek() {
        return (BDaysOfWeekBits)this.get(daysOfWeek);
    }

    public final void setDaysOfWeek(BDaysOfWeekBits bDaysOfWeekBits) {
        this.set(daysOfWeek, (BValue)bDaysOfWeekBits, null);
    }

    public final BTimeRange getTimeRange() {
        return (BTimeRange)this.get(timeRange);
    }

    public final void setTimeRange(BTimeRange bTimeRange) {
        this.set(timeRange, (BValue)bTimeRange, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isAlwaysActive() {
        boolean bl = false;
        if (this.getDaysOfWeek().isEveryDay() && this.getTimeRange().isAllDay()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNeverActive() {
        return this.getDaysOfWeek().isEmpty();
    }

    public final BAbsTime getActiveStart(BAbsTime bAbsTime) {
        if (!this.isActive(bAbsTime)) {
            return null;
        }
        if (this.isAlwaysActive()) {
            return BAbsTime.make((BAbsTime)bAbsTime, (BTime)BTime.make((int)0, (int)0, (int)0, (int)0));
        }
        return BAbsTime.make((BAbsTime)bAbsTime, (BTime)this.getTimeRange().getStartTime());
    }

    public final BAbsTime getActiveEnd(BAbsTime bAbsTime) {
        if (!this.isActive(bAbsTime)) {
            return null;
        }
        if (this.isAlwaysActive()) {
            return null;
        }
        BTime bTime = this.getTimeRange().getEndTime();
        if (bTime.getTimeOfDayMillis() == 0L) {
            bAbsTime = bAbsTime.nextDay();
        }
        return BAbsTime.make((BAbsTime)bAbsTime, (BTime)bTime);
    }

    public final BAbsTime getNextActive(BAbsTime bAbsTime) {
        if (this.isAlwaysActive()) {
            return null;
        }
        if (this.isNeverActive()) {
            return null;
        }
        BDaysOfWeekBits bDaysOfWeekBits = this.getDaysOfWeek();
        BTimeRange bTimeRange = this.getTimeRange();
        if (this.getDaysOfWeek().includes(bAbsTime) && BTime.make((BAbsTime)bAbsTime).isBefore(bTimeRange.getStartTime())) {
            return BAbsTime.make((BAbsTime)bAbsTime, (BTime)bTimeRange.getStartTime());
        }
        BAbsTime bAbsTime2 = bAbsTime.nextDay();
        while (!bDaysOfWeekBits.includes(bAbsTime2.getWeekday())) {
            bAbsTime2 = bAbsTime2.nextDay();
        }
        return BAbsTime.make((BAbsTime)bAbsTime2, (BTime)bTimeRange.getStartTime());
    }

    public final BAbsTime getNextInactive(BAbsTime bAbsTime) {
        if (this.isAlwaysActive()) {
            return null;
        }
        if (this.isNeverActive()) {
            return null;
        }
        BDaysOfWeekBits bDaysOfWeekBits = this.getDaysOfWeek();
        BTimeRange bTimeRange = this.getTimeRange();
        if (bDaysOfWeekBits.includes(bAbsTime)) {
            long l = bTimeRange.getEndTime().getTimeOfDayMillis();
            if (l == 0L) {
                return BAbsTime.make((BAbsTime)bAbsTime.nextDay(), (BTime)bTimeRange.getEndTime());
            }
            long l2 = bAbsTime.getTimeOfDayMillis();
            if (l2 < l) {
                return BAbsTime.make((BAbsTime)bAbsTime, (BTime)bTimeRange.getEndTime());
            }
        }
        BAbsTime bAbsTime2 = bAbsTime.nextDay();
        while (!bDaysOfWeekBits.includes(bAbsTime2.getWeekday())) {
            bAbsTime2 = bAbsTime2.nextDay();
        }
        BTime bTime = bTimeRange.getEndTime();
        if (bTime.getTimeOfDayMillis() == 0L) {
            bAbsTime2 = bAbsTime2.nextDay();
        }
        return BAbsTime.make((BAbsTime)bAbsTime2, (BTime)bTimeRange.getEndTime());
    }

    public final boolean isActive(BAbsTime bAbsTime) {
        BTimeRange bTimeRange;
        if (!this.getDaysOfWeek().includes(bAbsTime.getWeekday())) {
            return false;
        }
        return !(this.getTimeRange().getStartTime().isAfter(this.getTimeRange().getEndTime()) ? (bTimeRange = new BTimeRange(this.getTimeRange().getEndTime(), this.getTimeRange().getStartTime())).includes(bAbsTime) : !this.getTimeRange().includes(bAbsTime));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBasicActivePeriod() {
    }

    public BBasicActivePeriod(BDaysOfWeekBits bDaysOfWeekBits, BTimeRange bTimeRange) {
        this.setDaysOfWeek(bDaysOfWeekBits);
        this.setTimeRange(bTimeRange);
    }

    static {
        Class clazz = class$javax$baja$history$ext$BBasicActivePeriod;
        if (clazz == null) {
            clazz = class$javax$baja$history$ext$BBasicActivePeriod = BBasicActivePeriod.class("[Ljavax.baja.history.ext.BBasicActivePeriod;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

