/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.db;

import com.tridium.bql.collection.BFilteredCollection;
import com.tridium.history.HistoryConfigChange;
import com.tridium.history.HistoryConfigChanges;
import com.tridium.history.db.BSysHistories;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.bql.BIRelational;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.DatabaseClosedException;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.InvalidHistoryIdException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHistoryDatabase
extends BHistorySpace
implements BIRelational {
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    static final Log eventLogger;
    private boolean open;
    private ArrayList listeners;
    static /* synthetic */ Class class$javax$baja$history$db$BHistoryDatabase;
    static /* synthetic */ Class class$javax$baja$history$BIHistory;

    public Type getType() {
        return TYPE;
    }

    public BITable getRelation(String string) {
        BITable bITable;
        if (string.startsWith("sys.") && (bITable = this.getSystemTable(string)) != null) {
            return bITable;
        }
        bITable = BOrd.make((OrdQuery)new HistoryQuery(string));
        try {
            BObject bObject = bITable.get((BObject)this);
            if (bObject instanceof BITable) {
                return (BITable)bObject;
            }
            if (bObject instanceof BICollection) {
                return ((BICollection)bObject).toTable();
            }
            throw new IllegalStateException("Unexpected type " + bObject.getType());
        }
        catch (UnresolvedException unresolvedException) {
            return null;
        }
    }

    public BICollection filter(IFilter iFilter) {
        return new BFilteredCollection((BICollection)this, iFilter);
    }

    public int getFlags(int n, Column column) {
        return 0;
    }

    public BFacets getFacets(int n, Column column) {
        return BFacets.NULL;
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws DatabaseClosedException {
        if (!this.open) {
            throw new DatabaseClosedException("The requested operation is not allowed while the database is closed.");
        }
    }

    public final synchronized void open() throws IOException {
        if (this.open) {
            return;
        }
        this.doOpen();
        this.open = true;
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDbOpened());
        }
    }

    protected abstract void doOpen() throws IOException;

    public final void close() {
        if (!this.open) {
            return;
        }
        this.doClose();
        this.open = false;
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDbClosed());
        }
    }

    protected abstract void doClose();

    public void flush() throws IOException, HistoryException {
        if (!this.open) {
            return;
        }
        this.doFlush();
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDbFlushed());
        }
    }

    protected abstract void doFlush();

    public String getDeviceName() {
        return Sys.getStation().getStationName();
    }

    public abstract void setConfig(BHistoryConfig var1);

    public final void deleteHistory(BHistoryId bHistoryId, Context context) {
        this.doDeleteHistory(bHistoryId, context);
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDeleted(bHistoryId));
        }
        BOrd bOrd = BOrd.make((String)("local:|history:/" + bHistoryId.getDeviceName()));
        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)bOrd, (String)bHistoryId.getHistoryName(), null));
    }

    public abstract void doDeleteHistory(BHistoryId var1, Context var2);

    public void deleteHistories(BOrd[] bOrdArray, Context context) {
        int n = 0;
        while (n < bOrdArray.length) {
            Cursor cursor = this.getHistoryIds(bOrdArray[n]);
            while (cursor.next()) {
                BHistoryId bHistoryId = (BHistoryId)cursor.get();
                this.deleteHistory(bHistoryId, context);
            }
            ++n;
        }
    }

    public final void renameHistory(BHistoryId bHistoryId, String string) {
        this.doRenameHistory(bHistoryId, string);
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeRenamed(bHistoryId, string));
        }
        BOrd bOrd = BOrd.make((String)("local:|history:/" + bHistoryId.getDeviceName()));
        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRenamed((BOrd)bOrd, (String)bHistoryId.getHistoryName(), (String)string, null));
    }

    public abstract void doRenameHistory(BHistoryId var1, String var2);

    public abstract void clearAllRecords(BHistoryId var1, Context var2);

    public void clearAllRecords(BOrd[] bOrdArray, Context context) {
        int n = 0;
        while (n < bOrdArray.length) {
            Cursor cursor = this.getHistoryIds(bOrdArray[n]);
            while (cursor.next()) {
                BHistoryId bHistoryId = (BHistoryId)cursor.get();
                this.clearAllRecords(bHistoryId, context);
            }
            ++n;
        }
    }

    public abstract void clearOldRecords(BHistoryId var1, BAbsTime var2, Context var3);

    public void clearOldRecords(BOrd[] bOrdArray, BAbsTime bAbsTime, Context context) throws HistoryException {
        int n = 0;
        while (n < bOrdArray.length) {
            Cursor cursor = this.getHistoryIds(bOrdArray[n]);
            while (cursor.next()) {
                BHistoryId bHistoryId = (BHistoryId)cursor.get();
                this.clearOldRecords(bHistoryId, bAbsTime, context);
            }
            ++n;
        }
    }

    public final void createHistory(BHistoryConfig bHistoryConfig) throws HistoryException {
        BOrd bOrd;
        this.checkOpen();
        if (this.exists(bHistoryConfig.getId())) {
            throw new DuplicateHistoryException(bHistoryConfig.getId());
        }
        boolean bl = this.deviceExists(bHistoryConfig.getId().getDeviceName());
        this.doCreateHistory(bHistoryConfig);
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeCreated(bHistoryConfig.getId(), bHistoryConfig));
        }
        if (!bl) {
            bOrd = BOrd.make((String)"local:|history:");
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)bOrd, (String)bHistoryConfig.getId().getDeviceName(), null));
        }
        bOrd = BOrd.make((String)("local:|history:/" + bHistoryConfig.getId().getDeviceName()));
        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)bOrd, (String)bHistoryConfig.getId().getHistoryName(), null));
    }

    protected abstract void doCreateHistory(BHistoryConfig var1);

    public abstract void recreateHistory(BHistoryConfig var1, boolean var2);

    public abstract void resizeHistory(BHistoryId var1, BCapacity var2, BFullPolicy var3);

    public void reconfigureHistory(BHistoryConfig bHistoryConfig) {
        if (!this.isOpen()) {
            return;
        }
        BHistoryId bHistoryId = bHistoryConfig.getId();
        BHistoryConfig bHistoryConfig2 = this.getConfig(bHistoryId);
        if (bHistoryConfig2 == null) {
            return;
        }
        HistoryConfigChanges historyConfigChanges = HistoryConfigChanges.compare(bHistoryConfig2, bHistoryConfig);
        if (historyConfigChanges.getChangeCount() == 0) {
            return;
        }
        BHistoryConfig bHistoryConfig3 = (BHistoryConfig)bHistoryConfig.newCopy(true);
        if (!bHistoryConfig.isMounted()) {
            HistoryConfigChanges.addMissingMetadata(bHistoryConfig2, bHistoryConfig3, historyConfigChanges);
        }
        HistoryConfigChange historyConfigChange = historyConfigChanges.get("recordType");
        BIHistory bIHistory = null;
        if (historyConfigChange != null) {
            log.trace((Object)((Object)bHistoryId) + ": recordType changed, recreating history");
            bIHistory = this.getHistory(bHistoryId);
            if (bIHistory != null && bIHistory.getRecordCount() != 0) {
                this.recreateHistory(bHistoryConfig3, true);
                return;
            }
        }
        if ((historyConfigChange = historyConfigChanges.get("interval")) != null) {
            log.trace((Object)((Object)bHistoryId) + ": interval changed, recreating history");
            if (bIHistory == null) {
                bIHistory = this.getHistory(bHistoryId);
            }
            if (bIHistory != null && bIHistory.getRecordCount() != 0) {
                this.recreateHistory(bHistoryConfig3, true);
                return;
            }
        }
        if ((historyConfigChange = historyConfigChanges.get("capacity")) != null) {
            log.trace((Object)((Object)bHistoryId) + ": capacity changed, resizing history");
            this.resizeHistory(bHistoryId, bHistoryConfig3.getCapacity(), bHistoryConfig3.getFullPolicy());
        }
        this.setConfig(bHistoryConfig3);
    }

    public BITable getSystemTable(String string) {
        if (string.equalsIgnoreCase("sys.histories")) {
            return new BSysHistories(this);
        }
        return null;
    }

    private final void validateConfig(BHistoryConfig bHistoryConfig) throws HistoryException {
        if (!bHistoryConfig.getId().isValid()) {
            throw new InvalidHistoryIdException(bHistoryConfig.getId());
        }
    }

    public BIHistory[] getHistories() {
        this.checkOpen();
        Class clazz = class$javax$baja$history$BIHistory;
        if (clazz == null) {
            clazz = class$javax$baja$history$BIHistory = BHistoryDatabase.class("[Ljavax.baja.history.BIHistory;", false);
        }
        Array array = new Array(clazz);
        BHistoryDevice[] bHistoryDeviceArray = this.listDevices();
        int n = 0;
        while (n < bHistoryDeviceArray.length) {
            BHistoryDevice bHistoryDevice = bHistoryDeviceArray[n];
            BHistorySpace bHistorySpace = (BHistorySpace)bHistoryDevice.getSpace();
            array.addAll((Object[])bHistorySpace.listHistories(bHistoryDevice));
            ++n;
        }
        return (BIHistory[])array.trim();
    }

    public boolean hasHistoryEventListeners() {
        boolean bl = false;
        if (this.listeners.size() > 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryEventListener[] getHistoryEventListeners() {
        HistoryEventListener[] historyEventListenerArray = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.toArray(new HistoryEventListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHistoryEventListener(HistoryEventListener historyEventListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = 0;
            while (true) {
                if (n >= this.listeners.size()) {
                    this.listeners.add(historyEventListener);
                    return;
                }
                if (this.listeners.get(n) == historyEventListener) {
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeHistoryEventListener(HistoryEventListener historyEventListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.listeners.size()) {
                if (this.listeners.get(n) == historyEventListener) {
                    this.listeners.remove(n);
                    break;
                }
                ++n;
            }
            return;
        }
    }

    public void fireHistoryEvent(BHistoryEvent bHistoryEvent) {
        if (eventLogger.isTraceOn()) {
            eventLogger.trace(bHistoryEvent.toString());
        }
        HistoryEventListener[] historyEventListenerArray = this.getHistoryEventListeners();
        int n = 0;
        while (n < historyEventListenerArray.length) {
            try {
                historyEventListenerArray[n].historyEvent(bHistoryEvent);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.open = false;
        this.listeners = new ArrayList();
    }

    public BHistoryDatabase() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$history$db$BHistoryDatabase;
        if (clazz == null) {
            clazz = class$javax$baja$history$db$BHistoryDatabase = BHistoryDatabase.class("[Ljavax.baja.history.db.BHistoryDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"historyDatabase.png");
        log = Log.getLog((String)"history.db");
        eventLogger = Log.getLog((String)"history.event");
    }
}

