/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.history.BDataRecoveryHistoryRecorder;
import com.tridium.history.BHistoryExtStatusJob;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.log.BLogHistoryService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.sys.station.Station;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.baja.agent.AgentFilter;
import javax.baja.collection.BICollection;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySourceService;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryGroup;
import javax.baja.history.BHistoryGroupings;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryService
extends BComponent
implements BIService,
BIDataRecoverySourceService {
    public static final Property maxOpenTime = BHistoryService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property historyGroupings = BHistoryService.newProperty((int)0, (BValue)new BHistoryGroupings(), null);
    public static final Action saveDb = BHistoryService.newAction((int)0, null);
    public static final Action closeUnusedHistories = BHistoryService.newAction((int)16, null);
    public static final Action enableExtensions = BHistoryService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action disableExtensions = BHistoryService.newAction((int)4, (BValue)new BVector(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final int ADD_TO_CACHE = 0;
    private static final int GET_FROM_CACHE = 1;
    public static Log logger;
    private static Type[] serviceTypes;
    private boolean serviceStarted;
    private boolean dbOpen;
    private boolean dbInitialized;
    private BIDataRecoveryService dataRecoveryService;
    private BDataRecoveryHistoryRecorder recorder;
    private ServiceListener serviceListener;
    private BHistoryDatabase db;
    private Clock.Ticket closeTicket;
    private long lastClose;
    private HashMap reportCache;
    private Random rand;
    private Station.SaveListener saveListener;
    private Queue cuhQueue;
    private CloseUnusedHistoriesWorker cuhWorker;
    static /* synthetic */ Class class$javax$baja$history$BHistoryService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$history$BHistoryGroup;

    public BRelTime getMaxOpenTime() {
        return (BRelTime)this.get(maxOpenTime);
    }

    public void setMaxOpenTime(BRelTime bRelTime) {
        this.set(maxOpenTime, (BValue)bRelTime, null);
    }

    public BHistoryGroupings getHistoryGroupings() {
        return (BHistoryGroupings)this.get(historyGroupings);
    }

    public void setHistoryGroupings(BHistoryGroupings bHistoryGroupings) {
        this.set(historyGroupings, (BValue)bHistoryGroupings, null);
    }

    public void saveDb() {
        this.invoke(saveDb, null, null);
    }

    public void closeUnusedHistories() {
        this.invoke(closeUnusedHistories, null, null);
    }

    public BOrd enableExtensions(BVector bVector) {
        return (BOrd)this.invoke(enableExtensions, (BValue)bVector, null);
    }

    public BOrd disableExtensions(BVector bVector) {
        return (BOrd)this.invoke(disableExtensions, (BValue)bVector, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BHistoryDatabase getDatabase() {
        if (!this.dbOpen) {
            return null;
        }
        return this.db;
    }

    protected BHistoryDatabase createDatabase() {
        return new BLocalHistoryDatabase(this);
    }

    public synchronized void initDataRecoverySource(BIDataRecoveryService bIDataRecoveryService) {
        block9: {
            if (this.dbInitialized) {
                return;
            }
            this.dbInitialized = true;
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (bSystemPlatformService != null && bSystemPlatformService.archiveEnabled("history")) {
                bSystemPlatformService.extractArchive("history");
            }
            try {
                this.db = this.createDatabase();
                this.db.open();
                if (bIDataRecoveryService == null) break block9;
                try {
                    this.recorder = (BDataRecoveryHistoryRecorder)this.db.getAgents().filter(AgentFilter.is((Type)BDataRecoveryHistoryRecorder.TYPE)).getDefault().getInstance();
                }
                catch (Exception exception) {}
                if (this.recorder != null) {
                    this.db.fw(1002, this.recorder, null, null, null);
                    this.recorder.setDataRecoveryService(bIDataRecoveryService);
                    this.recorder.setHistorySpace(this.db);
                    try {
                        this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
        BLocalHost.INSTANCE.addNavChild((BINavNode)this.db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void serviceStarted() {
        this.initDataRecoverySource(this.getDataRecoveryService());
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        if (this.db != null && this.recorder != null) {
            ServiceListener serviceListener = this.serviceListener;
            synchronized (serviceListener) {
                this.db.addHistoryEventListener(this.recorder);
            }
        }
        this.dbOpen = true;
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        Nre.serviceManager.addServiceListener(this.serviceListener);
        if (this.db instanceof BLocalHistoryDatabase && BLocalHistoryDatabase.WARM_UP_THREAD != null) {
            BLocalHistoryDatabase.WARM_UP_THREAD.start();
        }
    }

    public void started() {
        this.cuhQueue = new Queue(1);
        this.cuhWorker = new CloseUnusedHistoriesWorker((Worker.ITodo)this.cuhQueue);
        this.cuhWorker.start("CloseUnusedHistoriesWorker");
        this.lastClose = Clock.ticks();
        this.closeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)closeUnusedHistories, null);
        try {
            if (this.recorder != null && this.recorder.getLogHistoryService() == null) {
                this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
            }
        }
        catch (Throwable throwable) {}
    }

    public void stationStarted() throws Exception {
        try {
            if (this.recorder != null && this.recorder.getLogHistoryService() == null) {
                this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
            }
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void serviceStopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        Nre.serviceManager.removeServiceListener(this.serviceListener);
        try {
            this.remove("onStationSave");
        }
        catch (Exception exception) {}
        if (this.db != null) {
            ServiceListener serviceListener = this.serviceListener;
            synchronized (serviceListener) {
                if (this.recorder != null) {
                    this.db.fw(1002, null, null, null, null);
                    this.db.removeHistoryEventListener(this.recorder);
                    this.recorder = null;
                }
                // MONITOREXIT @DISABLED, blocks:[1, 3, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                this.db.close();
            }
            try {
                BLocalHost.INSTANCE.removeNavChild((BINavNode)this.db);
            }
            catch (Exception exception) {}
        }
        this.dbInitialized = false;
        this.dbOpen = false;
        this.serviceStarted = false;
    }

    public void stopped() {
        if (this.closeTicket != null) {
            this.closeTicket.cancel();
        }
        this.cuhWorker.stop();
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    private final boolean isHistoryNameUnique(String string) {
        BOrd bOrd = BOrd.make((String)("local:|station:|slot:/|bql:select from history:HistoryExt where historyConfig.historyName = '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve().get();
        if (bICollection.cursor().next()) {
            return false;
        }
        BHistoryId bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), string);
        return !this.db.exists(bHistoryId);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)closeUnusedHistories)) {
            if (!this.cuhWorker.isProcessing()) {
                try {
                    this.cuhQueue.enqueue((Object)new Invocation((BComponent)this, action, bValue, context));
                }
                catch (QueueFullException queueFullException) {}
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    public void doSaveDb() {
        if (!this.serviceStarted) {
            return;
        }
        try {
            this.db.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (bSystemPlatformService != null && this.db instanceof BLocalHistoryDatabase) {
            try {
                ((BLocalHistoryDatabase)this.db).createArchive();
            }
            catch (IOException iOException) {
                logger.error("Could not create history archive.", (Throwable)iOException);
            }
        }
        if (this.db != null && this.db.hasHistoryEventListeners()) {
            this.db.fireHistoryEvent(BHistoryEvent.makeDbSaved());
        }
    }

    public void doCloseUnusedHistories() {
        this.flushReportCache();
        long l = Clock.ticks();
        if (l - this.lastClose > this.getMaxOpenTime().getMillis() / (long)2) {
            if (this.db instanceof BLocalHistoryDatabase) {
                ((BLocalHistoryDatabase)this.db).closeUnusedTables(this.getMaxOpenTime().getMillis());
            }
            this.lastClose = Clock.ticks();
        }
    }

    public BOrd doEnableExtensions(BVector bVector, Context context) {
        return new BHistoryExtStatusJob(this, bVector, true).submit(context);
    }

    public BOrd doDisableExtensions(BVector bVector, Context context) {
        return new BHistoryExtStatusJob(this, bVector, false).submit(context);
    }

    public void changed(Property property, Context context) {
        if (!this.serviceStarted) {
            return;
        }
        if (property == maxOpenTime) {
            if (this.closeTicket != null) {
                this.closeTicket.cancel();
            }
            this.closeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)closeUnusedHistories, null);
        }
    }

    public Object fw(int n, Object object, Object object2, Object object3) {
        switch (n) {
            case 0: {
                return new Integer(this.addToReportCache((byte[])object));
            }
            case 1: {
                return this.getFromReportCache((Integer)object);
            }
        }
        return null;
    }

    private final synchronized int addToReportCache(byte[] byArray) {
        int n = this.getUniqueId();
        this.reportCache.put(new Integer(n), new ReportRec(byArray));
        return n;
    }

    private final synchronized byte[] getFromReportCache(int n) {
        ReportRec reportRec = (ReportRec)this.reportCache.get(new Integer(n));
        if (reportRec == null) {
            return null;
        }
        reportRec.touch();
        return reportRec.file;
    }

    private final synchronized int getUniqueId() {
        int n = (int)(this.rand.nextFloat() * 1000000.0f);
        while (this.reportCache.get(new Integer(n)) != null) {
            n = (int)(this.rand.nextFloat() * 1000000.0f);
        }
        return n;
    }

    private final synchronized void flushReportCache() {
        long l = Clock.ticks();
        ArrayList arrayList = null;
        Iterator iterator = this.reportCache.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ReportRec reportRec = (ReportRec)this.reportCache.get(k);
            if (!reportRec.isExpired(l)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList(1);
            }
            arrayList.add(k);
        }
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            this.reportCache.remove(arrayList.get(n2));
            ++n2;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 21 && this.db != null) {
            this.db.fw(n, object, object2, object3, object4);
        }
        return super.fw(n, object, object2, object3, object4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getHistoryGroupNames(BObject bObject) {
        BHistorySpace bHistorySpace = null;
        try {
            bHistorySpace = bObject instanceof BHistorySpace ? (BHistorySpace)bObject : (BHistorySpace)BOrd.make((String)"history:").get(bObject);
        }
        catch (Exception exception) {}
        if (bHistorySpace instanceof BFoxHistorySpace) {
            try {
                return ((BFoxHistorySpace)bHistorySpace).channel().getHistoryGroupNames();
            }
            catch (Exception exception) {}
        }
        try {
            Class clazz;
            BOrd bOrd = BOrd.make((String)"service:history:HistoryService");
            BHistoryService bHistoryService = (BHistoryService)bOrd.get(bObject);
            boolean bl = bHistoryService.isRunning() ^ true;
            if (bl) {
                bHistoryService.lease(1);
            }
            BHistoryGroupings bHistoryGroupings = bHistoryService.getHistoryGroupings();
            if (bl) {
                bHistoryGroupings.lease(1);
            }
            if ((clazz = class$java$lang$String) == null) {
                clazz = class$java$lang$String = BHistoryService.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            SlotCursor slotCursor = bHistoryGroupings.getProperties();
            while (true) {
                Class clazz2;
                if ((clazz2 = class$javax$baja$history$BHistoryGroup) == null) {
                    clazz2 = BHistoryService.class("[Ljavax.baja.history.BHistoryGroup;", false);
                }
                if (!slotCursor.next(clazz2)) {
                    if (array.size() <= 0) break;
                    return (String[])array.trim();
                }
                BHistoryGroup bHistoryGroup = (BHistoryGroup)slotCursor.get();
                if (bHistoryGroup == null || !bHistoryGroup.getEnabled()) continue;
                array.add((Object)SlotPath.unescape((String)slotCursor.property().getName()));
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String[] getSortPropertiesForGroup(BObject bObject, String string) {
        BHistorySpace bHistorySpace = null;
        try {
            bHistorySpace = bObject instanceof BHistorySpace ? (BHistorySpace)bObject : (BHistorySpace)BOrd.make((String)"history:").get(bObject);
        }
        catch (Exception exception) {}
        if (bHistorySpace instanceof BFoxHistorySpace) {
            try {
                return ((BFoxHistorySpace)bHistorySpace).channel().getSortPropertiesForGroup(string);
            }
            catch (Exception exception) {}
        }
        try {
            BHistoryGroup bHistoryGroup;
            BValue bValue;
            BOrd bOrd = BOrd.make((String)"service:history:HistoryService");
            BHistoryService bHistoryService = (BHistoryService)bOrd.get(bObject);
            boolean bl = bHistoryService.isRunning() ^ true;
            if (bl) {
                bHistoryService.lease(1);
            }
            BHistoryGroupings bHistoryGroupings = bHistoryService.getHistoryGroupings();
            if (bl) {
                bHistoryGroupings.lease(1);
            }
            if ((bValue = bHistoryGroupings.get(SlotPath.escape((String)string))) instanceof BHistoryGroup && (bHistoryGroup = (BHistoryGroup)bValue).getEnabled()) {
                return bHistoryGroup.getHistoryPropertiesToGroupBy().getNames();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private final BIDataRecoveryService getDataRecoveryService() {
        if (this.dataRecoveryService == null) {
            try {
                this.dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
                if (!this.dataRecoveryService.isEnabled()) {
                    this.dataRecoveryService = null;
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                this.dataRecoveryService = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.dataRecoveryService;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceStarted = false;
        this.dbOpen = false;
        this.dbInitialized = false;
        this.dataRecoveryService = null;
        this.recorder = null;
        this.serviceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void serviceEvent(BServiceEvent bServiceEvent) {
                if (bServiceEvent.getServiceType().is(BIDataRecoveryService.TYPE)) {
                    BIDataRecoveryService bIDataRecoveryService = (BIDataRecoveryService)bServiceEvent.getService();
                    if (bServiceEvent.getId() == 0) {
                        ServiceListener serviceListener = BHistoryService.this.serviceListener;
                        synchronized (serviceListener) {
                            if (BHistoryService.this.recorder != null) return;
                            if (!bIDataRecoveryService.isEnabled()) return;
                            BHistoryService.this.dataRecoveryService = bIDataRecoveryService;
                            try {
                                BHistoryService.this.recorder = (BDataRecoveryHistoryRecorder)BHistoryService.this.db.getAgents().filter(AgentFilter.is((Type)BDataRecoveryHistoryRecorder.TYPE)).getDefault().getInstance();
                            }
                            catch (Exception exception) {}
                            if (BHistoryService.this.recorder == null) return;
                            BHistoryService.this.recorder.setDataRecoveryService(BHistoryService.this.dataRecoveryService);
                            BHistoryService.this.recorder.setHistorySpace(BHistoryService.this.db);
                            try {
                                BHistoryService.this.recorder.setLogHistoryService((BLogHistoryService)Sys.getService((Type)BLogHistoryService.TYPE));
                            }
                            catch (Throwable throwable) {}
                            BHistoryService.this.db.addHistoryEventListener(BHistoryService.this.recorder);
                            return;
                        }
                    }
                    if (bServiceEvent.getId() != 1) return;
                    ServiceListener serviceListener = BHistoryService.this.serviceListener;
                    synchronized (serviceListener) {
                        if (BHistoryService.this.recorder == null) return;
                        if (BHistoryService.this.dataRecoveryService != null) {
                            if (BHistoryService.this.dataRecoveryService != bIDataRecoveryService) return;
                        }
                        BHistoryService.this.dataRecoveryService = null;
                        BHistoryService.this.db.removeHistoryEventListener(BHistoryService.this.recorder);
                        BHistoryService.this.recorder = null;
                        return;
                    }
                }
                if (!bServiceEvent.getServiceType().is(BLogHistoryService.TYPE)) return;
                try {
                    if (BHistoryService.this.recorder == null) return;
                    BHistoryService.this.recorder.setLogHistoryService((BLogHistoryService)bServiceEvent.getService());
                    return;
                }
                catch (Throwable throwable) {}
            }

            public final String toString() {
                return "ServiceListener for HistoryService " + BHistoryService.this.getNavOrd();
            }
        };
        this.reportCache = new HashMap();
        this.rand = new Random();
        this.saveListener = new Station.SaveListener(){

            public final void stationSave() {
                BHistoryService.this.saveDb();
            }

            public final void stationSaveOk() {
            }

            public final void stationSaveFail(String string) {
            }

            public final String toString() {
                return "HistoryService " + BHistoryService.this.getNavOrd();
            }
        };
    }

    public BHistoryService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$history$BHistoryService;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryService = BHistoryService.class("[Ljavax.baja.history.BHistoryService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"historyDatabase.png");
        logger = Log.getLog((String)"history");
        serviceTypes = new Type[]{TYPE};
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CloseUnusedHistoriesWorker
    extends Worker {
        private boolean processing;

        public boolean isProcessing() {
            return this.processing;
        }

        protected void process(Runnable runnable) throws Exception {
            this.processing = true;
            try {
                super.process(runnable);
            }
            catch (Exception exception) {
                this.processing = false;
                throw exception;
            }
            this.processing = false;
        }

        private final /* synthetic */ void this() {
            this.processing = false;
        }

        public CloseUnusedHistoriesWorker(Worker.ITodo iTodo) {
            super(iTodo);
            this.this();
        }
    }

    private static class ReportRec {
        long lastTouch = Clock.ticks();
        byte[] file;

        public boolean isExpired(long l) {
            boolean bl = false;
            if (l - this.lastTouch > 120000L) {
                bl = true;
            }
            return bl;
        }

        public void touch() {
            this.lastTouch = Clock.ticks();
        }

        public ReportRec(byte[] byArray) {
            this.file = byArray;
        }
    }
}

