/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.BHistoryDeltaQuery;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryScheme
extends BSpaceScheme {
    public static final BHistoryScheme INSTANCE = new BHistoryScheme();
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$history$BHistoryScheme;

    public Type getSpaceType() {
        return BHistorySpace.TYPE;
    }

    public OrdQuery parse(String string) {
        return new HistoryQuery(this.getId(), string);
    }

    public OrdTarget resolve(OrdTarget ordTarget, OrdQuery ordQuery, BSpace bSpace) {
        BIHistory bIHistory;
        Object object;
        HistoryQuery historyQuery = (HistoryQuery)ordQuery;
        BHistorySpace bHistorySpace = (BHistorySpace)bSpace;
        if (historyQuery.isHistoryFolderQuery()) {
            String[] stringArray = historyQuery.getHistoryFolderPath();
            BINavNode bINavNode = null;
            if (stringArray != null && stringArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("history://").append(stringArray[0]);
                bINavNode = bHistorySpace.getNavChild(stringBuffer.toString());
                int n = 1;
                while (bINavNode != null && n < stringArray.length) {
                    stringBuffer.append("/").append(stringArray[n]);
                    bINavNode = bINavNode.getNavChild(stringBuffer.toString());
                    ++n;
                }
            }
            return new OrdTarget(ordTarget, (BObject)bINavNode);
        }
        if (historyQuery.isSpaceQuery()) {
            return new OrdTarget(ordTarget, (BObject)bHistorySpace);
        }
        if (historyQuery.isDeviceQuery()) {
            BObject bObject;
            String string = historyQuery.getDeviceName();
            if (string.equals("^")) {
                string = bHistorySpace.getDeviceName();
            } else if (string.equals("@") && (bObject = ordTarget.get()).isComplex()) {
                BComplex bComplex = (BComplex)bObject;
                while (bComplex != null) {
                    if (bComplex instanceof NiagaraStation) {
                        string = ((NiagaraStation)bComplex).getStationName();
                        break;
                    }
                    bComplex = bComplex.getParent();
                }
            }
            return new OrdTarget(ordTarget, (BObject)bHistorySpace.getDevice(string));
        }
        String string = historyQuery.getDeviceName();
        String string2 = historyQuery.getHistoryName();
        if (string.equals("^")) {
            string = bHistorySpace.getDeviceName();
        } else if (string.equals("@") && (object = ordTarget.get()).isComplex()) {
            bIHistory = (BComplex)object;
            while (bIHistory != null) {
                if (bIHistory instanceof NiagaraStation) {
                    string = ((NiagaraStation)bIHistory).getStationName();
                    break;
                }
                bIHistory = bIHistory.getParent();
            }
        }
        object = BHistoryId.make(string, string2);
        try {
            bIHistory = bHistorySpace.resolveHistory((BHistoryId)((Object)object));
            if (historyQuery.hasTimeRange()) {
                BAbsTime bAbsTime = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)bIHistory.getConfig().getTimeZone());
                BAbsTime bAbsTime2 = historyQuery.getStartTime(bAbsTime);
                BAbsTime bAbsTime3 = historyQuery.getEndTime(bAbsTime);
                BObject bObject = null;
                bObject = historyQuery.isDelta() ? new BHistoryDeltaQuery(bIHistory, bAbsTime2, bAbsTime3) : (BObject)bIHistory.timeQuery(bAbsTime2, bAbsTime3);
                return new OrdTarget(ordTarget, bObject);
            }
            if (historyQuery.isDelta()) {
                BHistoryDeltaQuery bHistoryDeltaQuery = new BHistoryDeltaQuery(bIHistory, null, null);
                return new OrdTarget(ordTarget, (BObject)bHistoryDeltaQuery);
            }
            return new OrdTarget(ordTarget, (BObject)bIHistory);
        }
        catch (Exception exception) {
            throw new UnresolvedException("Cannot resolve history: " + object, (Throwable)exception);
        }
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BHistoryScheme() {
        super("history");
    }

    static {
        Class clazz = class$javax$baja$history$BHistoryScheme;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryScheme = BHistoryScheme.class("[Ljavax.baja.history.BHistoryScheme;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

