/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistorySchema;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHistoryRecord
extends BStruct
implements Externalizable,
BIHistoryRecordSet {
    public static final Property timestamp = BHistoryRecord.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE;
    public static final BFacets TIMESTAMP_FACETS;
    static /* synthetic */ Class class$javax$baja$history$BHistoryRecord;

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime bAbsTime) {
        this.set(timestamp, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHistorySchema getSchema() {
        BHistorySchema bHistorySchema = new BHistorySchema();
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            bHistorySchema.addColumn(property.getName(), property.getType().getTypeSpec());
        }
        bHistorySchema.getColumnCount();
        return bHistorySchema;
    }

    public abstract boolean isFixedSize();

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.read(objectInput);
    }

    public int getRecordSize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.write(dataOutputStream);
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return byteArrayOutputStream.size();
    }

    public final BHistoryRecord read(DataInput dataInput) throws IOException {
        this.setTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(dataInput));
        this.doRead(dataInput);
        return this;
    }

    protected abstract void doRead(DataInput var1) throws IOException;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.write(objectOutput);
    }

    public final BHistoryRecord write(DataOutput dataOutput) throws IOException {
        this.getTimestamp().encode(dataOutput);
        this.doWrite(dataOutput);
        return this;
    }

    protected abstract void doWrite(DataOutput var1) throws IOException;

    public String toString(Context context) {
        return this.getTimestamp().toString(context);
    }

    public final String toSummary(Context context) {
        StringBuffer stringBuffer = new StringBuffer(96);
        stringBuffer.append(this.getTimestamp().toString(context));
        stringBuffer.append(' ');
        this.toDataSummary(stringBuffer, context);
        return stringBuffer.toString();
    }

    public final String toDataSummary(Context context) {
        StringBuffer stringBuffer = new StringBuffer(64);
        this.toDataSummary(stringBuffer, context);
        return stringBuffer.toString();
    }

    public void toDataSummary(StringBuffer stringBuffer, Context context) {
        SlotCursor slotCursor = this.getProperties();
        boolean bl = true;
        while (slotCursor.next()) {
            if (!bl) {
                stringBuffer.append(' ');
            }
            bl = false;
            stringBuffer.append(slotCursor.get().toString(context));
        }
    }

    public int getRecordCount() {
        return 1;
    }

    public BHistoryRecord getRecord(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n + "!=0");
        }
        return this;
    }

    public BHistoryRecord[] getRecords() {
        return new BHistoryRecord[]{this};
    }

    public BHistoryRecord getLastRecord() {
        return this;
    }

    public BTypeSpec getRecordTypeSpec() {
        return this.getType().getTypeSpec();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BHistoryRecord() {
    }

    protected BHistoryRecord(BAbsTime bAbsTime) {
        this.setTimestamp(bAbsTime);
    }

    static {
        Class clazz = class$javax$baja$history$BHistoryRecord;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryRecord = BHistoryRecord.class("[Ljavax.baja.history.BHistoryRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        TIMESTAMP_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    }
}

