/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.HistoryNameException;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BHistoryId
extends BSimple {
    public static final BHistoryId DEFAULT;
    public static final BHistoryId NULL;
    public static final Type TYPE;
    public static final int MAX_NAME_LENGTH = 44;
    static final String DEVICE_SHORTHAND = "^";
    static final String NIAGARA_STATION_SHORTHAND = "@";
    private String deviceName;
    private String historyName;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$history$BHistoryId;

    public static final BHistoryId make(String string, String string2) {
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
            return NULL;
        }
        return (BHistoryId)new BHistoryId(string, string2).intern();
    }

    public static final BHistoryId make(String string) {
        if (string.length() == 0) {
            return NULL;
        }
        try {
            int n = string.indexOf(47);
            if (n != 0) {
                if (string.startsWith(DEVICE_SHORTHAND, 0) || string.startsWith(NIAGARA_STATION_SHORTHAND, 0)) {
                    if (n < 0) {
                        String string2 = string.substring(0, 1);
                        String string3 = string.substring(1);
                        return (BHistoryId)new BHistoryId(string2, string3).intern();
                    }
                    throw new SyntaxException("Invalid history id: " + string);
                }
                throw new SyntaxException("History id must start with a /. (" + string + ')');
            }
            int n2 = string.indexOf(47, n + 1);
            if (n2 == -1) {
                throw new SyntaxException("History name is required. (" + string + ')');
            }
            if (string.indexOf(47, n2 + 1) != -1) {
                throw new SyntaxException("Invalid history id: " + string);
            }
            String string4 = string.substring(n + 1, n2);
            String string5 = string.substring(n2 + 1);
            return (BHistoryId)new BHistoryId(string4, string5).intern();
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Exception exception) {
            throw new SyntaxException((Throwable)exception);
        }
    }

    public final String getDeviceName() {
        return this.deviceName;
    }

    public final String getHistoryName() {
        return this.historyName;
    }

    public final String getHistoryDisplayName() {
        return SlotPath.unescape((String)this.historyName);
    }

    public final BHistoryId toShorthand(String string) {
        if (this.isValid() && string != null && string.equals(this.deviceName)) {
            return BHistoryId.make(DEVICE_SHORTHAND, this.historyName);
        }
        return this;
    }

    public final BHistoryId fromShorthand(String string) {
        if (this.isValid() && (this.deviceName.equals(DEVICE_SHORTHAND) || this.deviceName.equals(NIAGARA_STATION_SHORTHAND))) {
            return BHistoryId.make(string, this.historyName);
        }
        return this;
    }

    public final void validateName() {
        BHistoryId.validateName(this.historyName);
    }

    public static final void validateName(String string) {
        if (string == null) {
            throw new HistoryNameException("History name cannot be null.");
        }
        if (!SlotPath.isValidName((String)string)) {
            throw new HistoryNameException("History name contains an invalid character.");
        }
        if (string.length() > 44) {
            throw new HistoryNameException("History name exceeds maximum length. (" + string.length() + " > 44)");
        }
    }

    public static final boolean isValidName(String string) {
        try {
            BHistoryId.validateName(string);
            return true;
        }
        catch (HistoryNameException historyNameException) {
            return false;
        }
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BHistoryId)) {
            return false;
        }
        BHistoryId bHistoryId = (BHistoryId)((Object)object);
        boolean bl = false;
        if (this.deviceName.equals(bHistoryId.deviceName) && this.historyName.equals(bHistoryId.historyName)) {
            bl = true;
        }
        return bl;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.deviceName);
        dataOutput.writeUTF(this.historyName);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return (BHistoryId)new BHistoryId(dataInput.readUTF(), dataInput.readUTF()).intern();
    }

    public final String encodeToString() {
        if (this.isNull()) {
            return "";
        }
        if (this.deviceName.equals(DEVICE_SHORTHAND) || this.deviceName.equals(NIAGARA_STATION_SHORTHAND)) {
            return this.deviceName + this.historyName;
        }
        return "/" + this.deviceName + '/' + this.historyName;
    }

    public final BObject decodeFromString(String string) {
        return BHistoryId.make(string);
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.deviceName.equals("") && this.historyName.equals("")) {
            bl = true;
        }
        return bl;
    }

    public final boolean isValid() {
        boolean bl = false;
        if (!this.deviceName.equals("") && !this.historyName.equals("")) {
            bl = true;
        }
        return bl;
    }

    public final Type getType() {
        return TYPE;
    }

    public static final void main(String[] stringArray) throws Exception {
        BHistoryId bHistoryId = new BHistoryId(DEVICE_SHORTHAND, "hname");
        System.out.println((Object)bHistoryId);
        System.out.println("valid=" + bHistoryId.isValid());
        bHistoryId = new BHistoryId(NIAGARA_STATION_SHORTHAND, "hname");
        System.out.println((Object)bHistoryId);
        System.out.println("valid=" + bHistoryId.isValid());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BHistoryId(String string, String string2) {
        this.deviceName = string;
        this.historyName = string2;
        this.hashCode = this.toString().hashCode();
    }

    static {
        NULL = DEFAULT = new BHistoryId("", "");
        Class clazz = class$javax$baja$history$BHistoryId;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryId = BHistoryId.class("[Ljavax.baja.history.BHistoryId;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

