/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.IOException;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySchema;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStorageType;
import javax.baja.history.HistoryException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryConfig
extends BComponent {
    public static final Property id = BHistoryConfig.newProperty((int)329, (BValue)BHistoryId.NULL, null);
    public static final Property historyName = BHistoryConfig.newProperty((int)6, (String)"", null);
    public static final Property source = BHistoryConfig.newProperty((int)265, (BValue)BOrdList.NULL, null);
    public static final Property sourceHandle = BHistoryConfig.newProperty((int)4, (BValue)BOrd.NULL, null);
    public static final Property timeZone = BHistoryConfig.newProperty((int)65, (BValue)BTimeZone.NULL, null);
    public static final Property recordType = BHistoryConfig.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property schema = BHistoryConfig.newProperty((int)5, (BValue)BHistorySchema.DEFAULT, null);
    public static final Property capacity = BHistoryConfig.newProperty((int)0, (BValue)BCapacity.makeByRecordCount(500), null);
    public static final Property fullPolicy = BHistoryConfig.newProperty((int)0, (BValue)BFullPolicy.roll, null);
    public static final Property storageType = BHistoryConfig.newProperty((int)4, (BValue)BStorageType.file, null);
    public static final Property interval = BHistoryConfig.newProperty((int)257, (BValue)BCollectionInterval.IRREGULAR, null);
    public static final Property systemTags = BHistoryConfig.newProperty((int)0, (BValue)BNameList.NULL, null);
    public static final Type TYPE;
    private int recordSize;
    private BHistoryRecord prototype;
    static /* synthetic */ Class class$javax$baja$history$BHistoryConfig;

    public BHistoryId getId() {
        return (BHistoryId)this.get(id);
    }

    public void setId(BHistoryId bHistoryId) {
        this.set(id, (BValue)bHistoryId, null);
    }

    public String getHistoryName() {
        return this.getString(historyName);
    }

    public void setHistoryName(String string) {
        this.setString(historyName, string, null);
    }

    public BOrdList getSource() {
        return (BOrdList)this.get(source);
    }

    public void setSource(BOrdList bOrdList) {
        this.set(source, (BValue)bOrdList, null);
    }

    public BOrd getSourceHandle() {
        return (BOrd)this.get(sourceHandle);
    }

    public void setSourceHandle(BOrd bOrd) {
        this.set(sourceHandle, (BValue)bOrd, null);
    }

    public BTimeZone getTimeZone() {
        return (BTimeZone)this.get(timeZone);
    }

    public void setTimeZone(BTimeZone bTimeZone) {
        this.set(timeZone, (BValue)bTimeZone, null);
    }

    public BTypeSpec getRecordType() {
        return (BTypeSpec)this.get(recordType);
    }

    public void setRecordType(BTypeSpec bTypeSpec) {
        this.set(recordType, (BValue)bTypeSpec, null);
    }

    public BHistorySchema getSchema() {
        return (BHistorySchema)this.get(schema);
    }

    public void setSchema(BHistorySchema bHistorySchema) {
        this.set(schema, (BValue)bHistorySchema, null);
    }

    public BCapacity getCapacity() {
        return (BCapacity)this.get(capacity);
    }

    public void setCapacity(BCapacity bCapacity) {
        this.set(capacity, (BValue)bCapacity, null);
    }

    public BFullPolicy getFullPolicy() {
        return (BFullPolicy)this.get(fullPolicy);
    }

    public void setFullPolicy(BFullPolicy bFullPolicy) {
        this.set(fullPolicy, (BValue)bFullPolicy, null);
    }

    public BStorageType getStorageType() {
        return (BStorageType)this.get(storageType);
    }

    public void setStorageType(BStorageType bStorageType) {
        this.set(storageType, (BValue)bStorageType, null);
    }

    public BCollectionInterval getInterval() {
        return (BCollectionInterval)this.get(interval);
    }

    public void setInterval(BCollectionInterval bCollectionInterval) {
        this.set(interval, (BValue)bCollectionInterval, null);
    }

    public BNameList getSystemTags() {
        return (BNameList)this.get(systemTags);
    }

    public void setSystemTags(BNameList bNameList) {
        this.set(systemTags, (BValue)bNameList, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getColumnType(String string) {
        try {
            BHistoryRecord bHistoryRecord = this.makeRecord();
            Property property = bHistoryRecord.getProperty(string);
            if (property == null) {
                return null;
            }
            return property.getDefaultValue().getType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BHistoryRecord makeRecord() throws HistoryException {
        BTypeSpec bTypeSpec = this.getRecordType();
        try {
            return BHistoryConfig.makeRecord(bTypeSpec);
        }
        catch (TypeNotFoundException typeNotFoundException) {
            if (bTypeSpec.getTypeName().equals("FloatTrendRecord")) {
                this.setRecordType(BNumericTrendRecord.TYPE.getTypeSpec());
                return new BNumericTrendRecord();
            }
            throw typeNotFoundException;
        }
    }

    private static final BHistoryRecord makeRecord(BTypeSpec bTypeSpec) {
        Type type = bTypeSpec.getResolvedType();
        return (BHistoryRecord)type.getInstance();
    }

    public BObject makePrototype() {
        try {
            return this.makeRecord();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public int getRecordSize() throws IOException, HistoryException {
        if (this.recordSize == -1) {
            try {
                BHistoryRecord bHistoryRecord = this.makeRecord();
                if (!bHistoryRecord.isFixedSize()) {
                    throw new UnsupportedOperationException("A fixed record size cannot be determined for a history with variable length records.");
                }
                this.recordSize = bHistoryRecord.getRecordSize();
            }
            catch (ModuleException moduleException) {
                throw new HistoryException(moduleException.getMessage(), moduleException);
            }
            catch (TypeException typeException) {
                throw new HistoryException(typeException.getMessage(), typeException);
            }
        }
        return this.recordSize;
    }

    public void changed(Property property, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (property == recordType && this.getSchema().equals((Object)BHistorySchema.DEFAULT)) {
            this.setSchema(this.makeRecord().getSchema());
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BIHistorySource) {
            ((BIHistorySource)bComplex).historyConfigChanged(this, property);
        }
    }

    public void added(Property property, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BIHistorySource) {
            ((BIHistorySource)bComplex).historyConfigChanged(this, property);
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BIHistorySource) {
            ((BIHistorySource)bComplex).historyConfigChanged(this, property);
        }
    }

    public void renamed(Property property, String string, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BIHistorySource) {
            ((BIHistorySource)bComplex).historyConfigChanged(this, property);
        }
    }

    public void flagsChanged(Slot slot, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (!slot.isProperty()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BIHistorySource) {
            ((BIHistorySource)bComplex).historyConfigChanged(this, slot.asProperty());
        }
    }

    public void facetsChanged(Slot slot, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (!slot.isProperty()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BIHistorySource) {
            ((BIHistorySource)bComplex).historyConfigChanged(this, slot.asProperty());
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(interval.getDefaultDisplayName(context) + ": " + (Object)((Object)this.getInterval())).append(", ");
        stringBuffer.append(recordType.getDefaultDisplayName(context) + ": ");
        stringBuffer.append(this.getRecordType().isNull() ? "null" : this.getRecordType().getResolvedType().getDisplayName(context).toLowerCase()).append(", ");
        stringBuffer.append(capacity.getDefaultDisplayName(context) + ": " + (Object)((Object)this.getCapacity())).append(", ");
        stringBuffer.append(fullPolicy.getDefaultDisplayName(context) + ": " + (Object)((Object)this.getFullPolicy()));
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.recordSize = -1;
    }

    public BHistoryConfig() {
        this.this();
    }

    public BHistoryConfig(BHistoryId bHistoryId, BTypeSpec bTypeSpec) {
        this.this();
        this.setId(bHistoryId);
        this.setRecordType(bTypeSpec);
        this.setSchema(BHistoryConfig.makeRecord(bTypeSpec).getSchema());
    }

    public BHistoryConfig(BCapacity bCapacity, BFullPolicy bFullPolicy) {
        this.this();
        this.setCapacity(bCapacity);
        this.setFullPolicy(bFullPolicy);
    }

    public BHistoryConfig(BHistoryId bHistoryId, BTypeSpec bTypeSpec, BCapacity bCapacity) {
        this.this();
        this.setId(bHistoryId);
        this.setRecordType(bTypeSpec);
        this.setSchema(BHistoryConfig.makeRecord(bTypeSpec).getSchema());
        this.setCapacity(bCapacity);
    }

    static {
        Class clazz = class$javax$baja$history$BHistoryConfig;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryConfig = BHistoryConfig.class("[Ljavax.baja.history.BHistoryConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

