/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.util;

import com.tridium.history.db.BLocalHistoryDatabase;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public class HistoryGen {
    private String dbDir;

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        int n3;
        String string;
        try {
            if (stringArray.length < 4) {
                throw new Exception("Not enough arguments!");
            }
            string = stringArray[0];
            n3 = Integer.parseInt(stringArray[1]);
            n2 = Integer.parseInt(stringArray[2]);
            n = Integer.parseInt(stringArray[3]);
        }
        catch (Exception exception) {
            System.out.println("Usage: HistoryGen <supervisor station> <station count> <history count> <record count>");
            return;
        }
        Thread.currentThread().setPriority(10);
        BRelTime bRelTime = BRelTime.make((long)900000L);
        float f = 0.0f;
        float f2 = 100.0f;
        int n4 = 0;
        File file = Sys.getBajaHome();
        File file2 = new File(file, "stations");
        File file3 = new File(file2, string);
        File file4 = new File(file3, "history");
        HistoryGen historyGen = new HistoryGen(file4.getAbsolutePath());
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n2) {
                boolean bl = false;
                while (!bl) {
                    try {
                        BAbsTime bAbsTime = BAbsTime.now();
                        BHistoryConfig bHistoryConfig = new BHistoryConfig();
                        bHistoryConfig.setId(BHistoryId.make("/station" + n5 + '-' + n4 + "/history" + n6));
                        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                        bHistoryConfig.setRecordType(BTypeSpec.make((String)"history:NumericTrendRecord"));
                        bHistoryConfig.setInterval(BCollectionInterval.make(bRelTime));
                        bHistoryConfig.setCapacity(BCapacity.UNLIMITED);
                        historyGen.generate(bHistoryConfig, bAbsTime, n, f, f2);
                        bl = true;
                    }
                    catch (DuplicateHistoryException duplicateHistoryException) {
                        ++n4;
                        bl = false;
                    }
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void generate(BHistoryConfig bHistoryConfig, BAbsTime bAbsTime, int n, float f, float f2) throws IOException {
        BLocalHistoryDatabase bLocalHistoryDatabase = new BLocalHistoryDatabase(new File(this.dbDir));
        bLocalHistoryDatabase.open();
        BNumericTrendRecord bNumericTrendRecord = (BNumericTrendRecord)bHistoryConfig.makeRecord();
        BAbsTime bAbsTime2 = bAbsTime;
        BRelTime bRelTime = bHistoryConfig.getInterval().getInterval();
        Random random = new Random();
        bLocalHistoryDatabase.createHistory(bHistoryConfig);
        BIHistory bIHistory = bLocalHistoryDatabase.getHistory(bHistoryConfig.getId());
        int n2 = 0;
        while (n2 < n) {
            bNumericTrendRecord.setTimestamp(bAbsTime2);
            bNumericTrendRecord.setValue(f + random.nextFloat() * (f2 - f));
            bIHistory.append(bNumericTrendRecord);
            bAbsTime2 = bAbsTime2.add(bRelTime);
            ++n2;
        }
        bLocalHistoryDatabase.close();
    }

    public HistoryGen(String string) {
        this.dbDir = string;
    }
}

