/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.BHistory;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.util.BTypeSpec;

public class HistoryItem {
    public static final BTypeSpec LineChart = HistoryItem.ts("LineChart");
    public static final BTypeSpec AreaChart = HistoryItem.ts("AreaChart");
    public static final BTypeSpec BarChart = HistoryItem.ts("BarChart");
    public static final BTypeSpec PieChart = HistoryItem.ts("PieChart");
    public static final BTypeSpec StackedBarChart = HistoryItem.ts("StackedBarChart");
    public static final BTypeSpec DiscreteLineChart = HistoryItem.ts("DiscreteLineChart");
    public static final BTypeSpec DiscreteAreaChart = HistoryItem.ts("DiscreteAreaChart");
    private BIHistory history;
    private BBrush brush;
    private BTypeSpec chartType;

    public BIHistory getHistory(BHistorySpace bHistorySpace) {
        return bHistorySpace.getHistory(this.history.getId());
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush bBrush) {
        this.brush = bBrush;
    }

    public BTypeSpec getChartType() {
        return this.chartType;
    }

    public void setChartType(BTypeSpec bTypeSpec) {
        this.chartType = bTypeSpec;
    }

    public HistoryItem copy() {
        HistoryItem historyItem = new HistoryItem(this.history);
        historyItem.brush = this.brush;
        historyItem.chartType = this.chartType;
        return historyItem;
    }

    public String toString() {
        return this.history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX);
    }

    static BTypeSpec ts(String string) {
        return BTypeSpec.make((String)"chart", (String)string);
    }

    public HistoryItem(BIHistory bIHistory) {
        this.history = bIHistory;
        this.brush = BColor.red.toBrush();
        this.chartType = LineChart;
    }
}

