/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.HistoryItem;
import com.tridium.history.ui.chart.HistoryListModel;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryList
extends BTransferWidget {
    public static final Action updateChartType = BHistoryList.newAction((int)4, (BValue)new BWidgetEvent());
    public static final Type TYPE;
    static BImage iconLine;
    static BImage iconArea;
    static BImage iconBar;
    static BImage iconStackBar;
    static BImage iconDisLine;
    static BImage iconDisArea;
    static BImage iconPie;
    static BModule module;
    static Lexicon lex;
    static String lexEmpty;
    private HistoryListModel model;
    static /* synthetic */ Class class$com$tridium$history$ui$chart$BHistoryList;

    public void updateChartType(BWidgetEvent bWidgetEvent) {
        this.invoke(updateChartType, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public HistoryListModel getModel() {
        return this.model;
    }

    public void setModel(HistoryListModel historyListModel) {
        if (this.model != null) {
            this.model.setOwner(null);
        }
        this.model = historyListModel;
        this.model.setOwner(this);
        this.modelChanged();
    }

    public void modelChanged() {
        this.rebuild();
    }

    public TransferEnvelope getTransferData() {
        return null;
    }

    public CommandArtifact drop(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        BIHistory[] bIHistoryArray = new BIHistory[mark.size()];
        int n = 0;
        while (n < bIHistoryArray.length) {
            bIHistoryArray[n] = (BIHistory)mark.getValue(n);
            ++n;
        }
        this.model.add(bIHistoryArray);
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        BIHistory[] bIHistoryArray = new BIHistory[mark.size()];
        int n = 0;
        while (n < bIHistoryArray.length) {
            bIHistoryArray[n] = (BIHistory)mark.getValue(n);
            ++n;
        }
        this.model.add(bIHistoryArray);
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) {
        return null;
    }

    public int dragOver(TransferContext transferContext) {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        int n = mark.size();
        int n2 = 0;
        while (n2 < n) {
            if (!(mark.getValue(n2) instanceof BIHistory)) {
                return 0;
            }
            BIHistory bIHistory = (BIHistory)mark.getValue(n2);
            BTypeSpec bTypeSpec = bIHistory.getRecordType();
            Type type = bTypeSpec.getResolvedType();
            if (!type.is(BTrendRecord.TYPE)) {
                return 0;
            }
            ++n2;
        }
        return 16;
    }

    public void computePreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.model.size() == 0) {
            BFont bFont = Theme.widget().getTextFont();
            d = bFont.width(lexEmpty) + 10.0;
            d2 = bFont.getHeight() + 10.0;
        } else {
            BWidget bWidget = (BWidget)this.get("content");
            bWidget.computePreferredSize();
            d = bWidget.getPreferredWidth();
            d2 = bWidget.getPreferredHeight() + 15.0;
        }
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.model.size() == 0) {
            return;
        }
        BWidget bWidget = (BWidget)this.get("content");
        bWidget.computePreferredSize();
        bWidget.setBounds(0.0, 0.0, this.getWidth(), bWidget.getPreferredHeight());
    }

    public void paint(Graphics graphics) {
        if (this.model.size() == 0) {
            BFont bFont = Theme.widget().getTextFont();
            double d = this.getWidth();
            double d2 = this.getHeight();
            double d3 = (d - bFont.width(lexEmpty)) / (double)2;
            double d4 = (d2 - bFont.getAscent()) / (double)2;
            graphics.setFont(bFont);
            graphics.setBrush(BColor.black);
            graphics.drawString(lexEmpty, d3, d4 + bFont.getAscent());
        } else {
            super.paint(graphics);
        }
    }

    private final void rebuild() {
        if (this.model.size() == 0) {
            this.removeAll();
            this.add("content", (BValue)new BNullWidget());
            return;
        }
        BGridPane bGridPane = new BGridPane(4);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setStretchColumn(3);
        bGridPane.setColumnGap(10.0);
        ArrayList<BLink> arrayList = new ArrayList<BLink>();
        int n = 0;
        while (n < this.model.size()) {
            HistoryItem historyItem = this.model.get(n);
            BBrushSwatch bBrushSwatch = new BBrushSwatch(historyItem.getBrush());
            bBrushSwatch.setPreferredSize(16.0, 16.0);
            bBrushSwatch.setController((BBrushSwatch.Controller)new SwatchController());
            BListDropDown bListDropDown = this.makeChartList(historyItem.getChartType());
            arrayList.add(new BLink((BComponent)bListDropDown, (Slot)BDropDown.valueModified, (Slot)updateChartType));
            BGridPane bGridPane2 = new BGridPane(3);
            bGridPane2.setHalign(BHalign.right);
            bGridPane2.setColumnGap(0.0);
            bGridPane2.add(null, (BValue)this.makeButton(new MoveUp((BWidget)this, historyItem)));
            bGridPane2.add(null, (BValue)this.makeButton(new MoveDown((BWidget)this, historyItem)));
            bGridPane2.add(null, (BValue)this.makeButton(new Delete((BWidget)this, historyItem)));
            bGridPane.add("swatch_" + n, (BValue)bBrushSwatch);
            bGridPane.add(null, (BValue)new BLabel(historyItem.toString(), BHalign.left));
            bGridPane.add("list_" + n, (BValue)bListDropDown);
            bGridPane.add(null, (BValue)bGridPane2);
            ++n;
        }
        this.removeAll();
        this.add("content", (BValue)new BBorderPane((BWidget)bGridPane, BInsets.make((double)5)));
        n = 0;
        while (n < arrayList.size()) {
            this.add(null, (BValue)((BLink)arrayList.get(n)));
            ++n;
        }
    }

    private final BListDropDown makeChartList(BTypeSpec bTypeSpec) {
        BListDropDown bListDropDown = new BListDropDown();
        BList bList = bListDropDown.getList();
        bList.setModel((javax.baja.ui.list.ListModel)new ListModel());
        bList.addItem((Object)new Item(HistoryItem.LineChart, lex.getText("chartBuilder.chartType.line"), iconLine));
        bList.addItem((Object)new Item(HistoryItem.AreaChart, lex.getText("chartBuilder.chartType.area"), iconArea));
        bList.addItem((Object)new Item(HistoryItem.BarChart, lex.getText("chartBuilder.chartType.bar"), iconBar));
        bList.addItem((Object)new Item(HistoryItem.StackedBarChart, lex.getText("chartBuilder.chartType.stackedBar"), iconStackBar));
        bList.addItem((Object)new Item(HistoryItem.DiscreteLineChart, lex.getText("chartBuilder.chartType.discreteLine"), iconDisLine));
        bList.addItem((Object)new Item(HistoryItem.DiscreteAreaChart, lex.getText("chartBuilder.chartType.discreteArea"), iconDisArea));
        bList.addItem((Object)new Item(HistoryItem.PieChart, lex.getText("chartBuilder.chartType.pie"), iconPie));
        int n = 0;
        if (bTypeSpec.equals((Object)HistoryItem.LineChart)) {
            n = 0;
        } else if (bTypeSpec.equals((Object)HistoryItem.AreaChart)) {
            n = 1;
        } else if (bTypeSpec.equals((Object)HistoryItem.BarChart)) {
            n = 2;
        } else if (bTypeSpec.equals((Object)HistoryItem.StackedBarChart)) {
            n = 3;
        } else if (bTypeSpec.equals((Object)HistoryItem.DiscreteLineChart)) {
            n = 4;
        } else if (bTypeSpec.equals((Object)HistoryItem.DiscreteAreaChart)) {
            n = 5;
        } else if (bTypeSpec.equals((Object)HistoryItem.PieChart)) {
            n = 6;
        }
        bListDropDown.getList().setSelectedIndex(n);
        return bListDropDown;
    }

    private final BButton makeButton(Command command) {
        BButton bButton = new BButton(command, false, true);
        bButton.setBackground(Theme.widget().getWindowBackground());
        bButton.setButtonStyle(BButtonStyle.toolBar);
        return bButton;
    }

    public void doUpdateChartType(BWidgetEvent bWidgetEvent) {
        BListDropDown bListDropDown = (BListDropDown)bWidgetEvent.getWidget();
        Item item = (Item)((Object)bListDropDown.getList().getSelectedItem());
        BTypeSpec bTypeSpec = item.spec;
        int n = this.findIndex(bListDropDown.getName());
        this.model.get(n).setChartType(bTypeSpec);
    }

    private final int findIndex(String string) {
        int n = string.indexOf("_");
        return Integer.parseInt(string.substring(n + 1));
    }

    static BImage img(String string) {
        return BImage.make((String)("module://icons/x16/charts/" + string));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BHistoryList() {
        this(new HistoryListModel());
    }

    public BHistoryList(HistoryListModel historyListModel) {
        this.setModel(historyListModel);
    }

    static {
        Class clazz = class$com$tridium$history$ui$chart$BHistoryList;
        if (clazz == null) {
            clazz = class$com$tridium$history$ui$chart$BHistoryList = BHistoryList.class("[Lcom.tridium.history.ui.chart.BHistoryList;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        iconLine = BHistoryList.img("line.png");
        iconArea = BHistoryList.img("area.png");
        iconBar = BHistoryList.img("bar.png");
        iconStackBar = BHistoryList.img("bar.png");
        iconDisLine = BHistoryList.img("discreteLine.png");
        iconDisArea = BHistoryList.img("discreteArea.png");
        iconPie = BHistoryList.img("pie.png");
        Class clazz2 = class$com$tridium$history$ui$chart$BHistoryList;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$history$ui$chart$BHistoryList = BHistoryList.class("[Lcom.tridium.history.ui.chart.BHistoryList;", false);
        }
        module = Sys.getModuleForClass((Class)clazz2);
        lex = Lexicon.make((String)"history");
        lexEmpty = lex.getText("chartBuilder.noSelections");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SwatchController
    extends BBrushSwatch.Controller {
        public void mousePressed(BMouseEvent bMouseEvent) {
        }

        public void mouseReleased(BMouseEvent bMouseEvent) {
            BColor bColor = BColor.red;
            BBrush bBrush = this.swatch.getBrush();
            if (bBrush.getPaint() instanceof BBrush.Solid) {
                bColor = ((BBrush.Solid)bBrush.getPaint()).getColor();
            }
            if ((bColor = BColorChooser.openInDialog((BWidget)this.swatch, (BColor)bColor)) != null) {
                BBrush bBrush2 = bColor.toBrush();
                this.swatch.setBrush(bBrush2);
                this.swatch.repaint();
                int n = BHistoryList.this.findIndex(this.swatch.getName());
                BHistoryList.this.model.get(n).setBrush(bBrush2);
            }
        }

        public void mouseEntered(BMouseEvent bMouseEvent) {
            BWidget bWidget = bMouseEvent.getWidget();
            bWidget.setMouseCursor(MouseCursor.dropper);
        }

        public void mouseExited(BMouseEvent bMouseEvent) {
            BWidget bWidget = bMouseEvent.getWidget();
            bWidget.setMouseCursor(MouseCursor.normal);
        }

        private SwatchController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MoveUp
    extends Command {
        private HistoryItem item;

        public CommandArtifact doInvoke() {
            BHistoryList.this.model.moveUp(this.item);
            return null;
        }

        public MoveUp(BWidget bWidget, HistoryItem historyItem) {
            super(bWidget, module, "chartBuilder.command.moveUp");
            this.item = historyItem;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MoveDown
    extends Command {
        private HistoryItem item;

        public CommandArtifact doInvoke() {
            BHistoryList.this.model.moveDown(this.item);
            return null;
        }

        public MoveDown(BWidget bWidget, HistoryItem historyItem) {
            super(bWidget, module, "chartBuilder.command.moveDown");
            this.item = historyItem;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Delete
    extends Command {
        private HistoryItem item;

        public CommandArtifact doInvoke() {
            BHistoryList.this.model.remove(this.item);
            return null;
        }

        public Delete(BWidget bWidget, HistoryItem historyItem) {
            super(bWidget, module, "chartBuilder.command.delete");
            this.item = historyItem;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListModel
    extends DefaultListModel {
        public BImage getItemIcon(int n) {
            DefaultListModel.Item item = (DefaultListModel.Item)this.getItem(n);
            return item.icon;
        }

        ListModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Item
    extends DefaultListModel.Item {
        BTypeSpec spec;
        String label;

        public String toString() {
            return this.label;
        }

        public Item(BTypeSpec bTypeSpec, String string, BImage bImage) {
            super(bImage, (Object)string);
            this.label = string;
            this.spec = bTypeSpec;
        }
    }
}

