/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.history.nav.BFilteredHistoryNavNode;
import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.ui.chart.BHistoryChartBuilder;
import com.tridium.history.ui.chart.BHistoryList;
import com.tridium.history.ui.chart.BRollupEditor;
import com.tridium.history.ui.chart.HistoryItem;
import com.tridium.history.ui.chart.HistoryListModel;
import com.tridium.ui.theme.Theme;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartPane;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.chart.binding.BDiscreteAxisSpec;
import javax.baja.chart.binding.BTableChartBinding;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChartEditor
extends BEdgePane {
    public static final Action buildChart = BChartEditor.newAction((int)0, null);
    public static final Action clear = BChartEditor.newAction((int)0, null);
    public static final Action stateChange = BChartEditor.newAction((int)4, null);
    public static final Type TYPE;
    private static HashMap states;
    private static Lexicon lex;
    private static BFacets noTimeZone;
    BHistoryChartBuilder builder;
    private State state;
    private BNavTree tree;
    private BSplitPane split;
    private BWbFieldEditor timeRangeEd;
    private BTextField titleField;
    private BWbFieldEditor showGridEd;
    private BRollupEditor rollupEd;
    private BHistoryList historyList;
    private boolean ignoreChanges;
    static /* synthetic */ Class class$com$tridium$history$ui$chart$BChartEditor;

    public void buildChart() {
        this.invoke(buildChart, null, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    public void stateChange() {
        this.invoke(stateChange, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void load(BObject bObject) {
        this.tree.setModel((TreeModel)new DefaultNavTreeModel((BINavNode)BFilteredHistoryNavNode.make(bObject, null, new HistoryFilter(), null)));
        this.restoreState();
        this.tree.relayout();
    }

    public BTransferWidget getTransferWidget() {
        return this.historyList;
    }

    public void doBuildChart() {
        BFoxClientConnection bFoxClientConnection;
        Object object;
        BHistoryService bHistoryService;
        BOrd bOrd = this.builder.getWbShell().getActiveOrd();
        BHistoryChannel bHistoryChannel = null;
        try {
            bHistoryService = (BHistoryService)BOrd.make((BOrd)bOrd, (String)"service:history:HistoryService").resolve().get();
            object = bHistoryService.getSession();
            bFoxClientConnection = ((BFoxSession)object).getConnection();
            bHistoryChannel = (BHistoryChannel)bFoxClientConnection.getChannels().get("history", BHistoryChannel.TYPE);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)"Cannot build chart.", (Object)exception);
        }
        try {
            bHistoryService = this.buildWidgetTree();
            object = new ByteArrayOutputStream(1024);
            bFoxClientConnection = new PxEncoder((OutputStream)object);
            bFoxClientConnection.encodeDocument((BWidget)bHistoryService);
            ((OutputStream)object).flush();
            int n = bHistoryChannel.postReport(((ByteArrayOutputStream)object).toByteArray());
            BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("history:|view:history:HistoryChartBuilder?id=" + n)).normalize();
            this.builder.getWbShell().hyperlink(bOrd2);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)lex.getText("chartBuilder.cannotBuildChart"), (Object)lex.getText("chartBuilder.buildError"), (Throwable)exception);
        }
    }

    public void doClear() {
        this.historyList.getModel().clear();
    }

    public BWidget buildWidgetTree() {
        Object object;
        ArrayList<BChart> arrayList = new ArrayList<BChart>(1);
        BChart bChart = null;
        int n = 0;
        while (n < this.state.model.size()) {
            object = this.state.model.get(n);
            BTypeSpec bTypeSpec = ((HistoryItem)object).getChartType();
            boolean bl = this.rollupEd.isRollup();
            BChart bChart2 = null;
            if (bChart == null || !bChart.getType().getTypeSpec().equals((Object)bTypeSpec)) {
                bChart2 = (BChart)bTypeSpec.getInstance();
                arrayList.add(bChart2);
                bChart = bChart2;
            } else {
                bChart2 = bChart;
            }
            BTableChartBinding bTableChartBinding = new BTableChartBinding();
            BDynamicTimeRange bDynamicTimeRange = null;
            try {
                bDynamicTimeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)exception);
                throw new BajaRuntimeException((Throwable)exception);
            }
            StringBuffer stringBuffer = new StringBuffer();
            BIHistory bIHistory = ((HistoryItem)object).getHistory(this.builder.getHistorySpace());
            stringBuffer.append(bIHistory.getOrdInSession().toString());
            stringBuffer.append("?").append(this.toOrdParams(bDynamicTimeRange, bIHistory.getConfig().getTimeZone()));
            if (bl) {
                Object object2;
                BRollupInterval bRollupInterval = this.rollupEd.getInterval();
                if (bRollupInterval instanceof BRelTime) {
                    object2 = (BRelTime)bRollupInterval;
                    stringBuffer.append("|bql:history:HistoryRollup.rollup(baja:RelTime");
                    stringBuffer.append(" '").append(object2.getMillis()).append("')");
                } else if (bRollupInterval instanceof BRollupInterval) {
                    try {
                        object2 = bRollupInterval;
                        stringBuffer.append("|bql:history:HistoryRollup.rollup(history:RollupInterval");
                        stringBuffer.append(" '").append(object2.encodeToString()).append("')");
                    }
                    catch (IOException iOException) {
                        Log.getLog((String)"history").error("Failed to encode BRollupInterval to String", (Throwable)iOException);
                    }
                }
            }
            bTableChartBinding.setOrd(BOrd.make((String)stringBuffer.toString()));
            bTableChartBinding.setXColumn(BColumnIdentifier.makeTableColumn((String)"timestamp"));
            bTableChartBinding.setYColumn(BColumnIdentifier.makeTableColumn((String)(bl ? this.rollupEd.getAlgorithm() : "value")));
            bTableChartBinding.setBrush(((HistoryItem)object).getBrush());
            if (bl) {
                bTableChartBinding.setXAxis((BAxisSpec)new BDiscreteAxisSpec());
            }
            bChart2.add(null, (BValue)bTableChartBinding);
            ++n;
        }
        BChartPane bChartPane = new BChartPane();
        object = this.titleField.getText().trim();
        if (((String)object).length() != 0) {
            bChartPane.getHeader().setTitle((String)object);
        }
        try {
            if (this.showGridEd.saveValue() == BBoolean.TRUE) {
                bChartPane.getCanvas().setShowHorizontalGridLines(true);
                bChartPane.getCanvas().setShowVerticalGridLines(true);
            }
        }
        catch (Exception exception) {}
        int n2 = 0;
        while (n2 < arrayList.size()) {
            bChartPane.add(null, (BValue)((BChart)arrayList.get(n2)));
            ++n2;
        }
        return bChartPane;
    }

    public String toOrdParams(BDynamicTimeRange bDynamicTimeRange, BTimeZone bTimeZone) {
        BAbsTime bAbsTime;
        BDynamicTimeRangeType bDynamicTimeRangeType = bDynamicTimeRange.getRangeType();
        if (bDynamicTimeRangeType != BDynamicTimeRangeType.timeRange) {
            return "period=" + bDynamicTimeRangeType.getTag();
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("period=").append(bDynamicTimeRangeType.getTag());
        BAbsTime bAbsTime2 = bDynamicTimeRange.getFixedStartTime();
        if (bAbsTime2 != null && !bAbsTime2.isNull()) {
            bAbsTime2 = BAbsTime.make((long)bAbsTime2.getMillis(), (BTimeZone)bTimeZone);
            stringBuffer.append(';').append("start=").append(bAbsTime2.encodeToString());
        }
        if ((bAbsTime = bDynamicTimeRange.getFixedEndTime()) != null && !bAbsTime.isNull()) {
            bAbsTime = BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone);
            stringBuffer.append(';').append("end=").append(bAbsTime.encodeToString());
        }
        return stringBuffer.toString();
    }

    private final String toKey() {
        BWbShell bWbShell = this.builder.getWbShell();
        if (bWbShell == null) {
            return null;
        }
        return "" + bWbShell.getActiveOrdTarget().getOrdWithoutViewQuery();
    }

    public void doStateChange() {
        if (this.ignoreChanges) {
            return;
        }
        try {
            boolean bl = false;
            if (this.showGridEd.saveValue() == BBoolean.TRUE) {
                bl = true;
            }
            this.state.showGridLines = bl;
        }
        catch (Exception exception) {}
        this.state.dividerPosition = this.split.getDividerPosition();
        this.state.title = this.titleField.getText();
        this.state.rollup = this.rollupEd.pickle();
        try {
            this.state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void restoreState() {
        var1_1 = this.toKey();
        if (var1_1 == null) {
            return;
        }
        this.ignoreChanges = true;
        try {
            block9: {
                var4_2 = (State)BChartEditor.states.get(var1_1);
                if (var4_2 == null) break block9;
                var4_2.editor = this;
                if (var4_2.model instanceof Model) {
                    ((Model)var4_2.model).editor = this;
                }
                this.state = var4_2.copy();
                this.titleField.setText(this.state.title);
                this.timeRangeEd.loadValue((BObject)this.state.timeRange, (Context)BChartEditor.noTimeZone);
                this.historyList.setModel(this.state.model);
                var5_3 = this.state.expandedDevices.keySet().iterator();
                block3: while (true) {
                    block10: {
                        if (var5_3.hasNext()) break block10;
                        var6_4 = BFacets.makeBoolean((BString)BString.make((String)BChartEditor.lex.getText("chartBuilder.show")), (BString)BString.make((String)BChartEditor.lex.getText("chartBuilder.hide")));
                        this.showGridEd.loadValue((BObject)BBoolean.make((boolean)this.state.showGridLines), (Context)var6_4);
                        this.split.setDividerPosition(this.state.dividerPosition);
                        this.rollupEd.unpickle(this.state.rollup);
                        ** GOTO lbl-1000
                    }
                    var6_4 = (String)var5_3.next();
                    var7_5 = this.tree.getModel();
                    var8_6 = var7_5.getRootCount();
                    var9_7 = 0;
                    while (true) {
                        if (var9_7 >= var8_6) continue block3;
                        var10_8 = var7_5.getRoot(var9_7);
                        if (var6_4.equals(var10_8.getText())) {
                            this.tree.setExpanded(var10_8, true);
                            continue block3;
                        }
                        ++var9_7;
                    }
                    break;
                }
            }
            if (this.tree.getModel().getRootCount() == 1) {
                this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
            }
        }
        catch (Throwable var2_9) {
            var3_10 = null;
            this.ignoreChanges = false;
            throw var2_9;
        }
lbl-1000:
        // 2 sources

        {
            var3_11 = null;
            this.ignoreChanges = false;
            BChartEditor.states.put(var1_1, this.state);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ignoreChanges = false;
    }

    public BChartEditor() {
        this.this();
    }

    public BChartEditor(BHistoryChartBuilder bHistoryChartBuilder) {
        this.this();
        this.builder = bHistoryChartBuilder;
        this.state = new State();
        this.state.editor = this;
        Model model = new Model();
        model.editor = this;
        this.state.model = model;
        this.state.dividerPosition = 30.0;
        this.state.timeRange = BDynamicTimeRange.make((BDynamicTimeRangeType)BDynamicTimeRangeType.today);
        this.tree = new BNavTree();
        this.tree.setController((TreeController)new Controller());
        this.historyList = new BHistoryList(this.state.model);
        this.timeRangeEd = BWbFieldEditor.makeFor((BObject)BDynamicTimeRange.DEFAULT);
        this.timeRangeEd.loadValue((BObject)this.state.timeRange, (Context)noTimeZone);
        this.showGridEd = BWbFieldEditor.makeFor((BObject)BBoolean.TRUE);
        BFacets bFacets = BFacets.makeBoolean((BString)BString.make((String)lex.getText("chartBuilder.show")), (BString)BString.make((String)lex.getText("chartBuilder.hide")));
        this.showGridEd.loadValue((BObject)BBoolean.TRUE, (Context)bFacets);
        this.rollupEd = new BRollupEditor();
        BFont bFont = Theme.widget().getBoldText();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setStretchColumn(1);
        bGridPane.setColumnGap(10.0);
        bGridPane.setHalign(BHalign.fill);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("chartBuilder.timeRange"), bFont));
        bGridPane.add(null, (BValue)this.timeRangeEd);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("chartBuilder.title"), bFont));
        this.titleField = new BTextField("", 40);
        bGridPane.add(null, (BValue)this.titleField);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("chartBuilder.gridLines"), bFont));
        bGridPane.add(null, (BValue)this.showGridEd);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("chartBuilder.rollup"), bFont));
        bGridPane.add(null, (BValue)this.rollupEd);
        BGridPane bGridPane2 = new BGridPane(2);
        BButton bButton = new BButton(lex.getText("chartBuilder.buildChart"));
        BButton bButton2 = new BButton(lex.getText("chartBuilder.clear"));
        bGridPane2.add(null, (BValue)bButton);
        bGridPane2.add(null, (BValue)bButton2);
        String string = lex.getText("chartBuilder.histories");
        String string2 = lex.getText("chartBuilder.currentCharts");
        this.split = new BSplitPane();
        this.split.setDividerPosition(this.state.dividerPosition);
        this.split.setWidget1((BWidget)new BTitlePane(string, (BWidget)new BTreePane((BTree)this.tree)));
        this.split.setWidget2((BWidget)new BTitlePane(string2, (BWidget)new BScrollPane((BWidget)this.historyList)));
        this.setTop((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)5)));
        this.setCenter((BWidget)new BBorderPane((BWidget)this.split, (double)5, 0.0, 0.0, 0.0));
        this.setBottom((BWidget)new BBorderPane((BWidget)bGridPane2, (double)5, 0.0, 0.0, 0.0));
        this.add("chartLink", (BValue)new BLink((BComponent)bButton, (Slot)BButton.actionPerformed, (Slot)buildChart));
        this.add("clearLink", (BValue)new BLink((BComponent)bButton2, (Slot)BButton.actionPerformed, (Slot)clear));
        this.add("divChange", (BValue)new BLink((BComponent)this.split, (Slot)BSplitPane.dividerMoved, (Slot)stateChange));
        this.add("titleChange", (BValue)new BLink((BComponent)this.titleField, (Slot)BTextField.textModified, (Slot)stateChange));
        this.add("gridChange", (BValue)new BLink((BComponent)this.showGridEd, (Slot)BWbFieldEditor.setModified, (Slot)stateChange));
        this.add("timeChange", (BValue)new BLink((BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)stateChange));
        this.add("rollupChange", (BValue)new BLink((BComponent)this.rollupEd, (Slot)BRollupEditor.modified, (Slot)stateChange));
    }

    static {
        Class clazz = class$com$tridium$history$ui$chart$BChartEditor;
        if (clazz == null) {
            clazz = class$com$tridium$history$ui$chart$BChartEditor = BChartEditor.class("[Lcom.tridium.history.ui.chart.BChartEditor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        states = new HashMap();
        lex = Lexicon.make((String)"history");
        noTimeZone = BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HistoryFilter
    implements IFilter {
        public boolean accept(Object object) {
            if (!(object instanceof BIHistory)) {
                return false;
            }
            BIHistory bIHistory = (BIHistory)object;
            try {
                BTypeSpec bTypeSpec = bIHistory.getRecordType();
                Type type = bTypeSpec.getResolvedType();
                if (!type.is(BTrendRecord.TYPE)) {
                    return false;
                }
                BTrendRecord bTrendRecord = (BTrendRecord)type.getInstance();
                boolean bl = false;
                if (bTrendRecord.getValueProperty().getType() != BString.TYPE) {
                    bl = true;
                }
                return bl;
            }
            catch (Exception exception) {
                return false;
            }
        }

        private HistoryFilter() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class State {
        BChartEditor editor;
        public HistoryListModel model;
        public BDynamicTimeRange timeRange;
        public String title;
        public HashMap expandedDevices;
        public boolean showGridLines;
        public double dividerPosition;
        public int[] rollup;

        public State copy() {
            State state = new State();
            state.editor = this.editor;
            state.model = this.model.copy();
            state.title = this.title;
            state.timeRange = this.timeRange;
            state.expandedDevices = (HashMap)this.expandedDevices.clone();
            state.showGridLines = this.showGridLines;
            state.dividerPosition = this.dividerPosition;
            System.arraycopy(this.rollup, 0, state.rollup, 0, this.rollup.length);
            return state;
        }

        private final /* synthetic */ void this() {
            this.title = "";
            this.expandedDevices = new HashMap();
            this.showGridLines = true;
            this.rollup = new int[2];
        }

        State() {
            this.this();
        }
    }

    static class Model
    extends HistoryListModel {
        BChartEditor editor;

        public void changed() {
            super.changed();
            this.editor.doStateChange();
        }

        public void add(BIHistory[] bIHistoryArray) {
            int n = 0;
            while (n < bIHistoryArray.length) {
                if (!this.isHistoryValidToAdd(bIHistoryArray[n])) {
                    return;
                }
                ++n;
            }
            n = 0;
            while (n < bIHistoryArray.length) {
                this.doAdd(new HistoryItem(bIHistoryArray[n]));
                ++n;
            }
            this.changed();
        }

        public void add(HistoryItem[] historyItemArray) {
            int n = 0;
            while (n < historyItemArray.length) {
                if (!this.isHistoryValidToAdd(historyItemArray[n].getHistory(this.editor.builder.getHistorySpace()))) {
                    return;
                }
                ++n;
            }
            n = 0;
            while (n < historyItemArray.length) {
                this.doAdd(historyItemArray[n]);
                ++n;
            }
            this.changed();
        }

        public void add(BIHistory bIHistory) {
            if (!this.isHistoryValidToAdd(bIHistory)) {
                return;
            }
            this.doAdd(new HistoryItem(bIHistory));
            this.changed();
        }

        public void add(HistoryItem historyItem) {
            if (!this.isHistoryValidToAdd(historyItem.getHistory(this.editor.builder.getHistorySpace()))) {
                return;
            }
            this.doAdd(historyItem);
            this.changed();
        }

        public HistoryListModel copy() {
            Model model = new Model();
            model.editor = this.editor;
            int n = 0;
            while (n < this.size()) {
                model.list.add(this.get(n).copy());
                ++n;
            }
            return model;
        }

        private final boolean isHistoryValidToAdd(BIHistory bIHistory) {
            return this.editor.builder.getHistorySpace().exists(bIHistory.getId());
        }

        Model() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Controller
    extends TreeController {
        public void expanded(TreeNode treeNode) {
            ((BChartEditor)BChartEditor.this).state.expandedDevices.put(treeNode.getText(), BBoolean.TRUE);
        }

        public void collapsed(TreeNode treeNode) {
            ((BChartEditor)BChartEditor.this).state.expandedDevices.remove(treeNode.getText());
        }

        public void nodeDoubleClicked(BMouseEvent bMouseEvent, TreeNode treeNode) {
            BINavNode bINavNode = ((NavTreeNode)treeNode).getNavNode();
            if (bINavNode instanceof BIHistory) {
                BChartEditor.this.historyList.getModel().add((BIHistory)bINavNode);
            }
        }

        private Controller() {
        }
    }
}

