/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.fox.sys.NiagaraStation;
import java.lang.reflect.Field;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class HistorySourceSubscriber
extends Subscriber {
    static Log log = Log.getLog((String)"history");
    private static CoalesceQueue queue = new CoalesceQueue(1000);
    private static ThreadPoolWorker threadPool = new ThreadPoolWorker((Worker.ITodo)queue);
    Class historyImportClass;
    Field lastSuccessSlot;

    public final void event(BComponentEvent bComponentEvent) {
        block4: {
            BComponentEvent bComponentEvent2 = this.filterHistorySourceEvent(bComponentEvent);
            if (bComponentEvent2 != null) {
                try {
                    if (!threadPool.isRunning()) {
                        threadPool.start("HistorySourceSubscriber");
                    }
                    queue.enqueue((Object)new EventProcessor(this, bComponentEvent2));
                }
                catch (Exception exception) {
                    if (!log.isTraceOn()) break block4;
                    log.trace("Encountered error enqueuing history source event" + bComponentEvent, (Throwable)exception);
                }
            }
        }
    }

    protected BComponentEvent filterHistorySourceEvent(BComponentEvent bComponentEvent) {
        BComponent bComponent = bComponentEvent.getSourceComponent();
        if (bComponent instanceof NiagaraStation) {
            return null;
        }
        if (bComponent instanceof BHistoryExt) {
            if (!BHistoryExt.lastRecord.equals((Object)bComponentEvent.getSlot())) {
                return null;
            }
        } else {
            try {
                if (this.historyImportClass == null) {
                    this.historyImportClass = Sys.loadClass((String)"driver", (String)"javax.baja.driver.history.BHistoryImport");
                }
                if (this.historyImportClass.isInstance(bComponent)) {
                    Object object;
                    if (this.lastSuccessSlot == null) {
                        this.lastSuccessSlot = this.historyImportClass.getField("lastSuccess");
                    }
                    if (!(object = this.lastSuccessSlot.get(bComponent)).equals(bComponentEvent.getSlot())) {
                        return null;
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return bComponentEvent;
    }

    protected boolean allowCoalescedEvents() {
        return false;
    }

    public abstract void historySourceEvent(BComponentEvent var1);

    public static final Context makeAsyncContext(Context context) {
        return new BasicContext(context, BFacets.make((String)"asyncHistorySubscribe", (boolean)true));
    }

    private final /* synthetic */ void this() {
        this.historyImportClass = null;
        this.lastSuccessSlot = null;
    }

    public HistorySourceSubscriber() {
        this.this();
    }

    static {
        threadPool.setMaxThreads(100);
    }

    static class EventProcessor
    implements Runnable,
    ICoalesceable {
        HistorySourceSubscriber subscriber;
        BComponentEvent event;

        public void run() {
            block3: {
                try {
                    if (this.subscriber.getSubscriptionCount() > 0) {
                        this.subscriber.historySourceEvent(this.event);
                    }
                }
                catch (Exception exception) {
                    if (!log.isTraceOn()) break block3;
                    log.trace("Encountered error processing history source event" + this.event, (Throwable)exception);
                }
            }
        }

        public Object getCoalesceKey() {
            if (this.subscriber.allowCoalescedEvents()) {
                return this.subscriber;
            }
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
            return iCoalesceable;
        }

        public EventProcessor(HistorySourceSubscriber historySourceSubscriber, BComponentEvent bComponentEvent) {
            this.subscriber = historySourceSubscriber;
            this.event = bComponentEvent;
        }
    }
}

