/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.collection.BEmptyTable;
import com.tridium.history.ui.BOutlierParams;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HistoryEditorTableModel
extends CollectionTableModel {
    private boolean[] modified;
    private boolean[] outliers;
    private BOutlierParams outlierParams;
    private boolean isOutlierType;

    public void setCollection(BICollection bICollection) {
        super.setCollection(bICollection);
        BITable bITable = this.getBITable();
        if (bITable.size() != 0) {
            BTrendRecord bTrendRecord = (BTrendRecord)bITable.get(0);
            this.isOutlierType = bTrendRecord.getValueProperty().getType().is(BINumeric.TYPE);
        }
        this.modified = new boolean[bITable.size()];
        this.outliers = new boolean[bITable.size()];
        this.updateOutliers();
        this.updateTable();
    }

    public BTrendRecord getRecord(int n) {
        return (BTrendRecord)this.getBITable().get(n);
    }

    public boolean modifyRecords(int[] nArray, BBoolean bBoolean, BSimple bSimple) {
        boolean bl = false;
        int n = 0;
        while (n < nArray.length) {
            BSimple bSimple2;
            BTrendRecord bTrendRecord = this.getRecord(nArray[n]);
            boolean bl2 = false;
            if (bBoolean != null) {
                boolean bl3 = bBoolean.getBoolean();
                BTrendFlags bTrendFlags = bTrendRecord.getTrendFlags();
                if (bTrendFlags.getBit(4) != bl3) {
                    BTrendFlags bTrendFlags2 = bTrendRecord.getTrendFlags().set(4, bl3);
                    bTrendRecord.setTrendFlags(bTrendFlags2);
                    this.setModified(nArray[n], true);
                    bl2 = true;
                    bl = true;
                }
            }
            if (bSimple != null && !(bSimple2 = (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty())).equals((Object)bSimple)) {
                bTrendRecord.set(bTrendRecord.getValueProperty(), (BValue)bSimple);
                bl2 = true;
                bl = true;
            }
            if (bl2) {
                bTrendRecord.setTrendFlags(bTrendRecord.getTrendFlags().set(8, true));
                this.modified[nArray[n]] = true;
            }
            ++n;
        }
        if (bl) {
            this.updateOutliers();
        }
        this.updateTable();
        return bl;
    }

    public boolean isModified(int n) {
        if (this.modified == null) {
            return false;
        }
        return this.modified[n];
    }

    public void setModified(int n, boolean bl) {
        if (this.modified == null) {
            this.modified = new boolean[this.getRowCount()];
        }
        this.modified[n] = bl;
    }

    public void clearModified() {
        BITable bITable = this.getBITable();
        this.modified = new boolean[bITable.size()];
    }

    public void setOutlierParams(BOutlierParams bOutlierParams) {
        this.outlierParams = bOutlierParams;
        this.updateOutliers();
    }

    public boolean isOutlier(int n) {
        if (this.outliers == null) {
            return false;
        }
        return this.outliers[n];
    }

    public int[] getOutliers() {
        if (this.outliers == null) {
            return new int[0];
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.outliers.length) {
            if (this.outliers[n2]) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.outliers.length && n4 < n) {
            if (this.outliers[n3]) {
                nArray[n4++] = n3;
            }
            ++n3;
        }
        return nArray;
    }

    public void clearOutliers() {
        BITable bITable = this.getBITable();
        this.outliers = new boolean[bITable.size()];
        this.getTable().repaint();
    }

    public void selectOutliers() {
        this.getTable().getSelection().deselectAll();
        int[] nArray = this.getOutliers();
        if (nArray.length == 0) {
            return;
        }
        this.getTable().getSelection().select(nArray);
    }

    public static boolean isOutlier(BITable bITable, int n, int n2, float f) {
        if (bITable == null || bITable.size() < 1) {
            return false;
        }
        int n3 = bITable.size();
        int n4 = n - n2 / 2;
        int n5 = n4 + n2 - 1;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 >= n3) {
            n5 = n3 - 1;
        }
        if (n == n4) {
            return false;
        }
        if (n == n5) {
            return false;
        }
        int n6 = 0;
        double d = 0.0;
        double[] dArray = new double[n5 - n4 + 1];
        int n7 = n4;
        while (n7 <= n5) {
            if (n7 != n) {
                BTrendRecord bTrendRecord = (BTrendRecord)bITable.get(n7);
                dArray[n6] = ((BDouble)bTrendRecord.get(bTrendRecord.getValueProperty())).getDouble();
                d += dArray[n6];
                ++n6;
            }
            ++n7;
        }
        if (n6 <= 1) {
            return false;
        }
        double[] dArray2 = new double[n6];
        System.arraycopy(dArray, 0, dArray2, 0, n6);
        double d2 = d / (double)n6;
        float f2 = 0.0f;
        int n8 = 0;
        while (n8 < n6) {
            f2 = (float)((double)f2 + (dArray2[n8] - d2) * (dArray2[n8] - d2));
            ++n8;
        }
        float f3 = (float)Math.sqrt(f2 / (float)(n6 - 1));
        BTrendRecord bTrendRecord = (BTrendRecord)bITable.get(n);
        double d3 = ((BDouble)bTrendRecord.get(bTrendRecord.getValueProperty())).getDouble();
        return !(d3 >= d2 - (double)(f3 * f)) || !(d3 <= d2 + (double)(f3 * f));
    }

    public void updateOutliers() {
        if (!this.isOutlierType || !this.outlierParams.getEnabled()) {
            this.clearOutliers();
            return;
        }
        int n = this.outlierParams.getWindowSize();
        float f = this.outlierParams.getPercentStdDev();
        BITable bITable = this.getBITable();
        int n2 = bITable.size();
        if (this.outliers == null) {
            this.outliers = new boolean[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.outliers[n3] = HistoryEditorTableModel.isOutlier(bITable, n3, n, f / 100.0f);
            ++n3;
        }
    }

    private final /* synthetic */ void this() {
        this.isOutlierType = true;
    }

    public HistoryEditorTableModel(Context context) {
        this((BITable)new BEmptyTable(), context);
    }

    public HistoryEditorTableModel(BITable bITable, Context context) {
        super(bITable, context);
        this.this();
    }
}

