/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.rollup.BHistoryRollupRecord;
import com.tridium.history.rollup.TrendRecordRollupValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CollectiveRollupValue
extends TrendRecordRollupValue {
    private double sum;
    private int count;
    private double min;
    private double max;
    private boolean firstElement;

    protected synchronized void doAddElement(BHistoryRecord bHistoryRecord) {
        if (bHistoryRecord instanceof BNumericTrendRecord) {
            double d = ((BNumericTrendRecord)bHistoryRecord).getValue();
            if (this.firstElement) {
                this.max = d;
                this.min = d;
                this.firstElement = false;
            } else {
                if (d > this.max) {
                    this.max = d;
                }
                if (d < this.min) {
                    this.min = d;
                }
            }
            this.sum += d;
            ++this.count;
        }
    }

    public BHistoryRecord getValue(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        return new BHistoryRollupRecord(bAbsTime, bAbsTime2, this.count, this.min, this.max, this.count > 0 ? this.sum / (double)this.count : 0.0, this.sum);
    }

    public synchronized void reset() {
        this.sum = 0.0;
        this.count = 0;
        this.max = 0.0;
        this.min = 0.0;
        this.firstElement = true;
    }

    private final /* synthetic */ void this() {
        this.sum = 0.0;
        this.count = 0;
        this.min = 0.0;
        this.max = 0.0;
        this.firstElement = true;
    }

    public CollectiveRollupValue() {
        this.this();
    }

    public CollectiveRollupValue(BStatus bStatus, BTrendFlags bTrendFlags, BTrendFlags bTrendFlags2) {
        super(bStatus, bTrendFlags, bTrendFlags2);
        this.this();
    }
}

