/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.log;

import com.tridium.util.ThrowableUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.log.Log;
import javax.baja.log.LogRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLogRecord
extends BHistoryRecord {
    public static final Property logName = BLogRecord.newProperty((int)0, (String)"", null);
    public static final Property severity = BLogRecord.newProperty((int)0, (int)3, null);
    public static final Property message = BLogRecord.newProperty((int)0, (String)"", null);
    public static final Property exception = BLogRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    public static final int STACK_TRACE_DEPTH;
    static /* synthetic */ Class class$com$tridium$history$log$BLogRecord;

    public String getLogName() {
        return this.getString(logName);
    }

    public void setLogName(String string) {
        this.setString(logName, string, null);
    }

    public int getSeverity() {
        return this.getInt(severity);
    }

    public void setSeverity(int n) {
        this.setInt(severity, n, null);
    }

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String string) {
        this.setString(message, string, null);
    }

    public String getException() {
        return this.getString(exception);
    }

    public void setException(String string) {
        this.setString(exception, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BLogRecord fromRecord(LogRecord logRecord) {
        return new BLogRecord(BAbsTime.make((long)logRecord.timestamp), logRecord.logName, logRecord.severity, logRecord.message == null ? "" : logRecord.message, BLogRecord.formatThrowable(logRecord.exception));
    }

    public BLogRecord setFromRecord(LogRecord logRecord) {
        this.setTimestamp(BAbsTime.make((long)logRecord.timestamp));
        this.setLogName(logRecord.logName);
        this.setSeverity(logRecord.severity);
        this.setMessage(logRecord.message == null ? "" : logRecord.message);
        this.setException(BLogRecord.formatThrowable(logRecord.exception));
        return this;
    }

    private static final String formatThrowable(Throwable throwable) {
        return ThrowableUtil.dumpToString((Throwable)throwable, (int)STACK_TRACE_DEPTH);
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput dataInput) throws IOException {
        this.setLogName(dataInput.readUTF());
        this.setSeverity(dataInput.readInt());
        this.setMessage(dataInput.readUTF());
        this.setException(dataInput.readUTF());
    }

    protected void doWrite(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getLogName());
        dataOutput.writeInt(this.getSeverity());
        dataOutput.writeUTF(this.getMessage());
        dataOutput.writeUTF(this.getException());
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(super.toString(context));
        stringBuffer.append('[').append(Log.severityToString((int)this.getSeverity())).append("] ");
        stringBuffer.append(this.getMessage());
        String string = this.getException();
        if (string.length() != 0) {
            stringBuffer.append(string.substring(0, 60));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BLogRecord() {
    }

    public BLogRecord(BAbsTime bAbsTime, String string, int n, String string2, String string3) {
        super(bAbsTime);
        this.setLogName(string);
        this.setSeverity(n);
        this.setMessage(string2);
        this.setException(string3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Class clazz = class$com$tridium$history$log$BLogRecord;
        if (clazz == null) {
            clazz = class$com$tridium$history$log$BLogRecord = BLogRecord.class("[Lcom.tridium.history.log.BLogRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        String string = System.getProperty("niagara.loghistory.error.depth", "5");
        int n = 5;
        try {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            STACK_TRACE_DEPTH = Math.min(Math.max(1, n), 20);
            throw throwable;
        }
        {
            Object var3_4 = null;
        }
        STACK_TRACE_DEPTH = Math.min(Math.max(1, n), 20);
    }
}

