/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.io;

import com.tridium.history.collection.ColumnSpec;
import com.tridium.history.io.HistoryOutput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public class RecordOutput
extends HistoryOutput {
    private BFacets tableFacets;
    private ColumnSpec[] specs;

    protected void doWriteHeader(DataOutput dataOutput) throws IOException {
        if (this.tableFacets == null) {
            BFacets.NULL.encode(dataOutput);
        } else {
            this.tableFacets.encode(dataOutput);
        }
        if (this.specs == null) {
            dataOutput.writeBoolean(false);
            return;
        }
        dataOutput.writeBoolean(true);
        dataOutput.writeInt(this.specs.length);
        int n = 0;
        while (n < this.specs.length) {
            this.specs[n].write(dataOutput);
            ++n;
        }
    }

    protected void doWrite(DataOutput dataOutput, BObject bObject) throws IOException {
        ((BHistoryRecord)bObject).write(dataOutput);
    }

    public static ColumnSpec[] getColumnSpecs(BHistoryConfig bHistoryConfig, Context context) {
        BHistoryRecord bHistoryRecord = bHistoryConfig.makeRecord();
        Property[] propertyArray = bHistoryRecord.getPropertiesArray();
        ColumnSpec[] columnSpecArray = new ColumnSpec[propertyArray.length];
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            BFacets bFacets = bHistoryConfig.getSlotFacets((Slot)property);
            BFacets bFacets2 = null;
            try {
                bFacets2 = (BFacets)bHistoryConfig.get(property.getName() + "Facets");
            }
            catch (Exception exception) {}
            bFacets = BFacets.make((BFacets)bFacets, bFacets2);
            columnSpecArray[n] = new ColumnSpec(property.getName(), property.getDefaultDisplayName(context), bFacets);
            ++n;
        }
        return columnSpecArray;
    }

    public static ColumnSpec[] getColumnSpecs(BITable bITable, Context context) {
        ColumnList columnList = bITable.getColumns();
        int n = columnList.size();
        ColumnSpec[] columnSpecArray = new ColumnSpec[n];
        int n2 = 0;
        while (n2 < n) {
            Column column = columnList.get(n2);
            BFacets bFacets = column.getFacets();
            if (bFacets == null) {
                bFacets = BFacets.NULL;
            }
            columnSpecArray[n2] = new ColumnSpec(column.getName(), column.getDisplayName(context), bFacets);
            ++n2;
        }
        return columnSpecArray;
    }

    public RecordOutput(DataOutput dataOutput) {
        super(dataOutput);
    }

    public RecordOutput(BHistoryConfig bHistoryConfig, DataOutput dataOutput, Context context) {
        super(dataOutput);
        this.specs = RecordOutput.getColumnSpecs(bHistoryConfig, context);
    }

    public RecordOutput(BITable bITable, DataOutput dataOutput, Context context) {
        super(dataOutput);
        this.tableFacets = bITable.getTableFacets();
        this.specs = RecordOutput.getColumnSpecs(bITable, context);
    }

    public RecordOutput(BITable bITable, Type type, DataOutput dataOutput, Context context) {
        super(type, dataOutput);
        this.tableFacets = bITable.getTableFacets();
        this.specs = RecordOutput.getColumnSpecs(bITable, context);
    }
}

