/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.io;

import com.tridium.history.io.RandomAccess;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileRandomAccess
implements RandomAccess {
    private RandomAccessFile io;
    private long offset;
    private boolean closeable;

    public void close() throws IOException {
        if (this.closeable) {
            this.io.close();
        }
    }

    public void seek(long l) throws IOException {
        this.io.seek(l + this.offset);
    }

    public long pos() throws IOException {
        return this.io.getFilePointer() - this.offset;
    }

    public long length() throws IOException {
        return this.io.length() - this.offset;
    }

    public void setLength(long l) throws IOException {
        this.io.setLength(l + this.offset);
    }

    public void flush() throws IOException {
        this.io.getFD().sync();
    }

    public FileDescriptor getFD() throws IOException {
        return this.io.getFD();
    }

    public int read() throws IOException {
        return this.io.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.io.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.io.read(byArray, n, n2);
    }

    public boolean readBoolean() throws IOException {
        return this.io.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.io.readByte();
    }

    public char readChar() throws IOException {
        return this.io.readChar();
    }

    public double readDouble() throws IOException {
        return this.io.readDouble();
    }

    public float readFloat() throws IOException {
        return this.io.readFloat();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.io.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.io.readFully(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.io.readInt();
    }

    public String readLine() throws IOException {
        return this.io.readLine();
    }

    public long readLong() throws IOException {
        return this.io.readLong();
    }

    public short readShort() throws IOException {
        return this.io.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.io.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.io.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.io.readUTF();
    }

    public int skipBytes(int n) throws IOException {
        return this.io.skipBytes(n);
    }

    public void write(int n) throws IOException {
        this.io.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.io.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.io.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.io.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.io.writeByte(n);
    }

    public void writeBytes(String string) throws IOException {
        this.io.writeBytes(string);
    }

    public void writeChar(int n) throws IOException {
        this.io.writeChar(n);
    }

    public void writeChars(String string) throws IOException {
        this.io.writeChars(string);
    }

    public void writeDouble(double d) throws IOException {
        this.io.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.io.writeFloat(f);
    }

    public void writeInt(int n) throws IOException {
        this.io.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.io.writeLong(l);
    }

    public void writeShort(int n) throws IOException {
        this.io.writeShort(n);
    }

    public void writeUTF(String string) throws IOException {
        this.io.writeUTF(string);
    }

    public FileRandomAccess(File file, String string) throws IOException {
        this(file, string, 0L);
    }

    public FileRandomAccess(File file, String string, long l) throws IOException {
        this(new RandomAccessFile(file, string), l);
        this.closeable = true;
    }

    public FileRandomAccess(String string, String string2) throws IOException {
        this(string, string2, 0L);
    }

    public FileRandomAccess(String string, String string2, long l) throws IOException {
        this(new RandomAccessFile(string, string2), l);
        this.closeable = true;
    }

    public FileRandomAccess(RandomAccessFile randomAccessFile, long l) {
        this.io = randomAccessFile;
        this.offset = l;
        this.closeable = false;
    }
}

