/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.fox;

import com.tridium.bql.projection.BProjectionTable;
import com.tridium.bql.projection.ColumnProjectionColumn;
import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryFolder;
import com.tridium.history.BHistoryMirror;
import com.tridium.history.RecordInputCursor;
import com.tridium.history.collection.BRecordTable;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.fox.BFoxHistoryDevice;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.fox.FoxHistoryException;
import com.tridium.history.io.HistoryInput;
import com.tridium.history.io.HistoryOutput;
import com.tridium.history.io.RecordInput;
import com.tridium.history.io.RecordOutput;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.data.BIDataTable;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.io.ByteBuffer;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.PatternFilter;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryChannel
extends BFoxChannel {
    public static final Type TYPE;
    private static final int HISTORY_NAV_NODE = 0;
    private static final int DEVICE_NAV_NODE = 1;
    private static final int HISTORY_FOLDER_NAV_NODE = 2;
    final HistoryChannelSubscriber historyChannelSubscriber;
    HashMap subscriptionCounter;
    static /* synthetic */ Class class$com$tridium$history$fox$BHistoryChannel;
    static /* synthetic */ Class class$javax$baja$history$BHistoryConfig;

    public Type getType() {
        return TYPE;
    }

    public void sessionOpened() throws Exception {
        this.historyChannelSubscriber.init();
    }

    public void sessionClosed(Throwable throwable) throws Exception {
        this.historyChannelSubscriber.kill();
        this.unsubscribeAllHistories();
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "deviceExists") {
            return this.deviceExists(foxRequest);
        }
        if (string == "getDevice") {
            return this.getDevice(foxRequest);
        }
        if (string == "exists") {
            return this.exists(foxRequest);
        }
        if (string == "getHistory") {
            return this.getHistory(foxRequest);
        }
        if (string == "getCategoryMasks") {
            return this.getCategoryMasks(foxRequest);
        }
        if (string == "createHistory") {
            return this.createHistory(foxRequest);
        }
        if (string == "getConfig") {
            return this.getConfig(foxRequest);
        }
        if (string == "getConfigs") {
            return this.getConfigs(foxRequest);
        }
        if (string == "setConfig") {
            return this.setConfig(foxRequest);
        }
        if (string == "getSummary") {
            return this.getSummary(foxRequest);
        }
        if (string == "deleteHistories") {
            return this.deleteHistories(foxRequest);
        }
        if (string == "renameHistory") {
            return this.renameHistory(foxRequest);
        }
        if (string == "listDevices") {
            return this.listDevices(foxRequest);
        }
        if (string == "listHistories") {
            return this.listHistories(foxRequest);
        }
        if (string == "clearAllRecords") {
            return this.clearAllRecords(foxRequest);
        }
        if (string == "clearOldRecords") {
            return this.clearOldRecords(foxRequest);
        }
        if (string == "postReport") {
            return this.postReport(foxRequest);
        }
        if (string == "getReport") {
            return this.getReport(foxRequest);
        }
        if (string == "updateSubscription") {
            return this.updateHistorySubscriptionCount(foxRequest);
        }
        if (string == "setProperty") {
            return this.setProperty(foxRequest);
        }
        if (string == "setPropertyFlags") {
            return this.setPropertyFlags(foxRequest);
        }
        if (string == "addProperty") {
            return this.addProperty(foxRequest);
        }
        if (string == "removeProperty") {
            return this.removeProperty(foxRequest);
        }
        if (string == "removeAllProperties") {
            return this.removeAllProperties(foxRequest);
        }
        if (string == "renameProperty") {
            return this.renameProperty(foxRequest);
        }
        if (string == "setPropertyFacets") {
            return this.setPropertyFacets(foxRequest);
        }
        if (string == "reorderProperties") {
            return this.reorderProperties(foxRequest);
        }
        if (string == "reorderPropertyToTop") {
            return this.reorderPropertyToTop(foxRequest);
        }
        if (string == "reorderPropertyToBottom") {
            return this.reorderPropertyToBottom(foxRequest);
        }
        if (string == "getPermissionsByOrd") {
            return this.getPermissionsByOrd(foxRequest);
        }
        if (string == "getGroupNames") {
            return this.getHistoryGroupNames(foxRequest);
        }
        if (string == "getGroupProperties") {
            return this.getSortPropertiesForGroup(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "append") {
            this.append(foxCircuit);
            return;
        }
        if (string == "getLastRecord") {
            this.getLastRecord(foxCircuit);
            return;
        }
        if (string == "timeQuery") {
            this.timeQuery(foxCircuit);
            return;
        }
        if (string == "resolve") {
            this.resolve(foxCircuit);
            return;
        }
        if (string == "update") {
            this.update(foxCircuit);
            return;
        }
        if (string == "getFolderNavChildren") {
            this.getFolderNavChildren(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public BHistoryDevice[] listDevices(BFoxHistorySpace bFoxHistorySpace) throws Exception {
        FoxRequest foxRequest = this.makeRequest("listDevices");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxTuple[] foxTupleArray = foxResponse.list("d");
        if (foxTupleArray == null) {
            return new BHistoryDevice[0];
        }
        BHistoryDevice[] bHistoryDeviceArray = new BFoxHistoryDevice[foxTupleArray.length];
        int n = 0;
        while (n < bHistoryDeviceArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            String string = foxMessage.getString("n");
            BPermissions bPermissions = BPermissions.make((String)foxMessage.getString("p"));
            bHistoryDeviceArray[n] = new BFoxHistoryDevice(bFoxHistorySpace, string, bPermissions);
            ++n;
        }
        return bHistoryDeviceArray;
    }

    public FoxResponse listDevices(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryDevice[] bHistoryDeviceArray = bHistoryDatabase.listDevices();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        int n = 0;
        if (bHistoryDeviceArray != null) {
            n = bHistoryDeviceArray.length;
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            BPermissions bPermissions = this.getPermissionsFor((Object)bHistoryDeviceArray[n3]);
            if (bPermissions.hasOperatorRead()) {
                FoxMessage foxMessage = new FoxMessage("d");
                foxMessage.add("n", bHistoryDeviceArray[n3].getDeviceName());
                foxMessage.add("p", bPermissions.encodeToString());
                foxResponse.add((FoxTuple)foxMessage);
            }
            ++n3;
        }
        return foxResponse;
    }

    public BHistoryId[] listHistories(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("listHistories");
        foxRequest.add("d", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxTuple[] foxTupleArray = foxResponse.list("h");
        if (foxTupleArray == null) {
            return new BHistoryId[0];
        }
        BHistoryId[] bHistoryIdArray = new BHistoryId[foxTupleArray.length];
        int n = 0;
        while (n < bHistoryIdArray.length) {
            BHistoryId bHistoryId;
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            bHistoryIdArray[n] = bHistoryId = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(foxMessage.getString("id"));
            ++n;
        }
        return bHistoryIdArray;
    }

    public BIHistory[] listHistories(BFoxHistorySpace bFoxHistorySpace, BHistoryDevice bHistoryDevice) throws Exception {
        String string = bHistoryDevice.getDeviceName();
        FoxRequest foxRequest = this.makeRequest("listHistories");
        foxRequest.add("d", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxTuple[] foxTupleArray = foxResponse.list("h");
        if (foxTupleArray == null) {
            return new BFoxHistory[0];
        }
        BIHistory[] bIHistoryArray = new BFoxHistory[foxTupleArray.length];
        int n = 0;
        while (n < bIHistoryArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            BHistoryId bHistoryId = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(foxMessage.getString("id"));
            BTypeSpec bTypeSpec = null;
            String string2 = foxMessage.getString("t", null);
            if (string2 != null) {
                bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(string2);
            }
            BPermissions bPermissions = BPermissions.make((String)foxMessage.getString("p"));
            bIHistoryArray[n] = new BFoxHistory(bFoxHistorySpace, bHistoryId, bTypeSpec, bPermissions, foxMessage.getString("d", null));
            ++n;
        }
        return bIHistoryArray;
    }

    public FoxResponse listHistories(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        String string = foxRequest.getString("d");
        BIHistory[] bIHistoryArray = bHistoryDatabase.listHistories(bHistoryDatabase.getDevice(string));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        int n = 0;
        if (bIHistoryArray != null) {
            n = bIHistoryArray.length;
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            BPermissions bPermissions = this.getPermissionsFor(bIHistoryArray[n3]);
            if (bPermissions.hasOperatorRead()) {
                FoxMessage foxMessage = new FoxMessage("h");
                foxMessage.add("id", bIHistoryArray[n3].getId().encodeToString());
                foxMessage.add("t", bIHistoryArray[n3].getRecordType().encodeToString());
                foxMessage.add("p", bPermissions.encodeToString());
                try {
                    BFormat bFormat = BHistory.getHistoryDisplayNameFormat(bIHistoryArray[n3]);
                    if (bFormat != null) {
                        foxMessage.add("d", bFormat.format((Object)bIHistoryArray[n3], this.getSessionContext()));
                    }
                }
                catch (Exception exception) {}
                foxResponse.add((FoxTuple)foxMessage);
            }
            ++n3;
        }
        return foxResponse;
    }

    public boolean deviceExists(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("deviceExists");
        foxRequest.add("name", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getBoolean("exists");
    }

    public FoxResponse deviceExists(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        boolean bl = bHistoryDatabase.deviceExists(foxRequest.getString("name"));
        foxResponse.add("exists", bl);
        return foxResponse;
    }

    public BHistoryDevice getDevice(BFoxHistorySpace bFoxHistorySpace, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getDevice");
        foxRequest.add("n", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("e")) {
            return null;
        }
        BPermissions bPermissions = BPermissions.make((String)foxResponse.getString("p"));
        return new BFoxHistoryDevice(bFoxHistorySpace, string, bPermissions);
    }

    public FoxResponse getDevice(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryDevice bHistoryDevice = bHistoryDatabase.getDevice(foxRequest.getString("n"));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BPermissions bPermissions = null;
        if (bHistoryDevice != null && !(bPermissions = this.getPermissionsFor((Object)bHistoryDevice)).hasOperatorRead()) {
            bHistoryDevice = null;
        }
        boolean bl = false;
        if (bHistoryDevice != null) {
            bl = true;
        }
        foxResponse.add("e", bl);
        if (bHistoryDevice != null) {
            foxResponse.add("p", bPermissions.encodeToString());
        }
        return foxResponse;
    }

    public boolean exists(BHistoryId bHistoryId) throws Exception {
        FoxRequest foxRequest = this.makeRequest("exists");
        foxRequest.add("id", bHistoryId.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getBoolean("exists");
    }

    public FoxResponse exists(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        boolean bl = bHistoryDatabase.exists(bHistoryId);
        foxResponse.add("exists", bl);
        return foxResponse;
    }

    public BCategoryMask[] getCategoryMasks(BFoxHistorySpace bFoxHistorySpace, BOrd bOrd) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getCategoryMasks");
        foxRequest.add("ord", bOrd.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        BCategoryMask bCategoryMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(foxResponse.getString("m"));
        BCategoryMask bCategoryMask2 = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(foxResponse.getString("a"));
        return new BCategoryMask[]{bCategoryMask, bCategoryMask2};
    }

    public FoxResponse getCategoryMasks(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("ord");
        BOrd bOrd = BOrd.make((String)("local:|" + string));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BObject bObject = bOrd.resolve().get();
        if (!(bObject instanceof BICategorizable)) {
            throw new BajaRuntimeException("Not categorizable: " + string);
        }
        BICategorizable bICategorizable = (BICategorizable)bObject;
        foxResponse.add("m", bICategorizable.getCategoryMask().encodeToString());
        foxResponse.add("a", bICategorizable.getAppliedCategoryMask().encodeToString());
        return foxResponse;
    }

    public BIHistory getHistory(BFoxHistorySpace bFoxHistorySpace, BHistoryId bHistoryId) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getHistory");
        foxRequest.add("id", bHistoryId.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("e")) {
            return null;
        }
        BTypeSpec bTypeSpec = null;
        String string = foxResponse.getString("t", null);
        if (string != null) {
            bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(string);
        }
        BPermissions bPermissions = BPermissions.make((String)foxResponse.getString("p"));
        return new BFoxHistory(bFoxHistorySpace, bHistoryId, bTypeSpec, bPermissions, foxResponse.getString("d", null));
    }

    public FoxResponse getHistory(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BIHistory bIHistory = bHistoryDatabase.getHistory(BHistoryId.make(foxRequest.getString("id")));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BPermissions bPermissions = null;
        if (bIHistory != null && !(bPermissions = this.getPermissionsFor(bIHistory)).hasOperatorRead()) {
            bIHistory = null;
        }
        boolean bl = false;
        if (bIHistory != null) {
            bl = true;
        }
        foxResponse.add("e", bl);
        if (bIHistory != null) {
            foxResponse.add("t", bIHistory.getRecordType().encodeToString());
            foxResponse.add("p", bPermissions.encodeToString());
            try {
                BFormat bFormat = BHistory.getHistoryDisplayNameFormat(bIHistory);
                if (bFormat != null) {
                    foxResponse.add("d", bFormat.format((Object)bIHistory, this.getSessionContext()));
                }
            }
            catch (Exception exception) {}
        }
        return foxResponse;
    }

    public void createHistory(BHistoryConfig bHistoryConfig) throws Exception {
        FoxRequest foxRequest = this.makeRequest("createHistory");
        foxRequest.add("xml", ValueDocEncoder.marshal((BValue)bHistoryConfig));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            throw new HistoryException("Cannot create history: " + (Object)((Object)bHistoryConfig.getId()));
        }
    }

    public FoxResponse createHistory(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryConfig bHistoryConfig = (BHistoryConfig)ValueDocDecoder.unmarshal((String)foxRequest.getString("xml"));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BPermissions bPermissions = this.getPermissionsFor((Object)bHistoryDatabase);
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("User does not have permission to create history " + (Object)((Object)bHistoryConfig.getId()));
            }
            bHistoryDatabase.createHistory(bHistoryConfig);
            foxResponse.add("success", bHistoryDatabase.exists(bHistoryConfig.getId()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public BHistoryConfig getConfig(BHistoryId bHistoryId) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getConfig");
        foxRequest.add("id", bHistoryId.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string = foxResponse.getString("xml", null);
        if (string == null) {
            throw new HistoryNotFoundException(bHistoryId);
        }
        BHistoryConfig bHistoryConfig = (BHistoryConfig)ValueDocDecoder.unmarshal((String)string);
        return bHistoryConfig;
    }

    public FoxResponse getConfig(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        BHistoryConfig bHistoryConfig = bHistoryDatabase.getConfig(bHistoryId);
        if (bHistoryConfig != null) {
            foxResponse.add("xml", ValueDocEncoder.marshal((BValue)bHistoryConfig));
        }
        return foxResponse;
    }

    public BHistoryConfig[] getConfigs(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getConfigs");
        foxRequest.add("patternFilter", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        int n = foxResponse.getInt("numConfigs", 0);
        if (n < 1) {
            return null;
        }
        BHistoryConfig[] bHistoryConfigArray = new BHistoryConfig[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = foxResponse.getString(("xml" + n2).intern());
            bHistoryConfigArray[n2] = (BHistoryConfig)ValueDocDecoder.unmarshal((String)string2);
            ++n2;
        }
        return bHistoryConfigArray;
    }

    public FoxResponse getConfigs(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        if (!(bHistoryDatabase instanceof BLocalHistoryDatabase)) {
            throw new HistoryException("Cannot find local history database.");
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        String string = foxRequest.getString("patternFilter");
        BHistoryConfig[] bHistoryConfigArray = this.getConfigs(bHistoryDatabase, string);
        int n = 0;
        if (bHistoryConfigArray != null) {
            n = bHistoryConfigArray.length;
        }
        int n2 = n;
        foxResponse.add("numConfigs", n2);
        int n3 = 0;
        while (n3 < n2) {
            foxResponse.add("xml" + n3, ValueDocEncoder.marshal((BValue)bHistoryConfigArray[n3]));
            ++n3;
        }
        return foxResponse;
    }

    private final BHistoryConfig[] getConfigs(BHistoryDatabase bHistoryDatabase, String string) {
        BHistoryDevice[] bHistoryDeviceArray = bHistoryDatabase.listDevices();
        if (bHistoryDeviceArray == null) {
            return null;
        }
        Class clazz = class$javax$baja$history$BHistoryConfig;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryConfig = BHistoryChannel.class("[Ljavax.baja.history.BHistoryConfig;", false);
        }
        Array array = new Array(clazz);
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)string);
        if (patternFilterArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < bHistoryDeviceArray.length) {
            BIHistory[] bIHistoryArray;
            BPermissions bPermissions = this.getPermissionsFor((Object)bHistoryDeviceArray[n]);
            if (bPermissions.hasOperatorRead() && (bIHistoryArray = bHistoryDatabase.listHistories(bHistoryDeviceArray[n])) != null) {
                int n2 = 0;
                while (n2 < bIHistoryArray.length) {
                    BHistoryConfig bHistoryConfig;
                    bPermissions = this.getPermissionsFor(bIHistoryArray[n2]);
                    if (bPermissions.hasOperatorRead() && BLocalHistoryDatabase.acceptSystemTags(bHistoryConfig = bIHistoryArray[n2].getConfig(), patternFilterArray)) {
                        array.add((Object)bHistoryConfig);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (array.size() < 1) {
            return null;
        }
        return (BHistoryConfig[])array.trim();
    }

    public void setConfig(BHistoryConfig bHistoryConfig) throws Exception {
        FoxRequest foxRequest = this.makeRequest("setConfig");
        foxRequest.add("xml", ValueDocEncoder.marshal((BValue)bHistoryConfig));
        FoxResponse foxResponse = this.sendSync(foxRequest);
    }

    public FoxResponse setConfig(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        String string = foxRequest.getString("xml");
        BHistoryConfig bHistoryConfig = (BHistoryConfig)ValueDocDecoder.unmarshal((String)string);
        BHistoryId bHistoryId = bHistoryConfig.getId();
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        if (bIHistory == null) {
            foxResponse.add("e", false);
        } else {
            BPermissions bPermissions = this.getPermissionsFor(bIHistory);
            if (!bPermissions.hasAdminWrite()) {
                bHistoryDatabase.setConfig(bHistoryConfig);
            } else {
                foxResponse.add("e", false);
            }
        }
        return foxResponse;
    }

    public BHistorySummary getSummary(BHistoryId bHistoryId) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getSummary");
        foxRequest.add("id", bHistoryId.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        boolean bl = foxResponse.getBoolean("exists", false);
        if (!bl) {
            return null;
        }
        int n = foxResponse.getInt("recCount", 0);
        long l = foxResponse.getTime("firstTs", 0L);
        long l2 = foxResponse.getTime("lastTs", 0L);
        BHistorySummary bHistorySummary = new BHistorySummary();
        bHistorySummary.setId(bHistoryId);
        bHistorySummary.setRecordCount(n);
        bHistorySummary.setFirstTimestamp(BAbsTime.make((long)l));
        bHistorySummary.setLastTimestamp(BAbsTime.make((long)l2));
        return bHistorySummary;
    }

    public FoxResponse getSummary(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        boolean bl = false;
        if (bIHistory != null) {
            bl = true;
        }
        foxResponse.add("exists", bl);
        if (bIHistory != null) {
            BHistorySummary bHistorySummary = bIHistory.getSummary();
            foxResponse.add("recCount", bHistorySummary.getRecordCount());
            foxResponse.add("firstTs", bHistorySummary.getFirstTimestamp().getMillis());
            foxResponse.add("lastTs", bHistorySummary.getLastTimestamp().getMillis());
        }
        return foxResponse;
    }

    public void deleteHistories(BOrd[] bOrdArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("deleteHistories");
        BHistoryChannel.ordsToMsg(bOrdArray, (FoxMessage)foxRequest);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        boolean bl = foxResponse.getBoolean("success");
        if (!bl) {
            throw new HistoryException("Cannot Delete Histories");
        }
    }

    public FoxResponse deleteHistories(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BOrd[] bOrdArray = BHistoryChannel.msgToOrds((FoxMessage)foxRequest);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            bHistoryDatabase.deleteHistories(bOrdArray, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void renameHistory(BHistoryId bHistoryId, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("renameHistory");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("historyName", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
    }

    public FoxResponse renameHistory(FoxRequest foxRequest) throws Exception {
        BPermissions bPermissions;
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("historyName");
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        if (bIHistory != null && !(bPermissions = this.getPermissionsFor(bIHistory)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to rename history " + (Object)((Object)bHistoryId));
        }
        bHistoryDatabase.renameHistory(bHistoryId, string);
        return null;
    }

    public BHistoryRecord getLastRecord(BHistoryId bHistoryId) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("getLastRecord");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("id", bHistoryId.encodeToString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (foxMessage2.getBoolean("empty", true)) {
            return null;
        }
        BTypeSpec bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(foxMessage2.getString("recType"));
        BHistoryRecord bHistoryRecord = (BHistoryRecord)bTypeSpec.getInstance();
        DataInputStream dataInputStream = new DataInputStream(foxCircuit.getInputStream());
        bHistoryRecord.read(dataInputStream);
        return bHistoryRecord;
    }

    /*
     * Exception decompiling
     */
    public void getLastRecord(FoxCircuit var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 228->232)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Cursor timeQuery(BHistoryId bHistoryId, BAbsTime bAbsTime, BAbsTime bAbsTime2) throws Exception {
        return this.timeQuery(bHistoryId, false, bAbsTime, bAbsTime2, false);
    }

    public Cursor timeQuery(BHistoryId bHistoryId, BAbsTime bAbsTime, BAbsTime bAbsTime2, boolean bl) throws Exception {
        return this.timeQuery(bHistoryId, false, bAbsTime, bAbsTime2, bl);
    }

    public Cursor timeQuery(BHistoryId bHistoryId, boolean bl, BAbsTime bAbsTime, BAbsTime bAbsTime2) throws Exception {
        return this.timeQuery(bHistoryId, bl, bAbsTime, bAbsTime2, false);
    }

    public Cursor timeQuery(BHistoryId bHistoryId, boolean bl, BAbsTime bAbsTime, BAbsTime bAbsTime2, boolean bl2) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("timeQuery");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("id", bHistoryId.encodeToString());
        if (bAbsTime != null && !bAbsTime.isNull()) {
            foxMessage.add("startTime", bAbsTime.getMillis());
        }
        if (bAbsTime2 != null && !bAbsTime2.isNull()) {
            foxMessage.add("endTime", bAbsTime2.getMillis());
        }
        foxMessage.add("leaseHistory", bl2);
        if (bl) {
            foxMessage.add("descending", bl);
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (!foxMessage2.getBoolean("success", true)) {
            throw new FoxHistoryException(foxMessage2.getString("error"));
        }
        String string = foxMessage2.getString("cursorCxFacets", null);
        BasicContext basicContext = null;
        if (string != null) {
            basicContext = new BasicContext(null, (BFacets)BFacets.DEFAULT.decodeFromString(string));
        }
        RecordInput recordInput = new RecordInput(new DataInputStream(foxCircuit.getInputStream()));
        return new RecordInputCursor(recordInput, (Context)basicContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void timeQuery(FoxCircuit foxCircuit) throws Exception {
        block15: {
            block14: {
                try {
                    Object object;
                    BHistory bHistory;
                    BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                    BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
                    FoxMessage foxMessage = foxCircuit.readMessage();
                    BHistoryId bHistoryId = BHistoryId.make(foxMessage.getString("id"));
                    BAbsTime bAbsTime = null;
                    BAbsTime bAbsTime2 = null;
                    BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                    FoxMessage foxMessage2 = new FoxMessage();
                    if (bIHistory == null) {
                        foxMessage2.add("success", false);
                        foxMessage2.add("error", "History not found: " + bHistoryId.toString());
                        foxCircuit.writeMessage(foxMessage2);
                        Object var3_10 = null;
                        break block14;
                    }
                    if (foxMessage.getBoolean("leaseHistory", false) && bIHistory instanceof BHistory) {
                        bHistory = (BHistory)bIHistory;
                        try {
                            Context context = this.getSessionContext();
                            bHistory.subscribe(this.historyChannelSubscriber, context);
                            bHistory.unsubscribe(this.historyChannelSubscriber, context);
                        }
                        catch (Exception exception) {
                            BHistoryService.logger.warning("Cannot lease (subscribe/unsubscribe) history " + (Object)((Object)bHistory.getId()), (Throwable)exception);
                        }
                    }
                    bHistory = null;
                    try {
                        long l = foxMessage.getTime("startTime", (long)-1);
                        if (l != (long)-1) {
                            bAbsTime = BAbsTime.make((long)l);
                        }
                        if ((l = foxMessage.getTime("endTime", (long)-1)) != (long)-1) {
                            bAbsTime2 = BAbsTime.make((long)l);
                        }
                        bHistory = bIHistory.timeQuery(bAbsTime, bAbsTime2, foxMessage.getBoolean("descending", false)).cursor();
                    }
                    catch (Exception exception) {
                        foxMessage2.add("success", false);
                        foxMessage2.add("error", exception.getClass().getName() + ": " + exception.getMessage());
                        foxCircuit.writeMessage(foxMessage2);
                        Object var3_11 = null;
                        foxCircuit.close();
                        return;
                    }
                    foxMessage2.add("success", true);
                    Context context = bHistory.getContext();
                    if (context != null && (object = context.getFacets()) != null) {
                        foxMessage2.add("cursorCxFacets", object.encodeToString());
                    }
                    foxCircuit.writeMessage(foxMessage2);
                    foxCircuit.flush();
                    object = null;
                    DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
                    object = bIHistory instanceof BITable ? new RecordOutput((BITable)bIHistory, (DataOutput)dataOutputStream, this.getSessionContext()) : new RecordOutput(bIHistory.getConfig(), (DataOutput)dataOutputStream, this.getSessionContext());
                    while (true) {
                        if (!bHistory.next()) {
                            ((HistoryOutput)object).flush();
                            ((HistoryOutput)object).close();
                            break block15;
                        }
                        ((HistoryOutput)object).write(bHistory.get());
                    }
                }
                catch (Throwable throwable) {
                    Object var3_12 = null;
                    foxCircuit.close();
                    throw throwable;
                }
            }
            foxCircuit.close();
            return;
        }
        Object var3_13 = null;
        foxCircuit.close();
    }

    public void append(BHistoryId bHistoryId, BIHistoryRecordSet bIHistoryRecordSet) throws Exception {
        if (bIHistoryRecordSet == null || bIHistoryRecordSet.getRecordCount() < 1) {
            return;
        }
        FoxCircuit foxCircuit = this.openCircuit("append");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("id", bHistoryId.encodeToString());
        foxMessage.add("recType", bIHistoryRecordSet.getRecordTypeSpec().encodeToString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (!foxMessage2.getBoolean("continue", true)) {
            throw new FoxHistoryException(foxMessage2.getString("error"));
        }
        BHistoryRecord bHistoryRecord = bIHistoryRecordSet.getRecord(0);
        ByteBuffer byteBuffer = null;
        byteBuffer = bHistoryRecord.isFixedSize() ? new ByteBuffer(bHistoryRecord.getRecordSize() * 100) : new ByteBuffer(12800);
        DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
        boolean bl = true;
        do {
            boolean bl2;
            byteBuffer.reset();
            int n = 0;
            do {
                bIHistoryRecordSet.getRecord(n).write((DataOutput)byteBuffer);
                bl2 = false;
                if (++n >= bIHistoryRecordSet.getRecordCount()) continue;
                bl2 = bl = true;
            } while (bl2 && n < 100);
            if (byteBuffer.getLength() == 0) continue;
            dataOutputStream.writeInt(n);
            byteBuffer.writeTo((OutputStream)dataOutputStream);
        } while (bl);
        dataOutputStream.flush();
        dataOutputStream.writeInt(0);
        dataOutputStream.flush();
    }

    public void append(BHistoryId bHistoryId, Cursor cursor) throws Exception {
        if (!cursor.next()) {
            return;
        }
        FoxCircuit foxCircuit = this.openCircuit("append");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("id", bHistoryId.encodeToString());
        foxMessage.add("recType", cursor.get().getType().getTypeSpec().encodeToString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (!foxMessage2.getBoolean("continue", true)) {
            throw new FoxHistoryException(foxMessage2.getString("error"));
        }
        RecordOutput recordOutput = new RecordOutput(new DataOutputStream(foxCircuit.getOutputStream()));
        do {
            recordOutput.write(cursor.get());
        } while (cursor.next());
        recordOutput.flush();
        recordOutput.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(FoxCircuit foxCircuit) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        FoxMessage foxMessage = foxCircuit.readMessage();
        BHistoryId bHistoryId = BHistoryId.make(foxMessage.getString("id"));
        BTypeSpec bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(foxMessage.getString("recType"));
        FoxMessage foxMessage2 = new FoxMessage();
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        if (bIHistory == null) {
            foxMessage2.add("continue", false);
            foxMessage2.add("error", "History not found: " + bHistoryId.toString());
            foxCircuit.writeMessage(foxMessage2);
            return;
        }
        Object object = this.getPermissionsFor(bIHistory);
        if (!object.hasAdminWrite()) {
            foxMessage2.add("continue", false);
            foxMessage2.add("error", "User does not have permission to append to history " + bHistoryId.toString());
            foxCircuit.writeMessage(foxMessage2);
            return;
        }
        object = bIHistory.getConfig();
        if (!object.getRecordType().equals((Object)bTypeSpec)) {
            foxMessage2.add("continue", false);
            foxMessage2.add("error", "Type mismatch: " + object.getRecordType() + " != " + bTypeSpec);
            foxCircuit.writeMessage(foxMessage2);
            return;
        }
        foxMessage2.add("continue", true);
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
        HistoryInput historyInput = null;
        try {
            historyInput = new RecordInput(new DataInputStream(foxCircuit.getInputStream()));
            RecordInputCursor recordInputCursor = new RecordInputCursor((RecordInput)historyInput, null);
            while (recordInputCursor.next()) {
                bIHistory.append((BHistoryRecord)recordInputCursor.get());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            historyInput.close();
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        historyInput.close();
    }

    public void update(BHistoryId bHistoryId, BHistoryRecord bHistoryRecord) throws Exception {
        if (bHistoryRecord == null) {
            return;
        }
        FoxCircuit foxCircuit = this.openCircuit("update");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("id", bHistoryId.encodeToString());
        foxMessage.add("recType", bHistoryRecord.getType().getTypeSpec().encodeToString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (!foxMessage2.getBoolean("continue", true)) {
            throw new FoxHistoryException(foxMessage2.getString("error"));
        }
        ByteBuffer byteBuffer = null;
        byteBuffer = bHistoryRecord.isFixedSize() ? new ByteBuffer(bHistoryRecord.getRecordSize() * 100) : new ByteBuffer(12800);
        DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
        byteBuffer.reset();
        boolean bl = false;
        bHistoryRecord.write((DataOutput)byteBuffer);
        if (byteBuffer.getLength() != 0) {
            byteBuffer.writeTo((OutputStream)dataOutputStream);
        }
        dataOutputStream.flush();
        dataOutputStream.writeInt(0);
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(FoxCircuit foxCircuit) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        FoxMessage foxMessage = foxCircuit.readMessage();
        BHistoryId bHistoryId = BHistoryId.make(foxMessage.getString("id"));
        BTypeSpec bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(foxMessage.getString("recType"));
        FoxMessage foxMessage2 = new FoxMessage();
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        if (bIHistory == null) {
            foxMessage2.add("continue", false);
            foxMessage2.add("error", "History not found: " + bHistoryId.toString());
            foxCircuit.writeMessage(foxMessage2);
            return;
        }
        Object object = this.getPermissionsFor(bIHistory);
        if (!object.hasAdminWrite()) {
            foxMessage2.add("continue", false);
            foxMessage2.add("error", "User does not have permission to update history " + bHistoryId.toString());
            foxCircuit.writeMessage(foxMessage2);
            return;
        }
        object = bIHistory.getConfig();
        if (!object.getRecordType().equals((Object)bTypeSpec)) {
            foxMessage2.add("continue", false);
            foxMessage2.add("error", "Type mismatch: " + object.getRecordType() + " != " + bTypeSpec);
            foxCircuit.writeMessage(foxMessage2);
            return;
        }
        foxMessage2.add("continue", true);
        foxCircuit.writeMessage(foxMessage2);
        foxCircuit.flush();
        DataInputStream dataInputStream = new DataInputStream(foxCircuit.getInputStream());
        try {
            BHistoryRecord bHistoryRecord = object.makeRecord();
            bHistoryRecord.read(dataInputStream);
            bIHistory.update(bHistoryRecord, this.getSessionContext());
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            dataInputStream.close();
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        dataInputStream.close();
    }

    public void clearAllRecords(BOrd[] bOrdArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("clearAllRecords");
        BHistoryChannel.ordsToMsg(bOrdArray, (FoxMessage)foxRequest);
        FoxResponse foxResponse = this.sendSync(foxRequest);
    }

    public FoxResponse clearAllRecords(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BOrd[] bOrdArray = BHistoryChannel.msgToOrds((FoxMessage)foxRequest);
        bHistoryDatabase.clearAllRecords(bOrdArray, this.getSessionContext());
        return null;
    }

    public void clearOldRecords(BOrd[] bOrdArray, BAbsTime bAbsTime) throws Exception {
        FoxRequest foxRequest = this.makeRequest("clearOldRecords");
        BHistoryChannel.ordsToMsg(bOrdArray, (FoxMessage)foxRequest);
        foxRequest.add("before", bAbsTime.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
    }

    public FoxResponse clearOldRecords(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BOrd[] bOrdArray = BHistoryChannel.msgToOrds((FoxMessage)foxRequest);
        BAbsTime bAbsTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(foxRequest.getString("before"));
        bHistoryDatabase.clearOldRecords(bOrdArray, bAbsTime, this.getSessionContext());
        return null;
    }

    public int postReport(byte[] byArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("postReport");
        foxRequest.add("file", byArray);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getInt("id");
    }

    public FoxResponse postReport(FoxRequest foxRequest) throws Exception {
        byte[] byArray = foxRequest.getBlob("file");
        try {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            Integer n = (Integer)bHistoryService.fw(0, byArray, null, null);
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            foxResponse.add("id", n.intValue());
            return foxResponse;
        }
        catch (Exception exception) {
            BHistoryService.logger.error("Cannot save report.", (Throwable)exception);
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            foxResponse.add("id", -1);
            return foxResponse;
        }
    }

    public byte[] getReport(int n) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getReport");
        foxRequest.add("id", n);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxTuple foxTuple = foxResponse.getOptional("file");
        if (foxTuple == null) {
            return null;
        }
        return ((FoxBlob)foxTuple).data;
    }

    public FoxResponse getReport(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService;
        int n = foxRequest.getInt("id");
        byte[] byArray = null;
        try {
            bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            byArray = (byte[])bHistoryService.fw(1, new Integer(n), null, null);
        }
        catch (Exception exception) {
            BHistoryService.logger.error("Cannot load report.", (Throwable)exception);
        }
        bHistoryService = new FoxResponse(foxRequest);
        if (byArray != null) {
            bHistoryService.add("file", byArray);
        }
        return bHistoryService;
    }

    public BObject resolve(BOrd bOrd) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("resolve");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("ord", bOrd.encodeToString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (!foxMessage2.getBoolean("resolved", true)) {
            throw new UnresolvedException(bOrd.toString());
        }
        String string = foxMessage2.getString("resultType", null);
        if (string == null) {
            throw new UnresolvedException("resultType required");
        }
        if (string.equals("records")) {
            RecordInput recordInput = new RecordInput(new DataInputStream(foxCircuit.getInputStream()));
            return new BRecordTable(recordInput);
        }
        if (string.equals("table")) {
            BIDataTable bIDataTable = DataTableDecoder.decode((DataInput)new DataInputStream(foxCircuit.getInputStream()));
            foxCircuit.close();
            return (BObject)bIDataTable;
        }
        if (string.equals("value")) {
            String string2 = foxMessage2.getString("dataValue", null);
            BValue bValue = ValueDocDecoder.unmarshal((String)string2);
            return bValue;
        }
        throw new UnresolvedException("Unsupported result type: " + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(FoxCircuit foxCircuit) throws Exception {
        block16: {
            block17: {
                block15: {
                    try {
                        BOrd bOrd;
                        FoxMessage foxMessage = foxCircuit.readMessage();
                        String string = foxMessage.getString("ord", null);
                        if (string == null) {
                            foxCircuit.writeMessage(BHistoryChannel.unresolved());
                            foxCircuit.flush();
                            Object var3_4 = null;
                            break block15;
                        }
                        BObject bObject = null;
                        try {
                            bOrd = BOrd.make((String)("local:|" + string));
                            bObject = bOrd.resolve().get();
                        }
                        catch (UnresolvedException unresolvedException) {
                            foxCircuit.writeMessage(BHistoryChannel.unresolved());
                            foxCircuit.flush();
                            Object var3_5 = null;
                            foxCircuit.close();
                            return;
                        }
                        catch (InvalidOrdBaseException invalidOrdBaseException) {
                            foxCircuit.writeMessage(BHistoryChannel.unresolved("history.invalidOrdBase", "Invalid ord base: " + invalidOrdBaseException.getMessage()));
                            foxCircuit.flush();
                            Object var3_6 = null;
                            foxCircuit.close();
                            return;
                        }
                        bOrd = new FoxMessage();
                        bOrd.add("resolved", true);
                        if (bObject instanceof BICollection) {
                            Object object;
                            BITable bITable = ((BICollection)bObject).toTable();
                            Cursor cursor = ((BICollection)bObject).cursor();
                            if (cursor.next()) {
                                if (cursor.get() instanceof BHistoryRecord && this.isPathsOnly(bITable)) {
                                    bOrd.add("resultType", "records");
                                    foxCircuit.writeMessage((FoxMessage)bOrd);
                                    foxCircuit.flush();
                                    RecordOutput recordOutput = new RecordOutput(bITable, (DataOutput)new DataOutputStream(foxCircuit.getOutputStream()), this.getSessionContext());
                                    do {
                                        recordOutput.write(cursor.get());
                                    } while (cursor.next());
                                    recordOutput.flush();
                                    recordOutput.close();
                                    break block16;
                                } else {
                                    bOrd.add("resultType", "table");
                                    foxCircuit.writeMessage((FoxMessage)bOrd);
                                    foxCircuit.flush();
                                    DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
                                    DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable((BITable)bITable), (DataOutput)dataOutputStream, (Context)this.getSessionContext());
                                    dataOutputStream.flush();
                                    dataOutputStream.close();
                                }
                                break block16;
                            }
                            BFacets bFacets = bITable.getTableFacets();
                            if (bFacets != null && (object = bFacets.gets("historyId", null)) != null) {
                                bOrd.add("resultType", "records");
                                foxCircuit.writeMessage((FoxMessage)bOrd);
                                foxCircuit.flush();
                                BHistoryId bHistoryId = (BHistoryId)BHistoryId.DEFAULT.decodeFromString((String)object);
                                BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                                BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
                                BHistoryConfig bHistoryConfig = bHistoryDatabase.getConfig(bHistoryId);
                                if (bHistoryConfig == null) {
                                    throw new BajaRuntimeException("History not found: " + (Object)((Object)bHistoryId));
                                }
                                DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
                                RecordOutput recordOutput = new RecordOutput(bITable, bHistoryConfig.getRecordType().getResolvedType(), dataOutputStream, this.getSessionContext());
                                recordOutput.flush();
                                recordOutput.close();
                                break block17;
                            }
                            bOrd.add("resultType", "table");
                            foxCircuit.writeMessage((FoxMessage)bOrd);
                            foxCircuit.flush();
                            object = new DataOutputStream(foxCircuit.getOutputStream());
                            DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable((BITable)bITable), (DataOutput)object, (Context)this.getSessionContext());
                            ((DataOutputStream)object).flush();
                            ((FilterOutputStream)object).close();
                            break block16;
                        }
                        if (bObject instanceof BValue) {
                            bOrd.add("resultType", "value");
                            bOrd.add("dataValue", ValueDocEncoder.marshal((BValue)((BValue)bObject)));
                            foxCircuit.writeMessage((FoxMessage)bOrd);
                            foxCircuit.flush();
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var3_8 = null;
                        foxCircuit.close();
                        throw throwable;
                    }
                }
                foxCircuit.close();
                return;
            }
            Object var3_7 = null;
            foxCircuit.close();
            return;
        }
        Object var3_9 = null;
        foxCircuit.close();
    }

    private final boolean isPathsOnly(BITable bITable) {
        if (!(bITable instanceof BProjectionTable)) {
            return true;
        }
        Column[] columnArray = bITable.getColumns().list();
        int n = 0;
        while (n < columnArray.length) {
            if (!(columnArray[n] instanceof ColumnProjectionColumn)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setProperty(BHistoryId bHistoryId, String string, BValue bValue, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("setProperty");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        foxRequest.add("xml", ValueDocEncoder.marshal((BValue)bValue));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot set property '").append(string);
            stringBuffer.append("' on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse setProperty(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        String string2 = foxRequest.getString("xml");
        BValue bValue = ValueDocDecoder.unmarshal((String)string2);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.set(bIHistory.getProperty(string), bValue, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void setPropertyFlags(BHistoryId bHistoryId, String string, int n, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("setPropertyFlags");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        foxRequest.add("flags", n);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot set flags for property '").append(string);
            stringBuffer.append("' on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse setPropertyFlags(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        int n = foxRequest.getInt("flags");
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.setFlags(bIHistory.getSlot(string), n, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void addProperty(BHistoryId bHistoryId, String string, BValue bValue, int n, BFacets bFacets, Context context) throws Exception {
        FoxResponse foxResponse;
        FoxRequest foxRequest = this.makeRequest("addProperty");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        foxRequest.add("xml", ValueDocEncoder.marshal((BValue)bValue));
        foxRequest.add("flags", n);
        if (bFacets != null) {
            foxRequest.add("facets", bFacets.encodeToString());
        }
        if (!(foxResponse = this.sendSync(foxRequest)).getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot add property '").append(string);
            stringBuffer.append("' on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse addProperty(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        String string2 = foxRequest.getString("xml");
        BValue bValue = ValueDocDecoder.unmarshal((String)string2);
        int n = foxRequest.getInt("flags");
        String string3 = foxRequest.getString("facets", null);
        BFacets bFacets = string3 != null ? BFacets.make((String)string3) : null;
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.add(string, bValue, n, bFacets, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void removeProperty(BHistoryId bHistoryId, String string, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("removeProperty");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot remove property '").append(string);
            stringBuffer.append("' from history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse removeProperty(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.remove(string, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (NoSuchSlotException noSuchSlotException) {
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void removeAllProperties(BHistoryId bHistoryId, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("removeAllProperties");
        foxRequest.add("id", bHistoryId.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot remove all properties from history: ");
            stringBuffer.append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse removeAllProperties(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.removeAll(this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void renameProperty(BHistoryId bHistoryId, String string, String string2, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("renameProperty");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("oldName", string);
        foxRequest.add("newName", string2);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot rename property '").append(string);
            stringBuffer.append("' on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse renameProperty(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("oldName");
        String string2 = foxRequest.getString("newName");
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.rename(bIHistory.getProperty(string), string2, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void setPropertyFacets(BHistoryId bHistoryId, String string, BFacets bFacets, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("setPropertyFacets");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        foxRequest.add("facets", bFacets.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot set facets for slot '").append(string);
            stringBuffer.append("' on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse setPropertyFacets(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        BFacets bFacets = BFacets.make((String)foxRequest.getString("facets"));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.setFacets(bIHistory.getSlot(string), bFacets, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void reorderProperties(BHistoryId bHistoryId, String[] stringArray, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("reorderProperties");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propLen", stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            foxRequest.add("propName" + n, stringArray[n]);
            ++n;
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot reorder properties on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse reorderProperties(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        int n = foxRequest.getInt("propLen");
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            Property[] propertyArray = new Property[n];
            int n2 = 0;
            while (n2 < n) {
                propertyArray[n2] = bIHistory.getProperty(foxRequest.getString(("propName" + n2).intern()));
                ++n2;
            }
            bIHistory.reorder(propertyArray, this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void reorderPropertyToTop(BHistoryId bHistoryId, String string, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("reorderPropertyToTop");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot reorder property '").append(string);
            stringBuffer.append("' to top on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse reorderPropertyToTop(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.reorderToTop(bIHistory.getProperty(string), this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public void reorderPropertyToBottom(BHistoryId bHistoryId, String string, Context context) throws Exception {
        FoxRequest foxRequest = this.makeRequest("reorderPropertyToBottom");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("propName", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot reorder property '").append(string);
            stringBuffer.append("' to bottom on history: ").append(bHistoryId.toString());
            throw new HistoryException(stringBuffer.toString());
        }
    }

    private final FoxResponse reorderPropertyToBottom(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        String string = foxRequest.getString("propName");
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
            bIHistory.reorderToBottom(bIHistory.getProperty(string), this.getSessionContext());
            foxResponse.add("success", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            foxResponse.add("success", false);
        }
        return foxResponse;
    }

    public BPermissions getPermissionsByOrd(BOrd bOrd) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getPermissionsByOrd");
        foxRequest.add("ord", bOrd.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return BPermissions.make((int)foxResponse.getInt("p"));
    }

    public FoxResponse getPermissionsByOrd(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("ord");
        BOrd bOrd = BOrd.make((String)("local:|" + string));
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BObject bObject = bOrd.resolve().get();
        if (!(bObject instanceof BIProtected)) {
            throw new BajaRuntimeException("Not protected: " + string);
        }
        BPermissions bPermissions = ((BIProtected)bObject).getPermissions(this.getSessionContext());
        if (bPermissions == null) {
            bPermissions = BPermissions.none;
        }
        foxResponse.add("p", bPermissions.getMask());
        return foxResponse;
    }

    public BINavNode[] getFolderNavChildren(BFoxHistorySpace bFoxHistorySpace, String[] stringArray, BINavNode bINavNode, Map map) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("getFolderNavChildren");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("o", bINavNode.getNavOrd().relativizeToSession().encodeToString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        if (!foxMessage2.getBoolean("success", true)) {
            throw new FoxHistoryException(foxMessage2.getString("error"));
        }
        int n = stringArray.length;
        FoxTuple[] foxTupleArray = foxMessage2.list("h");
        if (foxTupleArray == null) {
            return new BINavNode[0];
        }
        BINavNode[] bINavNodeArray = new BINavNode[foxTupleArray.length];
        int n2 = 0;
        while (n2 < bINavNodeArray.length) {
            FoxMessage foxMessage3 = (FoxMessage)foxTupleArray[n2];
            switch (foxMessage3.getInt("c")) {
                case 0: {
                    BHistoryId bHistoryId = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(foxMessage3.getString("id"));
                    BTypeSpec bTypeSpec = null;
                    String string = foxMessage3.getString("t", null);
                    if (string != null) {
                        bTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(string);
                    }
                    BPermissions bPermissions = BPermissions.make((String)foxMessage3.getString("p"));
                    bINavNodeArray[n2] = new BHistoryMirror(new BFoxHistory(bFoxHistorySpace, bHistoryId, bTypeSpec, bPermissions, foxMessage3.getString("d", null)), bINavNode);
                    break;
                }
                case 1: {
                    String string = foxMessage3.getString("n");
                    BPermissions bPermissions = BPermissions.make((String)foxMessage3.getString("p"));
                    bINavNodeArray[n2] = new BFoxHistoryDevice(bFoxHistorySpace, string, bPermissions);
                    break;
                }
                case 2: {
                    String[] stringArray2 = new String[n + 1];
                    int n3 = 0;
                    while (n3 < n) {
                        stringArray2[n3] = stringArray[n3];
                        ++n3;
                    }
                    stringArray2[n] = foxMessage3.getString("n");
                    bINavNodeArray[n2] = new BHistoryFolder(bFoxHistorySpace, stringArray2, bINavNode);
                    break;
                }
            }
            if (bINavNodeArray[n2] != null) {
                map.put(bINavNodeArray[n2].getNavName(), bINavNodeArray[n2]);
            }
            ++n2;
        }
        return bINavNodeArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFolderNavChildren(FoxCircuit foxCircuit) throws Exception {
        try {
            FoxMessage foxMessage;
            block13: {
                String string;
                block14: {
                    FoxMessage foxMessage2 = foxCircuit.readMessage();
                    string = foxMessage2.getString("o");
                    BOrd bOrd = BOrd.make((String)("local:|" + string));
                    BObject bObject = bOrd.resolve().get();
                    foxMessage = new FoxMessage();
                    if (!(bObject instanceof BINavNode)) break block14;
                    BINavNode[] bINavNodeArray = ((BINavNode)bObject).getNavChildren();
                    int n = bINavNodeArray.length;
                    int n2 = 0;
                    while (true) {
                        block16: {
                            FoxMessage foxMessage3;
                            BPermissions bPermissions;
                            BISpaceNode bISpaceNode;
                            block15: {
                                if (n2 >= n) {
                                    foxMessage.add("success", true);
                                    break block13;
                                }
                                if (!(bINavNodeArray[n2] instanceof BIHistory)) break block15;
                                bISpaceNode = (BIHistory)bINavNodeArray[n2];
                                bPermissions = this.getPermissionsFor(bISpaceNode);
                                if (bPermissions.hasOperatorRead()) {
                                    foxMessage3 = new FoxMessage("h");
                                    foxMessage3.add("c", 0);
                                    foxMessage3.add("id", bISpaceNode.getId().encodeToString());
                                    foxMessage3.add("t", bISpaceNode.getRecordType().encodeToString());
                                    foxMessage3.add("p", bPermissions.encodeToString());
                                    try {
                                        BFormat bFormat = BHistory.getHistoryDisplayNameFormat((BIHistory)bISpaceNode);
                                        if (bFormat != null) {
                                            foxMessage3.add("d", bFormat.format((Object)bISpaceNode, this.getSessionContext()));
                                        }
                                    }
                                    catch (Exception exception) {}
                                    foxMessage.add((FoxTuple)foxMessage3);
                                }
                                break block16;
                            }
                            if (bINavNodeArray[n2] instanceof BHistoryDevice) {
                                bISpaceNode = (BHistoryDevice)bINavNodeArray[n2];
                                bPermissions = this.getPermissionsFor(bISpaceNode);
                                if (bPermissions.hasOperatorRead()) {
                                    foxMessage3 = new FoxMessage("h");
                                    foxMessage3.add("c", 1);
                                    foxMessage3.add("n", bISpaceNode.getDeviceName());
                                    foxMessage3.add("p", bPermissions.encodeToString());
                                    foxMessage.add((FoxTuple)foxMessage3);
                                }
                            } else if (bINavNodeArray[n2] instanceof BHistoryFolder && (bPermissions = this.getPermissionsFor(bISpaceNode = (BHistoryFolder)bINavNodeArray[n2])).hasOperatorRead()) {
                                foxMessage3 = new FoxMessage("h");
                                foxMessage3.add("c", 2);
                                foxMessage3.add("n", bISpaceNode.getHistoryFolderName());
                                foxMessage.add((FoxTuple)foxMessage3);
                            }
                        }
                        ++n2;
                    }
                }
                foxMessage.add("success", false);
                foxMessage.add("error", "Not a NavNode: " + string);
            }
            foxCircuit.writeMessage(foxMessage);
        }
        catch (Throwable throwable) {
            Object var3_15 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var3_16 = null;
        }
        foxCircuit.close();
    }

    public String[] getHistoryGroupNames() throws Exception {
        FoxRequest foxRequest = this.makeRequest("getGroupNames");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("n");
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        return stringArray;
    }

    public FoxResponse getHistoryGroupNames(FoxRequest foxRequest) throws Exception {
        String[] stringArray = BHistoryService.getHistoryGroupNames(null);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            foxResponse.add("n", stringArray[n3]);
            ++n3;
        }
        return foxResponse;
    }

    public String[] getSortPropertiesForGroup(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getGroupProperties");
        foxRequest.add("g", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String[] stringArray = foxResponse.listStrings("n");
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        return stringArray;
    }

    public FoxResponse getSortPropertiesForGroup(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("g");
        String[] stringArray = BHistoryService.getSortPropertiesForGroup(null, string);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            foxResponse.add("n", stringArray[n3]);
            ++n3;
        }
        return foxResponse;
    }

    public int updateHistorySubscriptionCount(BHistoryId bHistoryId, BComponent bComponent, int n, Context context) throws Exception {
        BObject bObject;
        if (bComponent == null) {
            return 0;
        }
        String string = BHistoryChannel.toOrd(bComponent);
        FoxRequest foxRequest = this.makeRequest("updateSubscription");
        foxRequest.add("id", bHistoryId.encodeToString());
        foxRequest.add("ord", string);
        foxRequest.add("change", n);
        boolean bl = false;
        if (context != null && (bObject = context.getFacet("asyncHistorySubscribe")) instanceof BBoolean) {
            bl = ((BBoolean)bObject).getBoolean();
        }
        foxRequest.add("asyncSub", bl);
        if (bl) {
            this.sendAsync(foxRequest);
            return -1;
        }
        bObject = this.sendSync(foxRequest);
        return bObject.getInt("count");
    }

    public FoxResponse updateHistorySubscriptionCount(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BHistoryId bHistoryId = BHistoryId.make(foxRequest.getString("id"));
        BHistory bHistory = (BHistory)bHistoryDatabase.getHistory(bHistoryId);
        BComponent bComponent = this.fromOrd(foxRequest.getString("ord"));
        int n = foxRequest.getInt("change");
        if (foxRequest.getBoolean("asyncSub")) {
            this.historyChannelSubscriber.asyncUpdate(bHistory, bComponent, n);
            return null;
        }
        int n2 = bHistory.updateHistorySubscriptionCount(bComponent, n, null);
        this.updateSubscriptionCounter(bHistory, bComponent, n);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("count", n2);
        return foxResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateSubscriptionCounter(Object object, BComponent bComponent, int n) {
        HashMap hashMap = this.subscriptionCounter;
        synchronized (hashMap) {
            HistorySourceSubscriptionCount historySourceSubscriptionCount = (HistorySourceSubscriptionCount)this.subscriptionCounter.get(object);
            int n2 = n;
            if (historySourceSubscriptionCount != null && (n2 = historySourceSubscriptionCount.count + n2) <= 0) {
                this.subscriptionCounter.remove(object);
                return;
            }
            this.subscriptionCounter.put(object, new HistorySourceSubscriptionCount(bComponent, n2));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unsubscribeAllHistories() {
        HashMap hashMap = this.subscriptionCounter;
        synchronized (hashMap) {
            Iterator iterator = this.subscriptionCounter.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.subscriptionCounter.clear();
                    return;
                }
                Object k = iterator.next();
                try {
                    HistorySourceSubscriptionCount historySourceSubscriptionCount = (HistorySourceSubscriptionCount)this.subscriptionCounter.get(k);
                    if (k instanceof BHistory) {
                        ((BHistory)k).updateHistorySubscriptionCount(historySourceSubscriptionCount.historySource, -1 * historySourceSubscriptionCount.count, null);
                        continue;
                    }
                    if (!(k instanceof BIPollableHistorySource)) continue;
                    ((BIPollableHistorySource)k).updateHistorySubscriptionCount(-1 * historySourceSubscriptionCount.count);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static final void ordsToMsg(BOrd[] bOrdArray, FoxMessage foxMessage) throws Exception {
        int n = 0;
        while (n < bOrdArray.length) {
            FoxMessage foxMessage2 = new FoxMessage("ord");
            foxMessage2.add("ord", bOrdArray[n].encodeToString());
            foxMessage.add((FoxTuple)foxMessage2);
            ++n;
        }
    }

    private static final BOrd[] msgToOrds(FoxMessage foxMessage) throws Exception {
        FoxTuple[] foxTupleArray = foxMessage.list("ord");
        BOrd[] bOrdArray = new BOrd[foxTupleArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < foxTupleArray.length) {
            FoxMessage foxMessage2 = (FoxMessage)foxTupleArray[n2];
            try {
                BOrd bOrd = (BOrd)BOrd.DEFAULT.decodeFromString(foxMessage2.getString("ord"));
                bOrdArray[n++] = bOrd;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        if (n != bOrdArray.length) {
            BOrd[] bOrdArray2 = new BOrd[n];
            System.arraycopy(bOrdArray, 0, bOrdArray2, 0, n);
            bOrdArray = bOrdArray2;
        }
        return bOrdArray;
    }

    private static final FoxMessage unresolved() {
        return BHistoryChannel.unresolved(null, null);
    }

    private static final FoxMessage unresolved(String string, String string2) {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("resolved", false);
        if (string2 != null) {
            foxMessage.add("msg", string2);
        }
        return foxMessage;
    }

    private static final String toOrd(BComponent bComponent) {
        String string = (String)bComponent.getHandle();
        if (string == null) {
            throw new IllegalStateException(bComponent.toDebugString());
        }
        return "h:" + string;
    }

    private final BComponent fromOrd(String string) {
        return (BComponent)BOrd.make((String)string).get((BObject)this);
    }

    static final /* synthetic */ void access$0(BHistoryChannel bHistoryChannel, Object object, BComponent bComponent, int n) {
        bHistoryChannel.updateSubscriptionCounter(object, bComponent, n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.historyChannelSubscriber = new HistoryChannelSubscriber(this);
        this.subscriptionCounter = new HashMap();
    }

    public BHistoryChannel() {
        super("history");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$history$fox$BHistoryChannel;
        if (clazz == null) {
            clazz = class$com$tridium$history$fox$BHistoryChannel = BHistoryChannel.class("[Lcom.tridium.history.fox.BHistoryChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class HistoryChannelSubscriber
    extends Subscriber
    implements Runnable {
        boolean running;
        boolean isAlive;
        Queue queue;
        BHistoryChannel channel;

        public void event(BComponentEvent bComponentEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void init() {
            Queue queue = this.queue;
            synchronized (queue) {
                this.running = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void kill() {
            Queue queue = this.queue;
            synchronized (queue) {
                this.running = false;
                while (this.isAlive) {
                    this.queue.clear();
                    try {
                        this.queue.wait(1000L);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void asyncUpdate(BHistory bHistory, BComponent bComponent, int n) {
            Queue queue = this.queue;
            synchronized (queue) {
                if (!this.running) {
                    return;
                }
                this.queue.enqueue((Object)new HistorySubscriptionUpdate(bHistory, bComponent, n));
                if (!this.isAlive) {
                    this.isAlive = true;
                    Thread thread = new Thread((Runnable)this, "HistoryChannelSubscriber");
                    thread.start();
                }
                return;
            }
        }

        /*
         * Exception decompiling
         */
        public final void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 21->62)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final /* synthetic */ void this() {
            this.running = false;
            this.isAlive = false;
            this.queue = new Queue();
        }

        public HistoryChannelSubscriber(BHistoryChannel bHistoryChannel) {
            this.this();
            this.channel = bHistoryChannel;
        }
    }

    static class HistorySourceSubscriptionCount {
        BComponent historySource;
        int count;

        HistorySourceSubscriptionCount(BComponent bComponent, int n) {
            this.historySource = bComponent;
            this.count = n;
        }
    }

    static class HistorySubscriptionUpdate {
        BHistory history;
        BComponent historySource;
        int change;

        HistorySubscriptionUpdate(BHistory bHistory, BComponent bComponent, int n) {
            this.history = bHistory;
            this.historySource = bComponent;
            this.change = n;
        }
    }
}

